
/*============================================
 *
 * Sael Lee 
 * May 08, 2008
 *
 *===========================================*/


/* 
 * Data structure
 * 	1. mesh (gst, msms, msp, obj)
 * 	2. Volumedx  (grid type : acc, elec)
 * 	3. surface (vector lst)
 * 	4. seed (vector lst)
 * 	5. seedGraph (nodes edges)
 *
 */
#include "ProcessLocal.h"

#include "Common.h"

#include "VolumeDX.h"
#include "Apbs2DX.h"
#include "MapPdb2Surf.h"
#include "ProcessPDB.h"
#include "Visibility.h"

int main(int argc, char** argv)
{

	char* smolFN = argv[1];
	
	
	// 1. read mesh or apbs 
	SeedVec<double,float> seedVec; 
	SurfVec<double,float> surfVec; 

	Apbs2DX<double,float> apbs2dx;
	
	// 2. generate surf, seeds, acc
	apbs2dx.setSeedVec(&seedVec);
	apbs2dx.setSurfVec(&surfVec);
	apbs2dx.readacc(smolFN);
	apbs2dx.calSurf(1);
//	apbs2dx.readpot("test/1kvkA_s_pot.dx");
//	apbs2dx.calSurfPot();
//	(apbs2dx.getSurf()).writeDX("tmp.dx");
	apbs2dx.calSurfFilled();
	VolumeDX<double,float> csf = apbs2dx.getSurfFilled();

	// seedVec.printSeeds();


	Visibility<double,float> vis;
	vis.SeedVis(csf, 4.6, &seedVec);
//	vis.SurfVis(csf, 10.0, &seedVec, &surfVec);

	seedVec.printSeeds();

	
	apbs2dx.clearAcc();
 	apbs2dx.clearPot();
	apbs2dx.clearSurf();
 	apbs2dx.clearSeed();
 	
}







