

// given ligand receptor and het pdb files 
// find het atoms that are in between the ligand and receptor
#include<iostream>
#include<fstream>

using namespace std;
#include "Common.h"
#include "ProcessPDB.h"

// test ApbsVolumeDX

int main(int argc, char** argv)
{
	char* ligFN = argv[1];
	char* recFN	= argv[2];
	char* hetFN = argv[3];
	float threshold = atof(argv[4]);
	
	cout 	<< "ligand: " << ligFN << " receptor: " << recFN << " het: " 
				<< hetFN << " threshold: " << threshold << endl;   

	ProcessPDB<double,float> ligPDB;
	ligPDB.ReadPDB(ligFN);
	ProcessPDB<double,float> recPDB;
	recPDB.ReadPDB(recFN);
	ProcessPDB<double,float> hetPDB;
	hetPDB.ReadPDB(hetFN);
	
	vector<ATOMStruct> ligA = ligPDB.getATOM();
	vector<ATOMStruct> recA = recPDB.getATOM();
	vector<ATOMStruct> hetA = hetPDB.getHETATM();

	vector<int> hetCheck(hetA.size());
	for(int i=0; i<hetA.size(); i++)
	{
		for(int j=0; j<ligA.size(); j++)
		{
			if(DIST(hetA[i].x, hetA[i].y, hetA[i].z, ligA[j].x, ligA[j].y, ligA[j].z)<threshold){
				int found=0;
				for(int k=0; k<recA.size(); k++)
				{
					if(DIST(hetA[i].x, hetA[i].y, hetA[i].z,recA[k].x, recA[k].y, recA[k].z)<threshold){
						cout << hetA[i].aSN << endl;
						found=1;
						break;
					}
				}	
				if(found)break;
			}
		}
	}


}
