/*============================================
 * author				: Sael Lee 
 * last modified: MAY 3, 2010
 * description	: 
 *===========================================*/
#include "Common.h"
#include "ProcessPDB.h"

int main(int argc, char** argv)
{
	if(argc != 4){exit(-1);}
	
	char	*ligFN = argv[1];
	char	*lcsFN = argv[2];
	char	*outFN = argv[3];
	

	ProcessPDB<double,float> ligpdb;
	ligpdb.ReadPDB(ligFN);
	vector<ATOMStruct> ligA = ligpdb.getHETATM();
	float cogX, cogY, cogZ;
	ligpdb.getCOG(cogX,cogY,cogZ);

	cout << cogX << " " << cogY << " " << cogZ << endl;

	ProcessPDB<double,float> lcspdb;
	lcspdb.ReadPDB(lcsFN);
	vector<ATOMStruct> lcsA = lcspdb.getATOM();

	int 	minInd=-1;
	float minDist=999; 
	for (int i=0; i<lcsA.size(); i++)
	{
			lcsA[i].ATOMprint();
			float dist = DIST(lcsA[i].x,lcsA[i].y,lcsA[i].z, cogX,cogY,cogZ);	
			if(dist < minDist)
			{
				minInd = i;
				minDist = dist;
			}
	}
		
	FILE * pFile;
	pFile=fopen(outFN,"w");
	lcsA[minInd].ATOMprint(pFile);
	fclose(pFile);

	cout << ligFN << " lcs_pocket_# " << minInd+1 << endl;
	return 0;
	
}










