/*============================================
 * author				: Sael Lee 
 * last modified: June 21, 2011
 * description	: converts pdb format structure file to 
 * 								fasta format sequence file
 *===========================================*/

#include "ProcessPDB.h"

using namespace std;

int main(int argc, char** argv)
{
	if(argc!=3 && argc!=4){
		cout << "usage("<< argc <<") : " << argv[0] << " pdbFile  pdbID (chainID) \n";
		exit(-1);
	}

	char * pdbFN = argv[1];
	char * pdbID = argv[2];

	ProcessPDB<double,float> testpdb;
	testpdb.ReadPDB(pdbFN);
	if(argc == 4){
		char chainID = argv[3][0];
		testpdb.GetFasta(pdbID, chainID);
	} else{
		testpdb.GetFasta(pdbID);
	}
	return 1;

}
