#include<iostream>
#include<fstream>

using namespace std;
// ---- local includes ----
//#include "ZernikeDescriptor.h"
#include "VolumeDX.h"
#include "Points2DX.h"
#include "Mesh2DX.h"
#include "Common.h"

// test ApbsVolumeDX
void Usage(char* exc, char* op)
{
	cout << exc << " error for " << op  << "\n";
	cout << " REQUIRED:\n";
	cout << "		-obj 	intput object file name\n";
	cout << "		-dx   output dx file name\n";
	cout << "		-gs  	gs\n";
	cout << "		-del 	del\n";
	cout << "		-cen 	cenX cenY cenZ\n";
}

int main(int argc, char** argv)
{
	
//=========================================================
// process argument
//=========================================================

	int 	gs = MAXINT;
	float del = MAXINT;
	float cenX = 0, cenY = 0, cenZ = 0; 
	
	char 	*objFN, *dxFN;
	
	if(argc < 6){
		Usage(argv[0], "NUM of argument less then 5\n" );
		exit(-1);
	}
	
	for (int i=1; i<argc; i++) {
		
		if (strcmp(argv[i], "-obj")==0) {
			objFN = argv[++i];	
		} else if (strcmp(argv[i], "-dx")==0) {
			dxFN = argv[++i];	
		} else if (strcmp(argv[i], "-del")==0) {
			if (sscanf(argv[++i], "%f", &del)!=1 || del <= 0) {
				Usage(argv[0], argv[i]); return -1;
			}
		} else if (strcmp(argv[i], "-gs")==0) {
			if (sscanf(argv[++i], "%d", &gs)!=1 || gs <= 0) {
				Usage(argv[0], argv[i]); return -1;
			}
		} else if (strcmp(argv[i], "-cen")==0) {
			if (sscanf(argv[++i], "%f", &cenX)!=1) {
				Usage(argv[0], argv[i]); return -1;
			}
			if (sscanf(argv[++i], "%f", &cenY)!=1) {
				Usage(argv[0], argv[i]); return -1;
			}
			if (sscanf(argv[++i], "%f", &cenZ)!=1) {
				Usage(argv[0], argv[i]); return -1;
			}
		} else {
			Usage(argv[0], argv[i]); return -1;
		}

	} // end for

		
// ================================
//	test Mesh2DX
// ===============================
		Mesh2DX<float, double> mesh(OBJ, objFN ,SURFACE, gs, del, cenX, cenY, cenZ);
 
		mesh.writeSurf(dxFN);
		mesh.clear();
}
