/*
 * TODO: NEED MODIFICATION SO THAT THE 3DZDS WITH ALL ZERO VALUES WILL BE NOT CONSIDERED. 
 * 1. IF SHAPE PROPERTIES IS ALL ZERO : THAT SEED WILL NOT BE USED FOR COMPARISON
 * 2. IF ANY OTHER PROPERTIES IS ALL ZERO : WEIGHT OF THAT PROPERTY WILL BE ZERO
 * */
#include <iostream>
#include <fstream>
#include <vector>
#include <cmath>
#include <list>
using namespace std;
#include <stdlib.h>

#define MIN(a,b) ((a)<(b)) ? (a):(b)  
#define MAX(a,b) ((a)>(b)) ? (a):(b)  
#define SQR(a)		 ((a)*(a))	
#define DIST3(a,b,c) sqrt((a)*(a)+(b)*(b)+(c)*(c))

#define MAXVAL		999999
#define MINVAL		-999999
#define THRESHOLD 8

//#define TEST

// local weights and seed info
struct SEED 
{ // declare SEED struct type
  double x, y, z; // coordinate of patch center
  vector<double> invS; // shape
  vector<double> invE; // electrostatics
  vector<double> invV; // visibility
  vector<double> invHB; // hydrogen bond
  vector<double> invHP; // hydrophobicity by XlogP
  vector<double> invA; // aromaticity
  int n_hbdon, n_hbacc, n_arom; // number of grid points that have hydrogen bond donor, acceptor, and aromaticity character
  int sdsN; // seeds number of the pocket
  vector<double> DistSds; // geodesic distance between the seed with all other seeds
  vector<double> dis; // fraction of neighbor seeds in different geodesic distances
} seed_type; // define object of type SEED


double l2(vector<double>& vec1, vector<double>& vec2) 
{ // calculate Euclidean distance
  double ssum = 0;
  int n = MIN(vec1.size(), vec2.size());
  
  for (int i = 0; i < n; i++) 
    {
      ssum += SQR(vec1[i]-vec2[i]);
    }
  return sqrt(ssum);
}

double l2HB(vector<double>& vec1, vector<double>& vec2, bool zero_patch_1, bool zero_patch_2,
	    double pen_p0l0, double pen_phl0, double pen_p0lh)
{
  double l2_dist, sqr_sum;
  int n = MIN(vec1.size(), vec2.size());
  
  if(zero_patch_1 and zero_patch_2)
    {
      return pen_p0l0;
    }
  else if(zero_patch_1 and not zero_patch_2)
    {
      return pen_p0lh;
      //return sqrt(2);
      //return 1.0;
    }
  else if(not zero_patch_1 and zero_patch_2)
    {
      return pen_phl0;
      //return sqrt(2);
      //return HB_pen;
    }
  else
    {
      for(int i = 0; i < n; i++)
	{
	  sqr_sum += SQR(vec1[i] - vec2[i]);
	}
      l2_dist = sqrt(sqr_sum);
      return l2_dist;
    }
}

double l2V2(vector<double>& vec1, vector<double>& vec2) 
{ // Root-mean-square-difference between vectors
  double ssum = 0;
  int n = MIN(vec1.size(), vec2.size());
  for (int i = 0; i < n; i++) 
    {
      ssum += SQR(vec1[i]-vec2[i]);
    }
  return (sqrt(ssum / n));
}

void NeibDis(SEED& s1)
{
  (s1.dis).clear();
  (s1.dis).resize(40,0);
  double n_seed = double(s1.sdsN);
  for ( int i = 0; i < s1.DistSds.size(); i++ )
    {
      if ( s1.DistSds[i] < 1 ) s1.dis[0] = s1.dis[0] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 2 ) s1.dis[1] = s1.dis[1] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 3 ) s1.dis[2] = s1.dis[2] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 4 ) s1.dis[3] = s1.dis[3] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 5 ) s1.dis[4] = s1.dis[4] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 6 ) s1.dis[5] = s1.dis[5] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 7 ) s1.dis[6] = s1.dis[6] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 8 ) s1.dis[7] = s1.dis[7] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 9 ) s1.dis[8] = s1.dis[8] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 10 ) s1.dis[9] = s1.dis[9] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 11 ) s1.dis[10] = s1.dis[10] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 12 ) s1.dis[11] = s1.dis[11] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 13 ) s1.dis[12] = s1.dis[12] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 14 ) s1.dis[13] = s1.dis[13] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 15 ) s1.dis[14] = s1.dis[14] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 16 ) s1.dis[15] = s1.dis[15] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 17 ) s1.dis[16] = s1.dis[16] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 18 ) s1.dis[17] = s1.dis[17] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 19 ) s1.dis[18] = s1.dis[18] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 20 ) s1.dis[19] = s1.dis[19] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 21 ) s1.dis[20] = s1.dis[20] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 22 ) s1.dis[21] = s1.dis[21] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 23 ) s1.dis[22] = s1.dis[22] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 24 ) s1.dis[23] = s1.dis[23] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 25 ) s1.dis[24] = s1.dis[24] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 26 ) s1.dis[25] = s1.dis[25] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 27 ) s1.dis[26] = s1.dis[26] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 28 ) s1.dis[27] = s1.dis[27] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 29 ) s1.dis[28] = s1.dis[28] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 30 ) s1.dis[29] = s1.dis[29] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 31 ) s1.dis[30] = s1.dis[30] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 32 ) s1.dis[31] = s1.dis[31] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 33 ) s1.dis[32] = s1.dis[32] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 34 ) s1.dis[33] = s1.dis[33] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 35 ) s1.dis[34] = s1.dis[34] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 36 ) s1.dis[35] = s1.dis[35] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 37 ) s1.dis[36] = s1.dis[36] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 38 ) s1.dis[37] = s1.dis[37] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 39 ) s1.dis[38] = s1.dis[38] + (1.0 / n_seed);
      else if ( s1.DistSds[i] < 40 ) s1.dis[39] = s1.dis[39] + (1.0 / n_seed);
      else
	continue;
    }
}

double pcal(SEED& s1, SEED& s2, int n)
{ // dist btw geo dist distrib of patches 
  double delta;
  delta = l2(s1.dis, s2.dis);
  return delta;
}

double rpd(vector<SEED>& bidders, vector<SEED>& goods, int i, int j, vector<int>& owner, int nn)
{ // dist of geo dist diff btw matched patches
  double rpdist;
  int count = 0;
  double tmpdist = 0.0;
  for ( int m = 0; m < owner.size(); m++ )
    {
      if ( owner[m] == -1 ) continue;
      else if ( m == j ) continue;
      else
	{
	  tmpdist += fabs(goods[j].DistSds[m] - bidders[i].DistSds[owner[m]]);
	  count++;
	}
    }
  if ( count == 0 ) rpdist = 0.0;
  else
    {
      rpdist = tmpdist/(double)count;
    }
  rpdist = rpdist/(double)nn;
  return rpdist;
}

bool check_zero_patch(vector<double>& zerd)
{
  bool zero_patch;
  int n_dim = zerd.size();
  zero_patch = true;
  for(int i = 0; i < n_dim; i++)
    {
      if(zerd[i] != 0.0)
	{
	  zero_patch = false;
	  break;
	}
    }
  return zero_patch;
}

double pts_diff(int n_pts_1, int n_pts_2)
{
  double diff;
  diff = abs(float(n_pts_1) - float(n_pts_2)) / 250.0;
  return diff;
}

double seedDist(SEED& s1, SEED& s2, double wE, double wV, double wHB_pts,
		double wHP, double wA_pts)
{ // weighted sum of Euclidean dist of ZerD
	double dist = 0;
	double dS = l2(s1.invS, s2.invS);
	double dE = l2(s1.invE, s2.invE);
	double dV = l2(s1.invV, s2.invV);
	double dHP = l2(s1.invHP, s2.invHP);
	double dHB_pts_don = pts_diff(s1.n_hbdon, s2.n_hbdon);
	double dHB_pts_acc = pts_diff(s1.n_hbacc, s2.n_hbacc);
	double dHB_pts = dHB_pts_don + dHB_pts_acc;
	double dA_pts = pts_diff(s1.n_arom, s2.n_arom);
	dist = dS + wE * dE + wV * dV + wHB_pts * dHB_pts + wHP * dHP + wA_pts * dA_pts;
	return dist;
}

void readSeed(char* filename, vector<SEED>& seed) 
{
  int Nseed, Ntype;
  vector<int> Ninv;
  Ninv.resize(6, 0);
  SEED tseed;
  int tmpI;
  ifstream infile1;

  infile1.open(filename, ifstream::in);
  infile1 >> Nseed;
  infile1 >> Ninv[0] >> Ninv[1] >> Ninv[2] >> Ninv[3] >> Ninv[4] >> Ninv[5];

  for (int i = 0; i < Nseed; i++) 
    {
      // read cntr crd
      infile1 >> tseed.x >> tseed.y >> tseed.z;

      // read shape inv
      (tseed.invS).resize(Ninv[0]);
      infile1 >> tmpI >> tmpI;
      for (int k = 0; k < Ninv[0]; k++) 
	{
	  infile1 >> (tseed.invS)[k];
	}

      // read ESP inv
      (tseed.invE).resize(Ninv[1]);
      infile1 >> tmpI >> tmpI;
      for (int k = 0; k < Ninv[1]; k++) 
	{
	  infile1 >> (tseed.invE)[k];
	}

      // read Vis inv
      (tseed.invV).resize(Ninv[2]);
      infile1 >> tmpI >> tmpI;
      for(int k = 0; k < Ninv[2]; k++)
	{
	  infile1 >> (tseed.invV)[k];
	}

      // read HB inv
      (tseed.invHB).resize(Ninv[3]);
      infile1 >> tmpI >> tmpI;
      for (int k = 0; k < Ninv[3]; k++) 
	{
	  infile1 >> (tseed.invHB)[k];
	}

      // read HP inv
      (tseed.invHP).resize(Ninv[4]);
      infile1 >> tmpI >> tmpI;
      for (int k = 0; k < Ninv[4]; k++) 
	{
	  infile1 >> (tseed.invHP)[k];
	}

      // read Arom inv
      (tseed.invA).resize(Ninv[5]);
      infile1 >> tmpI >> tmpI;
      for (int k = 0; k < Ninv[5]; k++)
	{
	  infile1 >> (tseed.invA)[k];
	}

      // read grid points for hydrogen bond and aromaticity
      infile1 >> tseed.n_hbdon >> tseed.n_hbacc >> tseed.n_arom;
      
      // read geodisic distance distribution btw curr. seed and other seeds
      infile1 >> tseed.sdsN;
      (tseed.DistSds).resize(tseed.sdsN);
      for ( int k = 0; k < tseed.sdsN; k++ )
	{
	  infile1 >> (tseed.DistSds)[k];
	}
      
      // convert distrib from simple count to fraction
      NeibDis(tseed);

      // send current seed to last seed of array
      seed.push_back(tseed);
    }
  
  infile1.close();
  
#ifdef TEST
  cout << "READ: " << endl;
  for (int i=0;i<Nseed;i++) 
    {
      cout << seed[i].x << " " << seed[i].y << " " << seed[i].z
	   << " " << (seed[i].invS).size() << " " << (seed[i].invE).size() << " " 
	   << (seed[i].invV).size() << " "
	   << (seed[i].invHB).size() << " " << (seed[i].invHP).size() << " "
	   << (seed[i].invA).size() << " " << seed[i].sdsN << " " 
	   << (seed[i].DistSds).size() << endl;
      cout << seed[i].invS[71] << " " << seed[i].invE[143] << " " << seed[i].invV[71] << " "
	   << seed[i].invHB[143] << " " << seed[i].invHP[143] << " " << seed[i].invA[71] << endl;
      cout << seed[i].n_hbdon << " " << seed[i].n_hbacc << " " << seed[i].n_arom << endl;
      cout << endl;
    }
#endif
	//----------
}

double ComputeAvgRP(vector<SEED>& seed1V, vector<SEED>& seed2V, vector<vector<double> >& pairs)
{
  // relative position computing -------------------------------	
  
  double avgRP = 0, varRP = 0;
  int count = 0;
  if (pairs.size() > 1) 
    {
      int i = 0;
      for (int i = 0; i < pairs.size(); i++) 
	{
	  if (pairs[i][2] == -1)
	    continue;
	  SEED s1a = seed1V[(int) pairs[i][0]];
	  SEED s1b = seed2V[(int) pairs[i][1]];
	  for (int j = i + 1; j < pairs.size(); j++) 
	    {
	      if (pairs[i][2] == -1)
		continue;
	      SEED s2a = seed1V[(int) pairs[j][0]];
	      SEED s2b = seed2V[(int) pairs[j][1]];
	      
	      double dista = DIST3(s1a.x-s2a.x, s1a.y-s2a.y, s1a.z-s2a.z);
	      double distb = DIST3(s1b.x-s2b.x, s1b.y-s2b.y, s1b.z-s2b.z);
	      
	      avgRP += fabs(dista - distb);
	      count++;
	    }
	}
      
      avgRP = avgRP / count;
    } 
  else 
    {
      avgRP = 4.0;
      //		avgRP = 10;	
    }
  return avgRP;
}

double nComputeAvgRP(vector<SEED>& seed1V, vector<SEED>& seed2V, vector<vector<double> >& pairs)
{
  // geodesic relative position computing
  
  double avgRP = 0, varRP = 0;
  int count = 0;
  
  if (pairs.size() > 1) 
    {
      int i = 0;
      for (int i = 0; i < pairs.size(); i++) 
	{
	  if (pairs[i][2] == -1)
	    continue;
	  //SEED s1a = seed1V[(int) pairs[i][0]];
	  //SEED s1b = seed2V[(int) pairs[i][1]];
	  for (int j = i + 1; j < pairs.size(); j++) 
	    {
	      if (pairs[i][2] == -1)
		continue;
	      //SEED s2a = seed1V[(int) pairs[j][0]];
	      //SEED s2b = seed2V[(int) pairs[j][1]];
	      
	      //double dista = DIST3(s1a.x-s2a.x, s1a.y-s2a.y, s1a.z-s2a.z);
	      //double distb = DIST3(s1b.x-s2b.x, s1b.y-s2b.y, s1b.z-s2b.z);
	      double dista = seed1V[(int) pairs[i][0]].DistSds[(int) pairs[j][0]];
	      double distb = seed2V[(int) pairs[i][1]].DistSds[(int) pairs[j][1]];
	      
	      avgRP += fabs(dista - distb);
	      count++;
	    }
	}
      
      avgRP = avgRP / count;
    } 
  else 
    {
      avgRP = 4.0;
      //		avgRP = 10;	
    }
  return avgRP;
}

int isZero(SEED& _seed) 
{
  float sum = 0;
  for (int i = 0; i < (_seed.invS).size(); i++) 
    {
      sum += (_seed.invS)[i];
    }
  if (sum > 0)
    return 0;
  else
    return 1;
}

// --------------------------------------------------------------
//	Auction Algorithm for biparitite matching
//	 Gabrielle Demange, David Gale and Marilda Sotomayor "Multi-Item Auctions",
//	 The Journal of Political Economy, Vol. 94, No. 4 (Aug., 1986), pp. 863-872
//
//       Xiaolei Zhu added a distance cutoff for the pairs
// -----------------------------------------------------------
void nModifiedWeightedBipartiteMatching(vector<SEED>& seeds1, vector<SEED>& seeds2, 
					vector<vector<double> >& pairs, double threshold, 
					double wZerD, double wHist, double wDist,
					double wE, double wV, double wHB_pts,
					double wHP, double wA_pts)
{
  vector<SEED> bidders;
  vector<SEED> goods;
  //cout << "threshold" << threshold << endl;
  // make it so that bidder is smaller of the two
  if (seeds1.size() > seeds2.size()) 
    {
      bidders = seeds2;
      goods = seeds1;
    }
  else 
    {
      bidders = seeds1;
      goods = seeds2;
    }
  // variables of WBM
  vector<double> P; //  
  vector<int> owner; //
  vector<double> ownDist; //
  list<int> Q; //
  int ng = goods.size(); // num of goods
  int nb = bidders.size();
  double rho = 1.0 / ((double) ng + 1.0); // termaxation factor
  
  // initializtion
  P.resize(ng, 0);
  owner.resize(ng, -1);
  ownDist.resize(ng, -1);
  for (int i = 0; i < nb; i++)
    {
      Q.push_back(i);
    }
  //	for(int j=0;j<nb;j++){owner[j] = j;}
  
  // iteration
  int iter = 0;
  double PavgRP = 999;
  double NavgRP = 999;

  while (Q.size() > 0 && iter < nb * 30) // termaxation condition
    {
      iter++;
      // 1. dequeue
      int i = Q.front();
      Q.pop_front();
      if (isZero(bidders[i]))
	continue;
      
      // 2. find good that maximizes dij+pj
      //     dij ; amount that bidder i values good j
      double maxWP = -9999; // dist_ij - p_j
      double maxDist = MAXVAL;
      double d1, d2, d3;
      int maxInd = -1;
      for (int j = 0; j < ng; j++) 
	{
	  if (isZero(goods[j]))
	    continue;
	  double dist;
	  if (seeds1.size() > seeds2.size()) 
	    {
	      d1 = seedDist(goods[j], bidders[i], wE, wV, wHB_pts, wHP, wA_pts);
	      d2 = pcal(bidders[i], goods[j], seeds1.size());//distance distribution
	      d3 = rpd(bidders, goods, i, j, owner, 20);//relative distance
	      dist = wZerD * d1 + wHist * d2 + wDist * d3; // average patch number of pockets in kahraman data set is 22.5
	      //	      cout << j << " " << i << " " << d1 << " " << d2 << " " << d3 << " " << dist << endl;
	    } 
	  else 
	    {
	      d1 = seedDist(bidders[i], goods[j], wE, wV, wHB_pts, wHP, wA_pts);
	      d2 = pcal(bidders[i], goods[j], seeds1.size());
	      d3 = rpd(bidders, goods, i, j, owner, 20);
	      dist = wZerD * d1 + wHist * d2 + wDist * d3;
	      //	      cout << i << " " << j << " " << d1 << " " << d2 << " " << d3 << " " << dist << endl;
	    }
	  // printf("%d %d: %f %f %f %f\n", i, j, dist, d1, d2, d3);
	  if (maxWP < ((MAXVAL - dist) - P[j])) 
	    {
	      // cout << i << " " << j << " " << d1 << " " << d2 << " " << d3 << " " << dist << " " 
	      //	   << P[j] << endl;
	      maxInd = j;
	      maxWP = (MAXVAL - dist) - P[j];
	      maxDist = dist;
	    }
	}

      // 3. or by theshold value
      if (maxWP >= 0 && maxDist < threshold)
	{
	  //	  cout << "Max Index: " << maxInd << " Partner: " << i << endl;
	  ownDist[maxInd] = maxDist;
	  if (owner[maxInd] != -1)
	    Q.push_back(owner[maxInd]);
	  owner[maxInd] = i;
	  P[maxInd] = P[maxInd] + rho;
	}
    }

  // store the pairs (seeds1, seeds2)
  for (int j = 0; j < ng; j++) 
    {
      if (owner[j] == -1)
	continue;
      vector<double> tmp;
      if (seeds1.size() > seeds2.size())
	{
	  tmp.push_back(j);
	  tmp.push_back(owner[j]);
	} 
      else 
	{
	  tmp.push_back(owner[j]);
	  tmp.push_back(j);
	}
      tmp.push_back(ownDist[j]);
      pairs.push_back(tmp);
    }
  
}
// --------------------------------------------------------------
//
//       random matching
// -----------------------------------------------------------
void RandomMatching(vector<SEED>& seeds1, vector<SEED>& seeds2, vector<vector<double> >& pairs,
		    double threshold, double wZerD, double wHist, double wDist, double wE,
		    double wV, double wHB_pts, double wHP, double wA_pts)
{
  vector<SEED> bidders;
  vector<SEED> goods;
  
  // make it so that bidder is smaller of the two
  if (seeds1.size() > seeds2.size()) 
    {
      bidders = seeds2;
      goods = seeds1;
    }
  else 
    {
      bidders = seeds1;
      goods = seeds2;
    }
  // variables of WBM
  vector<double> P; //  
  vector<int> owner; //
  vector<double> ownDist; //
  list<int> Q; //
  int ng = goods.size(); // num of goods
  int nb = bidders.size();
  double rho = 1.0 / ((double) ng + 1.0); // termaxation factor
  vector<int> occupied;
  occupied.resize(ng,0);
  // initializtion
  P.resize(ng, 0);
  owner.resize(ng, -1);
  ownDist.resize(ng, -1);
  for (int i = 0; i < nb; i++)
    {
      Q.push_back(i);
    }
  //	for(int j=0;j<nb;j++){owner[j] = j;}
  srand (time(NULL));
  // iteration
  int iter = 0;
  int	fully_occupied;
  int j, jj;
  double PavgRP = 999;
  double NavgRP = 999;
  
  while (Q.size() > 0) // termaxation condition
    {
      iter++;
      // 1. dequeue
      int i = Q.front();
      Q.pop_front();
      
      if (isZero(bidders[i]))
	continue;
      
      // 2. find good that maximizes dij+pj
      //     dij ; amount that bidder i values good j
      double maxWP = -9999; // dist_ij - p_j
      double maxDist = MAXVAL;
      double d1, d2, d3;
      int maxInd = -1;
      // generate a random j
      while ( 1 )
	{
	  j = rand() % ng;
	  
	  if (occupied[j] == 0)
	    {
	      occupied[j] = 1;
	      break;
	    }
	  fully_occupied = 1;
	  for (jj = 0; jj < ng; jj++)
	    {
	      if (occupied[jj] == 0)
		{
		  fully_occupied = 0;	
		  break;
		}	
	    }
	  if (fully_occupied)
	    {
	      j = -1;
	      break;
	    }
	}
      
      if(j == -1)
	{
	  break;	
	}
      
      if (isZero(goods[j]))
	continue;
      double dist;
      if (seeds1.size() > seeds2.size())
	{
	  d1 = seedDist(goods[j], bidders[i], wE, wV, wHB_pts, wHP, wA_pts);
	  d2 = pcal(bidders[i], goods[j], seeds1.size());
	  d3 = rpd(bidders, goods, i, j, owner, 20);
	  dist = wZerD * d1 + wHist * d2 + wDist * d3; // average patch number of pockets in kahraman data set is 22.5
	}
      else 
	{
	  d1 = seedDist(bidders[i], goods[j], wE, wV, wHB_pts, wHP, wA_pts);
	  d2 = pcal(bidders[i], goods[j], seeds1.size());
	  d3 = rpd(bidders, goods, i, j, owner, 20);
	  dist = wZerD * d1 + wHist * d2 + wDist * d3;
	}
            
      maxInd = j;
      maxWP = (MAXVAL - dist) - P[j];
      maxDist = dist;
      
      ownDist[maxInd] = maxDist;
      owner[maxInd] = i;
      P[maxInd] = P[maxInd] + rho;
    }
  // store the pairs (seeds1, seeds2)
  
  for (int j = 0; j < ng; j++) 
    {
      if (owner[j] == -1)
	continue;
      vector<double> tmp;
      if (seeds1.size() > seeds2.size()) 
	{
	  tmp.push_back(j);
	  tmp.push_back(owner[j]);
	}
      else 
	{
	  tmp.push_back(owner[j]);
	  tmp.push_back(j);
	}
      tmp.push_back(ownDist[j]);
      pairs.push_back(tmp);
    }
  
}

void print_match_pairs(vector<SEED>& seed1V, vector<SEED>& seed2V, vector<vector<double> >& pairs, double wE, double wHB, double wHP)
{

  int idx_1, idx_2;
  double dist, dist_sqr, dx, dy, dz;
  double dZ, dH, dD;
  SEED seed_1, seed_2;

  if(pairs.size() == 0)
    {
      cout << "No matched pair" << endl;
      return;
    }

  for(int i=0; i<pairs.size(); i++)
    {
      if(pairs[i][2] == -1)
	continue;

      idx_1 = (int)pairs[i][0];
      idx_2 = (int)pairs[i][1];
      seed_1 = seed1V[idx_1];
      seed_2 = seed2V[idx_2];

      dx = seed_1.x - seed_2.x;
      dy = seed_1.y - seed_2.y;
      dz = seed_1.z - seed_2.z;

      dist_sqr = dx * dx + dy * dy + dz * dz;
      dist = sqrt(dist_sqr);

      printf("%2d %2d %2d %8.3f\n", i, idx_1, idx_2, dist);
    }
}
void evaluateMatch(vector<SEED>& seed1V, vector<SEED>& seed2V, vector<vector<double> >& pairs, 
		   double wZerD, double wHist, double wE, double wV, double wHB_pts,
		   double wHP, double wA_pts)
{
  
  if (pairs.size() == 0) 
    {
      cout << "SUM1: 999  AVG1: 999  SUM2: 999 AVG2: 999" << " AVGS 999 999 999 999" << endl;
      return;
    }
  
  double sum1 = 0, sumdS = 0, sumdE = 0, sumdV = 0, sumdHB_pts = 0;
  double sumdHP = 0, sumdA_pts = 0; 
  
  // pairwise distances --------------------------
  for (int i = 0; i < pairs.size(); i++) 
    {
      if (pairs[i][2] == -1)
	continue;
      
      int ind1 = (int) pairs[i][0], ind2 = (int) pairs[i][1];
      SEED s1 = seed1V[ind1], s2 = seed2V[ind2];
      
      double wdA = 0;
      double dx, dy, dz, dist;
      double dS = l2(s1.invS, s2.invS);
      double dE = l2(s1.invE, s2.invE);
      double dV = l2(s1.invV, s2.invV);
      double dHP = l2(s1.invHP, s2.invHP);
      double dHB_pts_don = pts_diff(s1.n_hbdon, s2.n_hbdon);
      double dHB_pts_acc = pts_diff(s1.n_hbacc, s2.n_hbacc);
      double dHB_pts = dHB_pts_don + dHB_pts_acc;
      double dA_pts = pts_diff(s1.n_arom, s2.n_arom);


      wdA = dS + wE * dE + wV * dV + wHB_pts * dHB_pts + wHP * dHP + wA_pts * dA_pts;

      double score = wZerD * wdA + wHist * pcal(s1, s2, seed1V.size());
      dx = s1.x - s2.x;
      dy = s1.y - s2.y;
      dz = s1.z - s2.z;
      dist = DIST3(dx, dy, dz);

      printf("%2d %2d %6.3f %6.3f %6.3f %6.3f %6.3f %6.3f %6.3f %6.3f %6.3f %6.3f %6.3f\n", 
	     ind1, ind2, pairs[i][2], wdA, pcal(s1,s2, seed1V.size()), score, dS, dE, dV, dHB_pts, dHP, dA_pts, dist);

      sum1 += score;
      
      sumdS += dS;
      sumdE += dE;
      sumdV += dV;
      sumdHB_pts += dHB_pts;
      sumdHP += dHP;
      sumdA_pts += dA_pts;
      
    }

  // relative position computing -------------------------------	
  double avgRP = ComputeAvgRP(seed1V, seed2V, pairs);
  double navgRP = nComputeAvgRP(seed1V, seed2V, pairs);
  
  // summary of overall distance & possition information
  
  int ps = pairs.size();
  printf("SUM: %6.3f AVG: %6.3f avgRP: %6.3f navgRP: %6.3f", sum1, sum1 / ps, navgRP, avgRP);
  printf(" AVGSd: %6.3f %6.3f %6.3f %6.3f %6.3f %6.3f\n", sumdS / ps, sumdE / ps, sumdV / ps, sumdHB_pts / ps, sumdHP / ps, sumdA_pts / ps);
  
}

int main(int argc, char** argv) 
{
  char * seed1FN = argv[1];
  char * seed2FN = argv[2];

  // weights for geodesic distances
  double wZerD= atof(argv[3]);
  double wHist = atof(argv[4]);
  double wDist = atof(argv[5]);
  double threshold = atof(argv[6]);

  // weights for physico-chemical characteristics
  double wE = 0.8;
  double wV = 1.4;
  double wHB_pts = 0.8;
  double wHP = 0.1;
  double wA_pts = 0.2;
  
  double dist;

  // variables
  vector<SEED> seed1V; // query
  vector<SEED> seed2V; // compared
  vector<vector<double> > pairs; // selected pairing

  // read seed 1 file
  readSeed(seed1FN, seed1V);
  readSeed(seed2FN, seed2V);
  
  // select pairs
  nModifiedWeightedBipartiteMatching(seed1V, seed2V, pairs, threshold, wZerD, wHist, wDist,
				     wE, wV, wHB_pts, wHP, wA_pts);

  // print of output
  evaluateMatch(seed1V, seed2V, pairs, wZerD, wHist, wE, wV, wHB_pts, wHP, wA_pts); 

  //  print_match_pairs(seed1V, seed2V, pairs);
  return 1;
}
