/*============================================
 * author				: Sael Lee 
 * last modified: April 10, 2010
 * description	: 
 *===========================================*/
#include "ProcessLocal.h"
#include "Common.h"
#include "Apbs2DX.h"
#include "MapPdb2Surf.h"
#include "ProcessPDB.h"
#include "Visibility.h"

void Usage(char* exc, char* op)
{
	cout << exc << " error for " << op  << "\n";
	cout << " REQUIRED:\n";
	cout << " 	-s  *_smol.dx\n";
	cout << "		-p pdb file name\n";
	cout << " 	-o output File name\n";
	cout << " 	-rad local LZDrad in Angstrom\n";
	cout << " OPTIONAL:\n";
	cout << " 	-ord Zernike order default 15\n";
	cout << " 	-d  *_pot.dx\n";
	cout << "		-q pqr file name\n";
	cout << " 	-l 	ligand pdb\n";
	cout << " 	-lsel  select seed by Ligand\n";
	cout << " 	-psel  select seed by surface Atom\n";
	cout << " 	-si seed interval default 1 (take every si seed)\n";
	cout << " 	-sf seed dx file\n";
	cout << "		-vis radius(to use visibility seed selection)\n";
	cout << "		-lsc ligand single center option\n";
	cout << "		-lcs using ligsite option\n";
	
}


int main(int argc, char** argv)
{
	
//=========================================================
// process argument
//=========================================================

	int 	order = 15;
	float LZDrad = 6; 
	float ligRad = 5;
	float visT =  LZDrad*(4.0/5.0);
//	float visT = 5;
	int interval = 1;
	float intervalF = 3.5;

	int 	dimX = MAXINT, dimY = MAXINT, dimZ = MAXINT;
	float delX = MAXINT, delY = MAXINT, delZ = MAXINT;
	float cenX = 0, cenY = 0, cenZ = 0; 
	
	char 	*smolFN, *potFN, *outFN, *seedFN, *pdbFN, *pqrFN, *ligFN;
	
	int 	check_pot=0,check_seed=0, check_lig=0;
	int 	check_pdb=0, check_pqr=0, check_vis=0;
	int   check_selSeedByAtm = 0, check_selSeedByLig = 0;
	int 	check_ligSingleCen = 0, check_lcs = 0;

	if(argc < 4){
		Usage(argv[0], "NUM of argument less then 3\n" );
		exit(-1);
	}
	
	for (int i=1; i<argc; i++) {
		if (strcmp(argv[i], "-s")==0) {
			smolFN = argv[++i];	
		} else if (strcmp(argv[i], "-d")==0) {
			potFN = argv[++i];	
			check_pot = 1;
		} else if (strcmp(argv[i], "-o")==0) {
			outFN = argv[++i];
		} else if (strcmp(argv[i], "-p")==0) {	
			pdbFN = argv[++i];
			check_pdb = 1;
		} else if (strcmp(argv[i], "-q")==0) {
			pqrFN = argv[++i];
			check_pqr = 1;
		} else if (strcmp(argv[i], "-l")==0) {
			ligFN = argv[++i];
			check_lig = 1;
		} else if (strcmp(argv[i], "-rad")==0) {
			if (sscanf(argv[++i], "%f", &LZDrad)!=1 || LZDrad <= 0) {
				Usage(argv[0], argv[i]); return -1;
			}
		} else if (strcmp(argv[i], "-ord")==0) {
			if (sscanf(argv[++i], "%d", &order)!=1 || order <= 0) {
				Usage(argv[0], argv[i]); return -1;
			}
		} else if (strcmp(argv[i], "-sa")==0) {
			if (sscanf(argv[++i], "%f", &intervalF)!=1 || intervalF <= 0) {
				Usage(argv[0], argv[i]); return -1;
			}
		} else if (strcmp(argv[i], "-si")==0) {
			if (sscanf(argv[++i], "%d", &interval)!=1 || interval <= 0) {
				Usage(argv[0], argv[i]); return -1;
			}
		} else if (strcmp(argv[i], "-sf")==0) {
			seedFN = argv[++i];	
			check_seed = 1;
		}  else if (strcmp(argv[i], "-vis")==0) {
			if (sscanf(argv[++i], "%f", &visT)!=1 || visT <= 0) {
				Usage(argv[0], argv[i]); return -1;
			}
			check_vis = 1;
		} else if (strcmp(argv[i], "-psel")==0) {
			check_selSeedByAtm = 1;
		} else if (strcmp(argv[i], "-lsel")==0) {
			check_selSeedByLig = 1;
		}	 else if (strcmp(argv[i], "-lsc")==0) {
			check_ligSingleCen = 1;
		}	 else if (strcmp(argv[i], "-lcs")==0) {
			check_lcs = 1;
		} else {
			Usage(argv[0], argv[i]); return -1;
		}

	} // end for
	
	
	// output file names------------------------
	char visOFN[20], kdOFN[20], epOFN[20], surfOFN[20], seedOFN[20], outOFN[20], pocketOFN[20];
	strcpy(visOFN, outFN); strcat(visOFN, "_vi.dx");
	strcpy(kdOFN, outFN); strcat(kdOFN, "_kd.dx");
	strcpy(epOFN, outFN); strcat(epOFN, "_ep.dx");
	strcpy(surfOFN, outFN); strcat(surfOFN, "_su.dx");
	strcpy(seedOFN, outFN); strcat(seedOFN, "_seed.dx");
	strcpy(outOFN, outFN); strcat(outOFN, ".seed");
	strcpy(pocketOFN, outFN); strcat(pocketOFN, "_poc.dx");

	
	cout << "OUTPUT FNS: " << epOFN << " " << surfOFN << " " << seedOFN << endl;
	//--------------------------------------------------------
	// 1. read mesh or apbs and make initial seed and surface 
	//--------------------------------------------------------

	SeedVec<double,float> seedVec;
	SurfVec<double,float> surfVec; 
	Apbs2DX<double,float> apbs2dx;

	apbs2dx.setSeedVec(&seedVec);
	apbs2dx.setSurfVec(&surfVec);
	apbs2dx.readacc(smolFN);
	apbs2dx.calSurf(1);
	if(check_pot){
		apbs2dx.readpot(potFN);
		apbs2dx.calSurfPot();
	}
	apbs2dx.calSurfFilled();


	//-----------------------------------------
	// 3. for each surf & seed calculate propertes 
	// (residue hydrophobicity, charge, nearest atom residue)
	//-----------------------------------------
	ProcessPDB<double,float> testpdb;
	testpdb.ReadPDB(pdbFN);
	if(check_pqr){ testpdb.ReadPQR(pqrFN); }
	testpdb.addHydro();
	vector<ATOMStruct> tempA = testpdb.getATOM();
	seedVec.getPara(dimX,dimY,dimZ, delX,delY,delZ,cenX,cenY,cenZ);
	MapPdb2Surf<double,float> pdb2surf;
	pdb2surf.mapKDhydro(tempA, LZDrad*(4.0/5.0), dimX, dimY, dimZ, delX,delY,delZ, cenX, cenY, cenZ, &surfVec, &seedVec);

	VolumeDX<double,float> csf = apbs2dx.getSurfFilled();
		
	Visibility<double,float> vis;
	vis.SurfVis(csf, visT, &seedVec, &surfVec);
	seedVec.GenVisHist(0.1, visT);
	

// -------------------------------------------------
// Select pocket surface 
// -------------------------------------------------
	float maxPocketRange = 5; 
	if(check_lig)
	{
		cout << "extract pocket region \n";
		if(check_ligSingleCen){
			surfVec.PocketSurf_lsc( ligFN, csf );
		}else {
			surfVec.PocketSurf( ligFN, csf );
		}
		seedVec.remapSeeds(surfVec);
		if(check_lcs){
			VolumeDX<double,float> tDX = surfVec.getSurfsDX();
			tDX.makeCompact();
			float _tdx, _tdy, _tdz;
			tDX.getDel(_tdx, _tdy, _tdz);
			int _tgx, _tgy, _tgz;
			tDX.getGs(_tgx, _tgy, _tgz);
			maxPocketRange = MIN( MIN((float)_tgx*_tdx, (float)_tgy*_tdy), (float)_tgz*_tdz);

	//		tDX.writeDX(pocketOFN);
			tDX.writeDX("Pocket.dx");
		}
	}
	

//-----------------------------------------
// Global DX file computation 
//-----------------------------------------
	VolumeDX<double,float> surfDX;
	VolumeDX<double,float> VisDX;
	VolumeDX<double,float> KDDX; 
	VolumeDX<double,float> EPDX;
	VolumeDX<double,float> seedDX;

	surfDX = surfVec.getSurfsDX(SF);
	surfDX.writeDX(surfOFN);

		VisDX = surfVec.getSurfsDX(VIS);
//	VisDX.writeDX(visOFN);		
//	VisDX.writeDX("Vis.dx");
//	VisDX.writeGrid("Vis.grid");


	KDDX = surfVec.getSurfsDX(KD);
//	KDDX.writeDX(kdOFN);	
	//KDDX.writeGrid("KD.grid");
	
	if(check_pot){
		 EPDX = surfVec.getSurfsDX(EP);
//		 EPDX.writeDX(epOFN);	
//		EPDX.writeGrid("EP.grid");
	}

//	seedDX = seedVec.getSeedsDX();
//	seedDX.writeDX(seedOFN);
	//	seedDX.writeGrid("seed.grid");
	
	
	// --------------------------------------
	//	2. select seed point 
	// --------------------------------------
	if( check_seed ){
		// not coded yet
		exit(-1); 
	}else if(check_vis){	// Selection of seed by Visibility 
		cout << "START select seed by visibility threshold "  << visT << endl;
		cout << "REDUCE SEED SIZE FROM: "<< seedVec.size()<< " ";
		seedVec.SelSeedByVis(visT, interval);
		cout << " TO: " << seedVec.size() << endl;
	}else if(check_selSeedByAtm) {  // not coded yet
		cout << "START select seed by close surface Atom"  << 2.0 << endl;
		cout << "REDUCE SEED SIZE FROM: "<< seedVec.size()<< " ";
		//seedVec.SelSeedByAtm( pdbFN, 3.5 );
	 	seedVec.SelSeedByAtm( pdbFN, intervalF );
		cout << " TO: " << seedVec.size() << endl;
	}else{
		cout << "START select seed by Interval: " 
					<< (float)interval*delX << " Angstroms ( every " 
					<< interval << " seed point )" << endl;
		cout << "REDUCE SEED SIZE FROM: "<< seedVec.size()<< " ";
		seedVec.SelSeedByInterval(interval);
		cout << " TO: " << seedVec.size() << endl;
	}
	
	//-----------------------------------------------------
	// 4. INTERFACE extraction if ligand specified 
	//-----------------------------------------------------
	ProcessPDB<double,float> testlig;
	testlig.ReadPDB(ligFN);
	if(check_lig && !check_lcs){
		if(check_selSeedByLig){
			cout << "START find seed closest to ligand atoms" << endl;
			seedVec.InterfaceSeedClosest(ligFN, ligRad);
		}else if( testlig.size()>3) {
			cout << "START find interface " << endl;
	  	seedVec.InterfaceSeed(ligFN, ligRad, MIN(ligRad, LZDrad));
		}else{
			seedVec.InterfaceSeed(ligFN, 8.5 , 0);
		}
	}else if(check_lig && check_lcs){
		float Prad = MAX( MIN (maxPocketRange/2.0 - 2.0 , 8.5), 3.0 ); 
		seedVec.InterfaceSeed(ligFN, Prad , 0);
cout << "TEST: Prad " << Prad << " maxPR " << maxPocketRange << endl;
	}

	seedDX = seedVec.getSeedsDX();
	seedDX.writeDX(seedOFN);
	//	seedDX.writeGrid("seed.grid");
	apbs2dx.clear();

for(int i=0; i<seedVec.size(); i++){
	int a,b,c;
	(seedVec.getSeed(i))->getABC(a,b,c);
	cout << a << " " << b << " " << c << endl;
}


	//----------------------------------------------------
	// 5. generate localZD for each of the selected seed
	//----------------------------------------------------	
	seedVec.getPara(dimX,dimY,dimZ, delX,delY,delZ,cenX,cenY,cenZ);

	cout << "SEED PARA: "<<dimX<< " " << dimY<< " " << dimZ << " " 
					<< delX << " " 	<< delY << " " 	<< delZ << " " 
					<< cenX << " " << cenY << " " << cenZ << endl;
	cout << "LZDrad: " << LZDrad << endl;

	// surface shape -- 
	ProcessLocal<double,float> pldxALL(SF, seedVec, surfDX, order, LZDrad );
	char fnameALL[20];
	strcpy(fnameALL, outFN);
	strcat(fnameALL, "_01");
	pldxALL.SaveInvs(fnameALL);
	pldxALL.SaveInvs(seedVec, SF);
			
	surfDX.makeCompact();
	int _gsX,_gsY, _gsZ; 
	surfDX.getGs(_gsX,_gsY,_gsZ);
	ZernikeDescriptor<double,float> zds(surfDX.getGrid(), _gsX, 20);	
	strcat(fnameALL,"_g.inv");
	zds.SaveInvariants(fnameALL);
	
	// electrostatic potential --
	if(check_pot){
		ProcessLocal<double,float> pldxEP(EP, seedVec, EPDX, order, LZDrad);
		char fnameEP[20];
		strcpy(fnameEP, outFN);
		strcat(fnameEP,"_EP");
		pldxEP.SaveInvs(fnameEP);
		pldxEP.SaveInvs(seedVec, EP);
	
		EPDX.makeCompact();
		_gsX,_gsY, _gsZ; 
		EPDX.getGs(_gsX,_gsY,_gsZ);
		ZernikeDescriptor<double,float> zde(EPDX.getGrid(), _gsX, order);	
		strcat(fnameEP,"_g.inv");
		zds.SaveInvariants(fnameEP);
	}

	// hydrophobicity -- 
if(1){
	ProcessLocal<double,float> pldxKD(KD, seedVec, KDDX, order, LZDrad);
	char fnameKD[20];
	strcpy(fnameKD, outFN);
	strcat(fnameKD,"_KD");
	pldxKD.SaveInvs(fnameKD);
	pldxKD.SaveInvs(seedVec, KD);

	KDDX.makeCompact();
	_gsX,_gsY, _gsZ; 
	KDDX.getGs(_gsX,_gsY,_gsZ);
	ZernikeDescriptor<double,float> zdh(KDDX.getGrid(), _gsX, order);	
	strcat(fnameKD,"_g.inv");
	zds.SaveInvariants(fnameKD);
	
	// visibility -- 
	ProcessLocal<double,float> pldxVIS(VIS, seedVec, VisDX, order, LZDrad );
	char fnameVIS[20];
	strcpy(fnameVIS, outFN);
	strcat(fnameVIS, "_vis");
	pldxVIS.SaveInvs(fnameVIS);
	pldxVIS.SaveInvs(seedVec, VIS);


	VisDX.makeCompact();
	_gsX,_gsY, _gsZ; 
	VisDX.getGs(_gsX,_gsY,_gsZ);
	ZernikeDescriptor<double,float> zdv(VisDX.getGrid(), _gsX, order);	
	strcat(fnameVIS,"_g.inv");
	zds.SaveInvariants(fnameVIS);
	
}
	//------------------------------------------
	// 6. Print out selected seeds 
	//-----------------------------------------

		cout << "PRINTING SEEDS" << endl;
		ofstream fout(outOFN);
		int temp = fout.is_open();
		cout << "here 0 " << temp << endl;
		if(temp){
			cout << "here 1\n";
			if(check_lig){
				cout << "here 2\n";
				seedVec.printSeeds(fout, testpdb, testlig);
			}else{
				cout << "here 3\n";
				seedVec.printSeeds(fout, testpdb);
			}
		}
		fout.close();

	
	return 0;	
}







