/*============================================
 * author				: Sael Lee, Xiaolei Zhu
 * last modified: May 21, 2013
 * description	: 
 * I copied genLocInvPocket.cpp to genLocInvPocketLig.cpp.
 * In this file, I will try to make this program suitable for geting 
 * patch 3DZD for any ligand
 *===========================================*/
#include "ProcessLocal.h"
#include "Common.h"
#include "Apbs2DX.h"
#include "MapPdb2Surf.h"
#include "ProcessPDB.h"
#include "Visibility.h"

void Usage(char* exc, char* op) {
	cout << exc << " error for " << op << "\n";
	cout << " REQUIRED:\n";
	cout << " 	-s  *_smol.dx\n";
	cout << "	-p pdb file name\n";
	cout << " 	-o output File name\n";
	cout << " 	-rad local LZDrad in Angstrom\n";
	cout << " OPTIONAL:\n";
	cout << " 	-ord Zernike order default 15\n";
	cout << " 	-d  *_pot.dx\n";
	cout << "	-q pqr file name\n";
	cout << " 	-l 	ligand pdb\n";
	cout << " 	-lsel  select seed by Ligand\n";
	cout << " 	-psel  select seed by surface Atom\n";
	cout << " 	-si seed interval default 1 (take every si seed)\n";
	cout << " 	-sf seed dx file\n";
	cout << "	-vis radius(to use visibility seed selection)\n";
	cout << "	-lsc ligand single center option\n";

}

int main(int argc, char** argv) {

	//=========================================================
	// process argument
	//=========================================================

	int order = 15;
	float LZDrad = 6;
	float ligRad = 5;
	float visT = LZDrad * (4.0 / 5.0);
	//	float visT = 5;
	int interval = 5;
	float intervalF = 3.5;

	int dimX = MAXINT, dimY = MAXINT, dimZ = MAXINT;
	float delX = MAXINT, delY = MAXINT, delZ = MAXINT;
	float cenX = 0, cenY = 0, cenZ = 0;

	char *smolFN, *potFN, *outFN, *seedFN, *pdbFN, *pqrFN, *ligFN, *ligMOL2, *XlogPFN;

	int check_pot = 0, check_seed = 0, check_lig = 0, check_dx = 0;
	int check_hb = 1, check_XlogP = 0, check_arom = 0;
	int check_pdb = 0, check_pqr = 0, check_vis = 0, check_ldx = 0;
	int check_selSeedByAtm = 0, check_selSeedByLig = 0;
	int check_ligSingleCen = 0, check_lcs = 0;

	if (argc < 4) {
		//OLD 1
		Usage(argv[0], "NUM of argument less then 3\n");
		exit(-1);
	}

	for (int i = 1; i < argc; i++) {
		if (strcmp(argv[i], "-s") == 0) {
			smolFN = argv[++i];
		} else if (strcmp(argv[i], "-xlp") == 0) {
		  XlogPFN = argv[++i];
		  check_XlogP = 1;
		} else if (strcmp(argv[i], "-ar") == 0) {
		  check_arom = 1;
		} else if (strcmp(argv[i], "-d") == 0) {
			potFN = argv[++i];
			check_pot = 1;
		} else if (strcmp(argv[i], "-o") == 0) {
			outFN = argv[++i];
		} else if (strcmp(argv[i], "-p") == 0) {
			pdbFN = argv[++i];
			check_pdb = 1;
		} else if (strcmp(argv[i], "-q") == 0) {
			pqrFN = argv[++i];
			check_pqr = 1;
		} else if (strcmp(argv[i], "-l") == 0) {
			ligFN = argv[++i];
			check_lig = 1;
		} else if (strcmp(argv[i], "-mol2") == 0) {
			ligMOL2 = argv[++i];
		} else if (strcmp(argv[i], "-rad") == 0) {
			if (sscanf(argv[++i], "%f", &LZDrad) != 1 || LZDrad <= 0) {
				Usage(argv[0], argv[i]);
				return -1;
			}
		} else if (strcmp(argv[i], "-ord") == 0) {
			if (sscanf(argv[++i], "%d", &order) != 1 || order <= 0) {
				Usage(argv[0], argv[i]);
				return -1;
			}
		} else if (strcmp(argv[i], "-sa") == 0) {
			if (sscanf(argv[++i], "%f", &intervalF) != 1 || intervalF <= 0) {
				Usage(argv[0], argv[i]);
				return -1;
			}
		} else if (strcmp(argv[i], "-si") == 0) {
			if (sscanf(argv[++i], "%d", &interval) != 1 || interval <= 0) {
				Usage(argv[0], argv[i]);
				return -1;
			}
		} else if (strcmp(argv[i], "-sf") == 0) {
			seedFN = argv[++i];
			check_seed = 1;
		} else if (strcmp(argv[i], "-vis") == 0) {
		  /*			if (sscanf(argv[++i], "%f", &visT) != 1 || visT <= 0) {
				Usage(argv[0], argv[i]);
				return -1;
				}*/
			check_vis = 1;
		} else if (strcmp(argv[i], "-psel") == 0) {
			check_selSeedByAtm = 1;
		} else if (strcmp(argv[i], "-lsel") == 0) {
			check_selSeedByLig = 1;
		} else if (strcmp(argv[i], "-lsc") == 0) {
			check_ligSingleCen = 1;
		} else if (strcmp(argv[i], "-lcs") == 0) {
			check_lcs = 1;
		} else if (strcmp(argv[i], "-dx") == 0) {
			check_dx = 1;
		} else if (strcmp(argv[i], "-ldx") == 0) {
			check_ldx = 1;
		} else {
			Usage(argv[0], argv[i]);
			return -1;
		}

	} // end for


	// output file names------------------------
	char visOFN[200], kdOFN[200], epOFN[200], hbOFN[200], surfOFN[200], seedOFN[200],
	  outOFN[200], pocketOFN[200], XlogPOFN[200], aromOFN[200];
	strcpy(visOFN, outFN);
	strcat(visOFN, "_vi.dx");
	strcpy(kdOFN, outFN);
	strcat(kdOFN, "_kd.dx");
	strcpy(epOFN, outFN);
	strcat(epOFN, "_ep.dx");
	strcpy(hbOFN, outFN);
	strcat(hbOFN, "_hb.dx");
	strcpy(surfOFN, outFN);
	strcat(surfOFN, "_su.dx");
	strcpy(seedOFN, outFN);
	strcat(seedOFN, "_seed.dx");
	strcpy(outOFN, outFN);
	strcat(outOFN, ".seed");
	strcpy(pocketOFN, outFN);
	strcat(pocketOFN, "_poc.dx");
	strcpy(XlogPOFN, outFN);
	strcat(XlogPOFN, "_XlogP.dx");
	strcpy(aromOFN, outFN);
	strcat(aromOFN, "_arom.dx");

	cout << "OUTPUT FNS: " << epOFN << " " << surfOFN << " " << seedOFN << endl;
	//--------------------------------------------------------
	// 1. read mesh or apbs and make initial seed and surface 
	//--------------------------------------------------------

	SeedVec<double, float> seedVec;
	SurfVec<double, float> surfVec;
	Apbs2DX<double, float> apbs2dx;

	apbs2dx.setSeedVec(&seedVec);
	apbs2dx.setSurfVec(&surfVec);
	apbs2dx.readaccLig(smolFN);
	apbs2dx.calSurf(1);
	if (check_pot) {
	  apbs2dx.readpotLig(potFN);
	  apbs2dx.calSurfPot();
	}
	apbs2dx.calSurfFilled();
	//the next three lines do nothing just to use mapSeedABC()
	int _aa, _bb, _cc;
	seedVec.getABC(_aa, _bb, _cc, 1);
	Seed<double,float>* tmpseed = seedVec.getSeed(_aa, _bb, _cc);

	//-----------------------------------------
	// 3. for each surf & seed calculate propertes 
	// (residue hydrophobicity, charge, nearest atom residue)
	//-----------------------------------------
	ProcessPDB<double, float> testpdb;
	testpdb.ReadMOL2(ligMOL2);
	testpdb.AssignLigandProperties();
	if(check_pqr)
	  {
	    testpdb.ReadPQR(pqrFN);
	  }
	if(check_XlogP)
	  {
	    testpdb.Read_XlogP(XlogPFN);
	    //	    testpdb.Assign_arom_to_H();
	  }
	vector<ATOMStruct> tempA = testpdb.getATOM();
	seedVec.getPara(dimX, dimY, dimZ, delX, delY, delZ, cenX, cenY, cenZ);
	MapPdb2Surf<double, float> pdb2surf;
	pdb2surf.mapHB(tempA, LZDrad*(4.0/5.0), dimX, dimY, dimZ, delX,delY,delZ, cenX, cenY, cenZ, &surfVec, &seedVec);
	if(check_XlogP)
	  {
	    pdb2surf.map_XlogP(tempA, LZDrad, dimX, dimY, dimZ, delX, delY, delZ, cenX, cenY, cenZ, &surfVec, &seedVec);
	    //pdb2surf.map_real_XlogP(tempA, LZDrad, dimX, dimY, dimZ, delX, delY, delZ, cenX, cenY, cenZ, &surfVec, &seedVec);
	  }
	if(check_arom)
	  {
	     pdb2surf.map_aromaticity(tempA, LZDrad, dimX, dimY, dimZ, delX, delY, delZ, cenX, cenY, cenZ, &surfVec, &seedVec);
	  }

	/*testpdb.ReadPDB(pdbFN);
	if (check_pqr) {
		testpdb.ReadPQR(pqrFN);
	}
	testpdb.addHydro();
	vector<ATOMStruct> tempA = testpdb.getATOM();
// 	seedVec.getPara(dimX, dimY, dimZ, delX, delY, delZ, cenX, cenY, cenZ);
	MapPdb2Surf<double, float> pdb2surf;
	pdb2surf.mapKDhydro(tempA, LZDrad * (4.0 / 5.0), dimX, dimY, dimZ, delX,
			delY, delZ, cenX, cenY, cenZ, &surfVec, &seedVec); //get KDhydro for surfvec, get nearest resvector and atomvector for seedvec
	*/
	VolumeDX<double, float> csf = apbs2dx.getSurfFilled();

	Visibility<double, float> vis;
	//	vis.SurfVis(csf, visT, &seedVec, &surfVec); //set VIS for seedvec and surfvec
	vis.SurfVis_lig(csf, visT, &seedVec, &surfVec); //set VIS for seedvec and surfvec
	seedVec.GenVisHist(0.1, visT);

	// -------------------------------------------------
	// Select pocket surface 
	// -------------------------------------------------
	float maxPocketRange = 5;
	if (check_lig) {
		cout << "extract pocket region \n";
		if (check_ligSingleCen) {
			surfVec.PocketSurf_lsc(ligFN, csf);
		} else {
		  surfVec.PocketSurf(ligFN, csf);
		}

		seedVec.remapSeeds(surfVec);
		if (check_lcs) {
			VolumeDX<double, float> tDX = surfVec.getSurfsDX();
			tDX.makeCompact();
			float _tdx, _tdy, _tdz;
			tDX.getDel(_tdx, _tdy, _tdz);
			int _tgx, _tgy, _tgz;
			tDX.getGs(_tgx, _tgy, _tgz);
			maxPocketRange = MIN(MIN((float) _tgx * _tdx, (float) _tgy * _tdy),
					(float) _tgz * _tdz);

			if (check_dx)
				tDX.writeDX(pocketOFN);
		}
	}

	//-----------------------------------------
	// Global DX file computation 
	//-----------------------------------------
	VolumeDX<double, float> surfDX;
	VolumeDX<double, float> VisDX;
	VolumeDX<double, float> KDDX;
	VolumeDX<double, float> EPDX;
	VolumeDX<double, float> HBDX;//hydrogen bond (by Bingjie)
	VolumeDX<double, float> XlogPDX;
	VolumeDX<double, float> aromDX; // aromatic ring (by W.-H. Shin)
	VolumeDX<double, float> seedDX;

	surfDX = surfVec.getSurfsDX(SF);
	if (check_dx)
		surfDX.writeDX(surfOFN);

	VisDX = surfVec.getSurfsDX(VIS);
	if (check_dx)
		VisDX.writeDX(visOFN);
	//		VisDX.writeDX("Vis.dx");
	//	VisDX.writeGrid("Vis.grid");

	/*KDDX = surfVec.getSurfsDX(KD);
	if (check_dx)
		KDDX.writeDX(kdOFN);*/
	//KDDX.writeGrid("KD.grid");

	if (check_pot) {
		EPDX = surfVec.getSurfsDX(EP);
		if (check_dx)
			EPDX.writeDX(epOFN);
		//		EPDX.writeGrid("EP.grid");
	}
	if (check_hb) {
		HBDX = surfVec.getSurfsDX(HB);//HB is defined in Common.h as the index for hydrogen bond
		if (check_dx)
			HBDX.writeDX(hbOFN);
		//		EPDX.writeGrid("EP.grid");
	}
	if(check_XlogP)
	  {
	    XlogPDX = surfVec.getSurfsDX(XLP);
	    if(check_dx)
	      {
		XlogPDX.writeDX(XlogPOFN);
	      }
	  }

	if(check_arom)
	  {
	    aromDX = surfVec.getSurfsDX(AROM);
	    if(check_dx)
	      {
		aromDX.writeDX(aromOFN);
	      }
	  }

	// --------------------------------------
	//	2. select seed point 
	// --------------------------------------
	if (check_seed) {
		// not coded yet
		exit(-1);
		/*	} else if (check_vis) { // Selection of seed by Visibility 
		cout << "START select seed by visibility threshold " << visT << endl;
		cout << "REDUCE SEED SIZE FROM: " << seedVec.size() << " ";
		seedVec.SelSeedByVis(visT, interval);
		cout << " TO: " << seedVec.size() << endl;*/
	} else if (check_selSeedByAtm) { // not coded yet
		cout << "START select seed by close surface Atom" << 2.0 << endl;
		cout << "REDUCE SEED SIZE FROM: " << seedVec.size() << " ";
		//seedVec.SelSeedByAtm( pdbFN, 3.5 );
		//seedVec.SelSeedByAtm(pdbFN, intervalF);
		seedVec.SelSeedByAtm_from_PQR(pqrFN, intervalF);
		cout << " TO: " << seedVec.size() << endl;
	} else {
		cout << "START select seed by Interval: " << (float) interval * delX
				<< " Angstroms ( every " << interval << " seed point )" << endl;
		cout << "REDUCE SEED SIZE FROM: " << seedVec.size() << " ";
		seedVec.SelSeedByInterval(interval);
		cout << " TO: " << seedVec.size() << endl;
	}

	//-----------------------------------------------------
	// 4. INTERFACE extraction if ligand specified 
	//-----------------------------------------------------
	ProcessPDB<double, float> testlig;
	testlig.ReadPDB(ligFN);
	//vector<ATOMStruct> tempA = testlig.getATOM();
	if (check_lig && !check_lcs) {
		if (check_selSeedByLig) {
			cout << "START find seed closest to ligand atoms" << endl;
			seedVec.InterfaceSeedClosest(ligFN, ligRad);
		} else if (testlig.size() > 3) {
			cout << "START find interface " << endl;
			seedVec.InterfaceSeed(ligFN, ligRad, MIN(ligRad, LZDrad));
		} else {
			seedVec.InterfaceSeed(ligFN, 8.5, 0);
		}
	} else if (check_lig && check_lcs) {
		float Prad = MAX(MIN(maxPocketRange / 2.0 - 2.0, 8.5), 3.0);
		seedVec.InterfaceSeed(ligFN, Prad, 0);
		cout << "TEST: Prad " << Prad << " maxPR " << maxPocketRange << endl;
	}
	//calculate the geodesic distance between seeds
	seedVec.mapDistBtwSeeds(surfVec);

	seedDX = seedVec.getSeedsDX();
	if (check_dx)
		seedDX.writeDX(seedOFN);
	//	seedDX.writeGrid("seed.grid");
	apbs2dx.clear();

	for (int i = 0; i < seedVec.size(); i++) {
		int a, b, c;
		(seedVec.getSeed(i))->getABC(a, b, c);
		cout << a << " " << b << " " << c << endl;
	}

	//----------------------------------------------------
	// 5. generate localZD for each of the selected seed
	//----------------------------------------------------	
	seedVec.getPara(dimX, dimY, dimZ, delX, delY, delZ, cenX, cenY, cenZ);
	//MapPdb2Surf<double, float> pdb2surf;
	//pdb2surf.mapHB(tempA, LZDrad * (4.0 / 5.0), dimX, dimY, dimZ, delX,
			//delY, delZ, cenX, cenY, cenZ, &surfVec, &seedVec); //get KDhydro for surfvec, get nearest resvector and atomvector for seedvec

	cout << "SEED PARA: " << dimX << " " << dimY << " " << dimZ << " " << delX
			<< " " << delY << " " << delZ << " " << cenX << " " << cenY << " "
			<< cenZ << endl;
	cout << "LZDrad: " << LZDrad << endl;

	// surface shape -- 
	ProcessLocal<double, float> pldxALL(SF, seedVec, surfDX, order, LZDrad);
	char fnameALL[200];
	strcpy(fnameALL, outFN);
	strcat(fnameALL, "_01");
	//pldxALL.SaveInvs(fnameALL);
	pldxALL.SaveInvs(seedVec, SF);

	surfDX.makeCompact();
	int _gsX, _gsY, _gsZ;
	surfDX.getGs(_gsX, _gsY, _gsZ);
	ZernikeDescriptor<double, float> zds(surfDX.getGrid(), _gsX, 20);
	strcat(fnameALL, "_g.inv");
	//zds.SaveInvariants(fnameALL);

	// electrostatic potential --
	if (check_pot) {
		ProcessLocal<double, float> pldxEP(EP, seedVec, EPDX, order, LZDrad);
		char fnameEP[200];
		strcpy(fnameEP, outFN);
		strcat(fnameEP, "_EP");
		//pldxEP.SaveInvs(fnameEP);
		pldxEP.SaveInvs(seedVec, EP);

		EPDX.makeCompact();
		int _gsX, _gsY, _gsZ;
		EPDX.getGs(_gsX, _gsY, _gsZ);
		ZernikeDescriptor<double, float> zde(EPDX.getGrid(), _gsX, order);
		//strcat(fnameEP, "_g.inv");
		//zds.SaveInvariants(fnameEP);
	}
	// hydrogenbond (3DZD)
	if (check_hb) {
		ProcessLocal<double, float> pldxHB(HB, seedVec, HBDX, order, LZDrad);
		char fnameHB[200];
		strcpy(fnameHB, outFN);
		strcat(fnameHB, "_HB");
		//pldxHB.SaveInvs(fnameHB);
		pldxHB.SaveInvs(seedVec, HB);

		HBDX.makeCompact();
		int _gsX, _gsY, _gsZ;
		HBDX.getGs(_gsX, _gsY, _gsZ);
		ZernikeDescriptor<double, float> zde(HBDX.getGrid(), _gsX, order);
		//strcat(fnameHB, "_g.inv");
		//zds.SaveInvariants(fnameHB);
	}
	// hydrophobicity - XlogP
	if (check_XlogP)
	  {
	    ProcessLocal<double, float> pldxXlogP(XLP, seedVec, XlogPDX, order, LZDrad);
	    char fnameXlogP[200];
	    strcpy(fnameXlogP, outFN);
	    strcat(fnameXlogP, "_XlogP");
	    //pldxHB.SaveInvs(fnameHB);
	    pldxXlogP.SaveInvs(seedVec, XLP);
	    
	    XlogPDX.makeCompact();
	    int _gsX, _gsY, _gsZ;
	    XlogPDX.getGs(_gsX, _gsY, _gsZ);
	    ZernikeDescriptor<double, float> zdx(XlogPDX.getGrid(), _gsX, order);
	    //	    strcat(fnameXlogP, "_g.inv");
	    //	    zdx.SaveInvariants(fnameXlogP);
	  }
	// aromaticity
	if (check_arom)
	  {
	    ProcessLocal<double, float> pldxArom(AROM, seedVec, aromDX, order, LZDrad);
	    char fnameArom[200];
	    strcpy(fnameArom, outFN);
	    strcat(fnameArom, "arom");
	    //pldxHB.SaveInvs(fnameHB);
	    pldxArom.SaveInvs(seedVec, AROM);
	    
	    aromDX.makeCompact();
	    int _gsX, _gsY, _gsZ;
	    aromDX.getGs(_gsX, _gsY, _gsZ);
	    ZernikeDescriptor<double, float> zda(aromDX.getGrid(), _gsX, order);
	    //	    strcat(fnameXlogP, "_g.inv");
	    //	    zdx.SaveInvariants(fnameXlogP);
	  }

	
	// Visibility
	if(check_vis)
	  {
	    ProcessLocal<double, float> pldxVIS(VIS, seedVec, VisDX, order, LZDrad);
	    char fnameVIS[20];
	    strcpy(fnameVIS, outFN);
	    strcat(fnameVIS, "_vis");
	    //pldxVIS.SaveInvs(fnameVIS);
	    pldxVIS.SaveInvs(seedVec, VIS);

	    VisDX.makeCompact();
	    _gsX, _gsY, _gsZ;
	    VisDX.getGs(_gsX, _gsY, _gsZ);
	    ZernikeDescriptor<double, float> zdv(VisDX.getGrid(), _gsX, order);
	    strcat(fnameVIS, "_g.inv");
	    //zds.SaveInvariants(fnameVIS);
	  }
	
	// hydrogenbond (simple count)
	/*if (check_hb) {
		ProcessLocal<double, float> pldxHB(HB, seedVec, HBDX, order, LZDrad);
		char fnameHB[200];
		strcpy(fnameHB, outFN);
		strcat(fnameHB, "_HB");
		pldxHB.SaveInvs(fnameHB);
		pldxHB.SaveInvs(seedVec, HB);

		HBDX.makeCompact();
		int _gsX, _gsY, _gsZ;
		HBDX.getGs(_gsX, _gsY, _gsZ);
		ZernikeDescriptor<double, float> zde(HBDX.getGrid(), _gsX, order);
		strcat(fnameHB, "_g.inv");
		zds.SaveInvariants(fnameHB);
	}*/

	// hydrophobicity -- 
	/*if (1) {
		ProcessLocal<double, float> pldxKD(KD, seedVec, KDDX, order, LZDrad);
		char fnameKD[20];
		strcpy(fnameKD, outFN);
		strcat(fnameKD, "_KD");
		pldxKD.SaveInvs(fnameKD);
		pldxKD.SaveInvs(seedVec, KD);

		KDDX.makeCompact();
		_gsX, _gsY, _gsZ;
		KDDX.getGs(_gsX, _gsY, _gsZ);
		ZernikeDescriptor<double, float> zdh(KDDX.getGrid(), _gsX, order);
		strcat(fnameKD, "_g.inv");
		zds.SaveInvariants(fnameKD);

		// visibility -- 
		ProcessLocal<double, float> pldxVIS(VIS, seedVec, VisDX, order, LZDrad);
		char fnameVIS[20];
		strcpy(fnameVIS, outFN);
		strcat(fnameVIS, "_vis");
		pldxVIS.SaveInvs(fnameVIS);
		pldxVIS.SaveInvs(seedVec, VIS);

		VisDX.makeCompact();
		_gsX, _gsY, _gsZ;
		VisDX.getGs(_gsX, _gsY, _gsZ);
		ZernikeDescriptor<double, float> zdv(VisDX.getGrid(), _gsX, order);
		strcat(fnameVIS, "_g.inv");
		zds.SaveInvariants(fnameVIS);

	}*/
	//------------------------------------------
	// 6. Print out selected seeds 
	//-----------------------------------------

	cout << "PRINTING SEEDS" << endl;
	ofstream fout(outOFN);
	if (fout.is_open()) {
		if (check_lig) {
	//		seedVec.printSeeds(fout, testpdb, testlig);
			seedVec.printSeeds(fout);
			printf("I am ok here\n");
		} else {
			seedVec.printSeeds(fout, testpdb);
		}
	}
	fout.close();

	return 0;
}

