
/*============================================
 *
 * Sael Lee 
 * May 25, 2011
 * given PDB  and _smol.dx (_pot.dx) 
 * find surface region, 
 * 			visibility of surface region
 *===========================================*/

#include "ProcessLocal.h"
#include "Common.h"
#include "Apbs2DX.h"
#include "MapPdb2Surf.h"
#include "ProcessPDB.h"
#include "Visibility.h"

void Usage(char* exc, char* op)
{
	cout << exc << " error for " << op  << "\n";
	cout << " REQUIRED:\n";
	cout << "   -s  *_smol.dx\n";
	cout << "   -p pdb file name\n";
	cout << "   -o output File name\n";
	cout << " OPTIONAL:\n";
	cout << "   -l 	ligand pdb\n";
	cout << "		-d  *_pot.dx\n";
	cout << "		-q  pqr file name\n";
	cout << "		-zo order of 3DZD\n";
}


int main(int argc, char** argv)
{
	
//=========================================================
// process argument
//=========================================================

	float ligRad = 3.5;
	float visT = 10;
	int interval = 100;
	int order = 20;

	int 	dimX = MAXINT, dimY = MAXINT, dimZ = MAXINT;
	float delX = MAXINT, delY = MAXINT, delZ = MAXINT;
	float cenX = 0, cenY = 0, cenZ = 0; 
	
	char 	*smolFN, *potFN, *outFN, *seedFN, *pdbFN, *pqrFN, *ligFN;
	
	int check_lig = 0, check_pot = 0, check_pqr = 0;

	if(argc < 4){
		Usage(argv[0], "NUM of argument less then 3\n" );
		exit(-1);
	}
	
	for (int i=1; i<argc; i++) {
		
		if (strcmp(argv[i], "-s")==0) {
			smolFN = argv[++i];	
		} else if (strcmp(argv[i], "-o")==0) {
			outFN = argv[++i];
		} else if (strcmp(argv[i], "-p")==0) {	
			pdbFN = argv[++i];
		} else if (strcmp(argv[i], "-l")==0) {
			ligFN = argv[++i];
			check_lig = 1;
		} else if (strcmp(argv[i], "-d")==0){
			potFN = argv[++i];
			check_pot = 1;
		} else if (strcmp(argv[i], "-q")==0){
			pqrFN = argv[++i];
			check_pqr = 1;
		} else if(strcmp(argv[i], "-zo")==0){
			order = atoi(argv[++i]);
		} else {
			Usage(argv[0], argv[i]); return -1;
		}

	} // end for

	
	// output file names------------------------
	char surfOFN[20], interOFN[20], visOFN[20], kdOFN[20], epOFN[20];
	strcpy(surfOFN, outFN); strcat(surfOFN, "_surf.dx");
	strcpy(interOFN, outFN); strcat(interOFN, "_inter.dx");
	strcpy(visOFN, outFN); strcat(visOFN, "_vis.dx");
	
	cout << "OUTPUT FNS: " << surfOFN << " " << interOFN << " " << visOFN << endl;
	//-----------------------------------------
	// 0. read mesh or apbs 
	//-----------------------------------------

	SeedVec<double,float> seedVec;
	SurfVec<double,float> surfVec; 
	Apbs2DX<double,float> apbs2dx;

	//-----------------------------------------
	// 1. generate surf, seeds, acc	
	//----------------------------------------
	apbs2dx.setSeedVec(&seedVec);
	apbs2dx.setSurfVec(&surfVec);
	apbs2dx.readacc(smolFN);
	apbs2dx.calSurf(1);
	if(check_pot){
		apbs2dx.readpot(potFN);
		apbs2dx.calSurfPot();
	}
	apbs2dx.calSurfFilled();


	VolumeDX<double,float> surfDX;
	VolumeDX<double,float> surfPotDX;
	VolumeDX<double,float> seedDX;


	// surface ---------------------------
	surfDX = apbs2dx.getSurf();
	surfDX.writeDX(surfOFN);

	//-----------------------------------------
	// 2. visibility
	//-----------------------------------------
	
	Visibility<double,float> vis;
	apbs2dx.calSurfFilled();
	VolumeDX<double,float> csf = apbs2dx.getSurfFilled();
	vis.SurfVis(csf, visT, &seedVec, &surfVec);
//		vis.SeedVis(csf, visT, &seedVec);
	VolumeDX<double,float> VisDX;
	VisDX = surfVec.getSurfsDX(VIS);
	VisDX.writeDX(visOFN);	
//	VisDX.writeGrid("Vis.grid");

	apbs2dx.clearAcc();
	apbs2dx.clearPot();
//	apbs2dx.clearSurf();
//	apbs2dx.clearSeed();


	//-----------------------------------------
	// 3. for each surf & seed calculate propertes
	//-----------------------------------------
	ProcessPDB<double,float> testpdb;
	testpdb.ReadPDB(pdbFN);
	if(check_pqr){ testpdb.ReadPQR(pqrFN); }
	testpdb.addHydro();
	vector<ATOMStruct> tempA = testpdb.getATOM();
	seedVec.getPara(dimX,dimY,dimZ, delX,delY,delZ,cenX,cenY,cenZ);
	MapPdb2Surf<double,float> pdb2surf;
	pdb2surf.mapKDhydro(tempA, 2.5, dimX, dimY, dimZ, delX,delY,delZ, cenX, cenY, cenZ, &surfVec, &seedVec);


//-----------------------------------------
// Global DX file computation 
//-----------------------------------------

	VolumeDX<double,float> KDDX; 
	VolumeDX<double,float> EPDX;
	
	surfDX = surfVec.getSurfsDX(SF);
	surfDX.writeDX(surfOFN);
	surfDX.writeGrid("Surf.grid");
	
	VisDX = surfVec.getSurfsDX(VIS);
	VisDX.writeDX(visOFN);		
	VisDX.writeGrid("Vis.grid");
	
	KDDX = surfVec.getSurfsDX(KD);
	KDDX.writeDX(kdOFN);	
	KDDX.writeGrid("KD.grid");
	
	if(check_pot){
		 EPDX = surfVec.getSurfsDX(EP);
		 EPDX.writeDX(epOFN);	
		 EPDX.writeGrid("EP.grid");
	}

	apbs2dx.clear();

	seedDX = seedVec.getSeedsDX();


	//----------------------------------------------------
	// 5. generate localZD for each of the selected seed
	//----------------------------------------------------	
seedVec.getPara(dimX,dimY,dimZ, delX,delY,delZ,cenX,cenY,cenZ);

	cout << "SEED PARA: "<<dimX<< " " << dimY<< " " << dimZ << " " 
					<< delX << " " 	<< delY << " " 	<< delZ << " " 
					<< cenX << " " << cenY << " " << cenZ << endl;

	char fnameALL[20];
	strcpy(fnameALL, outFN);
	int _gsX,_gsY, _gsZ; 
	surfDX.getGs(_gsX,_gsY,_gsZ);
	ZernikeDescriptor<double,float> zds(surfDX.getGrid(), _gsX, 20);	
	strcat(fnameALL,"_gS.inv");
	zds.SaveInvariants(fnameALL);
	
	// electrostatic potential --
	if(check_pot){
		char fnameEP[20];
		strcpy(fnameEP, outFN);
	
		EPDX.getGs(_gsX,_gsY,_gsZ);
		double * grid = EPDX.getGrid();
		double * gridP = new double [_gsX*_gsY*_gsZ]; 
		double * gridN = new double [_gsX*_gsY*_gsZ]; 
		for (int i = 0; i < _gsX*_gsY*_gsZ; i++)
		{
			if(grid[i]>0){
				gridP[i] = grid[i];
				gridN[i] = 0;
			}else if(grid[i]<0){
				gridP[i] = 0;
				gridN[i] = grid[i];		
			}else{
				gridP[i] = 0;
				gridN[i] = 0;
			}
		}

		ZernikeDescriptor<double,float> zdeP(gridP, _gsX, order);	
		ZernikeDescriptor<double,float> zdeN(gridN, _gsX, order);	
		strcat(fnameEP,"_gE.inv");
		vector<float> Pinv; vector<float> Ninv;
		zdeP.SaveInvariants(Pinv); 
		zdeN.SaveInvariants(Ninv);
		FILE * outfEP;
		outfEP = fopen(fnameEP, "w");
		if(outfEP != NULL){
			int size =  Pinv[0] + Ninv[0];
			fprintf(outfEP, "%d\n", size );
			for(int i=1; i<Pinv.size(); i++){
				fprintf(outfEP, "%.5f\n", Pinv[i]);
			}
			for(int i=1; i<Ninv.size(); i++){
				fprintf(outfEP, "%.5f\n", Ninv[i]);
			}
		}
		fclose(outfEP);
		delete [] gridP;
		delete [] gridN;
	}

	// hydrophobicity -- 
	char fnameKD[20];
	strcpy(fnameKD, outFN);
	KDDX.getGs(_gsX,_gsY,_gsZ);
	
	double * grid = KDDX.getGrid();
	double * gridP = new double [_gsX*_gsY*_gsZ]; 
	double * gridN = new double [_gsX*_gsY*_gsZ];
	for (int i = 0; i < _gsX*_gsY*_gsZ; i++)
	{
		if(grid[i]>0){
			gridP[i] = grid[i];
			gridN[i] = 0;
		}else if(grid[i]<0){
			gridP[i] = 0;
			gridN[i] = grid[i];		
		}else{
			gridP[i] = 0;
			gridN[i] = 0;
		}
	}

	ZernikeDescriptor<double,float> zdhP(gridP, _gsX, order);	
	ZernikeDescriptor<double,float> zdhN(gridN, _gsX, order);	
	strcat(fnameKD,"_gH.inv");
	vector<float> Pinv; vector<float> Ninv;
	zdhP.SaveInvariants(Pinv); 
	zdhN.SaveInvariants(Ninv);
	FILE * outfKD;
	outfKD = fopen(fnameKD, "w");
	if(outfKD != NULL){
		int size =  Pinv[0] + Ninv[0];
		fprintf(outfKD, "%d\n", size );
		for(int i=1; i<Pinv.size(); i++){
			fprintf(outfKD, "%.5f\n", Pinv[i]);
		}
		for(int i=1; i<Ninv.size(); i++){
			fprintf(outfKD, "%.5f\n", Ninv[i]);
		}
	}
	delete [] gridP;
	delete [] gridN;

	// visibility -- 
	char fnameVIS[20];
	strcpy(fnameVIS, outFN);
	VisDX.getGs(_gsX,_gsY,_gsZ);
	ZernikeDescriptor<double,float> zdv(VisDX.getGrid(), _gsX, order);	
	strcat(fnameVIS,"_gV.inv");
	zdv.SaveInvariants(fnameVIS);
	
	return 0;	
}

