//#define DEBUG_AROM
#define DEBUG_XlogP_prot
#include "ProcessLocal.h"
#include "Common.h"
#include "Apbs2DX.h"
#include "MapPdb2Surf.h"
#include "ProcessPDB.h"
#include "Visibility.h"

int main()
{
  // Declare Variables

  // file names
  char *pdb_file = "1p8d_H.pdb";
  char *XlogP_file = "1p8d_H.xlp";
  char *pqr_file = "1p8d_H.pqr";
  char *smol_file = "1p8d_H_smol.dx";
  char *pot_file = "1p8d_H_pot.dx";
  char *lig_file = "1p8d_H_lig.pdb";

  // grid information variables
  int x_dim, y_dim, z_dim;
  float x_itv, y_itv, z_itv;
  float x_cntr, y_cntr, z_cntr;

  // initializing grid variables
  x_dim = y_dim = z_dim = MAXINT;
  x_itv = y_itv = z_itv = MAXINT;
  x_cntr = y_cntr = z_cntr = 0.0;

  float LZDrad = 6.0;
  float MHP_Dcut = 10.0;

  // classes
  SeedVec<double, float> seedVec;
  SurfVec<double, float> surfVec;
  Apbs2DX<double, float> apbs2dx;
  ProcessPDB<double, float> testpdb;

  apbs2dx.setSeedVec(&seedVec);
  apbs2dx.setSurfVec(&surfVec);
  apbs2dx.readacc(smol_file);
  apbs2dx.calSurf(1);
  apbs2dx.readpot(pot_file);
  apbs2dx.calSurfPot();
  apbs2dx.calSurfFilled();

  //  testpdb.ReadPDB(pdb_file);
  //testpdb.ReadPQR(pqr_file);
  testpdb.ReadPQR_detail(pqr_file);
  //testpdb.addHB();
  //testpdb.Read_XlogP(XlogP_file);
  testpdb.assign_XlogP_prot();
  //vector<ATOMStruct> tempA = testpdb.getATOM();
  
  //  seedVec.getPara(x_dim, y_dim, z_dim, x_itv, y_itv, z_itv, x_cntr, y_cntr, z_cntr);
  // MapPdb2Surf<double, float> pdb2Surf;
  //pdb2Surf.map_XlogP(tempA, MHP_Dcut, x_dim, y_dim, z_dim, x_itv, y_itv, z_itv, x_cntr, y_cntr, z_cntr, &surfVec, &seedVec);
  //  pdb2Surf.map_aromaticity(tempA, MHP_Dcut, x_dim, y_dim, z_dim, x_itv, y_itv, z_itv, x_cntr, y_cntr, z_cntr, &surfVec, &seedVec);
  // pdb2Surf.mapHB(tempA, LZDrad*(4.0/5.0), x_dim, y_dim, z_dim, x_itv, y_itv, z_itv, x_cntr, y_cntr, z_cntr, &surfVec, &seedVec);

  //  float visT = 6.0;
  //  VolumeDX<double, float> csf = apbs2dx.getSurfFilled();
  //  Visibility<double, float> vis;
  //  vis.SurfVis(csf, visT, &seedVec, &surfVec);
  //  seedVec.GenVisHist(0.1, visT);

  //  float maxPocketRange = 5;
  //  surfVec.PocketSurf_lsc(lig_file, csf);
  //  seedVec.remapSeeds(surfVec);
  
  //  VolumeDX<double, float> XLPDX;
  //  VolumeDX<double, float> surfDX;
  //  VolumeDX<double, float> EPDX;

  //  surfDX = surfVec.getSurfsDX(SF);
  //  EPDX = surfVec.getSurfsDX(EP);
  //  XLPDX = surfVec.getSurfsDX(XLP);
  
  return 0;
}
