/*============================================
 *
 * Sael Lee 
 * Oct. 16, 2007
 *
 *===========================================*/

#ifndef VOLUMEDX_H
#define VOLUMEDX_H

// ---- std includes ---
#include <vector>
#include <iostream>
#include <fstream>

using namespace std;

#include <stdio.h>
#include <cstring>
#include <cmath>


template<class T, class TIn>
class VolumeDX 
{
private:
//	char* comment_;
//	char* header_;
//	char* tail_;
	TIn delX_, delY_, delZ_; 						// interval size
	int gsX_, gsY_, gsZ_;							// grid point count
	TIn minX_, minY_, minZ_;						// origin
	TIn cenX_, cenY_, cenZ_;
	
	T* grid_;
public:
	VolumeDX();
	void clear();
	/*
	char* getComment(){return comment_;};
	void setComment(const char* _comment){comment_ = new char[strlen(_comment)]; strcpy(comment_,_comment);};
	
	char* getHeader(){return header_;};
	void setHeader(const char* _header){header_ = new char[strlen(_header)]; strcpy(header_,_header);};

	char* getTail(){return tail_;};
	void setTail(const char* _tail){tail_ = new char[strlen(_tail)]; strcpy(tail_,_tail);};
	
	*/
	
	T* getGrid(){return grid_;};
	void getGrid( vector<T>  &_grid );												// make grid cubic and return cubic grid
	void setGrid(T* _grid){	
		if(grid_!=NULL){delete [] grid_; grid_ = NULL; } 
		grid_ = _grid;
	};
	
	void getDel(TIn& _delX, TIn& _delY,TIn& _delZ){_delX=delX_; _delY=delY_; _delZ=delZ_;};
	void setDel(TIn _delX, TIn _delY,TIn _delZ){delX_=_delX; delY_=_delY; delZ_=_delZ;};
	
	void getMin(TIn&_minX, TIn& _minY,TIn& _minZ){_minX=minX_; _minY=minY_; _minZ=minZ_;};
	void setMin(TIn _minX, TIn _minY,TIn _minZ){minX_=_minX; minY_=_minY; minZ_=_minZ;};
	
	void getGs(int& _gsX, int& _gsY,int& _gsZ){_gsX=gsX_; _gsY=gsY_; _gsZ=gsZ_;};
	void setGs(int _gsX, int _gsY,int _gsZ){gsX_=_gsX; gsY_=_gsY; gsZ_=_gsZ;};

	int getPara(int& _gs, TIn& _del, TIn& _cenX, TIn& _cenY, TIn& _cenZ );
	void setPara(int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ );
		
	int getPara(int& _gsX, int& _gsY, int& _gsZ, TIn& _delX, TIn& _delY, TIn& _delZ, TIn& _cenX, TIn& _cenY, TIn& _cenZ);
	void setPara(int _gsX, int _gsY, int _gsZ, TIn _delX, TIn _delY, TIn _delZ,  TIn _cenX, TIn _cenY, TIn _cenZ);

	void printPara(){
		cout << "Para: \n" 
			<< "\tgs: "<< gsX_ << " "  << gsY_ << " " << gsZ_ << " " 
			<< "\tcen: " << cenX_ << " " << cenY_ << " " << cenZ_ << " " 
			<< "\tdel: " << delX_ << " " << delY_ << " " << delZ_ << endl;
	};
	
	void copyDX(VolumeDX<T,TIn> &_dx);
	
	// read apbs dx volume data
	void readDX(const char* _fname);

	// write apbs dx volume data
	void writeDX(const char* _fname);

	// write only the voxel data
	void writeGrid(const char* _fname);

	void makeSphere(int _gs);
	void makeSphereV2(int _gs);

	void makeCompact();

	void reduceSize();

private:

		void TRANSFORMTO(int _i, int _j, int _k, TIn& _a, TIn& _b, TIn& _c)
		{
			_a = ((TIn)_i - ((TIn)gsX_ - 1.0)/2.0)*delX_ + cenX_;
			_b = ((TIn)_j - ((TIn)gsY_ - 1.0)/2.0)*delY_ + cenY_;
			_c = ((TIn)_k - ((TIn)gsZ_ - 1.0)/2.0)*delZ_ + cenZ_;
		};

		void TRANSFORMFROM(TIn _a, TIn _b, TIn _c, int& _aa, int& _bb, int& _cc)
		{
			_aa = (int)((_a - cenX_)/delX_ + ((TIn)gsX_ - 1.0)/2.0);
			_bb = (int)((_b - cenY_)/delY_ + ((TIn)gsY_ - 1.0)/2.0);
			_cc = (int)((_c - cenZ_)/delZ_ + ((TIn)gsZ_ - 1.0)/2.0);
		};
	
};

#include "VolumeDX.cpp"

#endif
