/*
 * Sael Lee
 */
	
	
template <class T, class TIn>
VolumeDX<T,TIn>::VolumeDX()
{
//	comment_="\0";
//	header_="\0";
//	tail_="\0";
	delX_=0, delY_=0, delZ_=0; 		// interval size
	gsX_=0, gsY_=0, gsZ_=0;							// grid point count
	minX_=0, minY_=0, minZ_=0;							// origin
	
	grid_ = NULL;

}

template <class T, class TIn>
void VolumeDX<T,TIn>::clear()
{
	if(grid_ != NULL) 
	{
		delete [] grid_;
		grid_ = NULL;
	}
}

template <class T, class TIn>
void VolumeDX<T,TIn>::readDX(const char* _fname)
{
//	char _comment[1024] = "\0";
//	char _header[1024] = "\0";
//	char _tail[1024] = "\0";
	int _gsX,_gsY, _gsZ;
	TIn _minX, _minY, _minZ;
	TIn _delX, _delY, _delZ;
	vector<T> _grid;
	
	ifstream fin(_fname);
	if(!fin.is_open()){
		cout << "File " << _fname << "not found in readDX()\n" << endl;
		exit(1);
	}
	
	char s[256];
	while(!fin.eof()){
		fin >> s;	
		//comments
		if( !strcmp(s,"#") ){
			fin.unget();
			fin.getline(s, 256);
//			strcat(_comment, s);
//			strcat(_comment,"\n");
		}
		//object 1 class gridpositions counts 65 65 65
		else if(!strcmp(s,"object"))
		{
#ifdef DEBUG
			cout << "object" << endl;
#endif
			fin >> s;	// 1 or 2 or \"*\"
			if(!strcmp(s, "1")) 
			{
				fin >> s;	// "class"
				fin >> s;	// "gridpositions" 
				fin >> s; // "counts"
				fin >> s; _gsX = atoi(s);
				fin >> s; _gsY = atoi(s);
				fin >> s; _gsZ = atoi(s);
				setGs(_gsX, _gsY, _gsZ);
//				sprintf(s, "object 1 class gridpositions counts %d %d %d\n", _gsX, _gsY, _gsZ); 
//				strcat(_header, s );
				_grid.clear();
				_grid.resize(_gsX*_gsY*_gsZ);				
			}
			else if(!strcmp(s, "2")) 
			{
				fin.ignore(256,'\n');
//				sprintf(s, "object 2 class gridconnections counts %d %d %d\n",_gsX, _gsY, _gsZ); 
//				strcat(_header, s);
			}
			else if(!strcmp(s, "3")) 
			{
				fin.ignore(256,'\n');
//				sprintf(s,"object 3 class array type double rank 0 items %d data follows\n", _gsX*_gsY*_gsZ);
//				strcat(_header, s);
				// get data	
#ifdef DEBUG
				cout << "DATA" << endl;
#endif
				for(int i=0; i<_gsX*_gsY*_gsZ; i++)
				{
					fin >> s;
					T ftmp = atof(s);
					_grid[i]=ftmp;
				}	
			}
			else 
			{
//				strcat(_tail, "object ");
//				strcat(_tail, s);
//				strcat(_tail," ");
				fin.getline(s, 256);
//				strcat(_tail, s);
//				strcat(_tail, "\n");
			}
		}
		else if(!strcmp(s,"origin"))
		{
#ifdef DEBUG
			cout << "origin" << endl;
#endif
			fin >> s; _minX = atof(s);
			fin >> s; _minY = atof(s);
			fin >> s; _minZ = atof(s);
			setMin(_minX,_minY, _minZ);
//			sprintf(s, "origin %f %f %f\n");
//			strcat(_header, s);
		} 
		else if(!strcmp(s,"delta"))
		{
#ifdef DEBUG
			cout << "delta" << endl;
#endif
			fin >> s; _delX = atof(s); fin >> s; fin >> s;
			fin >> s; fin >> s; fin >> s; _delY = atof(s); fin >> s;
			fin >> s; fin >> s; fin >> s; fin >> s; _delZ = atof(s); 
			setDel(_delX,_delY,_delZ);
//			sprintf(s, "delta %f 0.0 0.0\ndelta 0.0 %f 0.0\ndelta 0.0 0.0 %f\n", _delX, _delY, _delZ);
//			strcat(_header,s);
		}
		else if(!strcmp(s,"attribute") || !strcmp(s, "component"))
		{
//			strcat(_tail, s); strcat(_tail," ");
			fin.getline(s, 256);
//			strcat(_tail, s); strcat(_tail,"\n");
		}
		else 
		{
#ifdef DEBUG
			cout << "ELSE" << endl;
#endif
		}

	}
	
	
	T* _result = new T [_gsX*_gsY*_gsZ];
	for(int x=0; x<_gsX; x++){
		for(int y=0; y<_gsY; y++){
			for(int z=0; z<_gsZ; z++){
				int l = (x*_gsY+y)*_gsZ + z;
				_result[l] = _grid[l];
			}
		}
	}


	cenX_  = minX_ + (((TIn)gsX_-1.0)/2.0)*delX_;
	cenY_  = minY_ + (((TIn)gsY_-1.0)/2.0)*delY_;
	cenZ_  = minZ_ + (((TIn)gsZ_-1.0)/2.0)*delZ_;

	
	// store to dx
//	setComment(_comment);
//	setHeader(_header);
	setGrid(_result);
//	setTail(_tail);

#ifdef DEBUG
		 	printf("\nreadDX(): ENDSTORE\n");
//			printf("readDX() : COMMENT : \n%s\n", comment_);
//			printf("readDX() : HEADER : \n%s\n", header_);
//			printf("readDX() : TAIL : \n%s\n", tail_);
			
	//		setPara(_gsX,_gsY,_gsZ,_delX,_delY,_delZ,_cenX,_cenY,_cenZ);
			
	//		cout << "PARAMETER: " 
	//				<< gsX_<< " "  << gsY_<< " " << gsZ_ << " " 
	//				<< delX_ << " " << delY_ << " " << delZ_ << " " 
	//				<< cenX_ << " " << cenY_ << " " << cenZ_ << endl; 



#endif
}

template<class T, class TIn>
void VolumeDX<T,TIn>::writeDX(const char* _fname)
{
	ofstream fout(_fname);
	int _d = gsX_*gsY_*gsZ_;
	// HEADER
	fout 	<< "# Data from APBS 0.4.0" 																						<< endl
				<< "# " 																																<< endl
				<< "# POTENTIAL (kT/e)" 																								<< endl
				<< "#" 																																	<< endl
				<< "object 1 class gridpositions counts "<<gsX_<< " "<<gsY_<<" "<<gsZ_	<< endl
				<< "origin "<< minX_ << " " << minY_ << " " << minZ_										<< endl
				<< "delta "<< delX_ << " 0 0"																						<< endl
				<< "delta 0 "<< delY_<< " 0"																						<< endl
				<< "delta 0 0 "<< delZ_																									<< endl
				<< "object 2 class gridconnections counts "<<gsX_<< " "<<gsY_<<" "<<gsZ_<< endl
				<< "object 3 class array type double rank 0 items "<<_d <<" data follows"	 	<< endl;
	
	// GRID 
	int n=1;
	for(int i=0; i<_d;i++)
	{
		fout << grid_[i];
		if( n != 3 ){ fout << " "; n++;}
		else{ fout << endl; n = 1;}
	}
	fout << endl;
	
	// TAIL
	fout 	<< "attribute \"dep\" string \"positions\"" 														<< endl
			 	<< "object \"regular positions regular connections\" class field"				<< endl
				<< "component \"positions\" value 1" 																		<< endl
				<< "component \"connections\" value 2"																	<< endl
				<< "component \"data\" value 3"																					<< endl;

	fout.close();
}


template<class T, class TIn>
void VolumeDX<T,TIn>::writeGrid(const char* _fname)
{
	ofstream fout(_fname);
	for(int i=0; i<gsX_*gsY_*gsZ_;i++)
	{
		fout << grid_[i] << " ";
	}
	fout.close();
}


template<class T, class TIn>
int VolumeDX<T,TIn>::getPara(int& _gs, TIn& _del, TIn& _cenX, TIn& _cenY, TIn& _cenZ )
{
	if(gsX_ == gsY_ && gsY_ == gsZ_ && delX_ == delY_ && delY_ == delZ_)
	{ 
		_gs = gsX_; 
		_del= delX_;
	}
	else
	{ 
		cout << "GS not same or del not same\n"; 
		return 0; 
	}
	
	_cenX  = minX_ + (((TIn)_gs-1.0)/2.0)*_del;
	_cenY  = minY_ + (((TIn)_gs-1.0)/2.0)*_del;
	_cenZ  = minZ_ + (((TIn)_gs-1.0)/2.0)*_del;

	return 1;
}

template<class T, class TIn>
void VolumeDX<T,TIn>::setPara(int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ )
{
	gsX_ = gsY_ = gsZ_ = _gs;
	delX_ = delY_ = delZ_ = _del;
	minX_ = _cenX - (((TIn)_gs-1.0)/2.0)*_del;
	minY_ = _cenY - (((TIn)_gs-1.0)/2.0)*_del;
	minZ_ = _cenZ - (((TIn)_gs-1.0)/2.0)*_del;
	cenX_ = _cenX;
	cenY_ = _cenY;
	cenZ_ = _cenZ;


}

template<class T, class TIn>
int VolumeDX<T,TIn>::getPara(int& _gsX, int& _gsY, int& _gsZ , TIn& _delX, TIn& _delY, TIn& _delZ, TIn& _cenX, TIn& _cenY, TIn& _cenZ )
{
	_gsX = gsX_; 
	_gsY = gsY_;
	_gsZ = gsZ_;

	_delX = delX_;
	_delY = delY_;
	_delZ = delZ_;
	
	_cenX  = minX_ + (((TIn)_gsX-1.0)/2.0)*_delX;
	_cenY  = minY_ + (((TIn)_gsY-1.0)/2.0)*_delY;
	_cenZ  = minZ_ + (((TIn)_gsZ-1.0)/2.0)*_delZ;

	return 1;
}

template<class T, class TIn>
void VolumeDX<T,TIn>::setPara(int _gsX, int _gsY, int _gsZ , TIn _delX, TIn _delY, TIn _delZ,  TIn _cenX, TIn _cenY, TIn _cenZ )
{
	
	gsX_ = _gsX;
	gsY_ = _gsY;
	gsZ_ = _gsZ;
	delX_ = _delX;
	delY_ = _delY;
	delZ_ = _delZ;
	minX_ = _cenX - (((TIn)_gsX-1.0)/2.0)*_delX;
	minY_ = _cenY - (((TIn)_gsY-1.0)/2.0)*_delY;
	minZ_ = _cenZ - (((TIn)_gsZ-1.0)/2.0)*_delZ;
	cenX_ = _cenX;
	cenY_ = _cenY;
	cenZ_ = _cenZ;

}


template<class T, class TIn>
void VolumeDX<T,TIn>::copyDX(VolumeDX<T,TIn> &_dx)
{
	int _gsX, _gsY, _gsZ; 
	TIn _delX, _delY, _delZ; 
	TIn _cenX, _cenY, _cenZ; 
	_dx.getPara(_gsX,_gsY,_gsZ,_delX,_delY,_delZ,_cenX,_cenY,_cenZ);
	setPara(_gsX,_gsY,_gsZ,_delX,_delY,_delZ,_cenX,_cenY,_cenZ);
	
	setGrid(_dx.getGrid());
}


template<class T, class TIn>
void VolumeDX<T,TIn>::makeCompact()
{
	// find the min max range of the orginal grid
	int minX=999999, minY=999999, minZ=999999;
	int maxX=000000, maxY=000000, maxZ=000000;
	vector<int> _X, _Y, _Z;
	vector<T> _val;
	_X.clear();_Y.clear();_Z.clear();_val.clear();
	for (int i=0; i<gsX_; i++){
		for (int j=0; j<gsY_; j++){
			for (int k=0; k<gsZ_; k++){

				int index=INDEX2(i,j,k,gsX_,gsY_,gsZ_);
				if( grid_[index]!=0 ){
					_val.push_back(grid_[index]);	
					_X.push_back(i); _Y.push_back(j); _Z.push_back(k);

					if(i<minX) minX=i; if(j<minY) minY=j; if(k<minZ) minZ=k;
					if(i>maxX) maxX=i; if(j>maxY) maxY=j; if(k>maxZ) maxZ=k;
				}
			}
		}
	}

	int maxD=0;
	if( maxX-minX > maxD ){ maxD = maxX-minX; }
	if( maxY-minY > maxD ){ maxD = maxY-minY; }
	if( maxZ-minZ > maxD ){ maxD = maxZ-minZ; }
	
	int rad = (int)((maxD/2.0)*1.4);
	
	
	int _cenGX = (int) ((minX+maxX)/2.0);
	int _cenGY = (int) ((minY+maxY)/2.0);
	int _cenGZ = (int) ((minZ+maxZ)/2.0);

	int _gs = 2*rad+1;
	T* _grid = new T [CUBIC(_gs )];
	for (int i=0; i< _gs; i++){
		for (int j=0; j< _gs; j++){
			for (int k=0; k< _gs; k++){
				_grid[INDEX1(i,j,k,_gs)] = 0;
			}
		}
	}
	
	for (int i=0; i<_val.size(); i++){
		int tmpIndex = INDEX1( _X[i]-_cenGX+rad, _Y[i]-_cenGY+rad, _Z[i]-_cenGZ+rad, _gs );
		if(tmpIndex < CUBIC( _gs ))
			_grid[tmpIndex] = _val[i];	
	}
		
	cenX_  = minX_ + (((TIn)gsX_-1.0)/2.0)*delX_;
	cenY_  = minY_ + (((TIn)gsY_-1.0)/2.0)*delY_;
	cenZ_  = minZ_ + (((TIn)gsZ_-1.0)/2.0)*delZ_;
	
	TIn _cenX, _cenY, _cenZ;
	TRANSFORMTO(_cenGX,_cenGY,_cenGZ, _cenX,_cenY,_cenZ);
	
	printPara();
	cout << _cenGX <<  ", " << _cenGY << ", " << _cenGZ<< " -> " 
		<< _cenX << "," << _cenY << ", " << _cenZ << endl;


	setGrid(_grid);
	setPara(_gs,_gs,_gs, delX_,delY_,delZ_, _cenX, _cenY, _cenZ);
	
	printPara();
}


template<class T, class TIn>
void VolumeDX<T,TIn>::getGrid(vector<T> &_grid )
{
	// find the min max range of the orginal grid
	int minX=999999, minY=999999, minZ=999999;
	int maxX=000000, maxY=000000, maxZ=000000;
	vector<int> _X, _Y, _Z;
	vector<T> _val;
	_X.clear();_Y.clear();_Z.clear();_val.clear();
	for (int i=0; i<gsX_; i++){
		for (int j=0; j<gsY_; j++){
			for (int k=0; k<gsZ_; k++){

				int index=INDEX2(i,j,k,gsX_,gsY_,gsZ_);
				if( grid_[index]!=0 ){
					_val.push_back(grid_[index]);	
					_X.push_back(i); _Y.push_back(j); _Z.push_back(k);

					if(i<minX) minX=i; if(j<minY) minY=j; if(k<minZ) minZ=k;
					if(i>maxX) maxX=i; if(j>maxY) maxY=j; if(k>maxZ) maxZ=k;
				}
			}
		}
	}

	int maxD=0;
	if( maxX-minX > maxD ){ maxD = maxX-minX; }
	if( maxY-minY > maxD ){ maxD = maxY-minY; }
	if( maxZ-minZ > maxD ){ maxD = maxZ-minZ; }
	
	int rad = (int)((maxD/2.0)*1.4);
	
	_grid.clear();
	_grid.resize(CUBIC(rad*2+1 ));
	
	int _cenX = (int) ((minX+maxX)/2.0);
	int _cenY = (int) ((minY+maxY)/2.0);
	int _cenZ = (int) ((minZ+maxZ)/2.0);

	for (int i=0; i<=rad*2; i++){
		for (int j=0; j<=rad*2; j++){
			for (int k=0; k<=rad*2; k++){
				_grid[INDEX1(i,j,k,2*rad+1)] = 0;
			}
		}
	}
	
	for (int i=0; i<_val.size(); i++){
		int tmpIndex = INDEX1( _X[i]-_cenX+rad, _Y[i]-_cenY+rad, _Z[i]-_cenZ+rad, 2*rad+1 );
		if(tmpIndex < CUBIC( 2*rad+1 ))
			_grid[tmpIndex] = _val[i];	
	}

}

// filed sphere
template<class T, class TIn>
void VolumeDX<T,TIn>::makeSphereV2(int _gs)
{
	setPara( _gs, _gs, _gs, 0.5, 0.5, 0.5, (_gs+1)/2, (_gs+1)/2, (_gs+1)/2 );
	grid_ = new T [_gs*_gs*_gs];
	for (int i=0; i<gsX_; i++){
		for (int j=0; j<gsY_; j++){
			for (int k=0; k<gsZ_; k++){
				float dist = DIST((_gs+1)/2, (_gs+1)/2, (_gs+1)/2, i, j, k);
				int index=INDEX2(i,j,k,gsX_,gsY_,gsZ_);
				if( dist < ((_gs+1)/2)-15   || ( dist < ((_gs+1)/2)-5 && dist > ((_gs+1)/2)-8 ) ){
					grid_[index]=1;
				}else{
					grid_[index]=0;
				}
			}
		}
	}


}

// shell of sphere
template<class T, class TIn>
void VolumeDX<T,TIn>::makeSphere(int _gs)
{
	setPara( _gs, _gs, _gs, 1, 1, 1, (_gs+1)/2, (_gs+1)/2, (_gs+1)/2 );
	grid_ = new T [_gs*_gs*_gs];
	for (int i=0; i<gsX_; i++){
		for (int j=0; j<gsY_; j++){
			for (int k=0; k<gsZ_; k++){
				float dist = DIST((_gs+1)/2, (_gs+1)/2, (_gs+1)/2, i, j, k);
				int index=INDEX2(i,j,k,gsX_,gsY_,gsZ_);
				if( dist > ((_gs+1)/2)-8  && dist < ((_gs+1)/2)-4   ){
					grid_[index]=1;
				}else{
					grid_[index]=0;
				}
			}
		}
	}


}


template<class T, class TIn>
void VolumeDX<T,TIn>::reduceSize()
{
//	TIn delX_, delY_, delZ_; 						// interval size
//	int gsX_, gsY_, gsZ_;							// grid point count
//	TIn minX_, minY_, minZ_;						// origin
//	TIn cenX_, cenY_, cenZ_;
	
//	T* grid_;

	TIn	prevMinX = minX_; TIn	prevMinY = minY_; TIn	prevMinZ = minZ_;
	// find the min max range of the orginal grid
	if(grid_==NULL){exit(-1);}
	int _newGsX = (gsX_+1)/2;	int _newGsY = (gsY_+1)/2;	int _newGsZ = (gsZ_+1)/2;
	T* _newGrid = new T [_newGsX*_newGsY*_newGsZ];
	for (int i=0; i<gsX_; i+=2){
		for (int j=0; j<gsY_; j+=2){
			for (int k=0; k<gsZ_; k+=2){
				int index1=INDEX2(i,j,k,gsX_,gsY_,gsZ_);
				int index2=INDEX2((int)(i/2), (int)(j/2), (int)(k/2), _newGsX, _newGsY, _newGsZ);
				_newGrid[index2] = grid_[index1];
			}
		}
	}
	setGrid(_newGrid);
	setPara(_newGsX,_newGsY, _newGsZ, delX_*2, delY_*2, delZ_*2, cenX_, cenY_, cenZ_);	
	minX_ = prevMinX;	minY_ = prevMinY;	minZ_ = prevMinZ;
	printPara();

}


