
// -------------------------------------------------------------
// COMPUTES the visibility for each Surface point buy
// counting the ocupied region of boundary of cube and then 
// normalizing by the maximum possible number of ocupied region.
// ref:  
// Bin Li , Srinivasan Turuvekere , Manish Agrawal , David La , Karthik Ramani  , and Daisuke Kihara 
// Characterization of local geometry of protein surfaces with the visibility criterion 
// Proteins: Structure, Function, and Bioinformatics, Volume 71, Issue 2, Date: 1 May 2008, Pages: 670-683.
// -------------------------------------------------------------
template<class T, class TIn>
void Visibility<T,TIn>::SeedVis(VolumeDX<T,TIn> filledDX, SeedVec<T,TIn> *_seedVec)
{
	SeedVis(filledDX, 2.0, _seedVec);
}	

// V2 ray casting method with vector rep. into bins 
template<class T, class TIn>
void Visibility<T,TIn>::SeedVisV2(VolumeDX<T,TIn> filledDX, TIn _rad, SeedVec<T,TIn> *_seedVec)
{
	// check if parameter is same (should clean this part!!!)
	int dimXS, dimYS, dimZS; 
	TIn delXS, delYS, delZS; 
	TIn cenXS, cenYS, cenZS;
	_seedVec->getPara(dimXS,dimYS,dimZS,delXS,delYS,delZS,cenXS,cenYS,cenZS);
	
	int dimX, dimY, dimZ; 
	TIn delX, delY, delZ; 
	TIn cenX, cenY, cenZ;
	filledDX.getPara(dimX,dimY,dimZ,delX,delY,delZ,cenX,cenY,cenZ);
	if(dimXS!=dimX||dimYS!=dimY||dimZS!=dimZ||delXS!=delX||delYS!=delY||delZS!=delZ||cenXS!=cenX||cenYS!=cenY||cenZS!=cenZ)
	{
		cout << "Parameter mismatch in SurfVis" << endl;
		return;
	}

	// set variables
	T* _grid = filledDX.getGrid();
	int elengthX = (int)ROUND(_rad*(1.0/delX)); 
	int elengthY = (int)ROUND(_rad*(1.0/delY)); 
	int elengthZ = (int)ROUND(_rad*(1.0/delZ)); 

	if( elengthX<7 || elengthY<7 ||elengthZ<7 ){
		cout << "radius too small re-adjusting radius from "
			<< _rad << " to " << 6.0*delX << endl;
		elengthX=elengthY=elengthZ=7;
	}
	
	if(elengthX%2 == 0 ){
		cout << "readjusting radius from "<< _rad << " to " << (++elengthX)*delX << endl;
	}
	if(elengthY%2 == 0 ){
		cout << "readjusting radius from "<< _rad << " to " << (++elengthY)*delY << endl;
	}
	if(elengthZ%2 == 0 ){
		cout << "readjusting radius from "<< _rad << " to " << (++elengthZ)*delZ << endl;
	}

	int ehalfX = (int)(((float)elengthX-1.0)/2.0);
	int ehalfY = (int)(((float)elengthY-1.0)/2.0);
	int ehalfZ = (int)(((float)elengthZ-1.0)/2.0);

	int total = (elengthX*elengthY*elengthZ) - ((elengthX-2)*(elengthY-2)*(elengthZ-2));

	//-------------------------------------------------------------------------------
	// WANT TO CHANGE THE DEFINITION!!!! RAY CASTING METHOD (<- take long time)  
	// initial computation of visibility for each of the Seed points 
	for(int num=0; num<_seedVec->size(); num++)
	{
		Surf<T,TIn>* tmpSurf = ((_seedVec->getSeed(num))->getSurf());
		int a,b,c;
		tmpSurf->getABC(a,b,c);

		// count visible voxels
		const int EXPAND = 2;
		vector<int> Seed_rtp(CUBIC(2*EXPAND),0);		// normalized vector coordinate of seed points
		if(a - ehalfX>0 && a + ehalfX< dimX && b - ehalfY>0 && b + ehalfY< dimY && c - ehalfY>0 && c + ehalfY< dimZ)
		{
			for(int i=ehalfX*-1; i<ehalfX; i++)
			{
				for(int j=ehalfY*-1; j<ehalfY; j++)
				{
					for(int k=ehalfZ*-1; k<ehalfZ; k++)
					{
						if(DIST(0,0,0,i,j,k) <= ehalfX && DIST(0,0,0,i,j,k) > ehalfX -1 )
						{
							if(_grid[INDEX2(a+i, b+j, c+k, dimX, dimY, dimZ)]>0)
							{
								 double dist = sqrt(i*i+j*j+k*k);
						
								int nx = ROUND( EXPAND*((i)/dist) )+EXPAND;
								int ny = ROUND( EXPAND*((j)/dist) )+EXPAND;
								int nz = ROUND( EXPAND*((k)/dist) )+EXPAND;
								int ind = INDEX1(nx,ny,nz, 2*EXPAND);
								if(ind>0 && ind<Seed_rtp.size()) Seed_rtp[ind]++;		
							}	
						}
					}	
				}	
			}
			// normalize 
			int count = 0;
			for( int sr = 0; sr < Seed_rtp.size(); sr++)
			{
				if(Seed_rtp[sr]>0)count++; 
			}
			tmpSurf->setPro((T)count/(T)Seed_rtp.size(), VIS);	
		
		}else{
			tmpSurf->setPro(-1, VIS);
		}
	}	
	// end initial computation of Visibility
	//-------------------------------------------------------------------------------

	// smoothing by averaging by neighoring visibilitys
	int _dimX, _dimY, _dimZ;
	TIn _delX, _delY, _delZ; 
	TIn _cenX, _cenY, _cenZ;
	_seedVec->getPara(_dimX,_dimY,_dimZ,_delX,_delY,_delZ,_cenX,_cenY,_cenZ);
	for(int num=0; num<_seedVec->size(); num++)
	{
		int count = 0;
		TIn sum = 0;
		for(int x=-2; x<=2; x++){
			for(int y=-2; y<=2; y++){
				for(int z=-2; z<=2; z++){
					int i,j,k;
					(_seedVec->getSeed(num))->getABC(i,j,k);	
					if(_seedVec->CHECK_RANGE(i+x, j+y, k+z, _dimX,_dimY,_dimZ))
					{
						int idx = _seedVec->getSeedIndex(i+x,j+y,k+z);
						if( idx > 0 )
						{ 
							sum += (_seedVec->getSeed(idx))->getPro(VIS);
							count++;
						}
					}
				
				}
			}
		}
		(_seedVec->getSeed(num))->setPro((T)(sum/(TIn)count), VIS);
	}


}

template<class T, class TIn>
void Visibility<T,TIn>::SeedVis(VolumeDX<T,TIn> filledDX, TIn _rad, SeedVec<T,TIn> *_seedVec)
{
	// check if parameter is same (should clean this part!!!)
	int dimXS, dimYS, dimZS; 
	TIn delXS, delYS, delZS; 
	TIn cenXS, cenYS, cenZS;
	_seedVec->getPara(dimXS,dimYS,dimZS,delXS,delYS,delZS,cenXS,cenYS,cenZS);
	
	int dimX, dimY, dimZ; 
	TIn delX, delY, delZ; 
	TIn cenX, cenY, cenZ;
	filledDX.getPara(dimX,dimY,dimZ,delX,delY,delZ,cenX,cenY,cenZ);
	if(dimXS!=dimX||dimYS!=dimY||dimZS!=dimZ||delXS!=delX||delYS!=delY||delZS!=delZ||cenXS!=cenX||cenYS!=cenY||cenZS!=cenZ)
	{
		cout << "Parameter mismatch in SurfVis" << endl;
		return;
	}

	// set variables
	T* _grid = filledDX.getGrid();
	int elengthX = (int)ROUND(_rad*(1.0/delX)); 
	int elengthY = (int)ROUND(_rad*(1.0/delY)); 
	int elengthZ = (int)ROUND(_rad*(1.0/delZ)); 

	if( elengthX<7 || elengthY<7 ||elengthZ<7 ){
		cout << "radius too small readjusting radius from "
			<< _rad << " to " << 6.0*delX << endl;
		elengthX=elengthY=elengthZ= 7;
	}
	
	if(elengthX%2 == 0 ){
		cout << "readjusting radius from "<< _rad << " to " << (++elengthX)*delX << endl;
	}
	if(elengthY%2 == 0 ){
		cout << "readjusting radius from "<< _rad << " to " << (++elengthY)*delY << endl;
	}
	if(elengthZ%2 == 0 ){
		cout << "readjusting radius from "<< _rad << " to " << (++elengthZ)*delZ << endl;
	}

	int ehalfX = (int)(((float)elengthX-1.0)/2.0);
	int ehalfY = (int)(((float)elengthY-1.0)/2.0);
	int ehalfZ = (int)(((float)elengthZ-1.0)/2.0);

	int total = (elengthX*elengthY*elengthZ) - ((elengthX-2)*(elengthY-2)*(elengthZ-2));

	//-------------------------------------------------------------------------------
	// WANT TO CHANGE THE DEFINITION!!!! RAY CASTING METHOD (<- take long time)  
	// initial computation of visibility for each of the Seed points 
	for(int num=0; num<_seedVec->size(); num++)
	{
		Surf<T,TIn>* tmpSurf = ((_seedVec->getSeed(num))->getSurf());
		int count = 0;	
		total = 0;	
		int tmp=0;
		int a,b,c;
		tmpSurf->getABC(a,b,c);

		// count visible voxels
		if(a - ehalfX>0 && a + ehalfX< dimX && b - ehalfY>0 && b + ehalfY< dimY && c - ehalfY>0 && c + ehalfY< dimZ){
			for(int i=ehalfX*-1; i<elengthX; i++){
				for(int j=ehalfY*-1; j<elengthY; j++){
					for(int k=ehalfZ*-1; k<elengthZ; k++){
						if(DIST(0,0,0,i,j,k) <= ehalfX && DIST(0,0,0,i,j,k) > ehalfX -1 )
						{
							total++;
							if(_grid[INDEX2(a+i, b+j, c+k, dimX, dimY, dimZ)]>0)
							{
							count++;
							}
						}
					}	
				}	
			}
			// normalize 
			tmpSurf->setPro((T)count/(T)total, VIS);	
		}else{
			tmpSurf->setPro(-1, VIS);
		}
	
	} 
	// end initial computation of Visibility
	//-------------------------------------------------------------------------------

	// smoothing by averaging by neighoring visibilitys
	int _dimX, _dimY, _dimZ;
	TIn _delX, _delY, _delZ; 
	TIn _cenX, _cenY, _cenZ;
	_seedVec->getPara(_dimX,_dimY,_dimZ,_delX,_delY,_delZ,_cenX,_cenY,_cenZ);
	for(int num=0; num<_seedVec->size(); num++)
	{
		int count = 0;
		TIn sum = 0;
		for(int x=-2; x<=2; x++){
			for(int y=-2; y<=2; y++){
				for(int z=-2; z<=2; z++){
					int i,j,k;
					(_seedVec->getSeed(num))->getABC(i,j,k);	
					if(_seedVec->CHECK_RANGE(i+x, j+y, k+z, _dimX,_dimY,_dimZ))
					{
						int idx = _seedVec->getSeedIndex(i+x,j+y,k+z);
						if( idx > 0 )
						{ 
							sum += (_seedVec->getSeed(idx))->getPro(VIS);
							count++;
						}
					}
				
				}
			}
		}
		(_seedVec->getSeed(num))->setPro((T)(sum/(TIn)count), VIS);
	}


}

template<class T, class TIn>
void Visibility<T,TIn>::SeedVis_lig(VolumeDX<T,TIn> filledDX, TIn _rad, SeedVec<T,TIn> *_seedVec)
/* By W. -H. Shin, 2016
Assigning visibility for ligand surface points.
To get complementarity value from protein patch, visibility is calculated as 1-(visibie direction)
If the small box to calculate vis. is located outside of the whole voxel box, it virtually assign 
0 to the grid points to the small box */
{
	// check if parameter is same (should clean this part!!!)
	int dimXS, dimYS, dimZS; 
	TIn delXS, delYS, delZS; 
	TIn cenXS, cenYS, cenZS;
	_seedVec->getPara(dimXS,dimYS,dimZS,delXS,delYS,delZS,cenXS,cenYS,cenZS);
	
	int dimX, dimY, dimZ; 
	TIn delX, delY, delZ; 
	TIn cenX, cenY, cenZ;
	filledDX.getPara(dimX,dimY,dimZ,delX,delY,delZ,cenX,cenY,cenZ);
	if(dimXS!=dimX||dimYS!=dimY||dimZS!=dimZ||delXS!=delX||delYS!=delY||delZS!=delZ||cenXS!=cenX||cenYS!=cenY||cenZS!=cenZ)
	{
		cout << "Parameter mismatch in SurfVis" << endl;
		return;
	}

	// set variables
	T* _grid = filledDX.getGrid();
	int elengthX = (int)ROUND(_rad*(1.0/delX)); 
	int elengthY = (int)ROUND(_rad*(1.0/delY)); 
	int elengthZ = (int)ROUND(_rad*(1.0/delZ)); 

	if( elengthX<7 || elengthY<7 ||elengthZ<7 ){
		cout << "radius too small readjusting radius from "
			<< _rad << " to " << 6.0*delX << endl;
		elengthX=elengthY=elengthZ= 7;
	}
	
	if(elengthX%2 == 0 ){
		cout << "readjusting radius from "<< _rad << " to " << (++elengthX)*delX << endl;
	}
	if(elengthY%2 == 0 ){
		cout << "readjusting radius from "<< _rad << " to " << (++elengthY)*delY << endl;
	}
	if(elengthZ%2 == 0 ){
		cout << "readjusting radius from "<< _rad << " to " << (++elengthZ)*delZ << endl;
	}

	int ehalfX = (int)(((float)elengthX-1.0)/2.0);
	int ehalfY = (int)(((float)elengthY-1.0)/2.0);
	int ehalfZ = (int)(((float)elengthZ-1.0)/2.0);

	int total = (elengthX*elengthY*elengthZ) - ((elengthX-2)*(elengthY-2)*(elengthZ-2));

	//-------------------------------------------------------------------------------
	// WANT TO CHANGE THE DEFINITION!!!! RAY CASTING METHOD (<- take long time)  
	// initial computation of visibility for each of the Seed points 
	for(int num=0; num<_seedVec->size(); num++)
	{
		Surf<T,TIn>* tmpSurf = ((_seedVec->getSeed(num))->getSurf());
		int count = 0;	
		total = 0;	
		int tmp=0;
		int a,b,c;
		tmpSurf->getABC(a,b,c);

		// count visible voxels
		for(int i=ehalfX*-1; i<elengthX; i++)
		  {
		    for(int j=ehalfY*-1; j<elengthY; j++)
		      {
			for(int k=ehalfZ*-1; k<elengthZ; k++)
			  {
			    if(DIST(0,0,0,i,j,k) <= ehalfX && DIST(0,0,0,i,j,k) > ehalfX -1 )
			      {
				total++;
				if(a + i > 0 && a + i < dimX && b + j > 0 && b + j < dimY &&
				   c + k > 0 && c + k < dimZ)
				  {
				    if(_grid[INDEX2(a+i, b+j, c+k, dimX, dimY, dimZ)]>0)
				      {
					count++;
				      }
				  }
				else
				  {
				    count++;
				  }
			      }
			  }	
		      }
		  }
		// normalize 
		tmpSurf->setPro((T)count/(T)total, VIS);
	} 
	// end initial computation of Visibility
	//-------------------------------------------------------------------------------

	// smoothing by averaging by neighoring visibilitys
	int _dimX, _dimY, _dimZ;
	TIn _delX, _delY, _delZ; 
	TIn _cenX, _cenY, _cenZ;
	_seedVec->getPara(_dimX,_dimY,_dimZ,_delX,_delY,_delZ,_cenX,_cenY,_cenZ);
	for(int num=0; num<_seedVec->size(); num++)
	{
		int count = 0;
		TIn sum = 0;
		for(int x=-2; x<=2; x++){
			for(int y=-2; y<=2; y++){
				for(int z=-2; z<=2; z++){
					int i,j,k;
					(_seedVec->getSeed(num))->getABC(i,j,k);	
					if(_seedVec->CHECK_RANGE(i+x, j+y, k+z, _dimX,_dimY,_dimZ))
					{
						int idx = _seedVec->getSeedIndex(i+x,j+y,k+z);
						if( idx > 0 )
						{ 
							sum += (_seedVec->getSeed(idx))->getPro(VIS);
							count++;
						}
					}
				
				}
			}
		}
		(_seedVec->getSeed(num))->setPro((T)(sum/(TIn)count), VIS);
	}


}

template<class T, class TIn>
void Visibility<T,TIn>::SurfVis(VolumeDX<T,TIn> filledDX, SeedVec<T,TIn> *_seedVec, SurfVec<T,TIn> *_surfVec  )
{
	SurfVis(filledDX, 2.0, _seedVec, _surfVec);
}	

template<class T, class TIn>
void Visibility<T,TIn>::SurfVis(VolumeDX<T,TIn> filledDX, TIn _rad, SeedVec<T,TIn> *_seedVec, SurfVec<T,TIn> *_surfVec  )
{
	SeedVis(filledDX, _rad, _seedVec);
	
	for(int num=0; num<_surfVec->size(); num++)
	{
		Surf<T,TIn>* tmpSurf = (_surfVec->getSurf(num));
		// if no value is assigned
		if((_surfVec->getSurf(num))->getPro(VIS) == 0)
		{
			int a,b,c;
			tmpSurf->getABC(a,b,c);
			int count = 0;
			T sum = 0;
			for(int i=-1;i<=1;i++){
				for(int j=-1;j<=1;j++){
					for(int k=-1;k<=1;k++){
						Surf<T,TIn>* tmp = _surfVec->getSurf(a+i,b+j,c+k);
						if(tmp!=NULL){
							if(tmp->getPro(VIS)>0){
								count++;
								sum += tmp->getPro(VIS);
							}
						}
					}
				}
				tmpSurf->setPro((T)sum/(T)count,VIS);
			}
		}
	}
	
}



template<class T, class TIn>
void Visibility<T,TIn>::SurfVisV2(VolumeDX<T,TIn> filledDX, TIn _rad, SeedVec<T,TIn> *_seedVec, SurfVec<T,TIn> *_surfVec  )
{
	SeedVisV2(filledDX, _rad, _seedVec);
	
	for(int num=0; num<_surfVec->size(); num++)
	{
		Surf<T,TIn>* tmpSurf = (_surfVec->getSurf(num));
		// if no value is assigned
		if((_surfVec->getSurf(num))->getPro(VIS) == 0)
		{
			int a,b,c;
			tmpSurf->getABC(a,b,c);
			int count = 0;
			T sum = 0;
			for(int i=-1;i<=1;i++){
				for(int j=-1;j<=1;j++){
					for(int k=-1;k<=1;k++){
						Surf<T,TIn>* tmp = _surfVec->getSurf(a+i,b+j,c+k);
						if(tmp!=NULL){
							if(tmp->getPro(VIS)>0){
								count++;
								sum += tmp->getPro(VIS);
							}
						}
					}
				}
				tmpSurf->setPro((T)sum/(T)count,VIS);
			}
		}
	}
	
}

template<class T, class TIn>
void Visibility<T,TIn>::SurfVis_lig(VolumeDX<T,TIn> filledDX, TIn _rad, SeedVec<T,TIn> *_seedVec, SurfVec<T,TIn> *_surfVec  )
{
	SeedVis_lig(filledDX, _rad, _seedVec);
	
	for(int num=0; num<_surfVec->size(); num++)
	{
		Surf<T,TIn>* tmpSurf = (_surfVec->getSurf(num));
		// if no value is assigned
		if((_surfVec->getSurf(num))->getPro(VIS) == 0)
		{
			int a,b,c;
			tmpSurf->getABC(a,b,c);
			int count = 0;
			T sum = 0;
			for(int i=-1;i<=1;i++){
				for(int j=-1;j<=1;j++){
					for(int k=-1;k<=1;k++){
						Surf<T,TIn>* tmp = _surfVec->getSurf(a+i,b+j,c+k);
						if(tmp!=NULL){
						  if(tmp->getPro(VIS)<1 && tmp->getPro(VIS)>=0){
								count++;
								sum += tmp->getPro(VIS);
							}
						}
					}
				}
				tmpSurf->setPro((T)sum/(T)count,VIS);
			}
		}
	}
	
}





