/*============================================
 *
 * Sael Lee 
 * May 08, 2008
 *
 *===========================================*/

#ifndef SURFVEC_H
#define SURFVEC_H

#include "Common.h"
#include "ProcessPDB.h"

template<class T, class TIn>
class Surf
{
 	private:
	
	 	TIn 									x, y, z;
		int 									a, b, c;
		int 									index;
		int 									seedIndex;

		T											pro[PROSIZE];			// properties : see Common.h

	public:	
	
		void init()
		{
			x = 0; y = 0; z = 0; 
			a = 0; b = 0; c = 0;
			index = -1;
			seedIndex = -1;
			for(int i=0;i<PROSIZE;i++)
				pro[i]=0;
		};
	
		void init(TIn _x, TIn _y, TIn _z, int _a, int _b, int _c, int _index)
		{
			x = _x; y = _y; z = _z; 
			a = _a; b = _b; c = _c;
			index = _index;
			seedIndex = -1;
			for(int i=0;i<PROSIZE;i++)
				pro[i]=0;

		};
	
		void clear(){init();};
	
		void setSeedIndex(int _n){seedIndex = _n;};
		
		void setPro(T _value, int _i)
		{
			if(_i>=PROSIZE){
				cout << "property index not valid\n";
				exit(-1);
			}else{
				pro[_i] = _value;
			}
		};

		T getPro(int _i)
		{
			if(_i>=PROSIZE){
				cout << "property index not valid\n";
				exit(-1);
			}else{
				return pro[_i];
			}
		}
		
		void setXYZ(TIn _x, TIn _y, TIn _z){x = _x; y = _y; z = _z;}
		void setABC(int _a, int _b, int _c){a = _a; b = _b; c = _c;}
		
		void getXYZ(TIn &_x, TIn &_y, TIn &_z){_x = x; _y = y; _z = z;}
		void getABC(int &_a, int &_b, int &_c){_a = a; _b = b; _c = c;}
		int  getIndex(){return index;};
		int  getSeedIndex(){return seedIndex;};

		void printSurf();
		void printSurf(std::ofstream & _fout);				
		
};


template<class T, class TIn>
class SurfVec
{
	private:
		TIn 											cenX_, cenY_, cenZ_;
		TIn 											delX_, delY_, delZ_;
		int 											dimX_, dimY_, dimZ_;

		vector<Surf<T, TIn> >			surfs;	
		
		map< int,int >						mapABC;	
		map< T,  int >						mapXYZ;
	
	public:
			
		void mapSurfABC();
		void mapSurfXYZ();
	

		// === BASIC functions =======
		void init()
		{
			cenX_ = cenY_ = cenZ_ = 0;
			delX_ = delY_ = delZ_ = 0;
			dimX_ = dimY_ = dimZ_ = 0;
			surfs.clear();
			mapABC=map< int,int >();
			mapXYZ=map< T,  int >();

		};
		
		void clear(){init();};
	
		void reserveSurfs(int _n){ surfs.reserve(_n); };
		
		int pushSurf(Surf<T,TIn> _surf)
		{
			surfs.push_back(_surf);
			return surfs.size()-1;
		};
	
		int size(){ return surfs.size(); };
		
		void printSurfs();
		
		// ==== SET functions	====
		void setPara(int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ )
		{			dimX_ = dimY_ = dimZ_ = _gs;		
			delX_	= delY_	= delZ_ = _del;
			cenX_	= _cenX; 	cenY_ = _cenY;	cenZ_ = _cenZ;
		};
		
		void setPara(int _gsX,int _gsY,int _gsZ,TIn _delX,TIn _delY, TIn _delZ,TIn _cenX,TIn _cenY,TIn _cenZ )
		{
			dimX_ = _gsX; 	dimY_ = _gsY;		dimZ_ = _gsZ;		
			delX_	= _delX;	delY_	= _delY;	delZ_	= _delZ;
			cenX_	= _cenX; 	cenY_ = _cenY;	cenZ_ = _cenZ;
		};
	
		// ==== GET functions ====
		void getPara(int& _gs, TIn& _del, TIn& _cenX, TIn& _cenY, TIn& _cenZ )
		{
			if(dimX_ == dimY_ && dimX_ == dimZ_)
				_gs 	= dimX_; 	
			else{
				cout << "dim miss match error\n";
				exit(-1);
			}
			if(delX_ == delY_ && delX_ == delZ_)
				_del 	= delX_; 	
			else{
				cout << "del miss match error\n";
				exit(-1);
			}
			_cenX	= cenX_; 	_cenY = cenY_;	_cenZ = cenZ_;
		};
		
		void getPara(int &_gsX,int &_gsY,int &_gsZ, TIn &_delX, TIn &_delY, TIn &_delZ, TIn& _cenX, TIn& _cenY, TIn& _cenZ )
		{
			_gsX 	= dimX_; 	_gsY 	= dimY_; 	_gsZ 	= dimZ_; 		
			_delX	= delX_;	_delY	= delY_;	_delZ	= delZ_;
			_cenX	= cenX_; 	_cenY = cenY_;	_cenZ = cenZ_;
		};
		

		vector<Surf<T,TIn> > getSurfs(){ return surfs; };
		
		Surf<T,TIn>* getSurf(int _i)
		{
			if(surfs.size() < _i+1){return NULL; }
			else{ return &(surfs[_i]); }
		};
	
		int getSurfSize(){return surfs.size();};

		Surf<T,TIn>* getSurf(int _a, int _b, int _c);
		Surf<T,TIn>* getSurf(TIn _x, TIn _y, TIn _z);
		
		VolumeDX<T,TIn> getSurfsDX();
		VolumeDX<T,TIn> getSurfsDX(int _proI);
		
		void copySurfs(vector<Surf<T,TIn> > &_surfs );

		void remapSurfs(SurfVec<T,TIn>& _surfVec);	

		ProcessPDB<T,TIn>	 InterfaceSurf(const char* pdbFile, TIn _dist);
		
		ProcessPDB<T,TIn>	 PocketSurf(const char* pdbFile, TIn _dist);
		ProcessPDB<T,TIn>	 PocketSurf(const char* pdbFile);
		ProcessPDB<T,TIn>	 PocketSurfV2(const char* pdbFile);
		
		vector<vector<int> > PocketSurf_lsc(const char* pdbFile, VolumeDX<T,TIn> filledDX, TIn _rad=15);
		int PocketSurf_cntr(TIn x_cntr, TIn y_cntr, TIn z_cntr, TIn pkt_rad);
		vector<vector<int> > PocketSurf(const char* pdbFile, VolumeDX<T,TIn> filledDX, TIn _rad=15);
		
		int					 			 PocketSurfV3(vector<Surf<T,TIn> > &_glSurfs);
	
		void TRANSFORMTO(int _i, int _j, int _k, TIn& _a, TIn& _b, TIn& _c)
		{
			_a = ((TIn)_i - ((TIn)dimX_ - 1.0)/2.0)*delX_ + cenX_;
			_b = ((TIn)_j - ((TIn)dimY_ - 1.0)/2.0)*delY_ + cenY_;
			_c = ((TIn)_k - ((TIn)dimZ_ - 1.0)/2.0)*delZ_ + cenZ_;
		};

		void TRANSFORMFROM(TIn _a, TIn _b, TIn _c, int& _aa, int& _bb, int& _cc)
		{
			_aa = (int)((_a - cenX_)/delX_ + ((TIn)dimX_ - 1.0)/2.0);
			_bb = (int)((_b - cenY_)/delY_ + ((TIn)dimY_ - 1.0)/2.0);
			_cc = (int)((_c - cenZ_)/delZ_ + ((TIn)dimZ_ - 1.0)/2.0);
		};
		
		void TRANSFORMFROM(TIn _a, TIn _b, TIn _c, TIn& _aa, TIn& _bb, TIn& _cc) //transfer the coor of _a, _b, _c to the grid origin
		{
			_aa = ((_a - cenX_)/delX_ + ((TIn)dimX_ - 1.0)/2.0);
			_bb = ((_b - cenY_)/delY_ + ((TIn)dimY_ - 1.0)/2.0);
			_cc = ((_c - cenZ_)/delZ_ + ((TIn)dimZ_ - 1.0)/2.0);
		};



};

#include "SurfVec.cpp"

#endif

