template<class T, class TIn>		
void Surf<T,TIn>::printSurf()
{
	cout << "index: " << index << endl;
	cout << "XYZ: " << x << " " << y << " " << z << endl;
	cout << "ABC: " << a << " " << b << " " << c << endl;
			
	cout << "Pro: " << PROSIZE << endl;
	for(int i=0; i<PROSIZE; i++){
		cout << "\t" << i << ": " << pro[i]<< endl;
	}
}

template<class T, class TIn>		
void Surf<T,TIn>::printSurf(std::ofstream &_fout)
{
	if(_fout.is_open()){
		_fout << "index: " << index << endl;
		_fout << "XYZ: " << x << " " << y << " " << z << endl;
		_fout << "ABC: " << a << " " << b << " " << c << endl;
				
		_fout << "Pro: " << PROSIZE << endl;
		for(int i=0; i<PROSIZE; i++){
			_fout << "\t" << i << ": " << pro[i]<< endl;
		}
	}
}


template<class T, class TIn>		
void SurfVec<T,TIn>::mapSurfABC()
{
#ifdef DEBUG
	cout << "start mapping surface to ABC" << endl;
#endif
	
	for(int i=0; i<surfs.size(); i++)
	{
		int _a, _b, _c;
		surfs[i].getABC(_a,_b,_c);
		mapABC[INDEX2(_a,_b,_c,dimX_,dimY_,dimZ_)] = i;	
	}

#ifdef DEBUG
	cout << "finish mapping surface to ABC" << endl;
#endif
	
}

template<class T, class TIn>		
void SurfVec<T,TIn>::mapSurfXYZ()
{
#ifdef DEBUG
	cout << "start mapping surface to ABC" << endl;
#endif
	
	for(int i=0; i<surfs.size(); i++)
	{
		TIn _x, _y, _z;
		surfs[i].getXYZ(_x,_y,_z);
		mapXYZ[INDEX2(_x,_y,_z, (T)dimX_,(T)dimY_,(T)dimZ_)] = i;	
	}

#ifdef DEBUG
	cout << "finish mapping surface to ABC" << endl;
#endif
	
}
	
template<class T, class TIn>		
Surf<T,TIn>* SurfVec<T,TIn>::getSurf(int _a, int _b, int _c)
{
	if(mapABC.size() == 0){mapSurfABC();}
	map<int,int>::iterator it;
	it=mapABC.find(INDEX2(_a,_b,_c,dimX_,dimY_,dimZ_));
	if(it!=mapABC.end()){
		return &(surfs[(*it).second]);	
	}else{
		return NULL;
	}
}

template<class T, class TIn>		
Surf<T,TIn>* SurfVec<T,TIn>::getSurf(TIn _x, TIn _y, TIn _z)
{
	if(mapXYZ.size() == 0){mapSurfXYZ();}
	map<int,int>::iterator it;
	it=mapXYZ.find(INDEX2(_x,_y,_z,(T)dimX_,(T)dimY_,(T)dimZ_));
	if(it!=mapXYZ.end()){
		return &(surfs[(*it).second]);	
	}else{
		return NULL;
	}
}


template<class T, class TIn>		
void SurfVec<T,TIn>::printSurfs()
{
	if(surfs.size()>0){
		for(int i=0; i<surfs.size(); i++){
			surfs[i].printSurf();
		}
	}
}

template<class T, class TIn>
VolumeDX<T,TIn> SurfVec<T,TIn>::getSurfsDX()
{
	VolumeDX<T,TIn> tmpDX;
	tmpDX.setPara(dimX_,dimY_,dimZ_, delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	
	T* _grid = new T[dimX_*dimY_*dimZ_];	
	for(int i=0;i<dimX_*dimY_*dimZ_; i++)
	{
		_grid[i] = 0;
	}
	if(surfs.size()>0){
		for(int i=0; i<surfs.size(); i++){
			int a, b, c;
			surfs[i].getABC(a,b,c);
			_grid[INDEX2(a,b,c,dimX_,dimY_,dimZ_)] = 1;
		}
	}
	
	tmpDX.setGrid(_grid);

	return tmpDX;
}

template<class T, class TIn>
VolumeDX<T,TIn> SurfVec<T,TIn>::getSurfsDX(int _proI)
{
	if(_proI<PROSIZE && _proI>0)
	{
		VolumeDX<T,TIn> tmpDX;
		tmpDX.setPara(dimX_,dimY_,dimZ_, delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	
		T* _grid = new T[dimX_*dimY_*dimZ_];	
		for(int i=0;i<dimX_*dimY_*dimZ_; i++)
		{
			_grid[i] = 0;
		}
		if(surfs.size()>0){
			for(int i=0; i<surfs.size(); i++){
				int a, b, c;
				surfs[i].getABC(a,b,c);
				_grid[INDEX2(a, b, c, dimX_,dimY_,dimZ_)] = surfs[i].getPro(_proI);
			}
		}
		tmpDX.setGrid(_grid);

		return tmpDX;
	
	}else{
		return getSurfsDX();
	}

}

template<class T, class TIn>
void SurfVec<T,TIn>::copySurfs(vector<Surf<T,TIn> > &_surfs )
{
	_surfs.clear();
	for(int i=0;i<surfs.size(); i++)
	{
		_surfs.push_back(surfs[i]);
	}
}

// given global residue surface,
template<class T, class TIn>
int SurfVec<T,TIn>::PocketSurfV3( vector<Surf<T,TIn> > &_glSurfs )
{
	float _cenX, _cenY, _cenZ;
		
	// initialize output SurfVec
	SurfVec<T,TIn> _surfVec;
	_surfVec.init();
	_surfVec.reserveSurfs(surfs.size());
// ----------------------------------------------------------------
	vector<int> surfInd1st;
	for(int i=0; i<_glSurfs.size(); i++)
	{
		for(int j=0; j< surfs.size(); j++)
		{ 
	 		TIn gx, gy, gz, lx,ly,lz;
			_glSurfs[i].getXYZ(gx, gy, gz);
			surfs[j].getXYZ(lx,ly,lz);
			if( DIST(lx,ly,lz, gx,gy,gz) <= 0.00001 )
//			if(lx == gx && ly == gy && lz == gz)
			{
				surfInd1st.push_back(i);
				break;
			}
		}
	}
	
	if(surfInd1st.size() <1) { return 0;}
	
	// remove any redundent information. 
	vector<int> surfInd2nd;
	surfInd2nd.push_back(surfInd1st[0]);
	for(int i=0; i<surfInd1st.size();i++){
		int found=0;
		for(int l=0; l<surfInd2nd.size();l++){
			if(surfInd1st[i] == surfInd2nd[l]) found = 1; break;
		}
		if(!found) surfInd2nd.push_back(surfInd1st[i]);
	}

	for(int i=0; i<surfInd2nd.size(); i++)
	{
		_surfVec.pushSurf( _glSurfs[surfInd2nd[i]] ); 
	}
	
	// initialize backward indexing
	for(int i=0; i<surfs.size(); i++)
	{
		surfs[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SurfSIZE reduced from " << surfs.size() << " ";
#endif
	
	_surfVec.copySurfs(surfs); 
	
#ifdef DEBUG	
	cout << " to  " << surfs.size() << endl;
#endif	
	
	// reset backward indexing
	for( int i=0; i<surfs.size(); i++ )
	{
		surfs[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSurfABC();
	mapSurfXYZ();
	
	return surfs.size();
}


// volumetric ray casting method V2 from center point using Cartician coordinates
template<class T, class TIn>
ProcessPDB<T,TIn> SurfVec<T,TIn>::PocketSurfV2(const char* pdbFile)
{
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	
	float _cenX, _cenY, _cenZ;
	vector<int> _selSurf;
	vector<vector< char *> > _selSurfVal1;
	vector<vector<float > > _selSurfVal2;

if(1){	
	if(ppdb.ATOMsize()>0 || ppdb.HETATMsize()>0)
	{
		ppdb.getCOG(_cenX, _cenY, _cenZ);
	}else {
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}	
}else{
	if(ppdb.ATOMsize()>0 || ppdb.HETATMsize()>0){

	}else if(ppdb.ATOMsize()==0 || ppdb.HETATMsize()==0){
		ppdb.getCOG(_cenX, _cenY, _cenZ);
	}else {
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}	


}
	// initialize output SurfVec
	SurfVec<T,TIn> _surfVec;
	_surfVec.init();
	_surfVec.reserveSurfs(surfs.size());
	
	// get DX for grid 
//	VolumeDX<T,TIn> tmpDX = getSurfsDX();
//	int _tdimX, _tdimY, _tdimZ;
//	tmpDX.getGs(_tdimX, _tdimY, _tdimZ);
//	T* tmpGrid = tmpDX.getGrid();

	vector<int> seedInd1st; // surface indexs for the first selection criterion
	vector<int> seedInd2nd;
	vector<int> seedInd3rd;
	vector<int> surfInd1st;
	vector<int> surfInd2nd;
	// cout <<  _maxX  << _minX <<   _maxY <<  _minY  << _maxZ << _minZ << endl;

// 0. transform surface vectors to center of gravity
// ----------------------------------------------------------------
	const int EXPAND = 30; 
	vector<vector<double> > Seed_rtp; // normalized vector coordinates of seed point 
	vector<double> itmp(5,-1);
	Seed_rtp.resize(CUBIC(2*EXPAND+1), itmp );
	for(int i=0; i<surfs.size(); i++)
	{
		TIn sx, sy, sz;
		surfs[i].getXYZ(sx,sy,sz);
		if( DIST(sx,sy,sz, _cenX,_cenY,_cenZ)<=15 ){
			
			surfInd1st.push_back(i); 
			// select only the seeds points from surface and compute vector
			// if( surfs[i].getSeedIndex()>0 ){				
				seedInd1st.push_back(i);
				double x = double(sx-_cenX), y = double(sy-_cenY), z = double(sz-_cenZ); 
				vector<double> tmp;	
				double dist = sqrt(x*x+y*y+z*z);
				tmp.push_back(i);
				tmp.push_back(dist); // r 

				int nx = (int)floor( EXPAND*(x/dist) )+EXPAND;
				int ny = (int)floor( EXPAND*(y/dist) )+EXPAND;
				int nz = (int)floor( EXPAND*(z/dist) )+EXPAND;

				tmp.push_back(nx);	tmp.push_back(ny);	tmp.push_back(nz);		

				int it=3;
				for(int ix=0; ix<it; ix++)
				{
					for(int iy=0; iy<it; iy++)
					{
						for(int iz=0; iz<it; iz++)
						{
							if(DIST(ix-(it-1)/2, iy-(it-1)/2,iz-(it-1)/2, 0, 0, 0) < it/2.0)
							{
								int ind0 = INDEX1(nx+ix+(it-1)/2,ny+iy+(it-1)/2,nz+iz+(it-1)/2, 2*EXPAND+1);
								if( (ind0>-1 && ind0<CUBIC(2*EXPAND+1)) && (Seed_rtp[ind0][1] == -1 || Seed_rtp[ind0][1] > dist) )
											Seed_rtp[ind0] = tmp;
							}
						}
					}
				}

		}
	}


#ifdef DEBUG
	cout  << " #Seed in range: " << seedInd1st.size() << " ; #surf in range: " << surfInd1st.size() << endl;
	cout << "store range information\n" << endl;
	for(int i=0;i<Seed_rtp.size();i++)
	{
		cout << "SEED RTP : ";
		for (int j = 0; j<Seed_rtp[i].size(); j++) 
		{
			cout << Seed_rtp[i][j] << " ";
		}
		cout << endl;
	}
#endif

  // pick closest point for each range; 
	int minInd = -1;
	double minDist = 9999;
	for(int i=0; i<Seed_rtp.size(); i++)
	{
		TIn visVal = surfs[(int)Seed_rtp[i][0]].getPro(VIS); 	
		if(Seed_rtp[i][1] > -1 && surfs[(int)Seed_rtp[i][0]].getSeedIndex()>0)
		{
			seedInd2nd.push_back((int)Seed_rtp[i][0]);
			if( minDist > Seed_rtp[i][1])
			{ minDist =  Seed_rtp[i][1]; minInd = (int)Seed_rtp[i][0];}
		}
	}

// ----------------------------------------------------------------
if(1){
// test 
#ifdef DEBUG
 	cout << "remove any noncontinuous points "<< seedInd2nd.size() << endl; 
#endif
		
		seedInd3rd.clear();
		seedInd3rd.push_back(minInd);
		for(int i=0; i<seedInd3rd.size();i++)
		{
			if(seedInd2nd.size()<1) break;	
			int x1, y1, z1;	
			surfs[seedInd3rd[i]].getABC(x1, y1, z1);
			vector<int> ind;
			for(int j=0; j<seedInd2nd.size();j++)
			{
				int x2, y2, z2;	
				surfs[seedInd2nd[j]].getABC(x2, y2, z2);
				TIn tdist = DIST(x1,y1,z1, x2, y2, z2);
				
				TIn visVal = surfs[seedInd2nd[j]].getPro(VIS); 	
				if ( ( tdist <= 2 ) ){ind.push_back(j);} //|| ( tdist <= 4 && visVal > 0.70 ) )
				
			}	
			if(ind.size()>6)
			{
				for(int j=0; j<ind.size();j++)
				{
					seedInd3rd.push_back( seedInd2nd[ind[j]-j] );
					seedInd2nd.erase( seedInd2nd.begin()+ind[j]-j );
					if(seedInd2nd.size()<1) break;	
				}
			}
			if(seedInd2nd.size()<1) break;
		}
	
	// remove any redundent information. 
	seedInd2nd.clear();
	seedInd2nd.push_back(seedInd3rd[0]);
	for(int i=0; i<seedInd3rd.size();i++){
		int found=0;
		for(int l=0; l<seedInd2nd.size();l++){
			if(seedInd3rd[i] == seedInd2nd[l]) found = 1; break;
		}
		if(!found) seedInd2nd.push_back(seedInd3rd[i]);
	}

if(1){
#ifdef DEBUG	
	cout << "growing surface pocket from surface : " << seedInd2nd.size() << endl;
#endif
	
//	for(int i = 0; i <3; i++){	
		int tsize = seedInd2nd.size();
		for(int j=0; j<surfInd1st.size(); j++)
		{
			int x1, y1, z1;	
			surfs[surfInd1st[j]].getABC(x1, y1, z1);
			for (int k=0; k<tsize; k++){
				int x2, y2, z2;	
				surfs[seedInd2nd[k]].getABC(x2, y2, z2);
				if ( DIST(x1,y1,z1, x2, y2, z2)< 1.5 && seedInd2nd[k] != surfInd1st[j]){
					seedInd2nd.push_back(surfInd1st[j]);
				}			
			}

//		}
	}


}


} // end if (0) 

//=============
	for(int i=0; i<seedInd2nd.size(); i++)
	{
		_surfVec.pushSurf(surfs[seedInd2nd[i]]); 
	}

//==============
	// initialize backward indexing
	for(int i=0; i<surfs.size(); i++)
	{
		surfs[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SurfSIZE reduced from " << surfs.size() << " ";
#endif
	
	_surfVec.copySurfs(surfs); 
	
#ifdef DEBUG	
	cout << " to  " << surfs.size() << endl;
#endif	
	
	// reset backward indexing
	for( int i=0; i<surfs.size(); i++ )
	{
		surfs[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSurfABC();
	mapSurfXYZ();
	
	return ppdb;

}

template<class T, class TIn>
void SurfVec<T,TIn>::remapSurfs( SurfVec<T,TIn> & _surfVec )
{
	// initialize backward indexing
	for(int i=0; i<surfs.size(); i++)
	{
		surfs[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SurfSIZE reduced from " << surfs.size() << " ";
#endif
	
	_surfVec.copySurfs(surfs); 
	
#ifdef DEBUG	
	cout << " to  " << surfs.size() << endl;
#endif	
	
	// reset backward indexing
	for( int i=0; i<surfs.size(); i++ )
	{
		surfs[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSurfABC();
	mapSurfXYZ();

	return;
}


// volumetric ray casting method V2 from center point using Cartician coordinates
// with using fill grid
template<class T, class TIn>
vector<vector<int> > SurfVec<T,TIn>::PocketSurf_lsc(const char* pdbFile, VolumeDX<T,TIn> filledDX, TIn _rad)
{
		// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	
	float _cenX, _cenY, _cenZ;
	if(ppdb.ATOMsize()>0 || ppdb.HETATMsize()>0)
	{
		ppdb.getCOG(_cenX, _cenY, _cenZ);
	}else {
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}	

	FILE * pFile;
	pFile = fopen(".temp.pdb","w");
	fprintf (pFile, "ATOM      1  X   XXX -   1    %8.3f%8.3f%8.3f  1.00 00.00           X  \n", _cenX, _cenY, _cenZ);
	fclose(pFile);

	return PocketSurf(".temp.pdb", filledDX, _rad);
}

template<class T, class TIn>
int SurfVec<T,TIn>::PocketSurf_cntr(TIn x_cntr, TIn y_cntr, TIn z_cntr, TIn pkt_rad)
// extracting pocket surface using sphere centered at (x_cntr, y_cntr, z_cntr)
// with radius pkt_rad
// by W.-H. Shin Jan. 2017
{
  // Initializing output SurfVec
  SurfVec<T,TIn> _surfVec;
  _surfVec.init();
  _surfVec.reserveSurfs(surfs.size());

  // Temp. crd. of grid pts.
  TIn x_crd, y_crd, z_crd;
  TIn dist; // dist. btw. pkt. cntr. and grid pt.
  vector<int> surf_idx; // array to contain grid pts.

  // calc. dist. btw. pkt. cntr. and grid pts.
  for(int i_pt = 0; i_pt < surfs.size(); i_pt++)
    {
      surfs[i_pt].getXYZ(x_crd, y_crd, z_crd);
      dist = DIST(x_crd, y_crd, z_crd, x_cntr, y_cntr, z_cntr);
      if(dist <= pkt_rad)
	{
	  surf_idx.push_back(i_pt);
	}
    }

  // store grid pts.
  for(int i = 0; i < surf_idx.size(); i++)
    {
      _surfVec.pushSurf(surfs[surf_idx[i]]);
    }

  // reset surf.
  for(int i = 0; i < surfs.size(); i++)
    {
      surfs[i].setSeedIndex(-1);
    }

  _surfVec.copySurfs(surfs);

  for(int i = 0; i < surfs.size(); i++)
    {
      surfs[i].setSeedIndex(i);
    }

  mapSurfABC();
  mapSurfXYZ();

  return 1;
}

// volumetric ray casting method V2 from center point using Cartician coordinates
// with using fill grid
template<class T, class TIn>
vector<vector<int> > SurfVec<T,TIn>::PocketSurf(const char* pdbFile, VolumeDX<T,TIn> filledDX, TIn _rad)
{
	// process pdb file
	cout << "CP" << endl;
	
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);

	cout << "CP3" << endl;

	vector<float> _cenX, _cenY, _cenZ;
	_cenX.clear(); _cenY.clear(); _cenZ.clear();
	if(ppdb.ATOMsize()>=9 || ppdb.HETATMsize()>=9)
	{	
		ppdb.getMinCenMax(_cenX,_cenY,_cenZ); //the farthest two atoms of the ligand and the atom which is nearest to the geometric center
	} else if(ppdb.ATOMsize()>0 || ppdb.HETATMsize()>0)
	{
		_cenX.resize(1); _cenY.resize(1); _cenZ.resize(1);
		ppdb.getCOG(_cenX[0], _cenY[0], _cenZ[0]);
	}else {
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}	

	float cenX=0,cenY=0,cenZ=0;
	ppdb.getCOG(cenX,cenY,cenZ);
	float cenA,cenB,cenC;
	TRANSFORMFROM(cenX,cenY,cenZ,cenA,cenB,cenC);
	// initialize output SurfVec
	SurfVec<T,TIn> _surfVec;
	_surfVec.init();
	_surfVec.reserveSurfs(surfs.size());
		
	vector<int> surfInd1; // surface indexs for the first selection criterion
	vector<int> surfInd2;
	vector<int> surfInd3;
	
	T* fGrid = filledDX.getGrid();
	// check grid parameters


// 0. transform filled and surface vectors to center of gravity
// ----------------------------------------------------------------
	const int EXPAND = 30; 
	vector<vector<vector<double> > > Surf_rtp; // normalized vector coordinates of surf point 
	vector<double> itmp(5,-1);
	Surf_rtp.resize(_cenX.size());	
	for(int i=0; i<Surf_rtp.size(); i++) (Surf_rtp[i]).resize(CUBIC(2*EXPAND+1), itmp );
		
	int minX = MAX(0,(int)(cenA-_rad/delX_)); int maxX = MIN(dimX_,(int)(cenA+_rad/delX_));
	int minY = MAX(0,(int)(cenB-_rad/delY_)); int maxY = MIN(dimY_,(int)(cenB+_rad/delY_));
	int minZ = MAX(0,(int)(cenC-_rad/delZ_)); int maxZ = MIN(dimZ_,(int)(cenC+_rad/delZ_));

	// set vector map for filled grid 
	for(int i=minX; i<maxX; i++){
		for(int j=minY; j<maxY; j++){
			for(int k=minZ; k<maxZ; k++){
				if(fGrid[INDEX2(i,j,k,dimX_,dimY_,dimZ_)]==0){continue;}	
				TIn sx,sy,sz; 
				TRANSFORMTO(i,j,k,sx,sy,sz);
				double dist2 = DIST(sx,sy,sz,cenX,cenY,cenZ); //distance between (sx,sy,sz) and geometric center
				for(int a = 0; a < _cenX.size(); a++)
				{
					double dist = DIST(sx,sy,sz, _cenX[a],_cenY[a],_cenZ[a]); //distance between (sx, sy, sz) and any of farthest two ligand atoms or the atom nearest to goc
			
					if( dist<=_rad && dist2<=_rad )
					{
						vector<double> tmp;	
						tmp.push_back(-3);
						tmp.push_back(dist); 
						double x = double(sx-_cenX[a]), y = double(sy-_cenY[a]), z = double(sz-_cenZ[a]); 

						int nx = (int)floor( EXPAND*(x/dist) )+EXPAND;
						int ny = (int)floor( EXPAND*(y/dist) )+EXPAND;
						int nz = (int)floor( EXPAND*(z/dist) )+EXPAND; //this (nx,ny,nz) will decide a direction from (_cenX[a], _cenY[a], _cenZ[a])

						tmp.push_back(nx);	tmp.push_back(ny);	tmp.push_back(nz);		
			
						int ind0 = INDEX1(nx,ny,nz, 2*EXPAND+1);
						if( (ind0>-1 && ind0<CUBIC(2*EXPAND+1)) )
							if((Surf_rtp[a][ind0][0] == -1 || Surf_rtp[a][ind0][1] > dist) ) //find the shortest distance at direction (nx,ny,nz)
									Surf_rtp[a][ind0] = tmp;

					}
				}
			
			}	
		}	
	}
	
	
	for(int i=0; i<surfs.size(); i++)
	{
		TIn sx, sy, sz;
		surfs[i].getXYZ(sx,sy,sz);
		double dist2 = DIST(sx,sy,sz,cenX,cenY,cenZ);
		for(int a = 0; a < _cenX.size(); a++)
		{
			double dist = DIST(sx,sy,sz, _cenX[a],_cenY[a],_cenZ[a]);
			if( dist<=_rad && dist2<=_rad )
			{
				surfInd1.push_back(i); 
				double x = double(sx-_cenX[a]), y = double(sy-_cenY[a]), z = double(sz-_cenZ[a]); 
				vector<double> tmp;	
				tmp.push_back(i);
				tmp.push_back(dist); // r 
	
				int nx = (int)floor( EXPAND*(x/dist) )+EXPAND;
				int ny = (int)floor( EXPAND*(y/dist) )+EXPAND;
				int nz = (int)floor( EXPAND*(z/dist) )+EXPAND;
	
				tmp.push_back(nx);	tmp.push_back(ny);	tmp.push_back(nz);		
	
				int ind0 = INDEX1(nx,ny,nz, 2*EXPAND+1);
				if( (ind0>-1 && ind0<CUBIC(2*EXPAND+1) ))
					if((Surf_rtp[a][ind0][0]>-1 && Surf_rtp[a][ind0][1]> dist) 
						|| (Surf_rtp[a][ind0][0]==-3 && Surf_rtp[a][ind0][1]+delX_> dist) )
						Surf_rtp[a][ind0] = tmp;
	
			}
		}
	}


#ifdef DEBUG_SUR
	cout << "#surf in range: " << surfInd1.size() << endl;
	cout << "store range information\n" << endl;
	for(int i=0;i<Surf_rtp.size();i++)
	{
		cout << "SEED RTP : ";
		for (int j = 0; j<Surf_rtp[i].size(); j++) 
		{
			if(Surf_rtp[i][j][0] > -1)	cout << Surf_rtp[i][j][0] << " ";
		}
		cout << endl;
	}
#endif

  // collect the surfs; 
	int minInd = -1;
	double minDist = 9999;
	for(int i=0; i<Surf_rtp.size(); i++)
	{
		for (int j=0; j<Surf_rtp[i].size();j++)
		{
			if(Surf_rtp[i][j][0] > -1)
			{
				surfInd2.push_back((int)Surf_rtp[i][j][0]);
				if( minDist > Surf_rtp[i][j][1])
				{ minDist =  Surf_rtp[i][j][1]; minInd = (int)Surf_rtp[i][j][0];}
			}
		}
	}


// ----------------------------------------------------------------
// test 
#ifdef DEBUG
 	cout << "remove any noncontinuous points "<< surfInd2.size() << endl; 
#endif
		
		surfInd3.clear();
		surfInd3.push_back(minInd);
		for(int i=0; i<surfInd3.size();i++)
		{
			if(surfInd2.size()<1) break;	
			int x1, y1, z1;	
			surfs[surfInd3[i]].getABC(x1, y1, z1);
			vector<int> ind;
			for(int j=0; j<surfInd2.size();j++)
			{
				int x2, y2, z2;	
				surfs[surfInd2[j]].getABC(x2, y2, z2);
				TIn tdist = DIST(x1,y1,z1, x2, y2, z2);
				if ( ( tdist < 2 ) ){ind.push_back(j);}
			}	
			if( ind.size() > 2 )//ICY changed value from 6 to 2 (1/28/2014)
			{
				for(int j=0; j<ind.size();j++)
				{
					surfInd3.push_back( surfInd2[ind[j]-j] );
					surfInd2.erase( surfInd2.begin()+ind[j]-j );
					if(surfInd2.size()<1) break;	
				}
			}
			if(surfInd2.size()<1) break;
		}


#ifdef DEBUG	
	cout << "growing surface pocket from surface : " << surfInd3.size() ;
#endif
	
	int tsize = surfInd3.size();
	for(int j=0; j<surfInd1.size(); j++)
	{
		int x1, y1, z1;	
		surfs[surfInd1[j]].getABC(x1, y1, z1);
		for (int k=0; k<tsize; k++)
		{
			int x2, y2, z2;	
			surfs[surfInd3[k]].getABC(x2, y2, z2);
			if ( DIST(x1,y1,z1, x2, y2, z2)< 1.5 && surfInd3[k] != surfInd1[j])
					surfInd3.push_back(surfInd1[j]);
		}
	}
	
#ifdef DEBUG	
	cout << " to : " << surfInd3.size() << endl;
	for(int i=0; i<surfInd3.size();i++){
			int a,b,c;
		surfs[surfInd3[i]].getABC(a,b,c);
		int idx = INDEX2(a,b,c,dimX_,dimY_,dimZ_);
		cout << "surfInd3[" << i << "] =  "<< surfInd3[i] <<" (" << a << ", " << b << ", " << c << ") " << idx << endl; 	
	}
#endif
	
	int count = 0;
	map<int,int> tmap;
	vector<vector<int> > IdxP;
	for(int i=0; i<surfInd3.size(); i++)
	{
		int a,b,c;
		surfs[surfInd3[i]].getABC(a,b,c);
		int idx = INDEX2(a,b,c,dimX_,dimY_,dimZ_);
		if(tmap.find(idx)==tmap.end())
		{
			vector<int> tmp(2,-1);
			_surfVec.pushSurf(surfs[surfInd3[i]]); 
			tmap[idx]=i;
			tmp[0] = surfs[surfInd3[i]].getSeedIndex();
			tmp[1] = count++;
		}
	}
	
// reset the surf vec
#ifdef DEBUG	
	cout << "SurfSIZE reduced from " << surfs.size() << " ";
#endif
	
	_surfVec.copySurfs(surfs); 
	
#ifdef DEBUG	
	cout << " to  " << surfs.size() << endl;
#endif	
	
	mapSurfABC();
	mapSurfXYZ();
	
	return IdxP;

}	



// volumetric ray casting method from center point using spherical coordinates
template<class T, class TIn>
ProcessPDB<T,TIn> SurfVec<T,TIn>::PocketSurf(const char* pdbFile)
{
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	
	float _cenX, _cenY, _cenZ;
	vector<int> _selSurf;
	vector<vector< char *> > _selSurfVal1;
	vector<vector<float > > _selSurfVal2;

	if(ppdb.ATOMsize()>0 || ppdb.HETATMsize()>0){
		//ppdb.getCOG(_cenX, _cenY, _cenZ);
		ppdb.getCenAtm(_cenX, _cenY, _cenZ);
	}else {
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}	
	
	// initialize output SurfVec
	SurfVec<T,TIn> _surfVec;
	_surfVec.init();
	_surfVec.reserveSurfs(surfs.size());
	
	// get DX for grid 
//	VolumeDX<T,TIn> tmpDX = getSurfsDX();
//	int _tdimX, _tdimY, _tdimZ;
//	tmpDX.getGs(_tdimX, _tdimY, _tdimZ);
//	T* tmpGrid = tmpDX.getGrid();

	vector<int> seedInd1st; // surface indexs for the first selection criterion
	vector<int> seedInd2nd;
	vector<int> seedInd3rd;
	vector<int> surfInd1st;
	vector<int> surfInd2nd;
	// cout <<  _maxX  << _minX <<   _maxY <<  _minY  << _maxZ << _minZ << endl;

// 0. transform surface vectors to center of gravity
	int cenGX, cenGY, cenGZ;
	TRANSFORMFROM(_cenX, _cenY, _cenZ, cenGX, cenGY, cenGZ);
	
	// 1. for each seed point find the spherical coordinate from 
	// 		center of the pocket. 
	// r = sqrt(x^2+y^2+z^2); theta=atan2(y,x) ; phi=(arccos(z/(sqrt(x^2+y^2+z^2)))) ;
	// x = r*cos(phi)*sin(theta); y= r*sin(phi)*cos(theta); z=r*cos(theta);
#ifdef DEBUG	
	cout << "computing spherical coordinate\n" << endl;
#endif
	vector<vector<double> > Seed_rtp; // spherical coordinates of seed point
	for(int i=0; i<surfs.size(); i++)
	{
		TIn sx, sy, sz;
		surfs[i].getXYZ(sx, sy, sz);
		if( DIST(sx,sy,sz,_cenX, _cenY, _cenZ)<=20 ){
			surfInd1st.push_back(i);
			if( surfs[i].getSeedIndex()<0  ){
				seedInd1st.push_back(i);
//				if(i%2==0){
					// int gx, gy, gz;
					// surfs[i].getABC(gx, gy, gz);
					// double x = double(gx-cenGX), y = double(gy-cenGY), z = double(gz-cenGZ); 
					double x = double(sx-_cenX), y = double(sy-_cenY), z = double(sz-_cenZ); 
				
					vector<double> tmp;	
					double dist = sqrt(x*x+y*y+z*z);
					tmp.push_back(i);
					tmp.push_back(dist); // r 
					tmp.push_back((atan2(y,x)+PI)*(180.0/PI) ); // theta [0, 360) 
					tmp.push_back(acos(z/(dist))*180.0/PI ); // phi  [0, 180]
						
					tmp.push_back(ROUND((tmp[3])/6.0)*60 + ROUND((tmp[2])/6.0));

					tmp.push_back(ROUND((tmp[3])/6.0)*60 + ROUND((tmp[2]-3)/6.0));
					tmp.push_back(ROUND((tmp[3])/6.0)*60 + ROUND((tmp[2]+3)/6.0));
					tmp.push_back(ROUND((tmp[3]-3)/6.0)*60 + ROUND((tmp[2])/6.0));
					tmp.push_back(ROUND((tmp[3]+3)/6.0)*60 + ROUND((tmp[2])/6.0));				
					tmp.push_back(ROUND((tmp[3]-3)/6.0)*60 + ROUND((tmp[2]-3)/6.0));
					tmp.push_back(ROUND((tmp[3]-3)/6.0)*60 + ROUND((tmp[2]+3)/6.0));
					tmp.push_back(ROUND((tmp[3]+3)/6.0)*60 + ROUND((tmp[2]-3)/6.0));
					tmp.push_back(ROUND((tmp[3]+3)/6.0)*60 + ROUND((tmp[2]+3)/6.0));

				
					tmp.push_back(ROUND((tmp[3])/6.0)*60 + ROUND((tmp[2]-9)/6.0));
					tmp.push_back(ROUND((tmp[3])/6.0)*60 + ROUND((tmp[2]+9)/6.0));
					tmp.push_back(ROUND((tmp[3]-9)/6.0)*60 + ROUND((tmp[2])/6.0));
					tmp.push_back(ROUND((tmp[3]+9)/6.0)*60 + ROUND((tmp[2])/6.0));

					tmp.push_back(ROUND((tmp[3]-3)/6.0)*60 + ROUND((tmp[2]-9)/6.0));
					tmp.push_back(ROUND((tmp[3]-3)/6.0)*60 + ROUND((tmp[2]+9)/6.0));
					tmp.push_back(ROUND((tmp[3]+3)/6.0)*60 + ROUND((tmp[2]-9)/6.0));
					tmp.push_back(ROUND((tmp[3]+3)/6.0)*60 + ROUND((tmp[2]+9)/6.0));
					
					tmp.push_back(ROUND((tmp[3]-9)/6.0)*60 + ROUND((tmp[2]-3)/6.0));
					tmp.push_back(ROUND((tmp[3]-9)/6.0)*60 + ROUND((tmp[2]+3)/6.0));
					tmp.push_back(ROUND((tmp[3]+9)/6.0)*60 + ROUND((tmp[2]-3)/6.0));
					tmp.push_back(ROUND((tmp[3]+9)/6.0)*60 + ROUND((tmp[2]+3)/6.0));
					
					tmp.push_back(ROUND((tmp[3]-9)/6.0)*60 + ROUND((tmp[2]-9)/6.0));
					tmp.push_back(ROUND((tmp[3]-9)/6.0)*60 + ROUND((tmp[2]+9)/6.0));
					tmp.push_back(ROUND((tmp[3]+9)/6.0)*60 + ROUND((tmp[2]-9)/6.0));
					tmp.push_back(ROUND((tmp[3]+9)/6.0)*60 + ROUND((tmp[2]+9)/6.0));


	/*
					tmp.push_back((int)((tmp[3])/6.0)*60 + (int)((tmp[2])/6.0));

					tmp.push_back((int)((tmp[3])/6.0)*60 + (int)((tmp[2]-4)/6.0));
					tmp.push_back((int)((tmp[3])/6.0)*60 + (int)((tmp[2]+4)/6.0));
					tmp.push_back((int)((tmp[3]-4)/6.0)*60 + (int)((tmp[2])/6.0));
					tmp.push_back((int)((tmp[3]+4)/6.0)*60 + (int)((tmp[2])/6.0));
					
					tmp.push_back((int)((tmp[3]-3)/6.0)*60 + (int)((tmp[2]-3)/6.0));
					tmp.push_back((int)((tmp[3]-3)/6.0)*60 + (int)((tmp[2]+3)/6.0));
					tmp.push_back((int)((tmp[3]+3)/6.0)*60 + (int)((tmp[2]-3)/6.0));
					tmp.push_back((int)((tmp[3]+3)/6.0)*60 + (int)((tmp[2]+3)/6.0));

					tmp.push_back((int)((tmp[3])/6.0)*60 + (int)((tmp[2]-5)/6.0));
					tmp.push_back((int)((tmp[3])/6.0)*60 + (int)((tmp[2]+5)/6.0));
					tmp.push_back((int)((tmp[3]-5)/6.0)*60 + (int)((tmp[2])/6.0));
					tmp.push_back((int)((tmp[3]+5)/6.0)*60 + (int)((tmp[2])/6.0));

					tmp.push_back((int)((tmp[3]-5)/6.0)*60 + (int)((tmp[2]-5)/6.0));
					tmp.push_back((int)((tmp[3]-5)/6.0)*60 + (int)((tmp[2]+5)/6.0));
					tmp.push_back((int)((tmp[3]+5)/6.0)*60 + (int)((tmp[2]-5)/6.0));
					tmp.push_back((int)((tmp[3]+5)/6.0)*60 + (int)((tmp[2]+5)/6.0));
*/

					Seed_rtp.push_back(tmp);


	//			}
			}
		}
	}
#ifdef DEBUG
	cout  << " #Seed in range: " << seedInd1st.size() << " ; #surf in range: " << surfInd1st.size() << endl;
#endif
	
#ifdef DEBUG	
	cout << "sorting process\n" << endl;
#endif

	// comb sort according to r-> theta,phi ==========
	// a. sort by th index
	int	ssize = Seed_rtp.size(); // diff value?
	int gap = ssize;
	for (;;){
		gap = (gap*10)/13;
		if(gap == 9 || gap == 10) gap = 11;
		if(gap < 1) gap = 1;
		bool swapped = FALSE;
		for (int i = 0;i < ssize - gap; i++)
		{
			int j = i + gap;
			if(Seed_rtp[i][1] > Seed_rtp[j][1]){ 
				std::swap(Seed_rtp[i],Seed_rtp[j]);
				swapped = TRUE;
			}
		}
		if(gap == 1 && !swapped) break;
	}

#ifdef DEBUG	
	cout << "store range information\n" << endl;
	for(int i=0;i<Seed_rtp.size();i++){
		cout << "SEED RTP : ";
		for (int j = 0; j<Seed_rtp[i].size(); j++) {
			cout << Seed_rtp[i][j] << " ";
		}
		cout << endl;
	}
#endif


  // pick closest point for each range; 
	vector<int> sortSeed(2000, -1);
	vector<float> minDist(2000, 99999); 
	for(int i=0; i<Seed_rtp.size(); i++){
		if(Seed_rtp[i].size() > 4){
			int tdIndex[Seed_rtp[i].size()-4];
			for (int j=0; j<Seed_rtp[i].size()-4; j++){
				tdIndex[j]= (int)Seed_rtp[i][4+j];
			}
			for(int j =0; j<Seed_rtp[i].size()-4; j++){
				if( Seed_rtp[i][1] < minDist[tdIndex[j]] ){
					minDist[tdIndex[j]] = Seed_rtp[i][1];
					sortSeed[tdIndex[j]] = i;
				}
			}
		}
	}


/*
// test random pick
	vector<int> sortSeed(2000, -1);
	vector<float> minDist(2000, 99999); 
	for(int i=0;i<Seed_rtp.size();i++){
		int td= (int)Seed_rtp[i][4];
		for (int j = 0; j<60; j++){
			if( td == 1*60 + j  || td == 15*60 + j || td == 28*60 + j){		
				minDist[i%2000] = Seed_rtp[i][1];
				sortSeed[i%2000] = i;
			}
		}
	}
*/

	float minDistA = 99999;
	int minIndA = -1;
	for(int i=0; i< sortSeed.size(); i++){
		if(sortSeed[i]!= -1){
			seedInd2nd.push_back((int)Seed_rtp[sortSeed[i]][0]);
			if(minDistA > Seed_rtp[sortSeed[i]][1])
			{
				minDistA = Seed_rtp[sortSeed[i]][1];
				minIndA = (int)Seed_rtp[sortSeed[i]][0];
			}
		}
	}

#ifdef DEBUG	
	cout << "find min dist information\n" << endl;
	for(int i=0;i<sortSeed.size();i++){
		if(sortSeed[i] !=-1){
		cout << "SEED RTP MIN dist: " << Seed_rtp[sortSeed[i]][0] << " "
  			<< Seed_rtp[sortSeed[i]][1] << " " << Seed_rtp[sortSeed[i]][2] << " "
			 << Seed_rtp[sortSeed[i]][3] << " " << Seed_rtp[sortSeed[i]][4] << endl;
		}
	}
#endif

// test 
/*

#ifdef DEBUG	
	cout << "save neighbors seed selection (seed selected " << seedInd2nd.size()<<")\n" << endl;
#endif
	
	// check continuity and push to _surfVec
//		for(int i=0; i<2;i++)
//		{
			cout << "seed size now " << seedInd2nd.size() << endl;
			int size = seedInd2nd.size();
			for(int j=0; j<size;j++)
			{
				int x1, y1, z1;	
				surfs[seedInd2nd[j]].getABC(x1, y1, z1);
				
				for (int k=0; k<seedInd1st.size(); k++){
					int x2, y2, z2;	
					surfs[seedInd1st[k]].getABC(x2, y2, z2);
					if ( DIST(x1,y1,z1, x2, y2, z2)<= 1 ){
						seedInd2nd.push_back(seedInd1st[k]);
					}
				}

			}
//		}
	
	seedInd1st.clear();

	// remove any redundent information. 
	seedInd3rd.clear();
	seedInd3rd.push_back(seedInd2nd[0]);
	for(int i=0; i<seedInd2nd.size();i++){
		int found=0;
		for(int l=0; l<seedInd3rd.size();l++){
			if(seedInd2nd[i] == seedInd3rd[l]) found = 1; break;
		}
		if(!found) seedInd3rd.push_back(seedInd2nd[i]);
	}
	seedInd2nd.clear();


#ifdef DEBUG
 	cout << "remove any noncontinuous points "<< seedInd3rd.size() << endl; 
#endif
	
		seedInd2nd.push_back(minIndA);
		for(int i=0; i<seedInd2nd.size();i++)
		{
			if(surfInd1st.size()<1) break;	
			int x1, y1, z1;	
			surfs[seedInd2nd[i]].getABC(x1, y1, z1);
			for(int j=0; j<seedInd3rd.size();j++)
			{
				int x2, y2, z2;	
				surfs[seedInd3rd[j]].getABC(x2, y2, z2);
				TIn tdist = DIST(x1,y1,z1, x2, y2, z2);
				if ( tdist <= 1.42 ){
					seedInd2nd.push_back(seedInd3rd[j]);
					seedInd3rd.erase(seedInd3rd.begin()+j);
					--j;
					if(seedInd3rd.size()<1) break;	
				}
			}

		}
	
#ifdef DEBUG	
	cout << "growing surface pocket from surface : " << seedInd2nd.size() << endl;
#endif
		
		int tsize = seedInd2nd.size();
		for(int j=0; j<tsize; j++)
		{
			int x1, y1, z1;	
			surfs[seedInd2nd[j]].getABC(x1, y1, z1);
			for (int k=0; k<surfInd1st.size(); k++){
				int x2, y2, z2;	
				surfs[surfInd1st[k]].getABC(x2, y2, z2);
				if ( DIST(x1,y1,z1, x2, y2, z2)<3 ){
					seedInd2nd.push_back(surfInd1st[k]);
				}			
			}
		}
	*/
	/*
	surfInd2nd.clear();
	surfInd2nd.push_back(seedInd2nd[0]);
	for(int i=0; i<seedInd2nd.size();i++){
		int found=0;
		for(int l=0; l<surfInd2nd.size();l++){
			if(seedInd2nd[i] == surfInd2nd[l]) found = 1; break;
		}
		if(!found) surfInd2nd.push_back(seedInd2nd[i]);
	}
	
	seedInd2nd.clear();
	
	// store
	for(int i=0; i<surfInd2nd.size(); i++)
	{
		_surfVec.pushSurf(surfs[surfInd2nd[i]]); 
	}
*/

//=============
	for(int i=0; i<seedInd2nd.size(); i++)
	{
		_surfVec.pushSurf(surfs[seedInd2nd[i]]); 
	}

//==============
	// initialize backward indexing
	for(int i=0; i<surfs.size(); i++)
	{
		surfs[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SurfSIZE reduced from " << surfs.size() << " ";
#endif
	
	_surfVec.copySurfs(surfs); 
	
#ifdef DEBUG	
	cout << " to  " << surfs.size() << endl;
#endif	
	
	// reset backward indexing
	for( int i=0; i<surfs.size(); i++ )
	{
		surfs[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSurfABC();
	mapSurfXYZ();
	
	return ppdb;
}


template<class T, class TIn>
ProcessPDB<T,TIn> SurfVec<T,TIn>::PocketSurf(const char* pdbFile, TIn _dist)
{
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	
	//ppdb.printPDB();	

	float _cenX, _cenY, _cenZ;
	vector<int> _selSurf;
	vector<vector< char *> > _selSurfVal1;
	vector<vector<float > > _selSurfVal2;

	if(ppdb.ATOMsize()>0 || ppdb.HETATMsize()>0){
		ppdb.getCOG(_cenX, _cenY, _cenZ);
	}else {
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}
	
	
	// initialize output SurfVec
	SurfVec<T,TIn> _surfVec;
	_surfVec.init();
	_surfVec.reserveSurfs(surfs.size());

	vector<int> surfInd1st; // surface indexs for the first selection criterion
	vector<int> surfInd2nd;

	float _minX, _minY, _minZ, _maxX, _maxY, _maxZ;
	_minX = _cenX - _dist; _minY = _cenY-_dist; _minZ = _cenZ-_dist;  
	_maxX = _cenX+_dist; _maxY = _cenY+_dist; _maxZ =_cenZ+ _dist;

	// cout <<  _maxX  << _minX <<   _maxY <<  _minY  << _maxZ << _minZ << endl;
		

	// June 2009 MODIFIED
	// 1. pre-select all surface within the bound
	// 2. check continuity from the surface point at the COG
	TIn minDist2COG = 99999;
	int minsi = 0;
	for(int i=0; i<surfs.size(); i++)
	{
		TIn sx, sy, sz;	
		//	surfs[i].getEXYZ(sx, sy, sz);
		surfs[i].getXYZ(sx, sy, sz);
	
		if( sx > _maxX || sx < _minX || sy > _maxY || sy < _minY || sz >_maxZ || sz < _minZ )
			continue;
	
		TIn tdist = DIST(sx,sy,sz,_cenX, _cenY, _cenZ);
		if( tdist <= _dist)
		{
			// push selected seeds
			surfInd1st.push_back(i);
		}
		
		if(DIST(sx,sy,sz, _cenX, _cenY, _cenZ) < minDist2COG)
		{
			minDist2COG = DIST(sx,sy,sz, _cenX, _cenY, _cenZ);
			minsi = i;
		}
	}

	// check continuity and push to _surfVec
	
		surfInd2nd.push_back(minsi);
		for(int i=0; i<surfInd2nd.size();i++)
		{
			if(surfInd1st.size()<1) break;	
			TIn x1, y1, z1;	
			surfs[surfInd2nd[i]].getXYZ(x1, y1, z1);

			for(int j=0; j<surfInd1st.size();j++)
			{
				TIn x2, y2, z2;	
				surfs[surfInd1st[j]].getXYZ(x2, y2, z2);

				TIn tdist = DIST(x1,y1,z1, x2, y2, z2);
				if ( tdist < 1.5 ){
					surfInd2nd.push_back(surfInd1st[j]);
					surfInd1st.erase(surfInd1st.begin()+j);
					--j;
					if(surfInd1st.size()<1) break;	
				}
			}

		}
	

	// store
	for(int i=0; i<surfInd2nd.size(); i++)
	{
		_surfVec.pushSurf(surfs[surfInd2nd[i]]); 
	}


	// initialize backward indexing
	for(int i=0; i<surfs.size(); i++)
	{
		surfs[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SurfSIZE reduced from " << surfs.size() << " ";
#endif
	
	_surfVec.copySurfs(surfs); 
	
#ifdef DEBUG	
	cout << " to  " << surfs.size() << endl;
#endif	
	
	// reset backward indexing
	for( int i=0; i<surfs.size(); i++ )
	{
		surfs[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSurfABC();
	mapSurfXYZ();
	
	return ppdb;
}


template<class T, class TIn>
ProcessPDB<T,TIn> SurfVec<T,TIn>::InterfaceSurf(const char* pdbFile, TIn _dist)
{
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	
	vector<ATOMStruct> _atm;
	vector<int> _selSurf;
	vector<vector< char *> > _selSurfVal1;
	vector<vector<float > > _selSurfVal2;

	if(ppdb.ATOMsize()>0){
		_atm = ppdb.getATOM();
	}else if(ppdb.HETATMsize()>1){
		_atm = ppdb.getHETATM();
	}else{
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}
	
//	ppdb.printPDB();
	
	// initialize output SurfVec
	SurfVec<T,TIn> _surfVec;
	_surfVec.init();
	_surfVec.reserveSurfs(surfs.size());

	vector<int> surfInd1st; // surface indexs for the first selection criterion
	vector<int> surfInd2nd;

	float _minX, _minY, _minZ, _maxX, _maxY, _maxZ;
	float _cogX, _cogY, _cogZ;
	ppdb.getMin(_minX,_minY,_minZ);
	ppdb.getMax(_maxX,_maxY,_maxZ);
	ppdb.getCOG(_cogX,_cogY,_cogZ);
	_minX -= _dist; _minY -= _dist; _minZ -= _dist;  
	_maxX += _dist; _maxY += _dist; _maxZ += _dist;

	// cout <<  _maxX  << _minX <<   _maxY <<  _minY  << _maxZ << _minZ << endl;
		

	// June 2009 MODIFIED
	// 1. pre-select all surface within the bound
	// 2. check continuity from the surface point at the COG
	TIn minDist2COG = 99999;
	int minsi = 0;
	for(int i=0; i<surfs.size(); i++)
	{
		TIn sx, sy, sz;	
		//	surfs[i].getEXYZ(sx, sy, sz);
		surfs[i].getXYZ(sx, sy, sz);
	
		if( sx > _maxX || sx < _minX || sy > _maxY || sy < _minY || sz >_maxZ || sz < _minZ )
			continue;
	
		for(int j=0; j<_atm.size(); j++)
		{
			TIn tdist = DIST(sx,sy,sz,_atm[j].x, _atm[j].y, _atm[j].z);
			if( tdist <= _dist)
			{
				// push selected seeds
				surfInd1st.push_back(i);
				break;
			}
		}
		
		if(DIST(sx,sy,sz, _cogX, _cogY, _cogZ) < minDist2COG)
		{
			minDist2COG = DIST(sx,sy,sz, _cogX, _cogY, _cogZ);
			minsi = i;
		}
	}

	// check continuity and push to _surfVec
	
		surfInd2nd.push_back(minsi);
		for(int i=0; i<surfInd2nd.size();i++)
		{
			if(surfInd1st.size()<1) break;	
			TIn x1, y1, z1;	
			surfs[surfInd2nd[i]].getXYZ(x1, y1, z1);

			for(int j=0; j<surfInd1st.size();j++)
			{
				TIn x2, y2, z2;	
				surfs[surfInd1st[j]].getXYZ(x2, y2, z2);

				TIn tdist = DIST(x1,y1,z1, x2, y2, z2);
				if ( tdist < 2.0 ){
					surfInd2nd.push_back(surfInd1st[j]);
					surfInd1st.erase(surfInd1st.begin()+j);
					--j;
					if(surfInd1st.size()<1) break;	
				}
			}

		}
	

	// store
	for(int i=0; i<surfInd2nd.size(); i++)
	{
		_surfVec.pushSurf(surfs[surfInd2nd[i]]); 
	}


	// initialize backward indexing
	for(int i=0; i<surfs.size(); i++)
	{
		surfs[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SurfSIZE reduced from " << surfs.size() << " ";
#endif
	
	_surfVec.copySurfs(surfs); 
	
#ifdef DEBUG	
	cout << " to  " << surfs.size() << endl;
#endif	
	
	// reset backward indexing
	for( int i=0; i<surfs.size(); i++ )
	{
		surfs[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSurfABC();
	mapSurfXYZ();
	
	return ppdb;
}


/*
template<class T, class TIn>
ProcessPDB<T,TIn> SurfVec<T,TIn>::InterfaceSurf(const char* pdbFile, TIn _dist)
{
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	
	vector<ATOMStruct> _atm;
	vector<int> _selSurf;
	vector<vector< char *> > _selSurfVal1;
	vector<vector<float > > _selSurfVal2;

	if(ppdb.ATOMsize()>1){
		_atm = ppdb.getATOM();
	}else if(ppdb.HETATMsize()>1){
		_atm = ppdb.getHETATM();
	}else{
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}
	
//	ppdb.printPDB();
	
	// initialize output SurfVec
	SurfVec<T,TIn> _surfVec;
	_surfVec.init();
	_surfVec.reserveSurfs(surfs.size());
	float _minX, _minY, _minZ, _maxX, _maxY, _maxZ;
	ppdb.getMin(_minX,_minY,_minZ);
	ppdb.getMax(_maxX,_maxY,_maxZ);
	_minX -= _dist; _minY -= _dist; _minZ -= _dist;  
	_maxX += _dist; _maxY += _dist; _maxZ += _dist;



	for(int i=0; i<surfs.size(); i++)
	{
		TIn sx, sy, sz;	
		//	surfs[i].getEXYZ(sx, sy, sz);
		surfs[i].getXYZ(sx, sy, sz);
	//	if( sx > _maxX || sx < _minX || sy > _maxY || sy < _minY || sz >_maxZ || sz < _minZ ){ 
	//		break;
	//	}
		TIn minDist = 99999;
		int minai = 0;
		for(int j=0; j<_atm.size(); j++)
		{
			if(DIST(sx,sy,sz,_atm[j].x, _atm[j].y, _atm[j].z)< minDist)  //_dist)
			{
				minDist = DIST(sx,sy,sz,_atm[j].x, _atm[j].y, _atm[j].z);
				minai = j;
			}
		}
		if(minDist<_dist){
			vector<char> tmp;
			tmp.push_back(_atm[minai].aName[0]);
			tmp.push_back(_atm[minai].aName[1]);
			tmp.push_back(_atm[minai].aName[2]);

			// push selected seeds
			_surfVec.pushSurf(surfs[i]);

			// push closest HETATM Atom name (aName) 
			//	cout << "DIST: " << minDist<< endl;
		}

	}

	// initialize backward indexing
	for(int i=0;i<surfs.size(); i++)
	{
		surfs[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SurfSIZE reduced from " << surfs.size() << " ";
#endif
	
	_surfVec.copySurfs(surfs); 
	
#ifdef DEBUG	
	cout << " to  " << surfs.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<surfs.size(); i++)
	{
		surfs[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSurfABC();
	mapSurfXYZ();
	
	return ppdb;
}

*/


