
/*============================================
 *
 * Sael Lee 
 * March 11, 2009
 *
 * HAVE problem with VisHist <- is commented out
 *===========================================*/

#ifndef SEEDVEC_H
#define SEEDVEC_H

#include "Common.h"
#include "ProcessPDB.h"

template<class T, class TIn>
class Seed
{
	private:
	
		Surf<T,TIn>*							seedSurf;		// closest surface voxel
		TIn												ex, ey, ez;
		
		float											*(proInvs[PROSIZE]);		// invs for each properties
		//I added the geodesic distance between this seed and other seeds
		float                                                                                   *DbtwSeed;              //distance between this seed and other seeds
		//int											nHBD, nHBA;//number of HB donor and acceptor (by Bingjie Hu)
		
		int												*cAtom;			// close atom	
		int		 										*cRes;			// close residue
		int 											*ligAName; 	// close ligand atom 
		bool 											sel;				// selected 
	
		float 										*visHist;		// histogram of visibility	
		
	public:
		Seed(){ init(); };
		~Seed(){ clear(); };
	
		void init();
		void init(TIn _x,TIn _y,TIn _z){init(); ex=_x; ey=_y; ez=_z;};
		
		void clear(){init();};
		
		void setSurf(Surf<T,TIn>* _surf){seedSurf = _surf; };

		void setcAcR(vector<int> &_catom, vector<int> &_cres);
	
		void setLig(vector<char> &_aName);
		void setLig(vector<int> &_aLigIn);

		void setInv(vector<float> &_inv, int _i);
		void setDbtwSeed(map<int, float> &_Dseeds);

		Surf<T,TIn>* getSurf(){return seedSurf; };
		
		void setPro(T _value, int _i){seedSurf->setPro(_value, _i);};
		T getPro(int _i){seedSurf->getPro(_i);};
		
		void getEXYZ(TIn &_x, TIn &_y, TIn &_z){_x=ex; _y=ey; _z=ez;};
		void getXYZ(TIn &_x, TIn &_y, TIn &_z){ seedSurf->getXYZ(_x,_y,_z); };
		void getABC(int &_a, int &_b, int &_c){seedSurf->getABC(_a,_b,_c);};
		int* getRes(){return cRes;};


		int  getSurfIndex(){seedSurf->getIndex();};	
		float * getVisHist(){return visHist; };
		void setVisHist(float* _visHist ){ visHist = _visHist; };
		
		void setSeedIndex(int _n){seedSurf->setSeedIndex(_n);};	
			
		TIn getDist(TIn _x, TIn _y, TIn _z){ return(DIST(ex,ey,ez,_x,_y,_z));};
		int nHBD, nHBA;//number of HB donor and acceptor (by Bingjie Hu)
		int nAROM; // # of aromatic grids of the patch
		void printSeed();
		void printSeed(std::ofstream &_fout);
		void printSeed(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb);
		void printSeed(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, ProcessPDB<T,TIn> _lig);
		void printSeed(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, vector<ATOMStruct> _atoms);
		void printSeed(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, ProcessPDB<T,TIn> _lig, vector<ATOMStruct> _atoms);

};	


template<class T, class TIn>
class SeedVec
{
	private:
		TIn 										cenX_, cenY_, cenZ_;
		TIn 										delX_, delY_, delZ_;
		int 										dimX_, dimY_, dimZ_;
		int 										ord_;

		vector<Seed<T,TIn> >		seeds;	
			
		map< int,int >						mapABC;	
		map< T,  int >						mapXYZ;
		
		void mapSeedABC();
		void mapSeedXYZ();

	
	public:
		void init()
		{
			cenX_ = cenY_ = cenZ_ = 0;
			delX_ = delY_ = delZ_ = 0;
			dimX_ = dimY_ = dimZ_	= 0;
			ord_ = 0;
			seeds.clear();
		};
		
		void clear(){init();};
		void reserveSeeds(int _n)
		{
			seeds.reserve(_n);
		};
		
		int pushSeed(Seed<T,TIn> _seed)
		{
			seeds.push_back(_seed);
			return seeds.size()-1;
		};
		
		void setPara(int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ )
		{
			dimX_ = dimY_ = dimZ_ = _gs;		
			delX_	= delY_	= delZ_ = _del;
			cenX_	= _cenX; 	cenY_ = _cenY;	cenZ_ = _cenZ;
		};
		void setPara(int _gsX,int _gsY,int _gsZ,TIn _delX,TIn _delY, TIn _delZ,TIn _cenX,TIn _cenY,TIn _cenZ )
		{
			dimX_ = _gsX; 	dimY_ = _gsY;		dimZ_ = _gsZ;		
			delX_	= _delX;	delY_	= _delY;	delZ_	= _delZ;
			cenX_	= _cenX; 	cenY_ = _cenY;	cenZ_ = _cenZ;
		};

		void setOrd(int _ord){ord_=_ord; };
		
		void getPara(int& _gs, TIn& _del, TIn& _cenX, TIn& _cenY, TIn& _cenZ )
		{
			if(dimX_ == dimY_ && dimX_ == dimZ_)
				_gs 	= dimX_; 	
			else{
				cout << "dim miss match error\n";
				exit(-1);
			}
			if(delX_ == delY_ && delX_ == delZ_)
				_del 	= delX_; 	
			else{
				cout << "del miss match error\n";
				exit(-1);
			}
			_cenX	= cenX_; 	_cenY = cenY_;	_cenZ = cenZ_;
		};
		
		void getPara(int &_gsX,int &_gsY,int &_gsZ,TIn &_delX,TIn &_delY, TIn &_delZ, TIn& _cenX, TIn& _cenY, TIn& _cenZ )
		{
			_gsX 	= dimX_; 	_gsY 	= dimY_; 	_gsZ 	= dimZ_; 		
			_delX	= delX_;	_delY	= delY_;	_delZ	= delZ_;
			_cenX	= cenX_; 	_cenY = cenY_;	_cenZ = cenZ_;
		};
		
		void getOrd(int& _ord){_ord=ord_;}
		
		Seed<T,TIn>* getSeed(int _i)
		{
			if(seeds.size() < _i+1){
				cout << "cannot find seed with ind " << _i << endl;			
				return NULL;
			}else{
				return &seeds[_i];
			}
		};
		
		Seed<T,TIn> getSeed2(int _i)
		{
			if(seeds.size() < _i+1){
				cout << "cannot find seed with ind " << _i << endl;
				exit(-1);
			}else{
				return seeds[_i];
			}
		};
	
		int getSeedSize(){return seeds.size();};


		T getPro(int _pro, int _i)
		{
			if(seeds.size() < _i+1){
				return -9999;
			}else{
				return seeds[_i].getPro(_pro);
			}
		};
	
		int getXYZ(TIn &_x, TIn &_y, TIn &_z, int _i)
		{
			if(seeds.size() < _i+1){
				return -9999;
			}else{
				seeds[_i].getXYZ(_x,_y,_z);
				return 1;
			}
		};
	
		int getABC(int &_a, int &_b, int &_c, int _i)
		{
			if(seeds.size() < _i+1){
				return -9999;
			}else{
				seeds[_i].getABC(_a,_b,_c);
				return 1;
			}
		};
	

		
		Seed<T,TIn>* getSeed(int _a, int _b, int _c);
		Seed<T,TIn>* getSeed(TIn _x, TIn _y, TIn _z);
		
		int getSeedIndex(int _a, int _b, int _c);
		int getSeedIndex(TIn _x, TIn _y, TIn _z);
		
		void printSeeds();
		void printSeeds(std::ofstream & _fout);
		void printSeeds(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb);
		void printSeeds(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, ProcessPDB<T,TIn> _lig );
		void printSeeds(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, vector<ATOMStruct> _atoms);
		void printSeeds(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, ProcessPDB<T,TIn> _lig, vector<ATOMStruct> _atoms);
	
		
		int size(){ return seeds.size(); };
	
		VolumeDX<T,TIn> getSeedsDX();
		
		void copySeeds(vector<Seed<T,TIn> > &_seeds );
		void copySeedVec(SeedVec<T,TIn> &_seedVec, int interval=1);
		
		void GenVisHist(float _binSize, float _radius);

		void SelSeedByVis(TIn radius=2.0, int interval=10);
		void SelSeedByInterval(int interval=10);
		void SelSeedByAtm( const char* pdbFile, TIn _dist=2.0); 
		void SelSeedByAtm_from_PQR( const char* pdbFile, TIn _dist=2.0); 

		ProcessPDB<T,TIn>	 InterfaceSeed(const char* pdbFile, TIn _dist, TIn _ldist=4.5);
		void	 InterfaceSeed_bndr_check(TIn x_cntr, TIn y_cntr, TIn z_cntr, TIn _dist, TIn pkt_rad);
		ProcessPDB<T,TIn>	 InterfaceSeedClosest(const char* ligFile, TIn _dist);
	
//		ProcessPDB<T,TIn>	 PocketSeed(const char* ligFile, TIn _dist);


		void TRANSFORMTO(int _i, int _j, int _k, TIn& _a, TIn& _b, TIn& _c)
		{
			_a = (_i - (dimX_ - 1)/2.0)*delX_ + cenX_;
			_b = (_j - (dimY_ - 1)/2.0)*delY_ + cenY_;
			_c = (_k - (dimZ_ - 1)/2.0)*delZ_ + cenZ_;
		};

		void TRANSFORMFROM(TIn _a, TIn _b, TIn _c, TIn& _aa, TIn& _bb, TIn& _cc)
		{
			_aa = (_a - cenX_)/delX_ + (dimX_ - 1)/2.0;
			_bb = (_b - cenY_)/delY_ + (dimY_ - 1)/2.0;
			_cc = (_c - cenZ_)/delZ_ + (dimZ_ - 1)/2.0;
		};

		
		int CHECK_RANGE(int a, int b, int c, int _dim){
			if (a>=0 && a<=_dim && b>=0 && b<=_dim && c>=0 && c<=_dim)
				return 1;
			else
				return 0;
		};
		
		int CHECK_RANGE(int a, int b, int c, int _dimA, int _dimB, int _dimC){
			if (a>=0 && a<=_dimA && b>=0 && b<=_dimB && c>=0 && c<=_dimC)
				return 1;
			else
				return 0;
		};
	
		int IN_RANGE(int a, int b, int c, int i, int j, int k, TIn inter){
			TIn dist = sqrt((TIn)(SQR((TIn)a-(TIn)i)+SQR((TIn)b-(TIn)j)+SQR((TIn)c-(TIn)k)));
			if(dist<inter) return 1;
			else return 0;
		};	
			
		void removeNei(list<Seed<T,TIn> > &mylist, 	map<int, std::_List_iterator<Seed<T, TIn> > > & mymap, int a, int b, int c, int interval);
		int  findflat( list<Seed<T,TIn> > &mylist, int prevPos);
	
	
		void remapSeeds( SurfVec<T,TIn>& _SurfVec );

		void mapDistBtwSeeds( SurfVec<T,TIn>& _SurfVec );


	
};


#include "SeedVec.cpp"

#endif

