template<class T, class TIn>
void Seed<T,TIn>::init()
{
	seedSurf=NULL;
	for(int i=0; i<PROSIZE;i++){
//		if(proInvs[i] != NULL)
//			delete [] proInvs[i];
		proInvs[i]=NULL;	
	}
	
//	if(visHist != NULL)
//		delete [] visHist;
	visHist=NULL;	
		
	cAtom = NULL;
	cRes 	= NULL;
	ligAName = NULL;
	ex=ey=ez=0;
	sel 	= false;
}

template<class T, class TIn>
void Seed<T,TIn>::printSeed()
{
	cout << "EXYZ: " << ex << " " << ey << " " << ez << endl;
	seedSurf->printSurf();		
	cout << "ProInvs: " << endl;
		
	for(int i=0; i<PROSIZE; i++){
		if(proInvs[i]!=NULL){
			cout << "\t" << i << " " << proInvs[i][0] << " ";
			for(int j=1; j<=proInvs[i][0]; j++){
				cout << proInvs[i][j] << " " ;
			}
			cout << endl;
		}
	}

	cout << "DbtwSeeds: " <<endl;
	cout << DbtwSeed[0] << " ";
	for ( int k = 1; k <= (int)DbtwSeed[0]; k++ )
	{
		cout << DbtwSeed[k] << " ";
	}
	cout <<endl;

	if(visHist!=NULL){
		cout << "visHist: " ;
		for(int j=1; j<=visHist[0]; j++){
			cout << visHist[j] << " " ;		
		}
	}
	cout << endl;
	
	cout << "cAtom: ";
	if(cAtom!=NULL){
		for(int i = 1; i <= cAtom[0]; i++){
			cout << cAtom[i] << " ";
		}
	}
	cout << endl;

	cout << "cRes: ";
	if(cRes!=NULL){
		for(int i = 1; i <= cRes[0]; i++){
			cout << cRes[i] << " ";
		}
	}
	cout << endl;
	
	cout << "ligAName: ";
	if(ligAName !=NULL){
		cout << ligAName << endl;
	}

}

template<class T, class TIn>
void Seed<T,TIn>::printSeed(std::ofstream &_fout)
{
	if(_fout.is_open()){
		_fout << "EXYZ: " << ex << " " << ey << " " << ez << endl;
		seedSurf->printSurf(_fout);		
		_fout << "ProInvs: ";
		int count = 0;
		for(int i=0; i<PROSIZE; i++){
			if(proInvs[i]!=NULL){count++;}
		}
		_fout << count << endl;

		for(int i=0; i<PROSIZE; i++){
			if(proInvs[i]!=NULL){
				_fout << "\t" << i << " " << proInvs[i][0] << " ";
				for(int j=1; j<=proInvs[i][0]; j++){
					_fout << proInvs[i][j] << " " ;
				}
				_fout << endl;
			}
		}
		
		_fout << "DbtwSeeds: " <<endl;
		_fout << DbtwSeed[0] << " ";
		for ( int k = 1; k <= (int)DbtwSeed[0]; k++ )
		{
			_fout << DbtwSeed[k] << " ";
		}
		_fout <<endl;

		_fout << "HBDA: " << nHBD << " " << nHBA <<endl;
		_fout << "nAROM: " << nAROM <<endl;
		_fout << "visHist: " ;
		if(visHist!=NULL){
			for(int j=1; j<=visHist[0]; j++){
				_fout << visHist[j] << " " ;		
			}
		}
		_fout << endl;

	}

}


template<class T, class TIn>
void Seed<T,TIn>::printSeed(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb)
{
	printSeed(_fout);
	if(_fout.is_open())
	{
		_fout << "cAtom: ";
		if(cAtom!=NULL){
			_fout << cAtom[0] << endl;
			for(int i = 1; i <= cAtom[0]; i++){
				_fout <<  (_pdb.atmIDmap_[cAtom[i]]).chain << " " 
						<< (_pdb.atmIDmap_[cAtom[i]]).rSN << " " 
						<< (_pdb.atmIDmap_[cAtom[i]]).AA  << " " 
						<< cAtom[i] <<  " " 
				      << (_pdb.atmIDmap_[cAtom[i]]).aName << endl;
			}
		}else{ _fout << "0\n"; }

		_fout << "cRes: ";
		if(cRes!=NULL){
			_fout << cRes[0] << endl;
			for(int i = 1; i <= cRes[0]; i++){
				_fout << (_pdb.resIDmap_[cRes[i]]).chain << " " 
							<< cRes[i] << " "
							<< (_pdb.resIDmap_[cRes[i]]).AA << endl;
			}
		}else{ _fout << "0\n"; } 
	
	}
}


template<class T, class TIn>
void Seed<T,TIn>::printSeed(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, ProcessPDB<T,TIn> _lig)
{

	if(_fout.is_open())
	{
		printSeed(_fout, _pdb);
		
		_fout << "ligAtom: ";
		if(ligAName!=NULL)	{
			_fout << ligAName[0] << endl;
			for(int i = 1; i <= ligAName[0]; i++){
				_fout <<  (_lig.hetatmIDmap_[ligAName[i]]).chain  
						<< " "<< (_lig.hetatmIDmap_[ligAName[i]]).rSN 
						<< " "<< (_lig.hetatmIDmap_[ligAName[i]]).AA
						<< " " << ligAName[i]
						<< " " << (_lig.hetatmIDmap_[ligAName[i]]).aName << endl;
//				_fout << (_lig.hetatmIDmap_[ligAName[i]]).aName << " ";

			}
//			_fout << endl;
		}else								{
			_fout << "0\n"; 
		}

	}
}

template<class T, class TIn>
void Seed<T,TIn>::printSeed(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, vector<ATOMStruct> _atoms)
{
	printSeed(_fout);
	if(_fout.is_open())
	{
		_fout << "cAtom: ";
		if(cAtom!=NULL){
			_fout << cAtom[0] << endl;
			for(int i = 1; i <= cAtom[0]; i++){
				_fout <<  (_atoms[cAtom[i]]).chain << " " 
						<< (_atoms[cAtom[i]]).rSN << " " 
						<< (_atoms[cAtom[i]]).AA  << " " 
						<< cAtom[i] <<  " " 
				      << (_atoms[cAtom[i]]).aName << " "
				      << (_atoms[cAtom[i]]).hbond << endl;
			}
		}else{ _fout << "0\n"; }

		_fout << "cRes: ";
		if(cRes!=NULL){
			_fout << cRes[0] << endl;
			for(int i = 1; i <= cRes[0]; i++){
				_fout << (_pdb.resIDmap_[cRes[i]]).chain << " " 
							<< cRes[i] << " "
							<< (_pdb.resIDmap_[cRes[i]]).AA << endl;
			}
		}else{ _fout << "0\n"; } 
	
	}
}


template<class T, class TIn>
void Seed<T,TIn>::printSeed(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, ProcessPDB<T,TIn> _lig, vector<ATOMStruct> _atoms)
{

	if(_fout.is_open())
	{
	  printSeed(_fout, _pdb, _atoms);
		
		_fout << "ligAtom: ";
		if(ligAName!=NULL)	{
			_fout << ligAName[0] << endl;
			for(int i = 1; i <= ligAName[0]; i++){
				_fout <<  (_lig.hetatmIDmap_[ligAName[i]]).chain  
						<< " "<< (_lig.hetatmIDmap_[ligAName[i]]).rSN 
						<< " "<< (_lig.hetatmIDmap_[ligAName[i]]).AA
						<< " " << ligAName[i]
						<< " " << (_lig.hetatmIDmap_[ligAName[i]]).aName << endl;
//				_fout << (_lig.hetatmIDmap_[ligAName[i]]).aName << " ";

			}
//			_fout << endl;
		}else								{
			_fout << "0\n"; 
		}

	}
}
template<class T, class TIn>
void Seed<T,TIn>::setInv(vector<float> &_inv, int _i)
{
	if(_i>=PROSIZE){
		cout << "index out of range in setInv: " << _i<< endl;
		exit(-1);
	}else{
		proInvs[_i] = new float [(int)(_inv[3])+1];
		proInvs[_i][0] = _inv[3];
		for(int i=4; i<_inv[3]+4; i++){
			proInvs[_i][i-3] = _inv[i];
		}
	}
}

template<class T, class TIn>
void Seed<T,TIn>::setDbtwSeed(map<int, float> &_Dseeds)
{
	int size = _Dseeds.size();
	DbtwSeed = new float [size+1];
	DbtwSeed[0] = (float)size;
	for ( int i = 0; i < size; i++ )
	{
		DbtwSeed[i+1] = _Dseeds[i];
	}
}


template<class T, class TIn>
void Seed<T,TIn>::setcAcR(vector<int> &_catom, vector<int> &_cres )
{
		
		if(_catom.size() != 0){
			cAtom = new int [_catom.size()+1];
			cAtom[0] = _catom.size();
			for(int i=0; i<_catom.size(); i++){
				cAtom[i+1] = _catom[i];
			}
		}
		
		if(_cres.size()!=0){
			cRes = new int [_cres.size()+1];
			cRes[0] = _cres.size();
			for(int i=0; i<_cres.size(); i++){
				cRes[i+1] = _cres[i];
			}
		}
}

template<class T, class TIn>
void Seed<T,TIn>::setLig(vector<int> &_aligIn)
{
		if(_aligIn.size() !=0 ){
			ligAName = new int [_aligIn.size()+1];
			ligAName[0] = _aligIn.size();
			for(int i = 0; i < _aligIn.size(); i++){
					ligAName[i+1] = _aligIn[i];
			}
		}
}


template<class T, class TIn>
void Seed<T,TIn>::setLig(vector<char> &_aName)
{
		ligAName = new char [_aName.size()+1];
		for(int i = 0; i < _aName.size(); i++){
				cout << _aName[i];
				ligAName[i] = _aName[i];
		}
		ligAName[_aName.size()] = '\0';
}

template<class T, class TIn>		
void SeedVec<T,TIn>::mapSeedABC()
{
#ifdef DEBUG
	cout << "start mapping seed to ABC" << endl;
#endif
	mapABC.clear();
	for(int i=0; i<seeds.size(); i++)
	{
		int _a, _b, _c;
		seeds[i].getABC(_a,_b,_c);
		mapABC[INDEX2(_a,_b,_c,dimX_,dimY_,dimZ_)] = i;	
	}

#ifdef DEBUG
	cout << "finish mapping surface to ABC" << endl;
#endif
	
}

template<class T, class TIn>		
void SeedVec<T,TIn>::mapSeedXYZ()
{
#ifdef DEBUG
	cout << "start mapping surface to ABC" << endl;
#endif
	mapXYZ.clear();
	for(int i=0; i<seeds.size(); i++)
	{
		TIn _x, _y, _z;
		seeds[i].getXYZ(_x,_y,_z);
		mapXYZ[INDEX2(_x,_y,_z,(T)dimX_,(T)dimY_,(T)dimZ_)] = i;	
	}

#ifdef DEBUG
	cout << "finish mapping surface to ABC" << endl;
#endif
	
}
		
template<class T, class TIn>		
Seed<T,TIn>* SeedVec<T,TIn>::getSeed(int _a, int _b, int _c)
{
	if(mapABC.size() == 0){mapSeedABC();}
	map<int,int>::iterator it;
	it=mapABC.find(INDEX2(_a,_b,_c,dimX_,dimY_,dimZ_));
	if(it!=mapABC.end()){
		return &(seeds[(*it).second]);	
	}else{
		return NULL;
	}
}

template<class T, class TIn>		
Seed<T,TIn>* SeedVec<T,TIn>::getSeed(TIn _x, TIn _y, TIn _z)
{
	if(mapXYZ.size() == 0){mapSeedXYZ();}
	map<int,int>::iterator it;
	it=mapXYZ.find(INDEX2(_x,_y,_z,(T)dimX_,(T)dimY_,(T)dimZ_));
	if(it!=mapXYZ.end()){
		return &(seeds[(*it).second]);	
	}else{
		return NULL;
	}

}


template<class T, class TIn>		
int SeedVec<T,TIn>::getSeedIndex(int _a, int _b, int _c)
{
	if(mapABC.size() == 0){mapSeedABC();}
	map<int,int>::iterator it;
	it=mapABC.find(INDEX2(_a,_b,_c,dimX_,dimY_,dimZ_));
	if(it!=mapABC.end()){
		return	(*it).second;	
	}else{
		return -1;
	}
}

template<class T, class TIn>		
int SeedVec<T,TIn>::getSeedIndex(TIn _x, TIn _y, TIn _z)
{
	if(mapXYZ.size() == 0){mapSeedXYZ();}
	map<int,int>::iterator it;
	it=mapXYZ.find(INDEX2(_x,_y,_z,(T)dimX_,(T)dimY_,(T)dimZ_));
	if(it!=mapXYZ.end()){
		return (*it).second;	
	}else{
		return -1;
	}

}

template<class T, class TIn>
void SeedVec<T,TIn>::printSeeds(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, ProcessPDB<T,TIn> _lig )	
{
	if(_fout.is_open()){
		_fout << "Printing Seeds : " << seeds.size()<< endl;
		_fout << "dim " << dimX_ << " " << dimY_ << " " << dimZ_
		<< " del " << delX_ << " " << " " << delY_ << " "<< delZ_
			<< " CenX " << cenX_ <<  " CenY " << cenY_ << " CenZ " << cenZ_ << endl;
		if(seeds.size()>0){
			for(int i=0; i<seeds.size(); i++){
				_fout << "SeedNum: " << i << endl;
				seeds[i].printSeed(_fout, _pdb, _lig);
			}
		}
	}
}


template<class T, class TIn>
void SeedVec<T,TIn>::printSeeds(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb)	
{
	if(_fout.is_open()){
		_fout << "Printing Seeds : " << seeds.size()<< endl;
		_fout << "dim " << dimX_ << " " << dimY_ << " " << dimZ_
		<< " del " << delX_ << " " << " " << delY_ << " "<< delZ_
			<< " CenX " << cenX_ <<  " CenY " << cenY_ << " CenZ " << cenZ_ << endl;
		if(seeds.size()>0){
			for(int i=0; i<seeds.size(); i++){
				_fout << "SeedNum: " << i << endl;
				seeds[i].printSeed(_fout, _pdb);
			}
		}
	}
}

template<class T, class TIn>
void SeedVec<T,TIn>::printSeeds(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, ProcessPDB<T,TIn> _lig, vector<ATOMStruct> _atoms)	
{
	if(_fout.is_open()){
		_fout << "Printing Seeds : " << seeds.size()<< endl;
		_fout << "dim " << dimX_ << " " << dimY_ << " " << dimZ_
		<< " del " << delX_ << " " << " " << delY_ << " "<< delZ_
			<< " CenX " << cenX_ <<  " CenY " << cenY_ << " CenZ " << cenZ_ << endl;
		if(seeds.size()>0){
			for(int i=0; i<seeds.size(); i++){
				_fout << "SeedNum: " << i << endl;
				seeds[i].printSeed(_fout, _pdb, _lig, _atoms);
			}
		}
	}
}


template<class T, class TIn>
void SeedVec<T,TIn>::printSeeds(std::ofstream &_fout, ProcessPDB<T,TIn> _pdb, vector<ATOMStruct> _atoms)	
{
	if(_fout.is_open()){
		_fout << "Printing Seeds : " << seeds.size()<< endl;
		_fout << "dim " << dimX_ << " " << dimY_ << " " << dimZ_
		<< " del " << delX_ << " " << " " << delY_ << " "<< delZ_
			<< " CenX " << cenX_ <<  " CenY " << cenY_ << " CenZ " << cenZ_ << endl;
		if(seeds.size()>0){
			for(int i=0; i<seeds.size(); i++){
				_fout << "SeedNum: " << i << endl;
				seeds[i].printSeed(_fout, _pdb, _atoms);
			}
		}
	}
}

template<class T, class TIn>
void SeedVec<T,TIn>::printSeeds(std::ofstream &_fout)	
{
	if(_fout.is_open()){
		_fout << "Printing Seeds : " << seeds.size()<< endl;
		_fout << "dim " << dimX_ << " " << dimY_ << " " << dimZ_
		<< " del " << delX_ << " " << " " << delY_ <<" "<< delZ_
			<< " CenX " << cenX_ <<  " CenY " << cenY_ << " CenZ " << cenZ_ << endl;
		if(seeds.size()>0){
			for(int i=0; i<seeds.size(); i++){
				_fout << "SeedNum: " << i << endl;
				seeds[i].printSeed(_fout);
			}
		}
	}
}


template<class T, class TIn>
void SeedVec<T,TIn>::printSeeds()	
{
	cout << "Printing Seeds : " << seeds.size()<< endl;
	cout << "dim " << dimX_ << " " << dimY_ << " " << dimZ_
	<< " del " << delX_ << " " << " " << delY_ << delZ_
		<< " CenX " << cenX_ <<  " CenY " << cenY_ << " CenZ " << cenZ_ << endl;
	if(seeds.size()>0){
		for(int i=0; i<seeds.size(); i++){
			cout << "SeedNum: " << i << endl;
			seeds[i].printSeed();
		}
	}
}



template<class T, class TIn>
VolumeDX<T,TIn> SeedVec<T,TIn>::getSeedsDX()
{
	VolumeDX<T,TIn> tmpDX;
	tmpDX.setPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_,cenX_, cenY_, cenZ_);
	
	T* _grid = new T[dimX_*dimY_*dimZ_];	
	for(int i=0;i<dimX_*dimY_*dimZ_; i++)
	{
		_grid[i] = 0;
	}
	
	for(int i=0; i<seeds.size(); i++)
	{
		int a, b, c;
		(seeds[i].getSurf())->getABC(a,b,c);
		_grid[INDEX2(a,b,c, dimX_,dimY_, dimZ_)] = 1;
	}
	
	tmpDX.setGrid(_grid);

	return tmpDX;
}

template<class T, class TIn>
void SeedVec<T,TIn>::copySeeds(vector<Seed<T,TIn> > &_seeds )
{
	_seeds.clear();
	for(int i=0;i<seeds.size(); i++)
	{
		_seeds.push_back(seeds[i]);
	}
}

template<class T, class TIn>
void SeedVec<T,TIn>::copySeedVec(SeedVec<T,TIn> &_seedVec, int interval)
{	
	_seedVec.init();
	_seedVec.setPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	
	_seedVec.reserveSeeds((int)(ceil(seeds.size()/interval)));
	int num = 0;
	if(seeds.size()>0)
	{
		for(int i=0; i< seeds.size(); i++)
		{
			if(num%interval == 0){
				_seedVec.pushSeed(seeds[i]);
			}
			num++; 
		}
	}
	
}

	
template<class T, class TIn>
bool compVIS(Seed<T,TIn> _s1, Seed<T,TIn> _s2)
{
	if (_s1.getPro(VIS)<_s2.getPro(VIS)) return true;
	else return false;
}

/*
template<class T, class TIn>
void SeedVec<T,TIn>::removeNei(list<Seed<T,TIn> > &mylist, 	map<int, std::_List_iterator<Seed<T, TIn> > > & mymap, int a, int b, int c, int interval)
{
		for(int i=-1*interval; i<=interval; i++)
		{
			for(int j=-1*interval; j<=interval; j++)
			{
				for(int k=-1*interval; k<=interval; k++)
				{
					
					if(CHECK_RANGE(a+i, b+i, c+k, dim_)){
						int idx = getSeedIndex(a+i,b+j,c+k);
						if(idx>0 && mymap.find(idx)!= mymap.end())
						{ 
							mylist.erase(mymap[idx]);
							mymap.erase(idx);
						}
					}
					
				}
			}
		}
}	
*/
template<class T, class TIn>
void SeedVec<T,TIn>::removeNei(list<Seed<T,TIn> > &mylist, 	map<int, std::_List_iterator<Seed<T, TIn> > > & mymap, int a, int b, int c, int interval)
{
		vector<vector<int> > Nei;
		vector<int> tempLocal;
		tempLocal.resize( CUBIC(2*interval+1), 0 );

		vector<int> tmpV;
		tmpV.resize(3);
		tmpV[0] = a; tmpV[1] = b; tmpV[2] = c;
		Nei.push_back(tmpV);
		
		while( Nei.size() > 0 ) {
		
			int i = tmpV[0] = Nei[Nei.size()-1][0];
			int j = tmpV[1] = Nei[Nei.size()-1][1];
			int k = tmpV[2] = Nei[Nei.size()-1][2];
			Nei.pop_back();
			
			int idx = getSeedIndex(i,j,k);
		  if(mymap.find(idx)!= mymap.end())
			{
				mylist.erase(mymap[idx]);
				mymap.erase(idx);
			}
			
			for(int x=-1; x<=1; x++){
				for(int y=-1; y<=1; y++){
					for(int z=-1; z<=1; z++){

						if(CHECK_RANGE(i+x, j+y, k+z, dimX_,dimY_,dimZ_)){
							{
								int idx = getSeedIndex(i+x,j+y,k+z);
								int tmpIndex = INDEX1( i+x-a+interval+1, j+y-b+interval+1, k+z-c+interval+1, 2*interval+1 );
							if(idx>0 && IN_RANGE(a,b,c,i+x,j+y,k+z, interval) 
										&& tempLocal[tmpIndex] == 0 )
								{ 
									vector<int> tmp;
									tmp.resize(3);
									tmp[0]=i+x; tmp[1]=j+y; tmp[2]=k+z;
									Nei.push_back(tmp);	
									tempLocal[tmpIndex] = 1; 
								}
							}
				
						}
					}
				}

			}

		}

}

template<class T, class TIn>
void SeedVec<T,TIn>::remapSeeds( SurfVec<T,TIn> &_surfVec )
{
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds( _surfVec.size() );
	_seedVec.setPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	_seedVec.setOrd(ord_);
	
	map<int,int> Tabc;
	
	int count=0;	
	for(int i=0; i<_surfVec.size(); i++)
	{
		int a,b,c;
		(_surfVec.getSurf(i))->getABC(a,b,c);
		int idx=INDEX2(a,b,c,dimX_,dimY_,dimZ_);
		Seed<T,TIn>* _seed = getSeed(a,b,c);
		if(Tabc.find(idx)==Tabc.end() && _seed != NULL)
		{
			Surf<T,TIn>* tsurf = _surfVec.getSurf(a,b,c);
			if(tsurf != NULL)
			{
				Seed<T,TIn> tseed = getSeed2(getSeedIndex(a,b,c));
				tseed.setSurf(tsurf);
				tseed.setSeedIndex(count); 
				_seedVec.pushSeed(tseed);
				Tabc[idx] = count++;
			}
		}
	}

#ifdef DEBUG	
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif

	_seedVec.copySeeds(seeds); 

#ifdef DEBUG	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	mapSeedABC();
	mapSeedXYZ();
	
	return;

}


template<class T, class TIn>
int SeedVec<T,TIn>::findflat(list<Seed<T,TIn> > &mylist, int prevPos)
{
//	if(prevPos < 0) return -1;
	std::_List_iterator<Seed<T, TIn> > it = mylist.begin();
	float minVal = 9999999;
	int range;
	if(mylist.size()/100 < 100 || prevPos==0 ){range = mylist.size()/2;}
	else{range = mylist.size()/100; }
	int minPos = prevPos-range;
	int maxPos = prevPos+range;
	if(maxPos > mylist.size() || prevPos == 0){maxPos = mylist.size();}
	if(minPos < 0 || minPos >= maxPos ){minPos = 0;}
	advance(it, minPos);
	for(int i=minPos; i<maxPos; i++, advance(it,1))
	{
		float newVal = fabs((*it).getPro(VIS)-0.5);
		if( minVal > newVal)
		{
			minVal = newVal;
			minPos = i;
			if(newVal == 0) break;
		}
	}
	
//	if(minVal < 0.1)
		return minPos;
//	else
//		return -1;
}


template<class T, class TIn>
void SeedVec<T,TIn>::GenVisHist(float _binSize, float _radius)
{
	// parameters
	int hisSize = ROUND(1.0/_binSize);
	int _rad    = ROUND(_radius/((delX_+delY_+delZ_)/3.0));
	// for each of the Seed points
	for(int i=0; i<seeds.size(); i++){
		int a,b,c;
		(getSeed(i))->getABC(a,b,c);
		// find visibility values with around neibors within _radius
		float* visVal = new float [hisSize+1];
		for(int j=1; j<=hisSize; j++){ visVal[j] = 0; }
		visVal[0] = hisSize;
		int count = 0;
		for(int x=-1*_rad; x<=_rad; x++){
			for(int y=-1*_rad; y<=_rad; y++){
				for(int z=-1*_rad; z<=_rad; z++){
					if(CHECK_RANGE(a+x, b+y, c+z, dimX_,dimY_,dimZ_))
					{
						int idx = getSeedIndex(a+x,b+y,c+z);
						if(idx>0 && IN_RANGE(a,b,c,a+x,b+y,c+z, _rad))
						{ 
							int tv=(int)floor((getSeed(idx))->getPro(VIS)*hisSize)+1;
							if (tv>0 && tv<hisSize+1)visVal[tv]++;
							count++;
						}
					}
				
				}
			}
		}
		
		for(int j=1; j<=hisSize; j++){ visVal[j]/count; }
		
		(getSeed(i))->setVisHist(visVal); 		
	}
}


// select(filter out) Seed point using Visibility as criterion
// need Visibility already calculated.
template<class T, class TIn>
void SeedVec<T,TIn>::SelSeedByVis(TIn _radius, int interval)
{
	// check if visibility is calculated
	if(seeds.size()<1)	{
		cout << "seed size is too small : " << seeds.size() << endl;
		exit(-1);
	}else if(seeds[0].getPro(VIS)==0 )	{
		cout << "Visibility need too be calculated first\n";
		exit(-1);
	}
	
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds((int)(ceil(seeds.size()/interval)));
	_seedVec.setPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	_seedVec.setOrd(ord_);

	// make copy of seedVec as list
	// and map for easy access
	list<Seed<T,TIn> > mylist;
	
	map<int, std::_List_iterator<Seed<T, TIn> > > mymap;	
	
	for(int i=0; i<seeds.size();i++)
	{
		mylist.push_back(seeds[i]);
		mymap[i]=(--(mylist.end()));
	}
	
	// sort Seed by visibility low -> high
	mylist.sort((bool(*)(Seed<T,TIn>, Seed<T,TIn>))(compVIS));	
	
	cout << "MYLIST" <<mylist.size() << endl;
	// if remove seed with visibility > 0.90 (barried)
	while((mylist.back()).getPro(VIS)>0.90)
	{
			int a,b,c;
			(mylist.back()).getABC(a,b,c);
			int idx = getSeedIndex(a,b,c);
			if(idx>0 && mymap.find(idx)!= mymap.end())
			{ 
				mylist.erase(mymap[idx]);
				mymap.erase(idx);
			}
	}
		cout << "MYLIST" <<mylist.size() << endl;

	int count = 0;
	// significant visibility max mid min
	int prevPos = findflat(mylist, 0);
	while(mylist.size()>interval+1)
	{
		int a,b,c;
		if(count % 3 == 0){
			// min && not close by ("interval" voxel away?)
			_seedVec.pushSeed(mylist.front());
			(mylist.front()).getABC(a,b,c);
		}else if(count % 3 == 1){
			// max && not close by ("interval" voxel away?)
			// need to remove completely covered ones
			_seedVec.pushSeed(mylist.back());
			(mylist.back()).getABC(a,b,c);
		}else{
			// flat && not close by ("interval" voxel away?)
			std::_List_iterator<Seed<T, TIn> > it = mylist.begin();
			prevPos = findflat(mylist, prevPos);
			if(prevPos>0){
				advance(it,prevPos);
				_seedVec.pushSeed(*it);
				(*it).getABC(a,b,c);
			}
		}
		removeNei(mylist, mymap, a,b,c, interval);
		count++;
	}
	
	// sort Seed by visibility low -> high
	//mylist.sort((bool(*)(Seed<T,TIn>, Seed<T,TIn>))(compVIS));	

	// initialize backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(-1);		
	}
	// reset the seed vec
#ifdef DEBUG	
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif
	
	_seedVec.copySeeds(seeds); 
	
#ifdef DEBUG	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(i);		
	}

	mapSeedABC();
	mapSeedXYZ();

	
	_seedVec.clear();
	mylist.clear();
	mymap.clear();
}


// select(filter out) Seed point using Visibility as criterion
// need Visibility already calculated.
template<class T, class TIn>
void SeedVec<T,TIn>::SelSeedByInterval(int interval)
{
	if(seeds.size()<1)	{
		cout << "seed size is too small : " << seeds.size() << endl;
		exit(-1);
	}
	
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds((int)(ceil(seeds.size()/interval)));
	_seedVec.setPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	_seedVec.setOrd(ord_);

	// make copy of seedVec as list
	// and map for easy access
	list<Seed<T,TIn> > mylist;
	
	map<int, std::_List_iterator<Seed<T, TIn> > > mymap;	
	
	for(int i=0; i<seeds.size();i++)
	{
		mylist.push_back(seeds[i]);
		mymap[i]=(--(mylist.end()));
	}

	while(mylist.size()>interval+1)
	{
		int a,b,c;
		// min && not close by ("interval" voxel away?)
		_seedVec.pushSeed(mylist.front());
		(mylist.front()).getABC(a,b,c);
		removeNei(mylist, mymap, a,b,c, interval);
		//_seedVec.pushSeed(mylist.back());
		//(mylist.back()).getABC(a,b,c);
		//removeNei(mylist, mymap, a,b,c, interval);
	}
	
	// initialize backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(-1);		
	}
	// reset the seed vec
#ifdef DEBUG	
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif
	
	_seedVec.copySeeds(seeds); 
	
#ifdef DEBUG	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(i);		
	}

	mapSeedABC();
	mapSeedXYZ();

	_seedVec.clear();
	
	mylist.clear();
	mymap.clear();
}



// select seed point by surface atms in pdbFile
template<class T, class TIn>
void SeedVec<T,TIn>::SelSeedByAtm(const char* pdbFile, TIn _dist)
{
	if(seeds.size()<1)	{
		cout << "seed size is too small : " << seeds.size() << endl;
		exit(-1);
	}
	
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	vector<ATOMStruct> SurfAtm = ppdb.getATOM(); 
	
	// tmp seed
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds((int)(ceil(SurfAtm.size())));
	_seedVec.setPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	_seedVec.setOrd(ord_);

// remove atoms C and H 
	if(0){
		for(int i=0;i<SurfAtm.size();i++)
		{
		  //	  if(SurfAtm[i].aName[0]=='C' || SurfAtm[i].aName[0]=='H' )
		  if(SurfAtm[i].aName[0]=='H' ) // for test: W. -H.
			{	
				SurfAtm.erase(SurfAtm.begin()+i);
				i--;
			}
		}
	}
	
	// make copy of seedVec as list
	// and map for easy access
	list<Seed<T,TIn> > mylist;
	
	map<int, std::_List_iterator<Seed<T, TIn> > > mymap;	
	
	for(int i=0; i<seeds.size();i++)
	{
		mylist.push_back(seeds[i]);
		mymap[i]=(--(mylist.end()));
	}

	// pop out non-surface atoms (within threshold dist to any seed)
	// select min dist seed to selected atm
	int interval = (int)ROUND(_dist/delX_); 
	int range = (int)ROUND(3.5/delX_);			// surface distance range 2A
	vector<TIn> tmp; tmp.push_back(-1); tmp.push_back(_dist);
	vector< vector<TIn> > tselAtm(SurfAtm.size(), tmp ); 
	for(int j=0; j < SurfAtm.size(); j++)
	{
		TIn minDist = 9999; int tJ = -1;
		TIn aa,bb,cc;
		TRANSFORMFROM( SurfAtm[j].x, SurfAtm[j].y, SurfAtm[j].z, aa, bb, cc);	
		for(int x=-1*range; x<range; x++ ){
			for(int y=-1*range; y<range; y++ ){
				for(int z=-1*range; z<range; z++ ){
					int idx = getSeedIndex((int)aa+x, (int)bb+y, (int)cc+z);
					if(mymap.find(idx)!=mymap.end())
					{
						TIn tDist = (getSeed(idx))->getDist(SurfAtm[j].x, SurfAtm[j].y, SurfAtm[j].z); 
						if(tDist < minDist){ minDist = tDist; tJ = idx;}
					}
				}
			}
		}
		if( minDist < range && tJ >= 0)
		{
			tselAtm[j][1]=minDist;
			tselAtm[j][0]= tJ;
			_seedVec.pushSeed(getSeed2(tJ));
			int a,b,c;
			(getSeed(tJ))->getABC(a,b,c);
			removeNei(mylist, mymap, a,b,c, interval);
		}
	}

	
#ifdef DEBUG_SEED	
	cout << "\nselect Surface atoms: Atoms size reduced from " << SurfAtm.size(); 
#endif	

#ifdef DEBUG_SEED
	
	for(int i=0; i < SurfAtm.size(); i++)
	{
		int indx = (int)(tselAtm[i][0]);
		if(indx==-1)
		{	
			SurfAtm.erase(SurfAtm.begin()+i);
			tselAtm.erase(tselAtm.begin()+i);
			i--;
		}
	}

	cout << " to " << SurfAtm.size() << endl; 
	char buff[200];
	char* ch_ptr = strrchr(pdbFile, '.');
	char* surfpdbF;
	if (ch_ptr)
	{
		strncpy (buff, pdbFile, ch_ptr - pdbFile); 
		buff[ch_ptr - pdbFile] = '\0';
	}else{
		strcpy(buff, pdbFile);
	}
	surfpdbF = buff;
	strcat (surfpdbF, "_surf.pdb");   
	cout << "output surface pdb file " << surfpdbF << endl;
	FILE *pFile;
	pFile = fopen(surfpdbF, "w");
	for(int i=0; i<SurfAtm.size();i++)
	{
		SurfAtm[i].ATOMprint(pFile);
	}

#endif

	// initialize backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(-1);		
	}
	
	// reset the seed vec
#ifdef DEBUG_SEED
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif

	_seedVec.copySeeds(seeds); 

#ifdef DEBUG_SEED	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(i);		
	}

	mapSeedABC();
	mapSeedXYZ();

	_seedVec.clear();
	
}

// select seed point by surface atms in PQR File: W. -H. Shin 9/5/2014
template<class T, class TIn>
void SeedVec<T,TIn>::SelSeedByAtm_from_PQR(const char* pqrFile, TIn _dist)
{
	if(seeds.size()<1)	{
		cout << "seed size is too small : " << seeds.size() << endl;
		exit(-1);
	}
	
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPQR_detail(pqrFile);
	vector<ATOMStruct> SurfAtm = ppdb.getATOM(); 
	
	// tmp seed
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds((int)(ceil(SurfAtm.size())));
	_seedVec.setPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	_seedVec.setOrd(ord_);

// remove atoms C and H 
	if(0){
		for(int i=0;i<SurfAtm.size();i++)
		{
		  //	  if(SurfAtm[i].aName[0]=='C' || SurfAtm[i].aName[0]=='H' )
		  if(SurfAtm[i].aName[0]=='H' ) // for test: W. -H.
			{	
				SurfAtm.erase(SurfAtm.begin()+i);
				i--;
			}
		}
	}
	
	// make copy of seedVec as list
	// and map for easy access
	list<Seed<T,TIn> > mylist;
	
	map<int, std::_List_iterator<Seed<T, TIn> > > mymap;	
	
	for(int i=0; i<seeds.size();i++)
	{
		mylist.push_back(seeds[i]);
		mymap[i]=(--(mylist.end()));
	}

	// pop out non-surface atoms (within threshold dist to any seed)
	// select min dist seed to selected atm
	int interval = (int)ROUND(_dist/delX_); 
	int range = (int)ROUND(3.5/delX_);			// surface distance range 2A
	vector<TIn> tmp; tmp.push_back(-1); tmp.push_back(_dist);
	vector< vector<TIn> > tselAtm(SurfAtm.size(), tmp ); 
	for(int j=0; j < SurfAtm.size(); j++)
	{
		TIn minDist = 9999; int tJ = -1;
		TIn aa,bb,cc;
		TRANSFORMFROM( SurfAtm[j].x, SurfAtm[j].y, SurfAtm[j].z, aa, bb, cc);	
		for(int x=-1*range; x<range; x++ ){
			for(int y=-1*range; y<range; y++ ){
				for(int z=-1*range; z<range; z++ ){
					int idx = getSeedIndex((int)aa+x, (int)bb+y, (int)cc+z);
					if(mymap.find(idx)!=mymap.end())
					{
						TIn tDist = (getSeed(idx))->getDist(SurfAtm[j].x, SurfAtm[j].y, SurfAtm[j].z); 
						if(tDist < minDist){ minDist = tDist; tJ = idx;}
					}
				}
			}
		}
		if( minDist < range && tJ >= 0)
		{
			tselAtm[j][1]=minDist;
			tselAtm[j][0]= tJ;
			_seedVec.pushSeed(getSeed2(tJ));
			int a,b,c;
			(getSeed(tJ))->getABC(a,b,c);
			removeNei(mylist, mymap, a,b,c, interval);
		}
	}

	
#ifdef DEBUG_SEED	
	cout << "\nselect Surface atoms: Atoms size reduced from " << SurfAtm.size(); 
#endif	

#ifdef DEBUG_SEED
	
	for(int i=0; i < SurfAtm.size(); i++)
	{
		int indx = (int)(tselAtm[i][0]);
		if(indx==-1)
		{	
			SurfAtm.erase(SurfAtm.begin()+i);
			tselAtm.erase(tselAtm.begin()+i);
			i--;
		}
	}

	cout << " to " << SurfAtm.size() << endl; 
	char buff[200];
	char* ch_ptr = strrchr(pdbFile, '.');
	char* surfpdbF;
	if (ch_ptr)
	{
		strncpy (buff, pdbFile, ch_ptr - pdbFile); 
		buff[ch_ptr - pdbFile] = '\0';
	}else{
		strcpy(buff, pdbFile);
	}
	surfpdbF = buff;
	strcat (surfpdbF, "_surf.pdb");   
	cout << "output surface pdb file " << surfpdbF << endl;
	FILE *pFile;
	pFile = fopen(surfpdbF, "w");
	for(int i=0; i<SurfAtm.size();i++)
	{
		SurfAtm[i].ATOMprint(pFile);
	}

#endif

	// initialize backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(-1);		
	}
	
	// reset the seed vec
#ifdef DEBUG_SEED
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif

	_seedVec.copySeeds(seeds); 

#ifdef DEBUG_SEED	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(i);		
	}

	mapSeedABC();
	mapSeedXYZ();

	_seedVec.clear();
	
}

/*
// select seed point by surface atms in pdbFile
template<class T, class TIn>
void SeedVec<T,TIn>::SelSeedByAtm(const char* pdbFile, TIn _dist)
{
	if(seeds.size()<1)	{
		cout << "seed size is too small : " << seeds.size() << endl;
		exit(-1);
	}
	
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	vector<ATOMStruct> SurfAtm = ppdb.getATOM(); 
	
	// tmp seed
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds((int)(ceil(SurfAtm.size())));
	_seedVec.setPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	_seedVec.setOrd(ord_);

	// make seed approximately 5A away from each other
	int interface = ROUND(5.0/delX_);   

// remove atoms C and H 
	if(0){
		for(int i=0;i<SurfAtm.size();i++)
		{
		if(SurfAtm[i].aName[0]=='C' || SurfAtm[i].aName[0]=='H' )
			{	
				SurfAtm.erase(SurfAtm.begin()+i);
				i--;
			}
		}
	}

	// pop out non-surface atoms (within threshold dist to any seed)
	// select min dist seed to selected atm
	
	vector<TIn> tmp; tmp.push_back(-1); tmp.push_back(_dist);
	vector< vector<TIn> > tselAtm(SurfAtm.size(), tmp ); 
	for(int i=0; i<seeds.size();i+=interface)
	{
		TIn minDist = 9999; int tJ = -1;
		for(int j=0; j < SurfAtm.size(); j++)
		{	
			TIn tDist = seeds[i].getDist(SurfAtm[j].x, SurfAtm[j].y, SurfAtm[j].z); 
			if(tDist < minDist){ minDist = tDist; tJ = j;}
		}			
		if( minDist < _dist && tJ >= 0)
		{
			tselAtm[tJ][1]=minDist;
			tselAtm[tJ][0]=i;
		}
	
	}
	
#ifdef DEBUG_SEED	
	cout << "\nselect Surface atoms: Atoms size reduced from " << SurfAtm.size(); 
#endif	

	for(int i=0; i < SurfAtm.size(); i++)
	{
		int indx = (int)(tselAtm[i][0]);
		if(indx!=-1)
		{
			_seedVec.pushSeed(seeds[indx]);
		}else{	
			SurfAtm.erase(SurfAtm.begin()+i);
			tselAtm.erase(tselAtm.begin()+i);
			i--;
		}
	}

#ifdef DEBUG_SEED
	cout << " to " << SurfAtm.size() << endl; 
	char buff[200];
	char* ch_ptr = strrchr(pdbFile, '.');
	char* surfpdbF;
	if (ch_ptr)
	{
		strncpy (buff, pdbFile, ch_ptr - pdbFile); 
		buff[ch_ptr - pdbFile] = '\0';
	}else{
		strcpy(buff, pdbFile);
	}
	surfpdbF = buff;
	strcat (surfpdbF, "_surf.pdb");   
	cout << "output surface pdb file " << surfpdbF << endl;
	FILE *pFile;
	pFile = fopen(surfpdbF, "w");
	for(int i=0; i<SurfAtm.size();i++)
	{
		SurfAtm[i].ATOMprint(pFile);
	}

#endif

	// initialize backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(-1);		
	}
	// reset the seed vec
#ifdef DEBUG_SEED
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif
	_seedVec.copySeeds(seeds); 
#ifdef DEBUG_SEED	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(i);		
	}

	mapSeedABC();
	mapSeedXYZ();

	_seedVec.clear();
	
}
*/

/*
template<class T, class TIn>
ProcessPDB<T,TIn> SeedVec<T,TIn>::InterfaceSeed(const char* pdbFile, TIn _dist)
{
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	
	vector<ATOMStruct> _atm;
	if(ppdb.ATOMsize()>0){
		_atm = ppdb.getATOM();
	}else if(ppdb.HETATMsize()>0){
		_atm = ppdb.getHETATM();
	}else{
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}
	
//	ppdb.printPDB();
	
	// initialize output SeedVec
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds(seeds.size());
	float _minX, _minY, _minZ, _maxX, _maxY, _maxZ;
	ppdb.getMin(_minX,_minY,_minZ);
	ppdb.getMax(_maxX,_maxY,_maxZ);
	_minX -= _dist; _minY -= _dist; _minZ -= _dist;  
	_maxX += _dist; _maxY += _dist; _maxZ += _dist;

	for(int i=0; i<seeds.size(); i++)
	{
		TIn sx, sy, sz;	
		//	seeds[i].getEXYZ(sx, sy, sz);
		seeds[i].getXYZ(sx, sy, sz);
	//	if( sx > _maxX || sx < _minX || sy > _maxY || sy < _minY || sz >_maxZ || sz < _minZ ){ 
	//		break;
	//	}
		TIn minDist = 99999;
		for(int j=0; j<_atm.size(); j++)
		{
			if(DIST(sx,sy,sz,_atm[j].x, _atm[j].y, _atm[j].z)< minDist)  //_dist)
			{
				minDist = DIST(sx,sy,sz,_atm[j].x, _atm[j].y, _atm[j].z);
	//			_seedVec.pushSeed(seeds[i]);
	//			break;
			}
		}
		if(minDist<_dist){
				_seedVec.pushSeed(seeds[i]);
			// push closest HETATM Atom name (aName) 
				cout << "DIST: " << minDist<< endl;
		}

	}
	
	// initialize backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif
	
	_seedVec.copySeeds(seeds); 
	
#ifdef DEBUG	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSeedABC();
	mapSeedXYZ();
	
	return ppdb;
}
*/

template<class T, class TIn>
ProcessPDB<T,TIn> SeedVec<T,TIn>::InterfaceSeed(const char* pdbFile, TIn _dist, TIn _ldist)
{
	// process pdb file
	ProcessPDB<T,TIn> ppdb;
	ppdb.ReadPDB(pdbFile);
	
	vector<ATOMStruct> _atm;
	vector<int> _selSeed;
	vector<vector< char *> > _selSeedVal1;
	vector<vector<float > > _selSeedVal2;

	if(ppdb.ATOMsize()>0){
		_atm = ppdb.getATOM();
	}else if(ppdb.HETATMsize()>0){
		_atm = ppdb.getHETATM();
	}else{
		cout << "no atom or hetatm found in " << pdbFile << endl;
		exit(-1);
	}
	
//	ppdb.printPDB();
	
	// initialize output SeedVec
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds(seeds.size());
	
	float _minX, _minY, _minZ, _maxX, _maxY, _maxZ;
	ppdb.getMin(_minX,_minY,_minZ);
	ppdb.getMax(_maxX,_maxY,_maxZ);
	_minX -= _dist; _minY -= _dist; _minZ -= _dist;  
	_maxX += _dist; _maxY += _dist; _maxZ += _dist;


	vector<int> selSeedIn;
	for(int i=0; i<seeds.size(); i++)
	{
		TIn sx, sy, sz;	
		//	seeds[i].getEXYZ(sx, sy, sz);
		seeds[i].getXYZ(sx, sy, sz);
		if( sx > _maxX || sx < _minX || sy > _maxY || sy < _minY || sz >_maxZ || sz < _minZ ) 
			continue;
		
		TIn minDist = 99999;
		int minai = 0;
		vector<int> _tIn; 
		_tIn.clear();

		int found = 0; 
		for(int j=0; j<_atm.size(); j++)
		{
			TIn _tdist = DIST(sx,sy,sz,_atm[j].x, _atm[j].y, _atm[j].z);
			if(_tdist < _dist) {	found = 1; }	
			if(_tdist < _ldist){ _tIn.push_back(_atm[j].aSN); }
			if(_tdist < minDist){ minDist = _tdist; minai = _atm[j].aSN; }
		}
		if(found){	
			selSeedIn.push_back(i);
			if(_tIn.size()>0)
			{
				_tIn.insert(_tIn.begin(), 1, minai);
			 	seeds[i].setLig(_tIn);
			}
		}
	}

	for(int i=0; i<selSeedIn.size(); i++)
		_seedVec.pushSeed(seeds[selSeedIn[i]]);

	selSeedIn.clear();

	// initialize backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif
	
	_seedVec.copySeeds(seeds); 
	
#ifdef DEBUG	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSeedABC();
	mapSeedXYZ();
	
	return ppdb;
}

template<class T, class TIn>
void SeedVec<T,TIn>::InterfaceSeed_bndr_check(TIn x_cntr, TIn y_cntr, TIn z_cntr, TIn _dist, TIn pkt_rad)
{
  // Written by W. -H. Shin, Jan. 2017
  // Remove seed located near boundary when the receptor subpocket surface is extracted from 
  // a given sphere center to solve 'Zero Patch' problem

	// initialize output SeedVec
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds(seeds.size());
	
	float _minX, _minY, _minZ, _maxX, _maxY, _maxZ;
	_minX = x_cntr - _dist - pkt_rad;
	_minY = y_cntr - _dist - pkt_rad;
	_minZ = z_cntr - _dist - pkt_rad;  
	_maxX = x_cntr + _dist + pkt_rad;
	_maxY = y_cntr + _dist + pkt_rad;
	_maxZ = z_cntr + _dist + pkt_rad;

	TIn inner_cut = pkt_rad - delX_;
	cout << "cutoff distance: "<< float(inner_cut) << endl;

	vector<int> selSeedIn;
	for(int i=0; i<seeds.size(); i++)
	{
		TIn sx, sy, sz;	
		//	seeds[i].getEXYZ(sx, sy, sz);
		seeds[i].getXYZ(sx, sy, sz);
		if( sx > _maxX || sx < _minX || sy > _maxY || sy < _minY || sz >_maxZ || sz < _minZ ) 
			continue;
		
		TIn minDist = 99999;
		int minai = 0;
		vector<int> _tIn; 
		_tIn.clear();

		int found = 0; 
		TIn _tdist = DIST(sx, sy, sz, x_cntr, y_cntr, z_cntr);
		//			if(_tdist < _dist) {	found = 1; }	
		if(_tdist < inner_cut) {	found = 1; }	
		if(found)
		  {	
			selSeedIn.push_back(i);
		  }
	}

	for(int i=0; i<selSeedIn.size(); i++)
		_seedVec.pushSeed(seeds[selSeedIn[i]]);

	selSeedIn.clear();

	// initialize backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif
	
	_seedVec.copySeeds(seeds); 
	
#ifdef DEBUG	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSeedABC();
	mapSeedXYZ();
	
}


template<class T, class TIn>
ProcessPDB<T,TIn> SeedVec<T,TIn>::InterfaceSeedClosest(const char* ligFile, TIn _dist)
{
	// select the Interface region first 
	ProcessPDB<T,TIn> ppdb = InterfaceSeed(ligFile, _dist);

	// find which of the interface seeds the ligand atoms are closest to
	// output number of seed = min( #InterfaceSeed, #atomsInLig )

	vector<ATOMStruct> _atm;
	vector<int> _selSeed;
	vector<vector< char *> > _selSeedVal1;
	vector<vector<float > > _selSeedVal2;

	if(ppdb.ATOMsize()>0){
		_atm = ppdb.getATOM();
	}else if(ppdb.HETATMsize()>0){
		_atm = ppdb.getHETATM();
	}else{
		cout << "no atom or hetatm found in " << ligFile << endl;
		exit(-1);
	}
	
	ppdb.printPDB();
	
	// initialize output SeedVec
	SeedVec<T,TIn> _seedVec;
	_seedVec.init();
	_seedVec.reserveSeeds(seeds.size());
	
	float _minX, _minY, _minZ, _maxX, _maxY, _maxZ;
	ppdb.getMin(_minX,_minY,_minZ);
	ppdb.getMax(_maxX,_maxY,_maxZ);
	_minX -= _dist; _minY -= _dist; _minZ -= _dist;  
	_maxX += _dist; _maxY += _dist; _maxZ += _dist;


	vector<int> selSeedIn;
	for(int i=0; i<seeds.size(); i++)
	{
		TIn sx, sy, sz;	
		//	seeds[i].getEXYZ(sx, sy, sz);
		seeds[i].getXYZ(sx, sy, sz);
		if( sx > _maxX || sx < _minX || sy > _maxY || sy < _minY || sz >_maxZ || sz < _minZ ) 
			continue;
		
		TIn minDist = 99999;
		int minai = 0;
		vector<int> _tIn; 
		_tIn.clear();

		int found = 0;
		for(int j=0; j<_atm.size(); j++)
		{
			TIn _tdist = DIST(sx,sy,sz,_atm[j].x, _atm[j].y, _atm[j].z);
			if(_tdist < _dist)
			{	
				found = 1;
					if(_tdist < _dist/2.0 || _tdist < 3.5 )
					{
						_tIn.push_back(_atm[j].aSN);
				//		cout << "here dist " << _tdist << " aSN : " << _atm[j].aSN << endl;
			 	//		_atm[j].ATOMprint();
					}
		//			if(_tdist < minDist){
		//				minDist = _tdist;
		//				minai = j;
						//vector<char> tmp;
						//tmp.resize(5,'\0');
						//for(int k=0; k < 5; k++){
						//	tmp[k] = _atm[minai].aName[k];
						//}
						//seeds[i].setLig( tmp );

		//		}
			
			}
		}

		if(found){	
			selSeedIn.push_back(i);
			seeds[i].setLig(_tIn);
		}
	}

	for(int i=0; i<selSeedIn.size(); i++)
		_seedVec.pushSeed(seeds[selSeedIn[i]]);

	selSeedIn.clear();

	// initialize backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(-1);		
	}

// reset the seed vec
#ifdef DEBUG	
	cout << "SEEDSIZE reduced from " << seeds.size() << " ";
#endif
	
	_seedVec.copySeeds(seeds); 
	
#ifdef DEBUG	
	cout << " to  " << seeds.size() << endl;
#endif	
	
	// reset backward indexing
	for(int i=0;i<seeds.size(); i++)
	{
		seeds[i].setSeedIndex(i);		
	}

//	_seedVec.printSeeds();
	
	mapSeedABC();
	mapSeedXYZ();
	
	return ppdb;
}




template<class T, class TIn>
void SeedVec<T,TIn>::mapDistBtwSeeds( SurfVec<T,TIn>& _SurfVec )
{
	//fist test seed and surf parameters
	int _dimX, _dimY, _dimZ;
	TIn _delX, _delY, _delZ;
	TIn _cenX, _cenY, _cenZ;
	_SurfVec.getPara(_dimX, _dimY, _dimZ, _delX, _delY, _delZ, _cenX, _cenY, _cenZ );
	if ( _dimX != dimX_ || _dimY != dimY_ || _dimZ != dimZ_ || _delX != delX_ || _delY != delY_ || _delZ != delZ_ ||
		_cenX != cenX_ || _cenY != cenY_ || _cenZ != cenZ_ )
	{
		cout << "Surface grid parameters are matched with Seed grid parameters! " << endl;
		exit(1);
	}
	
	
	
	//second calculate distance list for each seed
	for ( int i = 0; i < seeds.size(); i++ )
	{
		//get the a, b, c for this seed
		int _a, _b, _c;
		seeds[i].getABC(_a, _b, _c);
		vector<int>old_v;  //vetex have been checked
		old_v.clear();
		vector< vector<int> >current_v; // current vetex
		current_v.clear();
		vector< vector<int> >temp_v;
		temp_v.clear();
		vector<int>tmp;
		tmp.resize(3);
		tmp[0] = _a;
		tmp[1] = _b;
		tmp[2] = _c;
		temp_v.resize(1);
		temp_v[0] = tmp;
		map<int, float> Dseeds; //distance between current seeds and other seeds
		Dseeds.clear();

		Dseeds[i] = 0;
		old_v.push_back(INDEX2(_a, _b, _c, dimX_, dimY_, dimZ_));

		int j = 1; // label number of seeds have been identified
		int k = 1; //label distance between seeds
		while ( j < seeds.size() )
		{
			current_v = temp_v;
			if ( current_v.size() == 0 )
			{
				cout << "ERROR: the pocket surface is segmentated!\n" <<endl;
				exit(1);
			}
			temp_v.clear();
			//for ( int p = 0; p < current_v.size(); p++ )
			//{
			//	int idx = INDEX2(current_v[p][0], current_v[p][1], current_v[p][2], dimX_, dimY_, dimZ_);
			//	old_v.push_back(idx);
			//}
			int n = 0;
			for ( int p = 0; p < current_v.size(); p++ )
			{
				int a, b, c;
				a = current_v[p][0];
				b = current_v[p][1];
				c = current_v[p][2];
				for ( int x = -1; x <= 1; x++ )
				{
					for ( int y = -1; y <= 1; y++ )
					{
						for ( int z = -1; z <= 1; z++ )
						{
							int aa, bb, cc;
							aa = a + x;
							bb = b + y;
							cc = c + z;
							int tmpindx = INDEX2( aa, bb, cc, dimX_, dimY_, dimZ_);
							vector<int>::iterator it;
							it = find(old_v.begin(), old_v.end(), tmpindx);
							if ( it != old_v.end() ) continue;
							else
							{
								Seed<T,TIn>* _seed = getSeed(aa,bb,cc);
								Surf<T,TIn>* tsurf = _SurfVec.getSurf(aa,bb,cc);
								if ( _seed != NULL && tsurf != NULL )
								{
									Dseeds[mapABC[tmpindx]] = (float)k;
									temp_v.resize(n+1);
									temp_v[n].resize(3);
									temp_v[n][0] = aa;
									temp_v[n][1] = bb;
									temp_v[n][2] = cc;
									n++;
									j++;
									old_v.push_back(tmpindx);
								}
								else if ( _seed == NULL && tsurf != NULL )
								{
									temp_v.resize(n+1);
									temp_v[n].resize(3);
									temp_v[n][0] = aa;
									temp_v[n][1] = bb;
									temp_v[n][2] = cc;
									n++;
									old_v.push_back(tmpindx);
								}
								else
									continue;
							}
						}
					}
				}
			}
			current_v.clear();
			k++;
		}
		seeds[i].setDbtwSeed(Dseeds);
	}
}
