/*
 * Coded by : Sael Lee
 * Last Modified : APRIL 05, 2011
 * ADDED: getAtm(*,*)
 * MODIFIED:	(LigCluster modified)
 */
typedef char string4[5];
typedef char string11[12];

#define NUMPLPDONORS 49
static string4 plp_res_donor[] = {"ALA" , "ARG" , "ARG" , "ARG" , "ARG" , "ARG" , "ARG" , "ASN" ,
				  "ASN" , "ASN" , "ASP" , "ASH" , "ASH" , "CYS" , "CYX" , "GLN" , 
				  "GLN" , "GLN" , "GLU" , "GLH" , "GLH" , "GLY" , "HIS" , "HIS" ,
				  "HIE" , "HIE" , "HID" , "HID" , "HIP" , "HIP" , "HIP" , "ILE" ,
				  "LEU" , "LYS" , "LYS" , "LYS" , "LYS" , "MET" , "PHE" , "SER" ,
				  "SER" , "THR" , "THR" , "TRP" , "TRP" , "TYR" , "TYR" , "VAL" , 
				  "HIS" };
static string4 plp_atm_donor[] = {"H"   , "H"   , "HE"  , "HH11", "HH12", "HH21", "HH22", "H"   ,
				  "HD21", "HD22", "H"   , "H"   , "HD2" , "H"   , "H"   , "H"   ,
				  "HE21", "HE22", "H"   , "H"   , "HE2" , "H"   , "H"   , "HD1" ,
				  "H"   , "HE2" , "H"   , "HD1" , "H"   , "HD1" , "HE2" , "H"   ,
				  "H"   , "H"   , "HZ1" , "HZ2" , "HZ3" , "H"   , "H"   , "H"   ,
				  "HG"  , "H"   , "HG1" , "H"   , "HE1" , "H"   , "HH"  , "H"   ,
				  "HE2" };

#define NUMPLPACCEPTORS 42
static string4 plp_res_accep[] = {"ALA" , "ARG" , "ASN" , "ASN" , "ASP" , "ASP" , "ASP" , 
				  "ASH" , "ASH" , "ASH" , "CYS" , "CYX" , "GLN" , "GLN" , 
				  "GLU" , "GLU" , "GLU" , "GLH" , "GLH" , "GLH" , "GLY" , 
				  "HIS" , "HIS" , "HIE" , "HIE" , "HID" , "HID" , "HIP" ,
				  "ILE" , "LEU" , "LYS" , "MET" , "PHE" , "PRO" , "SER" ,
				  "SER" , "THR" , "THR" , "TRP" , "TYR" , "TYR" , "VAL" };
static string4 plp_atm_accep[] = {"O"   , "O"   , "O"   , "OD1" , "O"   , "OD1" , "OD2" ,
				  "O"   , "OD1" , "OD2" , "O"   , "O"   , "O"   , "OE1" ,
				  "O"   , "OE1" , "OE2" , "O"   , "OE1" , "OE2" , "O"   ,
				  "O"   , "NE2" , "O"   , "ND1" , "O"   , "NE2" , "O"   ,
				  "O"   , "O"   , "O"   , "O"   , "O"   , "O"   , "O"   ,
				  "OG"  , "O"   , "OG1" , "O"   , "O"   , "OH"  , "O"   };

#define N_arom_type 17
static string11 XlogP_arom_type[] = {"C.ar.h.X"   , "C.ar.h"     , "C.ar.ar"    , "C.ar.(-X).X", "C.ar.(-X)"  ,
				     "C.ar.X"     , "C.ar"       , "N.ar.X2"    , "N.ar.X"     , "N.ar"       ,
				     "N.ar.h.X"   , "N.ar.h"     , "N.ar.X2.(2)", "N.ar.X.(2)" , "N.ar.(2)"   ,
				     "O.ar"       , "S.ar"       };

#define N_xlp_atom_type 185
static string4 xlp_res[] = {"TYR" , "TYR" , "TYR" , "TYR" , "TYR" , "TYR" , "TYR" , "TYR" , "TYR" , "TYR" ,
			    "TYR" , "TYR" , "THR" , "THR" , "THR" , "THR" , "THR" , "THR" , "THR" , "VAL" , 
			    "VAL" , "VAL" , "VAL" , "VAL" , "VAL" , "VAL" , "PHE" , "PHE" , "PHE" , "PHE" ,
			    "PHE" , "PHE" , "PHE" , "PHE" , "PHE" , "PHE" , "PHE" , "PRO" , "PRO" , "PRO" ,
			    "PRO" , "PRO" , "PRO" , "PRO" , "ARG" , "ARG" , "ARG" , "ARG" , "ARG" , "ARG" ,
			    "ARG" , "ARG" , "ARG" , "ARG" , "ARG" , "GLY" , "GLY" , "GLY" , "GLY" , "CYS" ,
			    "CYS" , "CYS" , "CYS" , "CYS" , "CYS" , "ALA" , "ALA" , "ALA" , "ALA" , "ALA" , 
			    "LEU" , "LEU" , "LEU" , "LEU" , "LEU" , "LEU" , "LEU" , "LEU" , "MET" , "MET" ,
			    "MET" , "MET" , "MET" , "MET" , "MET" , "MET" , "ASP" , "ASP" , "ASP" , "ASP" ,
			    "ASP" , "ASP" , "ASP" , "ASP" , "GLN" , "GLN" , "GLN" , "GLN" , "GLN" , "GLN" ,
			    "GLN" , "GLN" , "GLN" , "SER" , "SER" , "SER" , "SER" , "SER" , "SER" , "TRP" ,
			    "TRP" , "TRP" , "TRP" , "TRP" , "TRP" , "TRP" , "TRP" , "TRP" , "TRP" , "TRP" ,
			    "TRP" , "TRP" , "TRP" , "LYS" , "LYS" , "LYS" , "LYS" , "LYS" , "LYS" , "LYS" ,
			    "LYS" , "LYS" , "GLU" , "GLU" , "GLU" , "GLU" , "GLU" , "GLU" , "GLU" , "GLU" ,
			    "GLU" , "ASN" , "ASN" , "ASN" , "ASN" , "ASN" , "ASN" , "ASN" , "ASN" , "ILE" , 
			    "ILE" , "ILE" , "ILE" , "ILE" , "ILE" , "ILE" , "ILE" , "HIS" , "HIS" , "HIS" ,
			    "HIS" , "HIS" , "HIS" , "HIS" , "HIS" , "HIS" , "HIS" , "TYR" , "TYR" , "TYR" , 
			    "TYR" , "PHE" , "PHE" , "PHE" , "PHE" , "PHE" , "TRP" , "TRP" , "TRP" , "TRP" ,
			    "TRP" , "HIS" , "HIS",  "HIS" , "HIS" };
static string4 xlp_atm[] = {"N"   , "CA"  , "C"   , "O"   , "CB"  , "CG"  , "CD1" , "CD2" , "CE1" , "CE2" , 
			    "CZ"  , "OH"  , "N"   , "CA"  , "C"   , "O"   , "CB"  , "OG1" , "CG2" , "N"   ,
			    "CA"  , "C"   , "O"   , "CB"  , "CG1" , "CG2" , "N"   , "CA"  , "C"   , "O"   ,
			    "CB"  , "CG"  , "CD1" , "CD2" , "CE1" , "CE2" , "CZ"  , "N"   , "CA"  , "C"   ,
			    "O"   , "CB"  , "CG"  , "CD"  , "N"   , "CA"  , "C"   , "O"   , "CB"  , "CG"  , 
			    "CD"  , "NE"  , "CZ"  , "NH1" , "NH2" , "N"   , "CA"  , "C"   , "O"   , "N"   ,
			    "CA"  , "C"   , "O"   , "CB"  , "SG"  , "N"   , "CA"  , "C"   , "O"   , "CB"  ,
			    "N"   , "CA"  , "C"   , "O"   , "CB"  , "CG"  , "CD1" , "CD2" , "N"   , "CA"  ,
			    "C"   , "O"   , "CB"  , "CG"  , "SD"  , "CE"  , "N"   , "CA"  , "C"   , "O"   ,
			    "CB"  , "CG"  , "OD1" , "OD2" , "N"   , "CA"  , "C"   , "O"   , "CB"  , "CG"  ,
			    "CD"  , "OE1" , "NE2" , "N"   , "CA"  , "C"   , "O"   , "CB"  , "OG"  , "N"   ,
			    "CA"  , "C"   , "O"   , "CB"  , "CG"  , "CD1" , "CD2" , "NE1" , "CE2" , "CE3" ,
			    "CZ2" , "CZ3" , "CH2" , "N"   , "CA"  , "C"   , "O"   , "CB"  , "CG"  , "CD"  ,
			    "CE"  , "NZ"  , "N"   , "CA"  , "C"   , "O"   , "CB"  , "CG"  , "CD"  , "OE1" ,
			    "OE2" , "N"   , "CA"  , "C"   , "O"   , "CB"  , "CG"  , "OD1" , "ND2" , "N"   ,
			    "CA"  , "C"   , "O"   , "CB"  , "CG1" , "CG2" , "CD1" , "N"   , "CA"  , "C"   ,
			    "O"   , "CB"  , "CG"  , "CD2" , "CE1" , "ND1" , "NE2" , "HE1" , "HE2" , "HD1" , 
			    "HD2" , "HE1" , "HE2",  "HD1" , "HD2" , "HZ"  , "HH2" , "HE3" , "HZ2" , "HZ2" ,
			    "HD1" , "HE1" , "HE2",  "HD2" , "HD1" };
static float xlp_val[] =   {-0.272, -0.342, -0.760,  0.641,  0.295,  0.172,  0.320,  0.320,  0.320,  0.320,
			    -0.028, -0.007, -0.272, -0.342, -0.760,  0.641, -0.144, -0.474,  0.480, -0.272,
			    -0.342, -0.760,  0.641,  0.144,  0.650,  0.650, -0.272, -0.342, -0.760,  0.641,
			     0.295,  0.172,  0.320,  0.320,  0.320,  0.320,  0.320, -0.105, -0.342, -0.760,
			     0.641,  0.357,  0.357, -0.097, -0.272, -0.342, -0.760,  0.641,  0.357,  0.357,
			    -0.097, -0.272, -0.760,  0.730, -0.657, -0.272, -0.264, -0.760,  0.641, -0.272,
			    -0.342, -0.760,  0.641, -0.097,  0.499, -0.272, -0.342, -0.760,  0.641,  0.480,
			    -0.272, -0.342, -0.760,  0.641,  0.357,  0.144,  0.650,  0.650, -0.272, -0.342,
			    -0.760,  0.641,  0.357, -0.097,  0.844,  0.016, -0.272, -0.342, -0.760,  0.641,
			     0.295, -0.524,  0.641,  0.641, -0.272, -0.342, -0.760,  0.641,  0.357, -0.264,
			    -0.760,  0.641, -0.657, -0.272, -0.342, -0.760,  0.641, -0.097, -0.474, -0.272,
			    -0.342, -0.760,  0.641,  0.295,  0.172, -0.100,  0.305,  0.270, -0.028,  0.320,
			     0.320,  0.320,  0.320, -0.272, -0.342, -0.760,  0.641,  0.357,  0.357,  0.357,
			    -0.097, -0.730, -0.272, -0.342, -0.760,  0.641,  0.357,  0.295, -0.524,  0.641,
			     0.641, -0.272, -0.342, -0.760,  0.641, -0.264, -0.760,  0.641, -0.657, -0.272,
			    -0.342, -0.760,  0.641,  0.144,  0.357,  0.650,  0.650, -0.272, -0.342, -0.760,
			     0.641,  0.295, -0.212, -0.100, -0.100,  0.091,  0.270,  0.000,  0.000,  0.000,
			     0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,
			     0.000,  0.000,  0.000,  0.000,  0.000};
static float arom_val[] =  {0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 1.0   , 1.0   , 1.0   , 1.0   , 1.0   , 
			    1.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 1.0   , 1.0   , 1.0   , 1.0   , 1.0   , 1.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 1.0   , 1.0   , 1.0   , 1.0   , 1.0   , 1.0   ,
			    1.0   , 1.0   , 1.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.D   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 1.0   , 1.0   , 1.0   , 1.0   , 1.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   , 0.0   ,
			    0.0   , 0.0   , 0.0   , 0.0   , 0.0   };

template<class T, class TIn>
int ProcessPDB<T,TIn>::ReadPDB(const char* _fname)
{
	string str;
	TIn Max[3] = {-3600,-3600,-3600};
	TIn Min[3] = { 3600, 3600, 3600}; 
	TIn Sum[3] = {0, 0, 0};
	int count  = 0;
	
	ifstream infile(_fname);
	if(!infile.is_open()){
		cout << "Cannot find " <<  _fname << endl;
		return -1;
	}

	int modifyA = 0; 
	if(atom_.size() > 1){modifyA = 1;}
	int modifyH = 0; 
	if(hetatm_.size() > 1){modifyH = 1;}
		
	int check_model = 0;
	while(getline(infile, str))
	{
		// Record ID
		char tmp[6];
		char record[6];
		for(int i=0; i<6; i++){
			tmp[i] = str[i];
		}
		sscanf(tmp, "%s", record);
//	cout << "Record  " << tmp <<  " "  << record << endl;
		
		if( !strcmp(record,"MODEL") )
		{
			if(check_model>=1) break; 
			check_model++;
		}
		
		if((strcmp(record,"ATOM")==0 || strcmp(record, "HETATM")==0) )
		{			

			count++;
			ATOMStruct tmpATOM; tmpATOM.init();
			char tmp3[3], tmp4[4], tmp5[5], tmp6[6], tmp7[7], tmp8[8], tmp9[9];
			
			// Aternative location code (if any)
			tmpATOM.aLC = str[16];
			if(str[16] != ' ' && str[16] != 'A') continue;
			
			// Record ID
			for(int i=0; i<6; i++){
				tmp7[i] = str[0+i];
			}
			tmp7[6] = '\0';
			sscanf(tmp7,"%s",tmpATOM.type);
			//cout << "Record  "  << tmpATOM.type << endl;
			
			// Atom serial number
			for(int i=0; i<5; i++){
				tmp6[i] = str[6+i];
			}
			tmp6[5] = '\0';
			tmpATOM.aSN = atoi(tmp6);
			
			// Atom name
			for(int i=0; i<4; i++){
				tmp5[i] = str[12+i];
			}
			tmp5[4] = '\0';
			sscanf(tmp5,"%s",tmpATOM.aName);
		
			// 3-letter amino acid code
			for(int i=0; i<3; i++){
				tmp4[i] = str[17+i];
			}
			tmp4[3] = '\0';
			sscanf(tmp4,"%s",tmpATOM.AA);

			// chain id code
			tmpATOM.chain = str[21];
			
			// Residue sequence number
			for(int i=0; i<4; i++){
				tmp5[i] = str[22+i];
			}
			tmp5[4] = '\0';
			tmpATOM.rSN = atoi(tmp5);
			
			// insertion code (if any)
			tmpATOM.iC = str[26];
			
			// coordinates
			for(int i=0; i<8; i++){
				tmp9[i] = str[30+i];
			}
			tmp9[8] = '\0';
			tmpATOM.x = atof(tmp9);
			Sum[0] += tmpATOM.x;
			if(tmpATOM.x > Max[0]) Max[0] = tmpATOM.x;
			if(tmpATOM.x < Min[0]) Min[0] = tmpATOM.x;
			
			for(int i=0; i<8; i++){
				tmp9[i] = str[38+i];
			}
			tmp9[8] = '\0';
			tmpATOM.y = atof(tmp9);
			Sum[1] += tmpATOM.y;
			if(tmpATOM.y > Max[1]) Max[1] = tmpATOM.y;
			if(tmpATOM.y < Min[1]) Min[1] = tmpATOM.y;
					
			for(int i=0; i<8; i++){
				tmp9[i] = str[46+i];
			}
			tmp9[8] = '\0';
			tmpATOM.z = atof(tmp9);
			Sum[2] += tmpATOM.z;
			if(tmpATOM.z > Max[2]) Max[2] = tmpATOM.z;
			if(tmpATOM.z < Min[2]) Min[2] = tmpATOM.z;
			
		
			// Occupancy value for atom
			for(int i=0; i<6; i++){
				tmp7[i] = str[54+i];
			}
			tmp7[6]= '\0';
			//tmpATOM.oV = atof(tmp6);
			tmpATOM.oV = atof(tmp7);

			// B-value
			for(int i=0; i<6; i++){
				tmp7[i] = str[60+i];
			}	
			tmp7[6] = '\0';
			tmpATOM.bV = atof(tmp7);

			// footnote number
			for(int i=0; i<3; i++){
				tmp4[i] = str[67+i];
			}
			tmp4[3] = '\0';
			sscanf(tmp4,"%s",tmpATOM.footN);
	
			// Element type
			tmp3[0] = str[76]; tmp3[1] = str[77];	tmp3[2] = '\0';
			sscanf(tmp3,"%s",tmpATOM.eleT);

			// Charge
			tmp3[0] = str[78]; tmp3[1] = str[79];	tmp3[2] = '\0';
			sscanf(tmp3,"%s",tmpATOM.cha);

#ifdef DEBUG1
			tmpATOM.ATOMprint();
#endif
			
			if(!strcmp(tmpATOM.type,"ATOM") && modifyA ){
				int index = searchXYZ(tmpATOM.x, tmpATOM.y, tmpATOM.z, atom_);	
				if(index != -1){
					atom_[index].copyATOMFrom(tmpATOM);
				}else{
					atom_.push_back(tmpATOM);	
					atmIDmap_[(atom_.back()).aSN] = atom_.back();
					resIDmap_[(atom_.back().rSN)] = atom_.back();
				}
			}else if(!strcmp(tmpATOM.type,"ATOM") && !modifyA ){
				atom_.push_back(tmpATOM);	
				atmIDmap_[(atom_.back()).aSN] = atom_.back();
				resIDmap_[(atom_.back().rSN)] = atom_.back();
			}else if(!strcmp(tmpATOM.type,"HETATM") && modifyH ){
				int index = searchXYZ(tmpATOM.x, tmpATOM.y, tmpATOM.z, hetatm_);	
				if(index != -1){
					hetatm_[index].copyATOMFrom(tmpATOM);
				}else{
					hetatm_.push_back(tmpATOM);	
					hetatmIDmap_[(hetatm_.back()).aSN] = hetatm_.back();
				}
			}else if(!strcmp(tmpATOM.type,"HETATM") && !modifyH ){
				hetatm_.push_back(tmpATOM);	
				hetatmIDmap_[(hetatm_.back()).aSN] = hetatm_.back();
			}
	/*
			if(!strcmp(tmpATOM.type,"HETATM")){
				hetatm_.push_back(tmpATOM);
			}else{
				atom_.push_back(tmpATOM);
			}
	*/
		}else if(strcmp(record,"TER")==0 )
		{
			// if ATOM component remove last residue if there is only one atom
			if(atom_.size()>3 && (atom_.back()).rSN != atom_[atom_.size()-2].rSN)
			{
				atmIDmap_.erase(atom_.back().aSN);
				resIDmap_.erase(atom_.back().rSN);
				atom_.pop_back();	
			}
		}
	}// end reading lines


	if( count>1 ){
		for(int i=0;i<3;i++)
		{
			cog_[i] = Sum[i]/count;
			cen_[i] = (Max[i]+Min[i])/2.0;
			min_[i] = Min[i];
			max_[i] = Max[i];
		}
		if( atom_.size()>1 ){	
			cenAtm_[0] = atom_[(int)((count-1)/2)].x;
			cenAtm_[1] = atom_[(int)((count-1)/2)].y;
			cenAtm_[2] = atom_[(int)((count-1)/2)].z;
		}else{
			cenAtm_[0] = hetatm_[(int)((count-1)/2)].x;
			cenAtm_[1] = hetatm_[(int)((count-1)/2)].y;
			cenAtm_[2] = hetatm_[(int)((count-1)/2)].z;
		}
	}else if( count==1 ){ 
		if( atom_.size() == 1 ){
			cog_[0] = cenAtm_[0] = cen_[0] = min_[0] = max_[0] = atom_[0].x;
			cog_[1] = cenAtm_[1] = cen_[1] = min_[1] = max_[1] = atom_[0].y;
			cog_[2] = cenAtm_[2] = cen_[2] = min_[2] = max_[2] = atom_[0].z;
		}else if( hetatm_.size()==1 ) {
			cog_[0] = cenAtm_[0] = cen_[0] = min_[0] = max_[0] = hetatm_[0].x;
			cog_[1] = cenAtm_[1] = cen_[1] = min_[1] = max_[1] = hetatm_[0].y;
			cog_[2] = cenAtm_[2] = cen_[2] = min_[2] = max_[2] = hetatm_[0].z;
	
		}
	}
	
	// make AAlst_ 1 letter amino acid code
	makeAAlst();

#ifdef DEBUG
		cout << "\nCalculated Centers: " << cen_[0] << " " 
			<< cen_[1] << " " << cen_[2] << endl;
		cout << "atom size : " << atom_.size() << endl;
		cout << "hetatm size : " << hetatm_.size() << endl;
#endif 

		int dummy_int = 1;
	return dummy_int;
	cout << "CP2" << endl;			
}


template<class T, class TIn>
int ProcessPDB<T,TIn>::ReadPQR(const char* _fname)
{
	ifstream pqr(_fname);		
	if(!pqr.is_open())
	{
		cout << "Cannot open " << _fname << endl;
		return -1;
	}

	int modifyA = 0; 
	if(atom_.size() > 1){modifyA = 1;}
	int modifyH = 0; 
	if(hetatm_.size() > 1){modifyH = 1;}
	
	char buffer[100];
	int num = 0;
	while(pqr.getline(buffer, 100))
	{
		if((buffer[0] == 'H' && buffer[3] == 'A')||(buffer[0] == 'A' && buffer[3] == 'M')){
	
			// Field_name Atom_number Atom_name Residue_name Residue_number X Y Z Charge Radius
			ATOMStruct tmpATOM; tmpATOM.init();
	 		sscanf(buffer, "%s %d %s %s %d %f %f %f %f %f\n", tmpATOM.type, &(tmpATOM.aSN), tmpATOM.aName,	tmpATOM.AA, &(tmpATOM.rSN), &(tmpATOM.x), &(tmpATOM.y), &(tmpATOM.z), &(tmpATOM.charge),	&(tmpATOM.radius) );
		 
			if(!strcmp(tmpATOM.type,"ATOM") && modifyA ){
				int index = searchXYZ(tmpATOM.x, tmpATOM.y, tmpATOM.z, atom_);	
				if(index != -1){
					atom_[index].charge = tmpATOM.charge;
					atom_[index].radius = tmpATOM.radius;
				}
			}else if(!strcmp(tmpATOM.type,"ATOM") && !modifyA ){
				atom_.push_back(tmpATOM);	
			}else if(!strcmp(tmpATOM.type,"HETATM") && modifyH ){
				int index = searchXYZ(tmpATOM.x, tmpATOM.y, tmpATOM.z, hetatm_);	
				if(index != -1){
					hetatm_[index].charge = tmpATOM.charge;
					hetatm_[index].radius = tmpATOM.radius;
				}
			}else{
				hetatm_.push_back(tmpATOM);	
			
			}
		}	
	}

}


template<class T, class TIn>
int ProcessPDB<T, TIn> :: ReadPQR_detail(const char* _fname)
// Read atom record from input PQR file not from PDB file.
// This function is a combination of ReadPDB and ReadPQR function
{
  ifstream pqr(_fname);
  if(!pqr.is_open())
    {
      cout << "Cannot find PQR file: " << _fname << endl;
      return -1;
    }

  string str;
  TIn Max[3] = {-3600, -3600, -3600};
  TIn Min[3] = {3600, 3600, 3600};
  TIn Sum[3] = {0, 0, 0};
  int count = 0;
  
  int modifyA = 0;
  if(atom_.size() > 1)
    {
      modifyA = 1;
    }
  int modifyH = 0;
  if(hetatm_.size() > 1)
  {
    modifyH = 1;
  }

  int check_model = 0;
  while(getline(pqr, str))
    {
      char tmp[6];
      char record[6];
      for(int i = 0; i < 6; i++)
	{
	  tmp[i] = str[i];
	}
      sscanf(tmp, "%s", record);
      
      if(!strcmp(record, "MODEL"))
	{
	  if(check_model >= 1) break;
	  check_model++;
	}
      
      if((strcmp(record, "ATOM") == 0 || strcmp(record, "HETATM") == 0))
	{
	  count++;
	  ATOMStruct tmpATOM;
	  tmpATOM.init();
	  char tmp_3[3], tmp_4[4], tmp_5[5], tmp_6[6], tmp_7[7], tmp_8[8], tmp_9[9];
	  
	  tmpATOM.aLC = str[16];
	  if(str[16] != ' ' && str[16] != 'A') continue;
	  
	  for(int i = 0; i < 6; i++)
	    {
	      tmp_7[i] = str[0 + i];
	    }
	  tmp_7[6] = '\0';
	  sscanf(tmp_7, "%s", tmpATOM.type);
	  
	  for(int i = 0; i < 5; i++)
	    {
	      tmp_6[i] = str[6 + i];
	    }
	  tmp_6[5] = '\0';
	  tmpATOM.aSN = atoi(tmp_6);
	  
	  for(int i = 0; i < 4; i++)
	    {
	      tmp_5[i] = str[12 + i];
	    }
	  tmp_5[4] = '\0';
	  sscanf(tmp_5, "%s", tmpATOM.aName);
	  
	  for(int i = 0; i < 3; i++)
	    {
	      tmp_4[i] = str[17 + i];
	    }
	  tmp_4[3] = '\0';
	  sscanf(tmp_4, "%s", tmpATOM.AA);
	  
	  tmpATOM.chain = str[21];
	  
	  for(int i = 0; i < 4; i++)
	    {
	      tmp_5[i] = str[22 + i];
	    }
	  tmp_5[4] = '\0';
	  tmpATOM.rSN = atoi(tmp_5);
	  
	  tmpATOM.iC = str[26];
	  
	  for(int i = 0; i < 8; i++)
	    {
	      tmp_9[i] = str[30 + i];
	    }
	  tmp_9[8] = '\0';
	  tmpATOM.x = atof(tmp_9);
	  Sum[0] += tmpATOM.x;
	  if(tmpATOM.x > Max[0]) Max[0] = tmpATOM.x;
	  if(tmpATOM.x < Min[0]) Min[0] = tmpATOM.x;
	  
	  for(int i = 0; i < 8; i++)
	    {
	      tmp_9[i] = str[38 + i];
	    }
	  tmp_9[8] = '\0';
	  tmpATOM.y = atof(tmp_9);
	  Sum[1] += tmpATOM.y;
	  if(tmpATOM.x > Max[1]) Max[1] = tmpATOM.y;
	  if(tmpATOM.x < Min[1]) Min[1] = tmpATOM.y;
	  
	  for(int i = 0; i < 8; i++)
	    {
	      tmp_9[i] = str[46 + i];
	    }
	  tmp_9[8] = '\0';
	  tmpATOM.z = atof(tmp_9);
	  Sum[2] += tmpATOM.z;
	  if(tmpATOM.x > Max[2]) Max[2] = tmpATOM.z;
	  if(tmpATOM.x < Min[2]) Min[2] = tmpATOM.z;
	  
	  for(int i = 0; i < 8; i++)
	    {
	      tmp_9[i] = str[i + 54];
	    }
	  tmp_9[8] = '\0';
	  tmpATOM.charge = atof(tmp_9);
	  
	  for(int i = 0; i < 7; i++)
	    {
	      tmp_8[i] = str[i + 62];
	    }
	  tmp_8[7] = '\0';
	  tmpATOM.radius = atof(tmp_8);
	  
	  if(!strcmp(tmpATOM.type, "ATOM") && modifyA)
	    {
	      int index = searchXYZ(tmpATOM.x, tmpATOM.y, tmpATOM.z, atom_);
	      if(index != -1)
		{
		  atom_[index].copyATOMFrom(tmpATOM);
		}
	      else
		{
		  atom_.push_back(tmpATOM);
		  atmIDmap_[(atom_.back()).aSN] = atom_.back();
		  resIDmap_[(atom_.back().rSN)] = atom_.back();
		}
	    }
	  else if(!strcmp(tmpATOM.type, "ATOM") && !modifyA)
	    {
	      atom_.push_back(tmpATOM);
	      atmIDmap_[(atom_.back()).aSN] = atom_.back();
	      resIDmap_[(atom_.back().rSN)] = atom_.back();
	    }
	  else if(!strcmp(tmpATOM.type, "HETATM") && modifyH)
	    {
	      int index = searchXYZ(tmpATOM.x, tmpATOM.y, tmpATOM.z, hetatm_);
	      if(index != -1)
		{
		  hetatm_[index].copyATOMFrom(tmpATOM);
		}
	      else
		{
		  hetatm_.push_back(tmpATOM);
		  hetatmIDmap_[(hetatm_.back()).aSN] = hetatm_.back();
		}
	    }
	}
      else if(strcmp(record, "TER") == 0)
	{
	  if(atom_.size() > 3 && (atom_.back()).rSN != atom_[atom_.size()-2].rSN)
	    {
	      atmIDmap_.erase(atom_.back().aSN);
	      resIDmap_.erase(atom_.back().rSN);
	      atom_.pop_back();
	    }
	}
    }	

  if(count > 1)
    {
      for(int i = 0; i < 3; i++)
	{
	  cog_[i] = Sum[i] / count;
	  cen_[i] = (Max[i] + Min[i]) / 2.0;
	  min_[i] = Min[i];
	  max_[i] = Max[i];
	}
      if(atom_.size() > 1)
	{
	  cenAtm_[0] = atom_[(int)((count - 1) / 2)].x;
	  cenAtm_[1] = atom_[(int)((count - 1) / 2)].y;
	  cenAtm_[2] = atom_[(int)((count - 1) / 2)].z;
	}
      else
	{
	  cenAtm_[0] = hetatm_[(int)(count - 1) / 2].x;
	  cenAtm_[1] = hetatm_[(int)(count - 1) / 2].y;
	  cenAtm_[2] = hetatm_[(int)(count - 1) / 2].z;
	}
    }
  else if(count == 1)
    {
      if(atom_.size() == 1)
	{
	  cog_[0] = cenAtm_[0] = cen_[0] = min_[0] = max_[0] = atom_[0].x;
	  cog_[1] = cenAtm_[1] = cen_[1] = min_[1] = max_[1] = atom_[0].y;
	  cog_[2] = cenAtm_[2] = cen_[2] = min_[2] = max_[2] = atom_[0].z;
	}
      else if(hetatm_.size() == 1)
	{
	  cog_[0] = cenAtm_[0] = cen_[0] = min_[0] = max_[0] = hetatm_[0].x;
	  cog_[1] = cenAtm_[1] = cen_[1] = min_[1] = max_[1] = hetatm_[0].y;
	  cog_[2] = cenAtm_[2] = cen_[2] = min_[2] = max_[2] = hetatm_[0].z;
	}
    }

  makeAAlst();

#ifdef DEBUG_PQR_DETAIL
  for(int i = 0; i < atom_.size(); i++)
    cout << atom_[i].charge << " " << atom_[i].radius << endl;
#endif
  
  return 1;
}

template<class T, class TIn>
void ProcessPDB<T,TIn>::makeAAlst()
{
	AAlst_.resize(atom_.size());
	ResidueStruct resMap;
	map<string,char>::iterator it;
	int prevrSN = -1;;
	for(int i=0; i<atom_.size(); i++){
		if(prevrSN != atom_[i].rSN){
			prevrSN = atom_[i].rSN;
			char buf[3];
			sscanf(atom_[i].AA,"%s", buf);
			string aaname;
			aaname.assign(buf);
			it=(resMap.aa1).find(aaname); 		
			if( it!=(resMap.aa1).end() ){
//				cout << (*it).second;
				AAlst_[i] = (*it).second;
			}

#ifdef DEBUG		
			cout << AAlst_[i];
#endif	
		}
	}

}


template<class T, class TIn>
int ProcessPDB<T,TIn>::searchXYZ(float _x, float _y, float _z, vector<ATOMStruct> _vect)
{
	if(_vect.size()<1){
		return -1;
	}
		 
	for(int i=0; i<_vect.size(); i++){
	 if( fabs(_vect[i].x - _x) < 0.0001  &&  fabs(_vect[i].y - _y) < 0.0001 &&  fabs(_vect[i].z - _z) < 0.0001 )
	 {
		 return i;
	 }
	}
	
	return -1;
}



template<class T, class TIn>
int ProcessPDB<T,TIn>::addHydro()
{
	
	res_.init();	
	
	if(atom_.size()<1 && hetatm_.size()<1){
		return -1;
	}
	
	if(atom_.size()>1){
		for(int i=0; i<atom_.size(); i++){
			atom_[i].KDhydro = (res_.kd)[atom_[i].AA];
		}
	}
	if(hetatm_.size()>1){
		for(int i=0; i<hetatm_.size(); i++){
			hetatm_[i].KDhydro = (res_.kd)[hetatm_[i].AA];
		}
	}
	
	return 1;
}


//==============================================================
// added by Bingjie Hu (03/01/2014) for hydrogen bond of protein
// modified by W. -H. Shin (9/5/2014) to assign hydrogen bond
// acceptor type to a hydrogen, not a heavy atom
// modified by W. -H. Shin (8/28/2017) to assign very small value
// to atoms with no hydrogen bond character
//==============================================================
template<class T, class TIn>
int ProcessPDB<T,TIn>::addHB()
{
  
  if(atom_.size()<1)
    {
      return -1;
    }
	
  if(atom_.size()>1){
    for(int i=0; i<atom_.size(); i++)
      {
	// initialization
	//atom_[i].hbond = 0.1; // add small value to neutral atom to fix bug
	atom_[i].hbond = 0.0;

	// check for donors
	for(int j = 0; j < NUMPLPDONORS; j++)
	  {
	    if(!strcmp(atom_[i].AA, plp_res_donor[j]) && !strcmp(atom_[i].aName, plp_atm_donor[j]))
	      {
		atom_[i].hbond = 1.0;
		break;
	      }
	  }
	
	// check for acceptors
	for(int j = 0; j < NUMPLPACCEPTORS; j++)
	  {
	    if(!strcmp(atom_[i].AA, plp_res_accep[j]) && !strcmp(atom_[i].aName, plp_atm_accep[j]))
	      {
		atom_[i].hbond = -1.0;
		break;
	      }
	  }
      }
  }

#ifdef DEBUG_HB
  for(int i_atm = 0; i_atm < atom_.size(); i_atm++)
    if(atom_[i_atm].hbond != 0.0 && atom_[i_atm].hbond != 0.1)
      {
	cout << atom_[i_atm].rSN << " " << atom_[i_atm].aSN << " " << atom_[i_atm].AA << " "
	     << atom_[i_atm].aName << " " << atom_[i_atm].hbond << endl;
      }
#endif

  return 1;
}


//==============================================================
// added by W. -H. Shin (9/5/2014) to assign XlogP value and 
// aromaticity to protein atoms
//==============================================================
template<class T, class TIn>
int ProcessPDB<T,TIn>::assign_XlogP_prot()
{
  
  if(atom_.size()<1)
    {
      return -1;
    }
	
  if(atom_.size()>1){
    for(int i=0; i<atom_.size(); i++)
      {
	// initialization
	atom_[i].XlogP = 0.0;
	atom_[i].arom = 0.1;

	for(int j = 0; j < N_xlp_atom_type; j++)
	  {
	    if(!strcmp(atom_[i].AA, xlp_res[j]) && !strcmp(atom_[i].aName, xlp_atm[j]))
	      {
		atom_[i].XlogP = xlp_val[j];
		atom_[i].arom = arom_val[j];
		break;
	      }
	  }
	if(i == 0 && strcmp(atom_[i].aName, "N") == 0) // N-terminal
	  {
	    atom_[i].XlogP = -0.730;
	  }
	if(strcmp(atom_[i].aName, "OXT") == 0) // C-terminal
	  {
	    atom_[i].XlogP = 0.641;
	  }
      }
  }

#ifdef DEBUG_XlogP_prot
  for(int i_atm = 0; i_atm < atom_.size(); i_atm++)
    cout << atom_[i_atm].rSN << " " << atom_[i_atm].aSN << " " << atom_[i_atm].AA << " "
	     << atom_[i_atm].aName << " " << atom_[i_atm].XlogP << " " << atom_[i_atm].arom << endl;
#endif

  return 1;
}

//=============================================================
//added by Bingjie Hu (03/01/2014) for hydrogen bond of ligand
//=============================================================
template<class T, class TIn>
int ProcessPDB<T,TIn>::ReadMOL2(const char* _fname)
{
	FILE	*fi;
	fi = fopen(_fname, "r");
	if (!fi){
		cout << "Cannot find " <<  _fname << endl;
		return -1;
	}
    char	line[1000];
    int     tmp0, tmp1, tmp2, nb1, nb2, i;


	// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 
	// read coordinate infomation 
	// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 

	// =========================================================  
	// read number of atoms and bonds
	while(!feof(fi))
	{
		fgets(line, 1000, fi);
		if(strstr(line, "@<TRIPOS>MOLECULE"))
		{
			fgets(line, 1000, fi);
			fgets(line, 1000, fi);
			sscanf(line, "%d%d", &(atomNum_), &(bondNum_));
		}
		if(strstr(line, "@<TRIPOS>ATOM"))
		{
			for(i = 0; i < atomNum_; i++)
			{
				ATOMStruct tmpATOM; tmpATOM.init();
				fgets(line, 1000, fi);
				sscanf(line, "%d%s%f%f%f%s%d", &(tmpATOM.aSN), tmpATOM.aName,
							&(tmpATOM.x), &(tmpATOM.y), &(tmpATOM.z),
							tmpATOM.eleT, &(tmpATOM.rSN));
				atom_.push_back(tmpATOM);
			}
		}
		if(strstr(line, "@<TRIPOS>BOND"))
		{
			for(i = 0; i < bondNum_; i++)
			{
				fgets(line, 1000, fi);
				sscanf(line, "%*s%d%d", &tmp1, &tmp2);
				nb1 = atom_[tmp1-1].numBonds;
				atom_[tmp1-1].bond_[nb1] = &(atom_[tmp2-1]);
				//atom_[tmp1-1].bond_.push_back(atom_[tmp2-1]);
				atom_[tmp1-1].numBonds++;
				nb2 = atom_[tmp2-1].numBonds;
				atom_[tmp2-1].bond_[nb2] = &(atom_[tmp1-1]);
				//atom_[tmp2-1].bond_.push_back(atom_[tmp1-1]);
				atom_[tmp2-1].numBonds++;
			}
			break;
		}
	}
}

//=============================================================
// added by W.-H. Shin (08/25/2014) for hydrophobicity of protein & ligand
// This process is done by reading outputs from XlogP3
//=============================================================
template<class T, class TIn>
int ProcessPDB<T, TIn> :: Read_XlogP(const char* _XlogP_file)
{
  ifstream infile(_XlogP_file);
  if(!infile.is_open())
    {
      cout << "Cannot file " << _XlogP_file << " !\n";
      return -1;
    }
  
  string line;
  char indicator[6], XlogP_type[12];
  int atm_idx;
  float XlogP, arom;
  char tmp_int[4], tmp_float[6], tmp_char[12];

  // initialization
  for (int i_atm = 0; i_atm < atom_.size(); i_atm++)
    {
      atom_[i_atm].XlogP = 0.0;
      atom_[i_atm].arom = 0.1;
    }

  // assign atomic XlogP value from XlogP result
  while (getline(infile, line))
    {
      for (int i=0; i<6; i++)
	indicator[i] = line[28+i];

      atm_idx = 0;
      XlogP = 0.0;
      arom = 0.0;

      if(strcmp(indicator, "XLOGP3") == 0) continue;
      if(strcmp(indicator, "------") == 0) continue;
      if(strcmp(indicator, "bution") == 0) continue;
      if(strcmp(indicator, "mino A") == 0) continue;
      
      for(int i=0; i<4; i++)
	tmp_int[i] = line[10+i];
      atm_idx = atoi(tmp_int);

      for(int i=0; i<11; i++)
	tmp_char[i] = line[i+38];
      tmp_char[11] = '\0';
      sscanf(tmp_char, "%s", XlogP_type);
      
      for(int i=0; i<6; i++)
	tmp_float[i] = line[51+i];
      XlogP = atof(tmp_float);

      for(int i_type = 0; i_type < N_arom_type; i_type++)
	{
	  if(strcmp(XlogP_type, XlogP_arom_type[i_type]) == 0)
	    {
	      arom = 1.0;
	    }
	}

      for(int i_atm = 0; i_atm < atom_.size(); i_atm++)
	{
	  if(atom_[i_atm].aSN == atm_idx)
	    {
	      atom_[i_atm].XlogP = XlogP;
	      atom_[i_atm].arom = arom;
	    }
	}

    }
 return 0;
}

//=============================================================
//added by Bingjie Hu (03/01/2014) for hydrogen bond of ligand
//=============================================================
template<class T, class TIn>
void ProcessPDB<T,TIn>::AssignLigandProperties()
{
    AssignElements();
   	AssignHybrid();
    AssignDonorAcceptor();
}

//=============================================================
//added by Bingjie Hu (03/01/2014) for hydrogen bond of ligand
//=============================================================
template<class T, class TIn>
int ProcessPDB<T,TIn>::AssignElements()
{
	int	i;
	
	if(atom_.size()<1){
		return -1;
	}
	
    for(i = 0; i < atom_.size(); i++)
    {
        if(strstr(atom_[i].eleT, "Cl") || strstr(atom_[i].eleT, "CL"))
        {
            atom_[i].element = eCL;
            atom_[i].mass =mCL;
        }
        else if(strstr(atom_[i].eleT, "CA2+") ||
                strstr(atom_[i].eleT, "CA2") ||
                strstr(atom_[i].eleT, "Ca2+"))
        {
            atom_[i].element = eMe3;
            atom_[i].mass =mCA;
        }
        else if(strstr(atom_[i].eleT, "CO2+"))
        {
            atom_[i].element = eMe2;
            atom_[i].mass =mCO;
        }
        else if(strstr(atom_[i].eleT, "CU2+") ||
                strstr(atom_[i].eleT, "CU"))
        {
            atom_[i].element = eMe2;
            atom_[i].mass =mCU;
        }
        else if(strstr(atom_[i].eleT, "ZN2+") ||
                strstr(atom_[i].eleT, "ZN2") ||
                strstr(atom_[i].eleT, "ZN"))
        {
            atom_[i].element = eMe2;
            atom_[i].mass =mZN;
        }
        else if(strstr(atom_[i].eleT, "NA1+"))
        {

            atom_[i].element = eMe3;
            atom_[i].mass =mNA;
        }
        else if(strstr(atom_[i].eleT, "FE") ||
                strstr(atom_[i].eleT, "Fe") ||
                strstr(atom_[i].eleT, "FE2+") ||
                strstr(atom_[i].eleT, "Fe2+") ||
                strstr(atom_[i].eleT, "FE3+") ||
                strstr(atom_[i].eleT, "Fe3+") ||
                strstr(atom_[i].eleT, "FE5+") ||
                strstr(atom_[i].eleT, "Fe5+"))
        {
            atom_[i].element = eMe2;
            atom_[i].mass =mFE;
        }
        else if(strstr(atom_[i].eleT, "Br") || strstr(

        atom_[i].eleT, "BR"))
        {
            atom_[i].element = eBR;
            atom_[i].mass =mBR;
        }
        else if(strstr(atom_[i].eleT, "H"))
        {
            atom_[i].element = eH;
            atom_[i].mass =mH;
        }
        else if(strstr(atom_[i].eleT, "B"))
        {
            atom_[i].element = eB;
            atom_[i].mass =mB;
        }
        else if(strstr(atom_[i].eleT, "C"))
        {
            atom_[i].element = eC;
            atom_[i].mass =mC;
        }
        else if(strstr(atom_[i].eleT, "N"))
        {
            atom_[i].element = eN;
            atom_[i].mass =mN;
        }
        else if(strstr(atom_[i].eleT, "O"))
        {
            atom_[i].element = eO;

            atom_[i].mass =mO;
        }
        else if(strstr(atom_[i].eleT, "F"))
        {
            atom_[i].element = eF;
            atom_[i].mass =mF;
        }
        else if(strstr(atom_[i].eleT, "P"))
        {
            atom_[i].element = eP;
            atom_[i].mass =mP;
        }
        else if(strstr(atom_[i].eleT, "S"))
        {
            atom_[i].element = eS;
            atom_[i].mass =mS;
        }
        else if(strstr(atom_[i].eleT, "I"))
        {
            atom_[i].element = eI;
            atom_[i].mass =mI;
        }
        //printf("%s: element %d, mass %f\n", atom_[i].aName, atom_[i].element, atom_[i].mass);
    }
	return 1;
}
//=============================================================
//added by Bingjie Hu (03/01/2014) for hydrogen bond of ligand
//=============================================================
template<class T, class TIn>
int ProcessPDB<T,TIn>::AssignHybrid()
{
	
	if(atom_.size()<1){
		return -1;
	}
	
    int					i, j, no;
    int					setToSp2, setToSp;

    //hybridization for C
    for(i = 0; i < atom_.size(); i++)
    {
        if(atom_[i].element == eC)	// C atoms
        {
            switch (atom_[i].numBonds)
            {
            case 4:
                atom_[i].hyb = sp3;
                break;
            case 3:
                atom_[i].hyb = sp2;
                break;
            case 2:
            case 1:
                atom_[i].hyb = sp;
                break;
            }
        }
    }

    //hybridization for S
    for(i = 0; i < atom_.size(); i++)
    {
        if(atom_[i].element == eS)	// S atoms
        {
            setToSp2 = 0;
            setToSp = 0;
            for(j = 0; j < atom_[i].numBonds; j++)
            {
                if(atom_[i].bond_[j]->hyb == sp2)
                    setToSp2 = 1;
                else if(atom_[i].bond_[j]->hyb == sp)
                    setToSp = 1;
            }
            switch (atom_[i].numBonds)
            {
            case 4:
                atom_[i].hyb = sp3;
                break;
            case 3:
                atom_[i].hyb = sp2;
            case 2:
                if(setToSp2)
                    atom_[i].hyb = sp2;
                else
                    atom_[i].hyb = sp3;
                break;
            case 1:
                if(setToSp)
                    atom_[i].hyb = sp;
                else if(setToSp2)
                    atom_[i].hyb = sp2;
                else
                    atom_[i].hyb = sp3;
                break;
            }
        }
    }

    //hybridization for N
    for(i = 0; i < atom_.size(); i++)
    {
        if(atom_[i].element == eN)	// N atoms
        {
            setToSp2 = 0;
            setToSp = 0;
            for(j = 0; j < atom_[i].numBonds; j++)
            {
                if(atom_[i].bond_[j]->hyb == sp2)
                    setToSp2 = 1;
                else if(atom_[i].bond_[j]->hyb == sp)
                    setToSp = 1;
            }
            switch (atom_[i].numBonds)
            {
            case 4:
                atom_[i].hyb = sp3;
                break;
            case 3:
                no = 0;
                for(j = 0; j < atom_[i].numBonds; j++)
                    if(atom_[i].bond_[j]->element == eO)
                        no++;
                if(no == 2)		// necessary for aliphatic nitro groups
                    setToSp2 = 1;
                if(setToSp2)
                    atom_[i].hyb = sp2;
                else
                    atom_[i].hyb = sp3;
                break;
            case 2:
                if(setToSp)
                    atom_[i].hyb = sp;
                else if(setToSp2)
                    atom_[i].hyb = sp2;
                else
                    atom_[i].hyb = sp3;
                break;
            case 1:
                atom_[i].hyb = sp;
                break;
            }
        }
    }

    //hybridization for O
    for(i = 0; i < atom_.size(); i++)
    {
        if(atom_[i].element == eO)	// O atoms
        {
            setToSp2 = 0;
            setToSp = 0;
            for(j = 0; j < atom_[i].numBonds; j++)
            {
                if(atom_[i].bond_[j]->hyb == sp2)
                    setToSp2 = 1;
                else if(atom_[i].bond_[j]->hyb == sp)
                    setToSp = 1;
            }
            switch (atom_[i].numBonds)
            {
            case 2:
                if(setToSp2)
                    atom_[i].hyb = sp2;
                else
                    atom_[i].hyb = sp3;
                break;
            case 1:
                if(setToSp)
                    atom_[i].hyb = sp;
                else if(setToSp2)
                    atom_[i].hyb = sp2;
                else
                    atom_[i].hyb = sp3;
                break;
            }
        }
    }

	#ifdef DEBUG
    printf("\nHybridisation:\n");
    for(i = 0; i < atom_.size(); i++)
    {
    	printf("Atom %3d %-4s: hybrid = ",atom_[i].aSN, atom_[i].aName);
    	switch(atom_[i].hyb)
    	{
    		case 0:
    			printf("NoHyb\n");
    			break;
    		case 1:
    			printf("sp\n");
    			break;
    		case 2:
    			printf("sp2\n");
    			break;
    		case 3:
    			printf("sp3\n");
    			break;
    	}
    }
	#endif
	return 1;
}

template<class T, class TIn>
int ProcessPDB<T, TIn>::Assign_arom_to_H()
{
  int i_atm;
  for(i_atm = 0; i_atm < atom_.size(); i_atm++)
    {
      if(atom_[i_atm].element == eH)
	{
	  if(atom_[i_atm].bond_[0]->arom == 1.0)
	    {
	      atom_[i_atm].arom = 1.0;
	    }
	}
    }
  return 1;
}

//=============================================================
// added by Bingjie Hu (03/01/2014) for hydrogen bond of ligand
// modified by W. -H. Shin (9/5/2014):
//  - Definition of hydrogen bond donor moved from heavy atoms
//    to hydrogen
// modified by W. -H. Shin (8/28/2017)
//  - add small value (0.1) to neutral atom
//=============================================================
template<class T, class TIn>
int ProcessPDB<T,TIn>::AssignDonorAcceptor()
{
  int s;
  float hbond;

  // assign acceptor types
  for(s = 0; s < atom_.size(); s++)
    {
      // initialization
      //hbond = 0.1; // small value to neutral atom to fix bug in HB
      hbond = 0.0;

      // check atom type: H or not?
      if(atom_[s].element == eH)
	{ // assign donor type
	  if(atom_[s].bond_[0]->element == eO || atom_[s].bond_[0]->element == eN || atom_[s].bond_[0]->element == eS)
	    {
	      hbond = -1.0;
	    }
	}
      
      else
	{ // assign acceptor type
	  
	  // natype 1: carbonyl ; natype 2: carboxyl ; natype 13: special for nitro group
	  if(atom_[s].element == eO && atom_[s].hyb == sp2 && atom_[s].numBonds == 1)
	    {
	      hbond = 1.0;
	    }
      
	  // natype 3: R-OH; natype 6: H2O; natype 7: R-O-R, R not H
	  else if(atom_[s].element == eO && atom_[s].hyb == sp3 && atom_[s].numBonds == 2)
	    {
	      hbond = 1.0;
	    }
      
	  // natype 3: Ar-OH
	  else if(atom_[s].element == eO && atom_[s].hyb == sp2 && atom_[s].numBonds == 2)
	    {
	      hbond = 1.0;
	    }

	  // natype 3: R-NH(-)
	  else if(atom_[s].element == eN && atom_[s].hyb == sp3 && atom_[s].numBonds == 2)
	    {
	      hbond = 1.0;
	    }
      
	  // natype 4: R-N-R
	  else if(atom_[s].element == eN && atom_[s].hyb == sp2 && atom_[s].numBonds == 2)
	    {
	      hbond = 1.0;
	    }
	  
	  // natype 5: P-O, S-O; natype 9: R-O
	  else if(atom_[s].element == eO && atom_[s].hyb == sp3 && atom_[s].numBonds == 1)
	    {
	      hbond = 1.0;
	    }
	  
	  // natype 8: R-S-R or Ar-S-Ar
	  else if(atom_[s].element == eS && atom_[s].numBonds == 2)
	    {
	      hbond = 1.0;
	    }
      
	  // natype 9: R-S
	  else if(atom_[s].element == eS && atom_[s].hyb == sp3 && atom_[s].numBonds == 1)
	    {
	      hbond = 1.0;
	    }

	  // natype 12: R3-N
	  else if(atom_[s].element == eN && atom_[s].hyb == sp3 && atom_[s].numBonds == 3)
	    {
	      hbond = 1.0;
	    }
	}

      atom_[s].hbond = hbond;
    }
}

// this assumes that the ligand positions are already sorted.
template<class T, class TIn>
int ProcessPDB<T,TIn>::getMinCenMax(vector<float>& _cenX, vector<float>& _cenY,vector<float>& _cenZ)
{
	
	vector<ATOMStruct> tatm;
	vector<int> atmlst;
	if(atom_.size()<5 && hetatm_.size()<5){
		cout << "atm size under 5" << endl;
		return 0;
	}
	if(atom_.size()==0) tatm = hetatm_;
	else tatm = atom_;

	vector<int> inds;
	
	// find farthest pair -----------------------------
	float maxD = -1;
	int ind1 = -1, ind2 = -1;
	for(int i=0; i<tatm.size()-1; i++){
		for(int j=i+1; j<tatm.size(); j++){
			float dist = DIST(tatm[i].x,tatm[i].y,tatm[i].z, tatm[j].x,tatm[j].y,tatm[j].z);
			if(dist>maxD)
			{
				maxD = dist;
				ind1 = i; ind2 = j; 
			}
		}
	}
	
	// find cen
	float tcogx=cog_[0], tcogy=cog_[1], tcogz=cog_[2], count=0;
		int minI=-1;  
		float minD=9999;
		for(int j=0; j<tatm.size(); j++)
		{
			if(j>tatm.size()) break;
			float dist = DIST(tatm[j].x,tatm[j].y,tatm[j].z,tcogx,tcogy,tcogz);
			if(dist<minD)
			{
				minD = dist;
				minI = j; 
			}
		}
		
		
	_cenX.push_back(tatm[ind1].x);	_cenX.push_back(tatm[ind2].x);
	_cenY.push_back(tatm[ind1].y);	_cenY.push_back(tatm[ind2].y);
	_cenZ.push_back(tatm[ind1].z);	_cenZ.push_back(tatm[ind2].z);
	
	tatm[ind1].ATOMprint();	tatm[ind2].ATOMprint();

	_cenX.push_back(tatm[minI].x);
	_cenY.push_back(tatm[minI].y);
	_cenZ.push_back(tatm[minI].z);
	
	tatm[minI].ATOMprint();


#ifdef DEBUG
	cout << _cenX.size() << endl;
	for(int i=0;i<_cenX.size();i++){
		printf ("ATOM      1  C   XXX -   1    %8.3f%8.3f%8.3f  1.00 00.00           C  \n", _cenX[i], _cenY[i], _cenZ[i]);
	}
#endif
	return _cenX.size();
}

template<class T, class TIn>
void ProcessPDB<T,TIn>::printPDB()
{
	if(atom_.size()>0){
		for(int i=0; i<atom_.size(); i++){
			atom_[i].ATOMprint();
		}
	}
	if(hetatm_.size()>0){
		for(int i=0; i<hetatm_.size(); i++){
			hetatm_[i].ATOMprint();
		}
	}
}

template<class T, class TIn>
void ProcessPDB<T,TIn>::printPDB(const char * pdbFN)
{
	FILE * pFile;
	pFile = fopen(pdbFN, "w");
	if(atom_.size()>0){
		for(int i=0; i<atom_.size(); i++){
			atom_[i].ATOMprint(pFile);
		}
	}
	if(hetatm_.size()>0){
		for(int i=0; i<hetatm_.size(); i++){
			hetatm_[i].ATOMprint(pFile);
		}
	}
	fclose(pFile);
}

template<class T, class TIn>
void ProcessPDB<T,TIn>::printPDB(const char * pdbFN, vector<ATOMStruct> _atm)
{
	FILE * pFile;
	pFile = fopen(pdbFN, "w");
	if(_atm.size()>0){
		for(int i=0; i<_atm.size(); i++){
			_atm[i].ATOMprint(pFile);
		}
	}
	fclose(pFile);
}


template<class T, class TIn>
void ProcessPDB<T,TIn>::printCACN()
{
	if(atom_.size()>0){
		for(int i=0; i<atom_.size(); i++){
			char str[5];
			sscanf(atom_[i].aName, "%s", str); 
			if(!strcmp("CA", str) || !strcmp("C", str) || !strcmp("N",str) )
				atom_[i].ATOMprint();
		}
	}
	if(hetatm_.size()>0){
		for(int i=0; i<hetatm_.size(); i++){
			char str[5];
			sscanf(atom_[i].aName, "%s", str); 
			if(!strcmp("CA", str) || !strcmp("C", str) || !strcmp("N",str) )
				hetatm_[i].ATOMprint();
		}
	}
}


template<class T, class TIn>
void ProcessPDB<T,TIn>::printCACN( vector<ATOMStruct> _atm )
{
	if(_atm.size()>0){
		for(int i=0; i<_atm.size(); i++){
			if(!strcmp("CA", _atm[i].aName) || !strcmp("C", _atm[i].aName) || !strcmp("N",_atm[i].aName) )
				_atm[i].ATOMprint();
		}
	}
}

template<class T, class TIn>
void ProcessPDB<T,TIn>::printCACN(const char * pdbFN, vector<ATOMStruct> _atm )
{
	
 	vector<ATOMStruct> tmpAtm;
	if(_atm.size()>0){
		for(int i=0; i<_atm.size(); i++){
			if(!strcmp("CA", _atm[i].aName) || !strcmp("C", _atm[i].aName) || !strcmp("N",_atm[i].aName) )
					tmpAtm.push_back(_atm[i]);
		}
	}
	
	if(tmpAtm.size()>0){
		FILE *pFile; 
		pFile = fopen(pdbFN, "w");
		for(int i =0; i<tmpAtm.size(); i++)
			tmpAtm[i].ATOMprint(pFile);
		fclose(pFile); 
	}

}




template<class T, class TIn>
int ProcessPDB<T,TIn>::Seperate4LigPlot(const char* _pdbID)
{
	cout << _pdbID << endl;

	ofstream outFile("ligstat_pdb.lst");

	char receptorFN[10];
	strcpy(receptorFN, _pdbID);
	strcat(receptorFN, "_rep.pdb");
	cout << _pdbID << " "<< receptorFN << endl;
	outFile << _pdbID << " " << receptorFN << endl;

	FILE *repFile; 
	repFile = fopen(receptorFN, "w");
	if(atom_.size()>0){
		for(int i=0; i<atom_.size(); i++){
			atom_[i].ATOMprint(repFile);
		}
	}
	fclose(repFile); 
	
	int pre_rSN = 0;
	int lignum = 0;
	FILE *ligFile = NULL;

	vector<vector<int> > LigInd2d;
	vector<int> LigInd1d;
	vector< string > LigFN; 

	if(hetatm_.size()>0){
		for(int i=0; i<hetatm_.size(); i++){
			char ligID[3];
			sscanf(hetatm_[i].AA,"%s", ligID); 
			if(strcmp(ligID,"HOH")){
				if(pre_rSN != hetatm_[i].rSN){
				 	if(lignum!=0) 
						LigInd2d.push_back(LigInd1d); 
					// if(ligFile!=NULL){ fclose(ligFile); }
					LigInd1d.clear();
					lignum++;

					string tmpS;
					tmpS.assign(_pdbID);
					LigFN.push_back(tmpS);
		
					// cout << ligFN << endl;
			
					// ligFile = fopen(ligFN, "w");				
				}				
				// hetatm_[i].ATOMprint(ligFile);		
				pre_rSN = hetatm_[i].rSN;
				LigInd1d.push_back(i);
			}
		} 
		if(lignum>0) LigInd2d.push_back(LigInd1d);

		cout << LigInd2d.size() << endl;
		for(int i=0; i< LigInd2d.size(); i++){
			char ligFN[64];  
			char numbuf[10];
			sprintf(numbuf, "%i", i+1);
			ligFN[0]=LigFN[i][0]; ligFN[1]=LigFN[i][1]; 
			ligFN[2]=LigFN[i][2]; ligFN[3]=LigFN[i][3];
			ligFN[4]='\0';
			strcat(ligFN,"_lig");
			strcat(ligFN, numbuf);
			strcat(ligFN, ".pdb");

			outFile << hetatm_[LigInd2d[i][0]].AA << " " << ligFN << endl;			
		
			ligFile = fopen(ligFN, "w");	
			fprintf(ligFile, "REMARK %s %s %d %c ", _pdbID, hetatm_[LigInd2d[i][0]].AA, hetatm_[LigInd2d[i][0]].rSN,  hetatm_[LigInd2d[i][0]].chain );
			for(int j=0; j<LigInd2d[i].size(); j++){
				fprintf(ligFile, "%s ", hetatm_[LigInd2d[i][j]].aName);	
			}
			fprintf(ligFile,"\n");

			for(int j=0; j<LigInd2d[i].size(); j++){
				hetatm_[LigInd2d[i][j]].ATOMprint(ligFile);		
			}
			fclose(ligFile);
		}

	}

	outFile.close();;

	return lignum; 
}



template<class T, class TIn>
void ProcessPDB<T,TIn>::SeperateCACNbyChain(const char* _pdbID)
{
	// discard HETATM
	char pdbFN[10]; 
	char prevChain = '*';
 	vector<ATOMStruct> _atm;
	_atm.clear();
	for (int i=0; i<atom_.size(); i++){
		if(atom_[i].chain != prevChain && prevChain != '*')
		{
			strcpy(pdbFN,_pdbID);
			char tmp[6]; 
			tmp[0] = prevChain;
			tmp[1] ='.';tmp[2]='p';tmp[3]='d';tmp[4]='b';tmp[5]='\0';
			strcat(pdbFN, tmp);
#ifdef DEBUG
	cout << "output file name: " << pdbFN << endl;
#endif
			printCACN(pdbFN, _atm);
			_atm.clear();
		}
		_atm.push_back(atom_[i]);
		prevChain = atom_[i].chain; 	
	}
	
	strcpy(pdbFN,_pdbID);
	char tmp[6]; 
	tmp[0] = prevChain;
	tmp[1] ='.';tmp[2]='p';tmp[3]='d';tmp[4]='b';tmp[5]='\0';
	strcat(pdbFN, tmp);
#ifdef DEBUG
	cout << "output file name: " << pdbFN << endl;
#endif
	printCACN(pdbFN, _atm);
	_atm.clear();

}

/*
 * given list of atoms, 
 * find and outputs the residues that is closes (threshold) to the
 * given list of atoms to the stored atom list.
 * return 1 if successful
 */
template<class T, class TIn>
int ProcessPDB<T,TIn>::GetCloseRes(vector<ATOMStruct> _atm, double _thresh=5.0 )	
{
	if(_atm.size()<=0 || atom_.size()<=0) return 0;
	vector<int> closeResNum; 

	cout << "Close residue within "<< _thresh << ": ";
	for (int i=0; i<atom_.size(); i++)
	{
		for (int j=0; j<_atm.size(); j++)
		{
			double dist = DIST(atom_[i].x,atom_[i].y,atom_[i].z, _atm[j].x,_atm[j].y,_atm[j].z);
			if(dist < _thresh )
			{
				closeResNum.push_back(atom_[i].rSN);
				cout << atom_[i].AA << "("<< atom_[i].rSN << ") ";
				break;
			}
		}	
	}
	cout << endl; 
	return 1;

}


/*
 * given list of atoms, 
 * find and outputs the residues that is closes (threshold) to the
 * given list of atoms to the stored atom list.
 * return 1 if successful
 */
template<class T, class TIn>
int ProcessPDB<T,TIn>::GetCloseRes(const char *pdbID, vector<ATOMStruct> _atm, double _thresh=5.0 )	
{
	if(_atm.size()<=0 || atom_.size()<=0) return 0;
	vector<int> closeResNum; 
	for (int i=0; i<atom_.size(); i++)
	{
		for (int j=0; j<_atm.size(); j++)
		{
			double dist = DIST(atom_[i].x,atom_[i].y,atom_[i].z, _atm[j].x,_atm[j].y,_atm[j].z);
			if(dist < _thresh )
			{
				closeResNum.push_back(atom_[i].rSN);
				break;
			}
		}	
	}

	if(closeResNum.size() > 5)
	{
		// file nameing
		char recepFN[64]; 
		strcpy(recepFN, pdbID);
		strcat(recepFN, "_lc");
		strcat(recepFN,".pdb");

		cout << recepFN << endl;

		FILE * recepF;
		recepF = fopen(recepFN, "w");
		if(recepF == NULL) perror ("Error opening file\n");
		
		for(int j=0; j<atom_.size();j++)
		{
			int found = 0;
			for(int k=0; k<closeResNum.size(); k++)
			{
				if(atom_[j].rSN == closeResNum[k]) 
				{ 
						found = 1;			break;
				}
			}
			if(found) atom_[j].ATOMprint(recepF); 
		}
		fclose(recepF);
		
		return 1;
	}

	return 0;

}

/*
 * given list of atoms, 
 * find and outputs the chain that is closest to the
 * given list of atoms to the stored atom list.
 * return 1 if successful
 */
template<class T, class TIn>
int ProcessPDB<T,TIn>::GetClosestHet(const char *pdbID, vector<ATOMStruct> _atm)	
{
	if(_atm.size()<=0 || hetatm_.size()<=0) return 0;
	double minDist = 99999;
	int minInd = 0;
	for (int i=0; i<_atm.size(); i++)
	{
		for (int j=0; j<hetatm_.size(); j++)
		{
			double dist = DIST(_atm[i].x,_atm[i].y,_atm[i].z, hetatm_[j].x,hetatm_[j].y,hetatm_[j].z);
			if(dist <minDist )
			{
				minDist = dist;
				minInd = j; 
			}
		}	
	}

	if(minDist < 10)
	{
		char chainID = hetatm_[minInd].chain; 
		// file nameing
		char recepFN[64]; 
		char chainbuf[2]; chainbuf[0]=chainID; chainbuf[1]='\0';
		strcpy(recepFN, pdbID);
		strcat(recepFN, "_");
		strcat(recepFN, hetatm_[minInd].AA);
		strcat(recepFN,".pdb");

		cout << recepFN << endl;

		FILE * recepF;
		recepF = fopen(recepFN, "w");
		if(recepF == NULL) perror ("Error opening file\n");
		
		for(int j=0; j<hetatm_.size();j++)
		{
			if(hetatm_[j].chain == chainID)
			{ hetatm_[j].ATOMprint(recepF); }
		}
		fclose(recepF);
		
		return 1;
	}

	return 0;

}



/*
 * given list of atoms, 
 * find and outputs the chain that is closest to the
 * given list of atoms to the stored atom list.
 * return 1 if successful
 */
template<class T, class TIn>
int ProcessPDB<T,TIn>::GetClosestChain(const char *pdbID, vector<ATOMStruct> _atm)	
{
	if(_atm.size()<=0 || atom_.size()<=0) return 0;
	double minDist = 99999;
	int minInd = 0;
	for (int i=0; i<_atm.size(); i++)
	{
		for (int j=0; j<atom_.size(); j++)
		{
			double dist = DIST(_atm[i].x,_atm[i].y,_atm[i].z, atom_[j].x,atom_[j].y,atom_[j].z);
			if(dist <minDist )
			{
				minDist = dist;
				minInd = j; 
			}
		}	
	}

	if(minDist < 10)
	{
		char chainID = atom_[minInd].chain; 
		// file nameing
		char recepFN[64]; 
		char chainbuf[2]; chainbuf[0]=chainID; chainbuf[1]='\0';
		strcpy(recepFN, pdbID);
		strcat(recepFN, "_");
		strcat(recepFN, chainbuf);
		strcat(recepFN,".pdb");

		cout << recepFN << endl;

		FILE * recepF;
		recepF = fopen(recepFN, "w");
		if(recepF == NULL) perror ("Error opening file\n");
		
		for(int j=0; j<atom_.size();j++)
		{
			if(atom_[j].chain == chainID)
			{ atom_[j].ATOMprint(recepF); }
		}
		fclose(recepF);
		
		return 1;
	}

	return 0;

}

/*
 * LigCluster: 
 *	0. cluster HETATMs excluding water
 *  1. determins if the pdb has binding ligand that any ligand HETATM is within 3.5
 * 	2. extracts clusters of HETATM (excl1uding water) in pdbfile
 *	3. extracts chains of ATOMs that HETATM are bounded to 
 * Output: 
 * 	Receptor : pdbID_chainID.pdb 
 * 							(pdbID is lowercase and chainID upper 
 * 							 no chain then use "-")
 * 	Ligand   : pdbID_chianID_ligand#.pdb
 * 						 (chainID should be the chain IDB of the receptior the ligand binds to)
 * Returns : number of Ligand clusters. 
 */
template<class T, class TIn>
int ProcessPDB<T,TIn>::LigCluster( const char* _pdbID, double _clusT = 4, int _HANum = 7 )
{
	const double covDist = 1.4;   
	// check if the ligand size is too small
	if(hetatm_.size()<_HANum) return 0;

  vector<ATOMStruct> newHet;
	vector<vector <ATOMStruct> > sepLig;   	// seperated ligand by resdiue sequence number chain combination 
	vector<vector <ATOMStruct> > HetClust; 	// clusters of ligands
	
	//0. Remove water and Hydrogen atoms from the hetatm_ list
	for (int i=0; i<hetatm_.size(); i++)
	{
		if(strcmp(hetatm_[i].AA,"HOH")!=0)
			if(	 !(hetatm_[i].aName[0]=='H'
				|| (hetatm_[i].aName[0]==' ' && hetatm_[i].aName[1]=='H') 
				|| (hetatm_[i].aName[0]==' ' && hetatm_[i].aName[1]==' ' && hetatm_[i].aName[2]=='H')
				|| (hetatm_[i].aName[0]==' ' && hetatm_[i].aName[1]==' ' && hetatm_[i].aName[2]=='H'  && hetatm_[i].aName[3]=='H')) )
				newHet.push_back(hetatm_[i]);	
	}
#ifdef DEBUG_LC
	for (int i=0; i<newHet.size(); i++)
	{
		newHet[i].ATOMprint();
	}
#endif
	
	// check if ligand size is too small 
	if(newHet.size()<_HANum) return 0;

	//1. Seperate HETATMs by same residue sequence number and chain combination
	int count=-1;
	int prevRSN=-1; char prevCH=' ';
	sepLig.resize(newHet.size());
	for (int i=0; i<newHet.size(); i++)
	{
		if(newHet[i].rSN != prevRSN || newHet[i].chain != prevCH ){
			count++;
		}
		sepLig[count].push_back(newHet[i]);
		prevRSN = hetatm_[i].rSN;
		prevCH = hetatm_[i].chain;
	}
	sepLig.resize(count+1);

#ifdef DEBUG_LC
	for (int i=0; i<sepLig.size(); i++)
	{
		cout << "Ligand  " << i << endl;
		for (int j=0; j<sepLig[i].size(); j++){
			(sepLig[i][j]).ATOMprint();
		}
	}
#endif
	
	// move covalently bound ligand
	int change = 0;
	do{
		change = 0;
		for (int i=0; i<sepLig.size(); i++)
		{
			int found = 0;
			if(strcmp(sepLig[i][0].AA, "MSE") == 0){ found =1; }
			else{
				for (int j=0; j<sepLig[i].size(); j++)
				{
					for (int k=0; k<atom_.size(); k++)
					{		
						double dist = DIST(atom_[k].x, atom_[k].y,atom_[k].z, sepLig[i][j].x, sepLig[i][j].y, sepLig[i][j].z);	
						if( dist < covDist ){ found = 1; break; }
					}
					if(found){ break;	}
				}
			}

			if(found)
			{
				for (int j=0; j<sepLig[i].size(); j++)
				{
					atom_.push_back(sepLig[i][j]);
					atmIDmap_[(atom_.back()).aSN] = atom_.back();
					resIDmap_[(atom_.back()).rSN] = atom_.back();
				}
				sepLig.erase(sepLig.begin()+i);
				change = 1;
				i--;
			}

		}
	}while(change && sepLig.size()>0);


	// remove ligand if too small 
	for (int i=0; i<sepLig.size(); i++)
	{
		if( sepLig[i].size() < _HANum ){
			sepLig.erase(sepLig.begin()+i);
			i--;
		}
	}

#ifdef DEBUG_LC
	for (int i=0; i<sepLig.size(); i++)
	{
		cout << "Ligand  " << i << endl;
		for (int j=0; j<sepLig[i].size(); j++){
			(sepLig[i][j]).ATOMprint();
		}
	}
#endif

 	// 2. Clusters of HETATMs by distance 
	int HCnum = 0;
	if(sepLig.size() == 0){
		return 0;
	}else if(sepLig.size() == 1) 
	{
		HetClust.resize(1);	
		for(int i=0; i<sepLig[0].size(); i++){ 
			HetClust[0].push_back( sepLig[0][i] );
		}
		sepLig.erase(sepLig.begin());
	}else
	{
		HetClust.resize(sepLig.size()); 
		for(int i=0; i<sepLig[0].size(); i++){ 
			HetClust[0].push_back(sepLig[0][i]);
		}
		sepLig.erase(sepLig.begin());

		while( sepLig.size()>0 )
		{ 
//			cout << "sepLig size: "  << sepLig.size() << endl;
			int removed = 0;
			if(sepLig.size()==0) break;
			for(int i=0; i<sepLig.size(); i++)	
			{		
				int found = 0;
				if(sepLig.size()==0) break;
				for(int j=0; j<sepLig[i].size(); j++)
				{
					for(int k=0; k<HetClust.size(); k++)
					{	
						for(int l=0; l<HetClust[k].size(); l++)
						{
							float dist = DIST(sepLig[i][j].x, sepLig[i][j].y,sepLig[i][j].z, HetClust[k][l].x, HetClust[k][l].y, HetClust[k][l].z); 
							if(dist<_clusT)	
							{
								// add seplig to HetClus and remove fromm seplig
#ifdef DEBUG_LC
cout << "ligand number " << i << " pushed to Cluster " << k 
			<< " with dist " << dist << " cindex " << l << " lindex " << j << endl;
cout << "DIST(" << sepLig[i][j].x<< "," <<sepLig[i][j].y<<"," <<sepLig[i][j].z
			<<","<< HetClust[k][l].x<<","<< HetClust[k][l].y<<","<< HetClust[k][l].z << endl;
#endif
								for(int m = 0; m<sepLig[i].size();m++)
								{	 
									HetClust[k].push_back(sepLig[i][m]);			
								}
								sepLig.erase(sepLig.begin()+i);
								i--;
								// and break out of 3 loops 
								found=1;
								removed++;
							}
							if(found) break;  // break out of l
						}
						if(found) break;  // break out of k
					}
					if(found) break;		// break out of j
				}
			}
			
			// start new cluster and add in the first seperate ligand	
			if(removed == 0 && sepLig.size() > 0)
			{
//				cout << sepLig[0].size() << " " << HetClust[HCnum].size() << endl;
				HCnum++;
				for(int m = 0; m<sepLig[0].size(); m++)
				{
					HetClust[HCnum].push_back( sepLig[0][m] );  
				}
				sepLig.erase(sepLig.begin());
				if(sepLig.size()==0) break;
			}

 		}		// end while loop

	}		// end cluster condition 
	HetClust.resize(++HCnum);

#ifdef DEBUG_LC
	for (int i=0; i<HetClust.size(); i++)
	{
		cout << "HetClust  " << i  << " clustD(" <<_clusT << ")"<< endl;
		for (int j=0; j<HetClust[i].size(); j++){
			(HetClust[i][j]).ATOMprint();
		}
	}
#endif

	// 3V2. extracts all chains of ATOMs that HETATM are bounded to 
	// 		and remove covalently bound HETATM (move them to ATOMs)
	vector<char> closeChain;
	closeChain.resize(HetClust.size());
	int ligNum = 0;
	for (int i=0; i<HetClust.size(); i++)
	{
		if(HetClust[i].size() < _HANum) continue;
		vector<char> chainLST; 		
		vector<float> minDistHA; 	// variable to store how many hetatms are close to receptor atms.
		minDistHA.clear(); minDistHA.resize(HetClust[i].size(), 100);
		for (int k=0; k<atom_.size(); k++)
		{	
			for (int j=0; j<HetClust[i].size(); j++)
			{
				double dist = DIST(atom_[k].x, atom_[k].y,atom_[k].z, HetClust[i][j].x, HetClust[i][j].y, HetClust[i][j].z);	
				// store min distance info 
				if(minDistHA[j]>dist) minDistHA[j] = dist; 
				
				// find close by chain 
				if( dist>=1.4 && dist < 3.5 )
				{
					if(chainLST.size()==0)
					{
						chainLST.push_back(atom_[k].chain);
					}else{
						int indfound=0;
						for(int l=0; l<chainLST.size();l++)
						{
							if( chainLST[l] == atom_[k].chain ){indfound=1;}
						}
						if(indfound==0) chainLST.push_back(atom_[k].chain);
					}
				}
				// break out of HET loop if distance too large 
				if( dist > 30 ){	break; }
			}	
		}			// end finding close chains

#ifdef DEBUG_LC
cout << "Cluster Number " << i << " "; 
for (int j=0; j<HetClust[i].size(); j++)
{
		cout << HetClust[i][j].rSN << " " <<  minDistHA[j] << " ";
}	
cout << endl;
#endif

		// A. Remove not bound ligands
			int remove = 0; int prevrSN = 0; int ct = 0; int ta = 0; int prevIndex = 0;
			prevrSN = HetClust[i][0].rSN;
			vector<char> HCresT; 					// ligand residue type in each Hetclust 
			vector<int>	 atmNum; 					// number of atoms in one ligands
			vector<int>	TresN; 						// ligand residue number in each HetClust
			int jj = 0;
			for (int j=0; j<HetClust[i].size(); j++)
			{
					if( prevrSN == HetClust[i][j].rSN )
					{
						if(minDistHA[j] < 4.0) { ct++; } ta++;
					}					
					if( prevrSN != HetClust[i][j].rSN || j == HetClust[i].size()-1) 
					{
#ifdef DEBUG_LC
cout << HetClust[i][j-1].rSN << " ct/ta: " << (float)ct << "/"  <<(float)ta << endl;				
#endif
						// at least 25% is in close contact with receptor or there is covalently bound atom 						
						if( ((float)ct/(float)ta < 0.3 && ta>3))							
						{ //remove the ligand from cluster
#ifdef DEBUG_LC
cout << "remove " << HetClust[i][prevIndex].aSN << " to " << 	HetClust[i][j].aSN << endl; 		
#endif 
							if(j == HetClust[i].size()-1){
								HetClust[i].erase(HetClust[i].begin()+prevIndex, HetClust[i].end());
								minDistHA.erase(minDistHA.begin()+prevIndex, minDistHA.end());
							}else{
								HetClust[i].erase(HetClust[i].begin()+prevIndex, HetClust[i].begin()+j);
								minDistHA.erase(minDistHA.begin()+prevIndex, minDistHA.begin()+j);
							}
								j = j-ta-1; 
						}else{
								if( TresN.size() == 0 || TresN[TresN.size()-1] != HetClust[i][j-1].rSN ){
#ifdef DEBUG_LC
cout << "PUSH " << HetClust[i][j-1].rSN << endl; 		
#endif 
								HCresT.push_back(HetClust[i][j-1].AA[0]);
								HCresT.push_back(HetClust[i][j-1].AA[1]);
								HCresT.push_back(HetClust[i][j-1].AA[2]);
								atmNum.push_back(ta);
								TresN.push_back(HetClust[i][j].rSN);
							}
						}
						ta = 0; ct = 0;
						prevIndex = j;
					}
					prevrSN = HetClust[i][j].rSN; 
					jj = j;
			}

			// last part of the loop
			if((float)ct/(float)ta < 0.3 && ta>3)		// at least 25% is in close contact with receptor 
			{ //remove the ligand from cluster
				HetClust[i].erase(HetClust[i].begin()+prevIndex, HetClust[i].begin()+prevIndex+ta);
//cout << "remove from " << prevIndex << " to " << prevIndex+ta << endl; 			
			}else{
				HCresT.push_back(HetClust[i][HetClust[i].size()-1].AA[0]);
				HCresT.push_back(HetClust[i][HetClust[i].size()-1].AA[1]);
				HCresT.push_back(HetClust[i][HetClust[i].size()-1].AA[2]);
				atmNum.push_back(ta);
			}
		

#ifdef DEBUG_LC
	for (int l=0; l<HetClust.size(); l++)
	{
		cout << "HetClust  " << l  << " clustD(" <<_clusT << ")"<< endl;
		for (int j=0; j<HetClust[l].size(); j++){
			(HetClust[l][j]).ATOMprint();
		}
	}
#endif

		// see if there is still at least one ligand that is larger than _HANum
		int foundLL = 0; 
		for (int j=0; j< atmNum.size(); j++){ if(atmNum[j]>=_HANum) foundLL++; 	}
//cout << " Found Large Lig : " << foundLL << endl;
		// print the chain and ligand. 
		if( foundLL>0 && chainLST.size()>0 && HetClust[i].size()>=_HANum) 
		{
			ligNum++;
			// file nameing
			char recepFN[64]; 
			char ligFN[64];
			char numbuf[10];
			char chainbuf[chainLST.size()];
			for(int is=0; is<chainLST.size();is++){ chainbuf[is]=chainLST[is]; }
			chainbuf[chainLST.size()]='\0';
			sprintf(numbuf, "%i", ligNum);
				
			strcpy(ligFN, _pdbID);
			strcat(ligFN, "_");
			strcat(ligFN, chainbuf);
			strcat(ligFN, "_");
			strcat(ligFN, numbuf);
			strcat(ligFN,".pdb");
			
			strcpy(recepFN, _pdbID);
			strcat(recepFN, "_");
			strcat(recepFN, chainbuf);
			strcat(recepFN,".pdb");

			FILE * recepF;
			recepF = fopen(recepFN, "w");
			if(recepF == NULL) perror ("Error opening file\n");
			for(int j=0; j<atom_.size();j++)
			{
				int printA = 0;
				for(int k=0; k<chainLST.size(); k++)
				{
					if(atom_[j].chain == chainLST[k] )
					{ printA = 1; break;	}
				}
					if(printA) atom_[j].ATOMprint(recepF);
			}
			fclose(recepF);
		
			FILE * ligF;
			ligF = fopen(ligFN, "w" );
			if(ligF == NULL) perror ("Error opening file\n");
			for(int j=0; j<HetClust[i].size();j++){
				HetClust[i][j].ATOMprint(ligF);
			}
			fclose(ligF);
	
			cout << recepFN << " " << ligFN << " "; 
			int hc=0;
			if(HCresT.size()>3){ 
				for(hc=0; hc<HCresT.size()-3; hc+=3){
					cout << HCresT[hc];
					if(HCresT[hc+1] != '\0'){ 
						cout << HCresT[hc+1];
						if(HCresT[hc+2] != '\0')	cout << HCresT[hc+2]; 
					}
					cout << " "; 
				}
			}
			cout << HCresT[hc];
			if(HCresT[hc+1] != '\0'){ 	
				cout << HCresT[hc+1];
				if(HCresT[hc+2] != '\0')	cout << HCresT[hc+2]; 
			}
			cout << endl; 


		} 	// end print output 

	}		// end part 3
	
	return ligNum;
}


template<class T, class TIn>
int ProcessPDB<T,TIn>::InterfaceSeq(const char* _pdbID, double interT)
{

	int seqNum = 0;
	vector<int> check; check.resize(atom_.size(), 0);
	for( int i=0; i< hetatm_.size(); i++ ){
		for( int j=0; j< atom_.size(); j++ ){
			if(atmDist(hetatm_[i], atom_[j]) < interT){
				check[j]++;	
			}
		}
	}
	
	char pdbFN[15];
	strcpy(pdbFN, _pdbID);
	strcat(pdbFN, ".fasta");
	FILE *outFile;
	outFile = fopen(pdbFN, "w");
	ResidueStruct rsMap; 
	rsMap.init();
	fprintf(outFile,">> %s ; %s pocket\n", _pdbID, hetatm_[0].AA );
	int preRSN = 0;
	for(int i=0; i<check.size(); i++){
		if(check[i]>0 && preRSN != atom_[i].rSN){
			char tmp[3]; 
			tmp[0]=atom_[i].AA[0]; tmp[1]=atom_[i].AA[1]; tmp[2]=atom_[i].AA[2];
			fprintf(outFile, "%c", rsMap.aa1[atom_[i].AA]);
			seqNum++;
		}
		preRSN = atom_[i].rSN;
	}
	fprintf(outFile, "\n");

	fprintf(outFile,">> %s ; %s all\n", _pdbID, hetatm_[0].AA );
	preRSN = 0;
	for(int i=0; i<check.size(); i++){
		if(check[i]>0 && preRSN != atom_[i].rSN ){
			fprintf(outFile, "%c", rsMap.aa1[atom_[i].AA]);
		}else if( preRSN != atom_[i].rSN ){
			fprintf(outFile, "X");
		}
		preRSN = atom_[i].rSN;
	}
	fprintf(outFile, "\n");
	fclose(outFile);
	
	return seqNum;

}


template<class T, class TIn>
int ProcessPDB<T,TIn>::GetFasta(const char* _pdbID, const char _chainID='?')
{
	// fasta sequence and pdb chain extraction 
	char pdbFN[15]; char fastaFN[15];
	strcpy(pdbFN, _pdbID);
	if(_chainID!='?'){
		char chainbuf[2]; chainbuf[0]=_chainID; chainbuf[1]='\0';
		strcat(pdbFN, chainbuf);
	}
	strcpy(fastaFN, pdbFN);
	strcat(pdbFN, ".pdb");
	strcat(fastaFN, ".fasta");

	FILE *outFile1, *outFile2;
	outFile1 = fopen(fastaFN, "w");
	outFile2 = fopen(pdbFN, "w");
	fprintf(outFile1,">> %s %c \n", _pdbID, _chainID );
	ResidueStruct rsMap; 
	rsMap.init();
	int prevRSN = 0; int countR = 0;
	for(int i=0; i<atom_.size(); i++)
	{
		if( _chainID == '?' || atom_[i].chain == _chainID )
		{
			if(prevRSN != atom_[i].rSN){ 
				char tmp[3]; 
				tmp[0]=atom_[i].AA[0]; tmp[1]=atom_[i].AA[1]; tmp[2]=atom_[i].AA[2];
				fprintf(outFile1, "%c", rsMap.aa1[atom_[i].AA]);
				countR++;
			}
			prevRSN = atom_[i].rSN;
			atom_[i].ATOMprint(outFile2);	
		}
	}
	fprintf(outFile1, "\n");	fprintf(outFile2, "\n");
	fclose(outFile1); 				fclose(outFile2);

	return countR;
}


// given raw pdb, with parameters pdbID and chainID
// output pdb chain and ligand that is bound to the pdbchain in pdbfile format and fasta seq
template<class T, class TIn>
int ProcessPDB<T,TIn>::GetCloseLig(const char* _pdbID, const char _chainID, float _percent=0.3, int _count=5 )
{
	int foundLig = 0;
	if(atom_.size() < 50 || hetatm_.size()<3)	return 0;

	vector<ATOMStruct> _selatm;
	// fasta sequence and pdb chain extraction 
	char pdbFN[15]; char fastaFN[15];
	char chainbuf[2]; chainbuf[0]=_chainID; chainbuf[1]='\0';
	strcpy(pdbFN, _pdbID);
	strcat(pdbFN, chainbuf);
	strcpy(fastaFN, pdbFN);
	strcat(pdbFN, ".pdb");
	strcat(fastaFN, ".fasta");

	FILE *outFile1, *outFile2;
	outFile1 = fopen(fastaFN, "w");
	outFile2 = fopen(pdbFN, "w");
	fprintf(outFile1,">> %s %c \n", _pdbID, _chainID );
	ResidueStruct rsMap; 
	rsMap.init();
	int prevRSN = 0;
	for(int i=0; i<atom_.size(); i++)
	{
		if( atom_[i].chain == _chainID )
		{
			if(prevRSN != atom_[i].rSN){ 
				char tmp[3]; 
				tmp[0]=atom_[i].AA[0]; tmp[1]=atom_[i].AA[1]; tmp[2]=atom_[i].AA[2];
				fprintf(outFile1, "%c", rsMap.aa1[atom_[i].AA]);
			}
			prevRSN = atom_[i].rSN;
			atom_[i].ATOMprint(outFile2);	
			_selatm.push_back(atom_[i]);
		}
	}
	fprintf(outFile1, "\n");	fprintf(outFile2, "\n");
	fclose(outFile1); 				fclose(outFile2);
	

	// ligand pdb extraction
	int prevrSN = 0, prevaSN = 0, countaN = 0, countClose = 0; 	
	for (int i=0; i<hetatm_.size(); i++)
	{
		if( strcmp(hetatm_[i].AA, "HOH" )==0) continue;
		if( prevrSN != hetatm_[i].rSN )
		{
			if( countaN > 3 && ( countClose/countaN > _percent || countClose > _count )){
				// output ligand
				char ligFN[15]; 
				char chainbuf[2]; chainbuf[0]=hetatm_[i-1].chain; chainbuf[1]='\0';
				strcpy(ligFN, _pdbID);
				strcat(ligFN, chainbuf);
				strcat(ligFN, "_");
				strcat(ligFN, hetatm_[i-1].AA);
				strcat(ligFN, ".pdb");

				FILE *outFile3;
				outFile3 = fopen(ligFN, "w");
				cout << pdbFN << "-" <<  ligFN << endl;
				for (int j=i-countaN; j<i; j++)
				{
					 hetatm_[j].ATOMprint(outFile3);	
				}
				fclose(outFile3); 	
				}
			countaN = 0; countClose = 0; 	
		}else{
			countaN++; 
			int found = 0;
			for (int k=0; k<_selatm.size(); k++)
			{
				float dist = atmDist(_selatm[k], hetatm_[i]); 
				if(dist < 4.5){ found=1; break; }
			}
			if(found)	countClose++;
		}
		
		prevrSN = hetatm_[i].rSN;
		prevaSN = hetatm_[i].aSN;
	}

	return foundLig;
}

template<class T, class TIn>
int ProcessPDB<T,TIn>::getAtm( vector<ATOMStruct> &_atom, int _type=ALLATOM )
{
	if(_type != HETATM)
	{
		_atom.clear(); 
		for(int i=0; i < atom_.size(); i++)
		{
			char str[5];
			sscanf(atom_[i].aName, "%s", str); 
			if(!strcmp(str, "CA")){
					_atom.push_back(atom_[i]);
			}else if(!strcmp(str, "C") || !strcmp(str, "N")){
				if(_type != CA )
					_atom.push_back(atom_[i]);
			}else if(!strcmp(str, "O") ){
				if(_type != CA && _type != CACN ) 
					_atom.push_back(atom_[i]);
			}else if(str[0] != 'H'){
				if(_type == ALLATOM)
					_atom.push_back(atom_[i]);
			}
		}
	}else{
		_atom.clear(); 
		for(int i=0; i < hetatm_.size(); i++) 
		{
			if(hetatm_[i].aName[0] != 'H'){
				_atom.push_back(hetatm_[i]);
			}
		}
	}
	return _atom.size();
}



