/*============================================
 *
 * Sael Lee 
 * May 21, 2008
 *
 *===========================================*/

#ifndef PROCESS_LOCAL__H
#define PROCESS_LOCAL__H

// ---- local program includes ----
using namespace std;
#include "ZernikeDescriptor.h"
#include "Common.h"
#include "Apbs2DX.h"

template<class T, class TIn>
class ProcessLocal
{
	public:
		// ---------------------- typedefs -------------------------------------- 
    typedef vector<T>          				 				T1D;
		typedef vector<T1D>												T2D;
		
		//--------------------- Constructors ------------------------------------
		ProcessLocal ();

		ProcessLocal (
				int _type,	
				T* _voxels, 				
				int _dim,															// dimension is $_dim^3
				int _order,														// maximal order o
				TIn _radius,													// radius of local sphere
				T* _seedGrid													// critical points given
			);
		
			ProcessLocal (
				int _type,
				T* _voxels, 				
				int _dim,															// dimension is $_dim^3
				int _order,														// maximal order o
				TIn _radius,													// radius of local sphere
				vector<TIn> &_seed											// critical points given
			);
		
		ProcessLocal (
				int _type,
				T* _voxels, 				
				int _dim,															// dimension is $_dim^3
				int _order,														// maximal order o
				TIn _radius,													// radius of local sphere
				const char* _fseed										// critical points given
			);
		
		ProcessLocal (
				int _type,	
				const char* _fvoxels, 				
				int _order,														// maximal order o
				TIn _radius,													// radius of local sphere
				const char* _fseed										// critical points given
			);
	
		ProcessLocal (
				int _type,
				T* _voxels, 											
				int _dim,															// dimension is $_dim^3
				int _order,														// maximal order o
				TIn _radius														// radius of local sphere			
				);
		
		ProcessLocal (
				int type_, 
				const char*_SeedListFN, 
				VolumeDX<T,TIn> &_dx, 
				int _order, 
				TIn _radius
				);
	
		ProcessLocal (
				int type_, 
				SeedVec<T,TIn> &_SeedVec, 
				VolumeDX<T,TIn> &_dx, 
				int _order, 
				TIn _radius													// radius of local sphere
				);
		
		
		// voxel with diff xyz dim
		ProcessLocal (
				int _type,
				T* _voxels, 											
				int _dimX, int _dimY, int _dimZ,			// dimension is $_dim^3
				int _order,														// maximal order o
				TIn _radius,													// radius of local sphere			
				vector<TIn> &_seed										// critical points given
				);
		
		// voxel with diff xyz dim
		ProcessLocal (
				int _type,
				T* _voxels, 											
				int _dimX, int _dimY, int _dimZ,			// dimension is $_dim^3
				int _order,														// maximal order o
				TIn _radius														// radius of local sphere			
				);
		


		//--------------- Public functions -----------------------------------
		
		void clear();
		
		// generate local voxels for input grid
		int GenLocalVoxels(int num, TIn _cenX, TIn _cenY, TIn _cenZ);
		
		void GenLocalInvs();
		void GenLocalInvs_Arom();
		void GenLocalInvsPN();	
		void GenLocalInvsPN_HB();
		
		void SaveInvs(const char* prefix);	
		void SaveInvs2ESOM(const char* prefix);	
		void SaveInvs(SeedVec<T,TIn> &_seeds, int _typeVal);
		
		//-----------------------------------------------------------
		void ReadVoxelsFromFile(const char* _fname);
		void ReadSeedFromFile(const char* _fname);
		void ReadSeedFromGrid(T* _seedGrid);
		void ReadSeedFromListFile(const char* _fname);


		void ReadSeedVec(SeedVec<T,TIn> &_seeds);
		void setDX(VolumeDX<T,TIn> &_dx);
		void setZDpara(int _type, int _order, TIn _radius);

		void MapAveEP(SeedVec<T,TIn> &_seeds); //used to get the average EP of the patch
		void MapnHBDA(SeedVec<T,TIn> &_seeds); //count number of HBDA of the patch (by Bingjie)
		void MapnAROM(SeedVec<T,TIn> &_seeds); //count number of HBDA of the patch (by Bingjie)
		
	private:

		//--------------- private variables -----------------------------------
		
		ZernikeDescriptor<T,TIn> zd_; 
		int order_;

		VolumeDX<T,TIn> dx_;										// global DX file
		T* voxels_;															// global  voxels
		T* local_;															// local voxels

		TIn delX_, delY_, delZ_; 
		TIn cenX_, cenY_, cenZ_;
		int dimX_, dimY_, dimZ_; 								// global grid size 
		int d_;																	// global dimXxdimYxdimZ
		int numSeed_;														// number of seed points
	 
		int type_; 															// ALL or PN
		vector<TIn> seedVec_;										// X Y Z possition of seed or critical points
		TIn radius_;														// radius of local sphere Angstrom
		int r_;																	// rounded radius
		TIn scale_;															// scale = 1/r;	
		
		vector<vector<float> > invs_;						// store Zernike Descriptors
		
		int IS_SURFACE(int index_){
			if(voxels_[index_] != 0) return 1;
			else return 0;
		};
		
		int IN_RANGE(TIn a, TIn b, TIn c, int i, int j, int k){
			TIn dist = sqrt((TIn)(SQR(a-i)+SQR(b-j)+SQR(c-k)));
			if(dist < r_ ) return 1;
			else return 0;
		};
		
		int CHECK_RANGE(int a, int b, int c, int _dim){
			if (a>=0 && a<=_dim && b>=0 && b<=_dim && c>=0 && c<=_dim)
				return 1;
			else
				return 0;
		};

		int CHECK_RANGE(int a, int b, int c, int _dimX, int _dimY, int _dimZ){
			if (a>=0 && a<=_dimX && b>=0 && b<=_dimY && c>=0 && c<=_dimZ)
				return 1;
			else
				return 0;
		};
	
		int A2G(TIn _radius){
			if( _radius/delX_ >= _radius/delY_){
				if( _radius/delX_ >= _radius/delZ_){
					return ROUND((_radius/delX_)+0.5);
				}else{
					return ROUND((_radius/delZ_)+0.5);
				}
			}else if(_radius/delY_ >= _radius/delZ_){
				return ROUND((_radius/delY_)+0.5);
			}else{
				return ROUND((_radius/delZ_)+0.5);
			}
		};

};


#include "ProcessLocal.cpp"

#endif


