/* ==============================================
 *
 *	Coded by 		: Sael lee
 *	Last update	: May 21, 2008
 *	Note				: need to update by filetype_ and caltype_ 
 *	
 * ============================================== */

//#define PRINT_HB_LOCAL
//# define PRINT_LOCAL

template<class T, class TIn>
ProcessLocal<T, TIn>::ProcessLocal ()
{
}

template<class T, class TIn>
ProcessLocal<T, TIn>::ProcessLocal(int _type, SeedVec<T,TIn> &_SeedVec, VolumeDX<T,TIn> &_dx, int _order, TIn _radius):type_(_type), order_ (_order), radius_ (_radius)
{
	ReadSeedVec(_SeedVec);
	setDX(_dx);
	r_ = A2G(radius_); 	

	if(type_ == ALL || type_ == SF || type_ == VIS)
	  //	if(type_ == ALL || type_ == SF || type_ == VIS || type_ == AROM)
		GenLocalInvs();
	else if ( type_ == EP )
	{
		GenLocalInvsPN();
		MapAveEP(_SeedVec);  //I add a new function MapAveEP to calculate the average EP of surface grid as a feature for a seed point
	}
	else if ( type_ == HB )
	{
		GenLocalInvsPN_HB();
		MapnHBDA(_SeedVec);  //count number of HBDA for the patch (by Bingjie Hu)
	}
	else if(type_ == AROM)
	  {
	    GenLocalInvs_Arom();
	    MapnAROM(_SeedVec); // count # of Aromatic seed of the patch
	  }
	else
		GenLocalInvsPN();

}

template<class T, class TIn>
ProcessLocal<T, TIn>::ProcessLocal(int _type,const char*  _seedListFN, VolumeDX<T,TIn> &_dx, int _order, TIn _radius	):
	type_ (_type),  order_ (_order), radius_ (_radius) 
{
	ReadSeedFromListFile(_seedListFN);	
	setDX(_dx);
	r_ = A2G(radius_); 	
	
	if(type_ == ALL || type_ == SF || type_ == VIS)
		GenLocalInvs();
	else
		GenLocalInvsPN();

}


template<class T, class TIn>
ProcessLocal<T, TIn>::ProcessLocal(int _type, T* _voxels, int _dim, int _order, TIn _radius,	T* _seedGrid):
	type_ (_type), voxels_ (_voxels),  order_ (_order), radius_ (_radius) 
{
	dimX_ = dimY_ = dimZ_ = _dim;	

	ReadSeedFromGrid(_seedGrid);	
	r_ = A2G(radius_); 	
	
	if(type_ == ALL || type_ == SF || type_ == VIS)
		GenLocalInvs();
	else
		GenLocalInvsPN();

}

template<class T, class TIn>
ProcessLocal<T, TIn>::ProcessLocal( int _type, T* _voxels, int _dim, int _order, TIn _radius, vector<TIn>& _seedVec):
	type_ (_type), voxels_ (_voxels), order_ (_order), radius_ (_radius), seedVec_ (_seedVec) 
{
	numSeed_ = seedVec_.size();
	r_ = A2G(radius_); 	
	
	dimX_ = dimY_ = dimZ_ = _dim;	
	delX_ = delY_ = delZ_ = 1; 
	cenX_ = (dimX_-1.0)/2.0;  cenY_ =  (dimY_-1.0)/2.0;  cenZ_ =  (dimZ_-1.0)/2.0; 
	dx_.setPara(dimX_, dimY_, dimZ_ , delX_, delY_, delZ_, cenX_, cenY_, cenZ_);
	dx_.setGrid(voxels_);	
	
	if(type_ == ALL || type_ == SF || type_ == VIS)
		GenLocalInvs();
	else
		GenLocalInvsPN();

}

template<class T, class TIn>
ProcessLocal<T, TIn>::ProcessLocal(int _type, T* _voxels, int _dim, int _order, TIn _radius,	const char* _fseed):
	type_ (_type), voxels_ (_voxels), order_ (_order), radius_ (_radius) 
{
	
	// set numSeed_, seedVec_
	ReadSeedFromFile( _fseed);
	r_ = A2G(radius_); 	
	
	dimX_ = dimY_ = dimZ_ = _dim;	
	delX_ = delY_ = delZ_ = 1; 
	cenX_ = (dimX_-1.0)/2.0;  cenY_ =  (dimY_-1.0)/2.0;  cenZ_ =  (dimZ_-1.0)/2.0; 
	dx_.setPara(dimX_, dimY_, dimZ_ , delX_, delY_, delZ_, cenX_, cenY_, cenZ_);
	dx_.setGrid(voxels_);	
	
	if(type_ == ALL || type_ == SF || type_ == VIS )
		GenLocalInvs();
	else
		GenLocalInvsPN();

}

template<class T, class TIn>
ProcessLocal<T, TIn>::ProcessLocal( int _type,const char* _fvoxels, int _order, TIn _radius,	const char* _fseed):
	 order_ (_order), radius_ (_radius)
{
	// set voxels_, dim_
	ReadVoxelsFromFile( _fvoxels);
	// set numSeed_, seedVec_
	ReadSeedFromFile( _fseed);
	r_ = A2G(radius_); 	
	
	if(type_ == ALL || type_ == SF || type_ == VIS )
		GenLocalInvs();
	else
		GenLocalInvsPN();

}


// voxel with diff xyz dim
template<class T, class TIn>
ProcessLocal<T, TIn>::ProcessLocal (int _type, T* _voxels, int _dimX, int _dimY, int _dimZ, int _order,	TIn _radius,	vector<TIn> &_seedVec):
		type_(_type), dimX_(_dimX), dimY_(_dimY), dimZ_(_dimZ), order_(_order), radius_(_radius), seedVec_ (_seedVec)
{
	numSeed_ = seedVec_.size();
	
	delX_ = delY_ = delZ_ = 1; 
	cenX_ = (dimX_-1.0)/2.0;  cenY_ =  (dimY_-1.0)/2.0;  cenZ_ =  (dimZ_-1.0)/2.0; 
	dx_.setPara(dimX_, dimY_, dimZ_ , delX_, delY_, delZ_, cenX_, cenY_, cenZ_);
	dx_.setGrid(voxels_);	
	
	r_ = A2G(_radius);

	if(type_ == ALL || type_ == SF || type_ == VIS)
		GenLocalInvs();
	else
		GenLocalInvsPN();
}
		
// voxel with diff xyz dim
template<class T, class TIn>
ProcessLocal<T, TIn>::ProcessLocal (int _type, T* _voxels, int _dimX, int _dimY, int _dimZ, int _order,	TIn _radius):
		type_(_type), dimX_(_dimX), dimY_(_dimY), dimZ_(_dimZ), order_(_order), radius_(_radius)
{
	
	delX_ = delY_ = delZ_ = 1; 
	cenX_ = (dimX_-1.0)/2.0;  cenY_ =  (dimY_-1.0)/2.0;  cenZ_ =  (dimZ_-1.0)/2.0; 
	dx_.setPara(dimX_, dimY_, dimZ_ , delX_, delY_, delZ_, cenX_, cenY_, cenZ_);
	dx_.setGrid(voxels_);	
	r_= A2G(_radius);

	if(type_ == ALL  || type_ == SF || type_ == VIS)
		GenLocalInvs();
	else
		GenLocalInvsPN();
}
	
	


template<class T, class TIn>
void ProcessLocal<T, TIn>::clear()
{
	dx_.clear();
	if(local_ != NULL  ) delete [] local_;
	invs_.clear();
	seedVec_.clear();

}

template<class T, class TIn>
void ProcessLocal<T, TIn>::ReadVoxelsFromFile(const char* _fname)
{
		// set voxels_
	dx_.readDX(_fname);
	voxels_ = dx_.getGrid();
	
	// set dim_
	dx_.setPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_, cenX_,cenY_,cenZ_);
}

template<class T, class TIn>
void ProcessLocal<T, TIn>::ReadSeedFromFile(const char* _fname)
{
	VolumeDX<T,TIn> dx_;
	dx_.readDX(_fname);
	T* seedGrid = dx_.getGrid();
	numSeed_ = ReadSeedFromGrid(seedGrid);	

	// check dim to see comparibility 
	T _dimX, _dimY, _dimZ;
	dx_.getGs(_dimX,_dimY,_dimZ);
	// check del to see compatibility
	T _delX, _delY, _delZ;
	dx_.getDel(_delX, _delY, _delZ);
	if((_dimX+_dimY)-2*_dimZ != 0)
	{
		cout 	<< "This is not a cubic grid dimX: " << _dimX 
					<< " dimY_" << dimY_ << "dimZ_" << dimZ_ << endl;
	}
	if( dimX_ != _dimX ||  dimY_ != _dimY || dimZ_ != _dimZ )
	{
		cout 	<< "ReadSeedFromFile(" << _fname
					<< ") : Dimension of Voxel("<<dimX_ << ", " << dimY_ << ", "<<dimZ_<<") and seed ("<<_dimX << ", " << _dimY << ", "<<_dimZ<< ") is different!!!\n";
		exit(-1);
	}
	dx_.clear();
	
}

template<class T, class TIn>
void ProcessLocal<T, TIn>::ReadSeedFromGrid(T* _seedGrid)
{
		int _numSeed=0;
		
		// get seed points
		seedVec_.clear();
		for(int x=0; x < dimX_  ; x++){
			for(int y=0; y < dimY_ ; y++){
				for(int z=0; z < dimZ_ ; z++){	
					int i = (x*dimX_ + y)*dimY_ + z;					
					if(_seedGrid[i] == 1)
					{
						seedVec_.push_back(x);
						seedVec_.push_back(y);
						seedVec_.push_back(z);
						_numSeed++;
					}
				
				}
			}
		}
		
		numSeed_ = _numSeed;
}

template<class T, class TIn>
void ProcessLocal<T, TIn>::ReadSeedFromListFile(const char* _seedListFN)
{
		ifstream infile(_seedListFN);
		int _numSeed=0;
		int tmp;
	
		if(infile.is_open()){
			// get seed points
			seedVec_.clear();
			while(infile >> tmp){
				seedVec_.push_back(tmp);
				_numSeed++;
			}
		}
		numSeed_ = _numSeed;
		infile.close();
}



template<class T, class TIn>
int ProcessLocal<T, TIn>::GenLocalVoxels(int num, TIn _cenX ,TIn _cenY , TIn _cenZ)
{
		int r = r_; 	
	
		vector<T> tempLocal;
		
		int cx = (int)ROUND(_cenX);
		if(cx<0) cx = 0; if(cx>dimX_) cx = dimX_;
		int cy = (int)ROUND(_cenY);
		if(cy<0) cy = 0;if(cy>dimY_) cy = dimY_;
		int cz = (int)ROUND(_cenZ);
		if(cz<0) cx = 0; if(cz>dimZ_) cz = dimZ_;
		
#ifdef DEBUG_LOC
			cout << "GenLocalVoxel: "
				<< "input Cen: " << _cenX << " " <<_cenY <<" "<< _cenZ << endl
				<< "interger cen: "<< cx << " " << cy << " " << cz << endl
				<< "radius = " << radius_<<" r = "<< r << endl;

#endif
		
		tempLocal.resize( CUBIC(2*r+1), 0 );
		vector<vector<int> > Nei;
		vector<int> tmpV;
		tmpV.resize(3);
		tmpV[0] = cx; tmpV[1] = cy; tmpV[2] = cz;
		Nei.push_back(tmpV);
		int count=0;
		while( Nei.size() > 0 )
		{
			count++;
			// findNeighbor(_cenX,_cenY,_cenZ, Nei, tempLocal);
			int a = Nei[Nei.size()-1][0];
			int b = Nei[Nei.size()-1][1];
			int c = Nei[Nei.size()-1][2];

#ifdef DEBUG_LOC1
			cout << "Looping : " << count << 
				"abc: " << a << " " << b << " " << c <<
				"r:" << r << endl;
#endif		
			Nei.pop_back();	
			
//			int tmpx[]={-1, 0,1,0, 0,0, -1,-1, 0, 1, 1, 0, -1,-1, 0, 1, 1, 0, -1,-1, 0, 1, 1, 0};
//			int tmpy[]={0 ,-1,0,1, 0,0, -1, 0,-1, 1, 0, 1,  1, 0, 1,-1, 0,-1,  1, 0, 1,-1, 0,-1};
//			int tmpz[]={0 , 0,0,0,-1,1,  0,-1,-1, 0, 1, 1,  0,-1,-1, 0, 1, 1,  0, 1, 1, 0,-1,-1};
			vector<int> newInd;
			vector<int> tmpInd;
			vector< vector<int> > tmpXYZ;
			int ncount=0;
	//		for(int tmpa=0; tmpa<24; tmpa++)
	//		{		
				//int x=tmpx[tmpa]; int y=tmpy[tmpa]; int z=tmpz[tmpa];		
				
				for(int x=-1; x<=1; x++){
					for(int y=-1; y<=1; y++){
						for(int z=-1; z<=1; z++){
							if(sqrt(x*x+y*y+z*z) > 1.5 ) continue;

							if(CHECK_RANGE(a+x, b+y, c+z, dimX_, dimY_, dimZ_))
							{
								int newIndex = INDEX2( a+x, b+y, c+z, dimX_,dimY_,dimZ_);
								int tmpIndex = INDEX1( a+x-cx+r, b+y-cy+r, c+z-cz+r, 2*r+1 );
								if(IS_SURFACE(newIndex) 
										&& IN_RANGE(_cenX,_cenY,_cenZ,a+x,b+y,c+z) )
								{
									ncount++;
									if( tempLocal[tmpIndex]==0)
									{
										vector<int> tmp;
										tmp.resize(3);
										tmp[0]=a+x; tmp[1]=b+y; tmp[2]=c+z;
										tmpXYZ.push_back(tmp);
										newInd.push_back(newIndex);
										tmpInd.push_back(tmpIndex);
									}
								}
							}
						
						}
					}
				}
			
			
	//		}

			if(ncount>6){
				for(int ind=0; ind<newInd.size(); ind++){
						Nei.push_back(tmpXYZ[ind]);
						tempLocal[tmpInd[ind]] = voxels_[newInd[ind]];
				}
			}
			newInd.clear(); tmpInd.clear();
		}
		
		T* _local = new T [CUBIC(2*r+1)];
			
		for (int i=0; i<CUBIC(2*r+1); ++i)
   	{
     	  _local[i] = tempLocal[i];
   	}
	
		tempLocal.clear();
		
		local_ = _local;

//		ZernikeDescriptor<double, double> zd12(local_, 10, 5);
//		vector<float> inv;
//		zd12.SaveInvariants(inv);

		return r;
}

template<class T, class TIn>
void ProcessLocal<T, TIn>::GenLocalInvs()
{
		zd_.Init(order_);
		
		for(int i=0; i < numSeed_; i+=3)
		{

			TIn _cenX = (TIn)seedVec_[i];
			TIn _cenY = (TIn)seedVec_[i+1];
			TIn _cenZ = (TIn)seedVec_[i+2];
	
			if(i!=0) delete [] local_;
			local_ = NULL;
			int r = GenLocalVoxels(i, _cenX, _cenY, _cenZ );
			
			zd_.ComputeLocal(local_, 2*r+1);

			vector<float> _inv;
   		zd_.SaveInvariants(_inv);
			for(int a = 0; a < _inv.size(); a++){
				if(isnan(_inv[a])){  printf("!!! nan _inv  !!!!\n");//ICY DEBUG
					_inv[a] = 0;
				}
			}
#ifdef PRINT_LOCAL
			char bufgrid[64] = "local2";
			char bufDX[64];		
			char numbuf[10];
			sprintf(numbuf, "%i", i/3);
			strcat(bufgrid, numbuf);
			strcpy(bufDX,bufgrid);
			if(type_ == ALL){
				strcat(bufgrid,"_01.txt");
				strcat(bufDX, "_01.dx");
			}else if(type_ == SF){
				strcat(bufgrid,"_SF.txt");
				strcat(bufDX, "_SF.dx");
			}else if(type_ == VIS){
				strcat(bufgrid,"_VIS.txt");
				strcat(bufDX, "_VIS.dx");
			}
			cout << ">>> " << bufgrid << " " << 
				_cenX << " " << _cenY << " " << _cenZ << endl;
			
			int newIndex = INDEX2( ROUND(_cenX), ROUND(_cenY), ROUND(_cenZ), dimX_, dimY_, dimZ_);
			int centerindex = INDEX1(r, r, r, 2*r+1);
			local_[centerindex] = -1;

			TIn tcX = (_cenX - ((TIn)dimX_-1.0)/2.0 )*delX_ + cenX_;			
			TIn tcY = (_cenY - ((TIn)dimY_-1.0)/2.0 )*delY_ + cenY_;			
			TIn tcZ = (_cenZ - ((TIn)dimZ_-1.0)/2.0 )*delZ_ + cenZ_;			
			
			VolumeDX<T,TIn> tloc;
			tloc.setPara(2*r+1,2*r+1,2*r+1,delX_,delY_,delZ_,tcX,tcY,tcZ);
			tloc.setGrid(local_);
			tloc.writeDX(bufDX);	
//			tloc.writeGrid(bufgrid);			
			
#endif
	 		
			vector<float> cen;
			cen.push_back((float)_cenX);  
			cen.push_back((float)_cenY); 
			cen.push_back((float)_cenZ); 
			vector<float>::iterator it;
			it = _inv.begin();
			_inv.insert(it,cen.begin(),cen.end());
						
			invs_.push_back(_inv);
	
#ifdef DEBUG_LOC	
		cout << "GenLocalInvs: Processing seed number " 
			<< (i+3)/3  << "/" << numSeed_/3 
			<< " at grid point center "
			<< _cenX << " " << _cenY  << " " << _cenZ << endl; 
		for(int a = 0; a < (invs_[invs_.size()-1]).size(); a++){
			cout << invs_[invs_.size()-1][a] << " ";
		}
		cout << endl;
#endif 

			_inv.clear();
		}
#ifdef DEBUG_LOC
		cout << "INVS size "<< invs_.size()<<"/"<< invs_[0].size() << endl;
#endif
}

template<class T, class TIn>
void ProcessLocal<T, TIn>::GenLocalInvs_Arom()
{
		zd_.Init(order_);
		
		for(int i=0; i < numSeed_; i+=3)
		{

			TIn _cenX = (TIn)seedVec_[i];
			TIn _cenY = (TIn)seedVec_[i+1];
			TIn _cenZ = (TIn)seedVec_[i+2];
	
			if(i!=0) delete [] local_;
			local_ = NULL;
			int r = GenLocalVoxels(i, _cenX, _cenY, _cenZ );
			
			T* localA = new T [(int)pow(2.0*r+1.0,3)];
			for (int j=0; j<(int)pow(2.0*r+1.0,3.0); ++ j)
			  {
			    localA[j]=0;
			  }

			int countA = 0;
			for (int j=0; j<pow(2.0*r,3); j++)
			  {
			    if(local_[j] > 0.5)
			      {
				localA[j] = local_[j];
				countA++;
			      }
			    else
			      {
				localA[j] = 0;
			      }
			  }
			
			zd_.ComputeLocal(localA, 2*r+1);

			vector<float> _inv;
   		zd_.SaveInvariants(_inv);
			for(int a = 0; a < _inv.size(); a++){
				if(isnan(_inv[a])){  printf("!!! nan _inv  !!!!\n");//ICY DEBUG
					_inv[a] = 0;
				}
			}
#ifdef PRINT_LOCAL
			char bufgrid[64] = "local2";
			char bufDX[64];		
			char numbuf[10];
			sprintf(numbuf, "%i", i/3);
			strcat(bufgrid, numbuf);
			strcpy(bufDX,bufgrid);
			if(type_ == ALL){
				strcat(bufgrid,"_01.txt");
				strcat(bufDX, "_01.dx");
			}else if(type_ == SF){
				strcat(bufgrid,"_SF.txt");
				strcat(bufDX, "_SF.dx");
			}else if(type_ == VIS){
				strcat(bufgrid,"_VIS.txt");
				strcat(bufDX, "_VIS.dx");
			}
			cout << ">>> " << bufgrid << " " << 
				_cenX << " " << _cenY << " " << _cenZ << endl;
			
			int newIndex = INDEX2( ROUND(_cenX), ROUND(_cenY), ROUND(_cenZ), dimX_, dimY_, dimZ_);
			int centerindex = INDEX1(r, r, r, 2*r+1);
			local_[centerindex] = -1;

			TIn tcX = (_cenX - ((TIn)dimX_-1.0)/2.0 )*delX_ + cenX_;			
			TIn tcY = (_cenY - ((TIn)dimY_-1.0)/2.0 )*delY_ + cenY_;			
			TIn tcZ = (_cenZ - ((TIn)dimZ_-1.0)/2.0 )*delZ_ + cenZ_;			
			
			VolumeDX<T,TIn> tloc;
			tloc.setPara(2*r+1,2*r+1,2*r+1,delX_,delY_,delZ_,tcX,tcY,tcZ);
			tloc.setGrid(local_);
			tloc.writeDX(bufDX);	
//			tloc.writeGrid(bufgrid);			
			
#endif
	 		
			vector<float> cen;
			cen.push_back((float)_cenX);  
			cen.push_back((float)_cenY); 
			cen.push_back((float)_cenZ); 
			vector<float>::iterator it;
			it = _inv.begin();
			_inv.insert(it,cen.begin(),cen.end());
						
			invs_.push_back(_inv);
	
#ifdef DEBUG_LOC	
		cout << "GenLocalInvs: Processing seed number " 
			<< (i+3)/3  << "/" << numSeed_/3 
			<< " at grid point center "
			<< _cenX << " " << _cenY  << " " << _cenZ << endl; 
		for(int a = 0; a < (invs_[invs_.size()-1]).size(); a++){
			cout << invs_[invs_.size()-1][a] << " ";
		}
		cout << endl;
#endif 

			_inv.clear();
		}
#ifdef DEBUG_LOC
		cout << "INVS size "<< invs_.size()<<"/"<< invs_[0].size() << endl;
#endif
}

template<class T, class TIn>
void ProcessLocal<T, TIn>::GenLocalInvsPN()
{
		zd_.Init(order_);
		
		for(int i=0; i < numSeed_; i+=3)
		{

			TIn _cenX = (TIn)seedVec_[i];
			TIn _cenY = (TIn)seedVec_[i+1];
			TIn _cenZ = (TIn)seedVec_[i+2];
			
			if(i!=0) delete [] local_;
			local_ = NULL;
		
		
			int r = GenLocalVoxels(i, _cenX, _cenY, _cenZ );
			
			T* localP = new T [(int)pow(2.0*r+1.0,3)];
			T* localN = new T [(int)pow(2.0*r+1.0,3)];
			for (int j=0; j<(int)pow(2.0*r+1.0,3.0); ++j)
			{
				localP[j]=0;
				localN[j]=0;
			}


			int countP = 0, countN = 0;
			for(int j=0; j<pow(2.0*r,3);j++)
			{
				if(local_[j]>0){
					localP[j] = local_[j]; countP++;
					localN[j] = 0;
				}else if(local_[j]<0){
					localP[j] = 0;
					localN[j] = local_[j]; countN++;
				}else{
					localP[j] = 0;
					localN[j] = 0;
				}
			}
			/*if (type_ == HB) 
			{
				printf("patch #%d P: %d N: %d\n", i, countP, countN);
			}*/

#ifdef PRINT_LOCAL

  		char bufgrid[64] = "local2";
			char bufDX[64];		
			char numbuf[10];
			sprintf(numbuf, "%i", i/3);
			strcat(bufgrid, numbuf);
			strcpy(bufDX,bufgrid);
			if(type_ == KD ){
				strcat(bufgrid,"_KD.txt");
				strcat(bufDX, "_KD.dx");
			}else if(type_ == EP){
				strcat(bufgrid,"_EP.txt");
				strcat(bufDX, "_EP.dx");
			}else if(type_ == HW){
				strcat(bufgrid,"_HW.txt");
				strcat(bufDX, "_HW.dx");
			}else if(type_ == HB){
			  strcat(bufgrid, "_HB.txt");
			  strcat(bufDX, "_HB.dx");
			}

			cout << ">>> " << bufgrid << " " << 
				_cenX << " " << _cenY << " " << _cenZ << endl;
			
			int newIndex = INDEX2( ROUND(_cenX), ROUND(_cenY), ROUND(_cenZ), dimX_, dimY_, dimZ_);
			int centerindex = INDEX1(r, r, r, 2*r+1);
//			local_[centerindex] = -1;

			TIn tcX = (_cenX - ((TIn)dimX_-1.0)/2.0 )*delX_ + cenX_;			
			TIn tcY = (_cenY - ((TIn)dimY_-1.0)/2.0 )*delY_ + cenY_;			
			TIn tcZ = (_cenZ - ((TIn)dimZ_-1.0)/2.0 )*delZ_ + cenZ_;			
			
		
			VolumeDX<T,TIn> tloc;
			tloc.setPara(2*r+1,2*r+1,2*r+1, delX_, delY_,delZ_, tcX, tcY, tcZ);
			tloc.setGrid(local_);
			tloc.writeDX(bufDX);	
//		tloc.writeGrid(bufgrid);	

#endif

		
			vector<float> _invP;
			vector<float> _invN;

//			if(countP>1){
				zd_.ComputeLocal( localP, 2*r+1);
//   			zd_.ComputeLocal( localP, 2*r+1, r,r,r, 1.0/(2.0*r+1.0) );
				zd_.SaveInvariants (_invP);
				for(int a = 0; a < _invP.size(); a++){
					if(isnan(_invP[a])){
						_invP[a] = 0;
					}
				}

//			}
//			if(countN>1){
				zd_.ComputeLocal( localN, 2*r+1);
//	   	zd_.ComputeLocal( localN, 2*r+1, r,r,r, 1.0/(2.0*r+1.0) );
			zd_.SaveInvariants (_invN);
			for(int a = 0; a < _invN.size(); a++){
				if(isnan(_invN[a])){
					_invN[a] = 0;
				}
			}

//			}
			// insert seed position in grid
			vector<float> cen;
			cen.push_back((float)_cenX);  
			cen.push_back((float)_cenY); 
			cen.push_back((float)_cenZ); 

			vector<float>::iterator it;
			it = _invP.begin();
			_invP.insert(it,cen.begin(),cen.end());
						
			// insert Negative value invs to Positive value invs
			it = _invP.end();
			_invP.insert(it,_invN.begin()+1,_invN.end());

			// change number of inv (*2)
			_invP[3] = _invP[3]*2;
			
			invs_.push_back(_invP);
			_invP.clear();
			_invN.clear();

			
			delete [] localP;
			delete [] localN;
			localP = NULL;
			localN = NULL;
			
		}
}

template<class T, class TIn>
void ProcessLocal<T, TIn>::GenLocalInvsPN_HB()
{
		zd_.Init(order_);

		for(int i=0; i < numSeed_; i+=3)
		{

			TIn _cenX = (TIn)seedVec_[i];
			TIn _cenY = (TIn)seedVec_[i+1];
			TIn _cenZ = (TIn)seedVec_[i+2];

			if(i!=0) delete [] local_;
			local_ = NULL;
		
			int r = GenLocalVoxels(i, _cenX, _cenY, _cenZ);

			T* localP = new T [(int)pow(2.0*r+1.0,3)];
			T* localN = new T [(int)pow(2.0*r+1.0,3)];
			for (int j=0; j<(int)pow(2.0*r+1.0,3.0); ++j)
			{
				localP[j]=0;
				localN[j]=0;
			}

			int countP = 0, countN = 0;
			for(int j=0; j<pow(2.0*r,3);j++)
			{
				if(local_[j]>0.5){
					localP[j] = local_[j]; countP++;
					localN[j] = 0;
				}else if(local_[j]<-0.5){
					localP[j] = 0;
					localN[j] = local_[j]; countN++;
				}else{
					localP[j] = 0;
					localN[j] = 0;
				}

			}

			/*if (type_ == HB) 
			{
				printf("patch #%d P: %d N: %d\n", i, countP, countN);
			}*/

#ifdef PRINT_HB_LOCAL

  		char bufgrid[64] = "test2_";
			char bufDX[64];		
			char numbuf[10];
			sprintf(numbuf, "%i", i/3);
			strcat(bufgrid, numbuf);
			strcpy(bufDX,bufgrid);
			strcat(bufgrid, "_HB.txt");
			strcat(bufDX, "_HB.dx");
			
			cout << ">>> " << bufgrid << " " << 
				_cenX << " " << _cenY << " " << _cenZ << endl;
			
			int newIndex = INDEX2( ROUND(_cenX), ROUND(_cenY), ROUND(_cenZ), dimX_, dimY_, dimZ_);
			int centerindex = INDEX1(r, r, r, 2*r+1);
//			local_[centerindex] = -1;

			TIn tcX = (_cenX - ((TIn)dimX_-1.0)/2.0 )*delX_ + cenX_;			
			TIn tcY = (_cenY - ((TIn)dimY_-1.0)/2.0 )*delY_ + cenY_;			
			TIn tcZ = (_cenZ - ((TIn)dimZ_-1.0)/2.0 )*delZ_ + cenZ_;			
			
		
			VolumeDX<T,TIn> tloc;
			tloc.setPara(2*r+1,2*r+1,2*r+1, delX_, delY_,delZ_, tcX, tcY, tcZ);
			tloc.setGrid(local_);
			tloc.writeDX(bufDX);	
//		tloc.writeGrid(bufgrid);	

#endif

		
			vector<float> _invP;
			vector<float> _invN;

//			if(countP>1){
				zd_.ComputeLocal( localP, 2*r+1);
//   			zd_.ComputeLocal( localP, 2*r+1, r,r,r, 1.0/(2.0*r+1.0) );
				zd_.SaveInvariants (_invP);
				for(int a = 0; a < _invP.size(); a++){
					if(isnan(_invP[a])){
						_invP[a] = 0;
					}
				}

//			}
//			if(countN>1){
				zd_.ComputeLocal( localN, 2*r+1);
//	   	zd_.ComputeLocal( localN, 2*r+1, r,r,r, 1.0/(2.0*r+1.0) );
			zd_.SaveInvariants (_invN);
			for(int a = 0; a < _invN.size(); a++){
				if(isnan(_invN[a])){
					_invN[a] = 0;
				}
			}

//			}
			// insert seed position in grid
			vector<float> cen;
			cen.push_back((float)_cenX);  
			cen.push_back((float)_cenY); 
			cen.push_back((float)_cenZ); 

			vector<float>::iterator it;
			it = _invP.begin();
			_invP.insert(it,cen.begin(),cen.end());
						
			// insert Negative value invs to Positive value invs
			it = _invP.end();
			_invP.insert(it,_invN.begin()+1,_invN.end());

			// change number of inv (*2)
			_invP[3] = _invP[3]*2;
			
			invs_.push_back(_invP);
			_invP.clear();
			_invN.clear();

			
			delete [] localP;
			delete [] localN;
			localP = NULL;
			localN = NULL;
			
		}
}

template<class T, class TIn>
void ProcessLocal<T,TIn>::SaveInvs(const char* prefix)
{
    
		// .inv file name
    char  buf[64];
		strcpy(buf, prefix);
		strcat(buf,".inv");
		
		ofstream invfile(buf); // openfile for inv
	 	cout << "invFilename : " << buf << endl;			
		
		invfile << invs_.size() << endl;
		for(int i=0; i<invs_.size(); i++)
		{
			for(int j=0; j<invs_[i].size(); j++)
			{
				invfile << invs_[i][j] << "\t";
			}
			invfile << endl;
		}
		invfile.close();	
}

	
template<class T, class TIn>
void ProcessLocal<T,TIn>::SaveInvs2ESOM(const char* prefix)
{
    
		// .inv file name
    char  buf1[64], buf2[64];
		strcpy(buf1, prefix);
		strcat(buf1,".lrn");
		
		strcpy(buf2, prefix);
		strcat(buf2,".names");
		
		ofstream lrnfile(buf1); // openfile for inv
		ofstream namefile(buf2); // openfile for inv

#ifdef DEBUG_LOC
		cout << "lrnFilename : " << buf1 << endl;			
		cout << "nameFilename : " << buf2 << endl;			
#endif		

		lrnfile << "# comments\n#\n"
						<< "% " << invs_.size() << endl
						<< "% " << invs_[0][3] << endl
						<< "% 9";
		for(int i=0; i<invs_[0][3];i++)
			lrnfile << "\t1";
		lrnfile << "\nKey";
		for(int i=0; i<invs_[0][3];i++)
			lrnfile << "\tinv" << i;
		lrnfile << endl;
		
		namefile << "% " << invs_.size() << endl;
		
		for(int i=0; i<invs_.size(); i++)
		{
			lrnfile << i+1 << "\t";
			namefile << i+1 << "\t";
			for(int j=0; j<invs_[i].size(); j++)
			{
				if(j>3){
					lrnfile << invs_[i][j] << "\t";
				}else if(j==0){
					namefile 	<< "local" << i << "\t" 
										<< invs_[i][j];
				}else if(j<3){
					namefile << "_" << invs_[i][j];
				}
			}
			lrnfile << endl;
			namefile << endl;
		}
		lrnfile.close();	
		namefile.close();
}


template<class T, class TIn>
void ProcessLocal<T,TIn>::SaveInvs(SeedVec<T,TIn> &_seeds, int _typeVal)
{
	if(_seeds.size() != invs_.size()){
	cout << "SIZE DIFF ERRO : SEED VEC size " << _seeds.size() << " invs size " << invs_.size();
	exit(-1);
	}

	for(int i=0; i<_seeds.size(); i++)
	{
		Seed<T,TIn> *tmpSeed = _seeds.getSeed(i);
		tmpSeed->setInv( invs_[i] , _typeVal);
	}
		
}

template<class T, class TIn>
void ProcessLocal<T,TIn>::ReadSeedVec(SeedVec<T,TIn> &_seeds)
{
	seedVec_.clear();
	seedVec_.resize(_seeds.size()*3);
	for(int i=0, j=0; i<_seeds.size(); i++, j+=3)
	{
		TIn a, b, c;
		TIn aa, bb, cc;
		(_seeds.getSeed(i))->getEXYZ(a,b,c);
		_seeds.TRANSFORMFROM(a,b,c,aa,bb,cc);
	  seedVec_[j]=aa; seedVec_[j+1]=bb; seedVec_[j+2]=cc; 
	}
	numSeed_ = seedVec_.size();
}

template<class T, class TIn>
void ProcessLocal<T,TIn>::setDX(VolumeDX<T,TIn> &_dx)
{
	dx_.copyDX(_dx);
	voxels_ = dx_.getGrid();
	dx_.getPara(dimX_,dimY_,dimZ_,delX_,delY_,delZ_,cenX_,cenY_,cenZ_);
	d_ = dimX_*dimY_*dimZ_;
}


template<class T, class TIn>
void ProcessLocal<T,TIn>::setZDpara(int _type, int _order, TIn _radius)
{
	type_=_type;
	order_=_order;
	radius_=_radius;
	r_ = A2G(radius_); 	
}

template<class T, class TIn>
void ProcessLocal<T,TIn>::MapAveEP(SeedVec<T,TIn> &_seeds)
{
	for ( int i = 0; i < _seeds.size(); i++ )
	{
		TIn a, b, c;
		TIn aa, bb, cc;
		(_seeds.getSeed(i))->getEXYZ(a,b,c);
		_seeds.TRANSFORMFROM(a,b,c,aa,bb,cc);
		delete [] local_;
		local_ = NULL;
		int r = GenLocalVoxels(i*3, aa, bb, cc );
		int tot = 0;
		T ave_ep = 0.0;
		for ( int j = 0; j < pow(2.0*r,3); j++)
		{
			if ( local_[j] != 0.0 )
			{
				ave_ep = ave_ep + local_[j];
				tot++;
			}
		}
		if ( tot == 0 )
			ave_ep = 0.0;
		else
			ave_ep = ave_ep/tot;
		Seed<T,TIn> *tmpSeed = _seeds.getSeed(i);
		tmpSeed->setPro(ave_ep, HW);
	}
}

template<class T, class TIn>
void ProcessLocal<T,TIn>::MapnHBDA(SeedVec<T,TIn> &_seeds)
{			
	for ( int i = 0; i < _seeds.size(); i++ )
	{
		TIn a, b, c;
		TIn aa, bb, cc;
		(_seeds.getSeed(i))->getEXYZ(a,b,c);
		_seeds.TRANSFORMFROM(a,b,c,aa,bb,cc);
		delete [] local_;
		local_ = NULL;
		int r = GenLocalVoxels(i*3, aa, bb, cc );
		int countP = 0, countN = 0;
		for(int j=0; j<pow(2.0*r,3);j++)
		{
			if(local_[j]>0.5){
					countP++;
			}else if(local_[j]<-0.5){
					countN++;
			}else{
			}
		}

		//printf("patch #%d P: %d N: %d\n", i, countP, countN);

		Seed<T,TIn> *tmpSeed = _seeds.getSeed(i);
		tmpSeed->nHBD = countP;
		tmpSeed->nHBA = countN;
	}
}

template<class T, class TIn>
void ProcessLocal<T,TIn>::MapnAROM(SeedVec<T,TIn> &_seeds)
{			
	for ( int i = 0; i < _seeds.size(); i++ )
	{
		TIn a, b, c;
		TIn aa, bb, cc;
		(_seeds.getSeed(i))->getEXYZ(a,b,c);
		_seeds.TRANSFORMFROM(a,b,c,aa,bb,cc);
		delete [] local_;
		local_ = NULL;
		int r = GenLocalVoxels(i*3, aa, bb, cc );
		int count = 0;
		for(int j=0; j<pow(2.0*r,3);j++)
		{
		  if(local_[j]>0.5)
			  {
			    count++;
			  }

		}

		Seed<T,TIn> *tmpSeed = _seeds.getSeed(i);
		tmpSeed->nAROM = count;
	}
}
