
/*============================================
 *
 * Sael Lee 
 * May 29, 2009
 * given PDB (protein and ligand) and _smol.dx 
 * find surface region, 
 * 			interface region, 
 * 			visibility of surface region
 *===========================================*/

#include "ProcessLocal.h"
#include "Common.h"
#include "Apbs2DX.h"
#include "MapPdb2Surf.h"
#include "ProcessPDB.h"
#include "Visibility.h"

void Usage(char* exc, char* op)
{
	cout << exc << " error for " << op  << "\n";
	cout << " REQUIRED:\n";
	cout << "   -s  *_smol.dx\n";
	cout << "   -p pdb file name\n";
	cout << "   -o output File name\n";
	cout << "   -l 	ligand pdb\n";
}


int main(int argc, char** argv)
{
	
//=========================================================
// process argument
//=========================================================

	float ligRad = 3.5;
	float visT = 10;
	int interval = 100;

	int 	dimX = MAXINT, dimY = MAXINT, dimZ = MAXINT;
	float delX = MAXINT, delY = MAXINT, delZ = MAXINT;
	float cenX = 0, cenY = 0, cenZ = 0; 
	
	char 	*smolFN, *potFN, *outFN, *seedFN, *pdbFN, *pqrFN, *ligFN;
	
	int check_lig = 0;

	if(argc < 5){
		Usage(argv[0], "NUM of argument less then 4\n" );
		exit(-1);
	}
	
	for (int i=1; i<argc; i++) {
		
		if (strcmp(argv[i], "-s")==0) {
			smolFN = argv[++i];	
		} else if (strcmp(argv[i], "-o")==0) {
			outFN = argv[++i];
		} else if (strcmp(argv[i], "-p")==0) {	
			pdbFN = argv[++i];
		} else if (strcmp(argv[i], "-l")==0) {
			ligFN = argv[++i];
			check_lig = 1;
		} else {
			Usage(argv[0], argv[i]); return -1;
		}

	} // end for

	
	// output file names------------------------
	char surfOFN[20], interOFN[20], visOFN[20];
	strcpy(surfOFN, outFN); strcat(surfOFN, "_surf.dx");
	strcpy(interOFN, outFN); strcat(interOFN, "_inter.dx");
	strcpy(visOFN, outFN); strcat(visOFN, "_vis.dx");
	
	cout << "OUTPUT FNS: " << surfOFN << " " << interOFN << " " << visOFN << endl;
	//-----------------------------------------
	// 0. read mesh or apbs 
	//-----------------------------------------

	SeedVec<double,float> seedVec;
	SurfVec<double,float> surfVec; 
	Apbs2DX<double,float> apbs2dx;

	//-----------------------------------------
	// 1. generate surf, seeds, acc	
	//----------------------------------------
	apbs2dx.setSeedVec(&seedVec);
	apbs2dx.setSurfVec(&surfVec);
	apbs2dx.readacc(smolFN);
	apbs2dx.calSurf(1);

	VolumeDX<double,float> surfDX;
	VolumeDX<double,float> surfPotDX;
	VolumeDX<double,float> seedDX;


	// surface ---------------------------
	surfDX = apbs2dx.getSurf();
	surfDX.writeDX(surfOFN);

	//-----------------------------------------
	// 2. visibility
	//-----------------------------------------
	
	Visibility<double,float> vis;
	apbs2dx.calSurfFilled();
	VolumeDX<double,float> csf = apbs2dx.getSurfFilled();
	vis.SurfVis(csf, visT, &seedVec, &surfVec);
//		vis.SeedVis(csf, visT, &seedVec);
	VolumeDX<double,float> VisDX;
	VisDX = surfVec.getSurfsDX(VIS);
	VisDX.writeDX(visOFN);	
	VisDX.writeGrid("Vis.grid");

	apbs2dx.clearAcc();
	apbs2dx.clearPot();
//	apbs2dx.clearSurf();
//	apbs2dx.clearSeed();


	//-----------------------------------------
	// 3. for each surf & seed calculate propertes
	//-----------------------------------------
	ProcessPDB<double,float> testpdb;
	testpdb.ReadPDB(pdbFN);
	vector<ATOMStruct> tempA = testpdb.getATOM();
//		cout << "PRINT PDB" << endl;
//		for(int i=0; i<tempA.size(); i++){
//			tempA[i].ATOMprint();
//		}
		
		seedVec.getPara(dimX,dimY,dimZ, delX,delY,delZ,cenX,cenY,cenZ);
		
		MapPdb2Surf<double,float> pdb2surf;
	
	
	//-----------------------------------------
	// 4 INTERFACE extraction
	//-----------------------------------------
 		if(check_lig){
			cout << "START find interface" << endl;
			surfVec.InterfaceSurf(ligFN, ligRad);
			VolumeDX<double,float> interfaceDX = surfVec.getSurfsDX();
			interfaceDX.writeDX(interOFN);
		}
	
	
	return 0;	
}







