/*============================================
 *
 * Sael Lee 
 * Oct. 16, 2007
 *
 *===========================================*/

#ifndef POINTS2DX_H
#define POINTS2DX_H

// ---- std includes ---
#include <vector>
#include <iostream>
#include <fstream>
#include <cstring>
#include <cmath>

using namespace std;

#include <stdio.h>

#include "VolumeDX.h"



template<class T, class TIn>
class Points2DX 
{
	public:
		//---------  constructor ------------------------------
		Points2DX();

		//---------- public functions -------------------------
		void clear();

		
		// Read Critical Points file and get xyz points
		void ReadCP(const char* _fname);

		// Read pdb file and get ATOM & HETATM points
		void ReadPDB(const char* _fname);

		// Read pdb file and get points according to residue numbers
		void ReadPDB(const char* _fname, const char* _resNumfname );
			
		// Read x y z file // ex > x1 y1 z1\n x2 y2 z2\n
		void ReadXYZ(const char* _fname);
		
		// save the vector
		void PutPoints(vector<TIn>& points);
		
		// process points in pdb or cp and map to dx (approximated to interger points)
		void TransformPoints(int _dim, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ);		
		void TransformPoints(int _dim, TIn _del);
		void NoTransform(int _dim, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ);	
		
		// save points_ 
		void SavePoints(vector<TIn>& points);
		void SavePoints(const char* points);
		
		// save DX 
		void SaveDX(const char* _fname);
		
		// get grid part of DX file
		VolumeDX<T,TIn> GetDX();
		
		void getPara(int& gs, TIn& del, TIn& cenx, TIn& ceny, TIn& cenz)
		{
			gs = dim_; del = del_;
			cenx = cen[0];	ceny = cen[1]; cenz = cen[2];
		};
		

		
	private:
		//-------- private variables ------------------------
		VolumeDX<T,TIn> 	dx_;							// dx file format of the (approximated) critical points
		vector<TIn>			trPoints_;					// x y z points (i, i+1, i+2) storing critical points after transforming
		vector<TIn>			ogPoints_;  	      // x y z points (i, i+1, i+2) storing critical points before transforming
		
		int 							dim_;							// dimension of cubic dx file
		TIn		 						del_;							// interval size of each voxel
		TIn 							cen[3];						// center of points
		
		//-------- private functions ---------------------------
		
		void SavePoints2DX(); 							// make DX file containing points
	
};


#include "Points2DX.cpp"

#endif

