
template<class T, class TIn>
Points2DX<T,TIn>::Points2DX()
{

}

template<class T, class TIn>
void Points2DX<T,TIn>::clear()
{
	dx_.clear();
	trPoints_.clear();
	ogPoints_.clear();
}


/*-----------------------------------------------------------------------	*\
* read ligand coordinate and find center.																	*
* 																																				*
* notice center calculated by psize.py in apbs package may be different.	*
* In order the make the center same, change																*												
* TIn Max[3] = {-3600,-3600,-3600};																			*
* TIn Min[3] = { 3600, 3600, 3600}; 																		*
* to																																			*
* float Max[3] = {0,0,0};																									*	
* float Min[3] = { 360, 360, 360}; 																				*
* as psize.py is doing.																										*
\* -----------------------------------------------------------------------*/

template<class T, class TIn>
void Points2DX<T,TIn>::ReadPDB(const char* _fname)
{
	char buffer[256];
	TIn Max[3] = {-3600,-3600,-3600};
	TIn Min[3] = { 3600, 3600, 3600}; 
	
	ifstream infile(_fname);
	if(!infile.is_open()){
		cout << "Cannot find " <<  _fname << endl;
		exit(-1);
	}
	ogPoints_.clear();
	while(infile.getline(buffer,256))
	{
		TIn xyz[3] = {0, 0, 0};
		char buffer2[8];

		if((buffer[0] == 'H' && buffer[3] == 'A')||(buffer[0] == 'A' && buffer[3] == 'M')){
			for (int i=0; i<3; i++){
				for(int j=0; j<8; j++) 
					buffer2[j] = buffer[31+i*8+j];
				xyz[i] = atof(buffer2);
			}

#ifdef DEBUG	
//			cout << "\nReadPDB: [" << buffer << "]: xyz " 
				cout << xyz[0] <<" "<< xyz[1] <<" "<< xyz[2] << endl;	
#endif
		
			ogPoints_.push_back(xyz[0]); 
			ogPoints_.push_back(xyz[1]);
			ogPoints_.push_back(xyz[2]);

			for(int i=0;i<3;i++)
			{
				if(xyz[i] > Max[i]) Max[i] = xyz[i];
				if(xyz[i] < Min[i]) Min[i] = xyz[i];
			}
			
		}
	}
	
	for(int i=0;i<3;i++)
	{
		cen[i] = (Max[i]+Min[i])/2.0;
	}

#ifdef DEBUG
		cout << "\nCalculated Centers: " << cen[0] << " " 
			<< cen[1] << " " << cen[2] << endl;
#endif 
			
}


// read pdb file and get points according to residue number
template<class T, class TIn>
void Points2DX<T,TIn>::ReadPDB(const char* _fname, const char* _resNumfname)
{
	char buffer[256];
	TIn Max[3] = {-3600,-3600,-3600};
	TIn Min[3] = { 3600, 3600, 3600}; 
	
	// read the residue numbers
	ifstream resfile(_resNumfname);
	if(!resfile.is_open()){
		cout << "Cannot find " <<  _resNumfname << endl;
		exit(-1);
	}
	vector<int> resNum;
	int num = 0;
	while(resfile >> num ){	resNum.push_back(num);}
	resfile.close();
	
	// read pdbfile and get points correspoding to residues 
	ifstream infile(_fname);
	if(!infile.is_open()){
		cout << "Cannot find " <<  _fname << endl;
		exit(-1);
	}

	ogPoints_.clear();
	while(infile.getline(buffer,256))
	{
		TIn xyz[3] = {0, 0, 0};
		char buffer2[8];

		// if HETATM or ATM
		if((buffer[0] == 'H' && buffer[3] == 'A')||(buffer[0] == 'A' && buffer[3] == 'M')){
			
		// if the residue number is in the resNum vector
			for(int i = 0; i < 4; i++){buffer2[i] = buffer[22+i];}
			int resN = atoi(buffer2);
			
			int hit = 0;
			for(int i=0; i<resNum.size();i++)
			{
				if(resN == resNum[i]){ hit = 1;	break;}
			}
			if(hit)
			{
				// get x y z
				for (int i=0; i<3; i++){
					for(int j=0; j<8; j++) 
						buffer2[j] = buffer[31+i*8+j];
					xyz[i] = atof(buffer2);
				}
			
#ifdef DEBUG1	
		cout << "\nReadPDB: [" << resN << "]: xyz " << xyz[0] <<" "<< xyz[1] <<" "<< xyz[2] << endl;	
#endif
				// store xyz
				ogPoints_.push_back(xyz[0]); 
				ogPoints_.push_back(xyz[1]);
				ogPoints_.push_back(xyz[2]);

				// MIN MAX calculation
				for(int i=0;i<3;i++)
				{
					if(xyz[i] > Max[i]) Max[i] = xyz[i];
					if(xyz[i] < Min[i]) Min[i] = xyz[i];
				}
				
			} // end hit
		}		// end ATOM HETATM
	}			// end reading file
	
	for(int i=0;i<3;i++)
	{
		cen[i] = (Max[i]+Min[i])/2.0;
	}

#ifdef DEBUG
		cout << "\nCalculated Centers: " << cen[0] << " " 
			<< cen[1] << " " << cen[2] << endl;
#endif 

}


// read critical points coordinate and get center
//  #    type        x         y         z        nx        ny        nz        pvalue        svalue    nresidue    nsatom 
template<class T, class TIn>
void Points2DX<T,TIn>::ReadCP(const char* _fname)
{
	char buffer[256];
	TIn Max[3] = {-3600,-3600,-3600};
	TIn Min[3] = { 3600, 3600, 3600}; 
		ifstream infile(_fname);
	if(!infile.is_open()){
		cout << "Cannot find " << _fname << endl;
		exit(-1);
	}

	ogPoints_.clear();
	while(infile.getline(buffer,256))
	{
		TIn xyz[3] = {0,0,0};
		char buffer2[8];
		sscanf (buffer," %*d %*s %f %f %f %*f %*f %*f %*f %*f %*d %*d", &xyz[0], &xyz[1], &xyz[2]);

#ifdef DEBUG1	
		if (xyz[0] && xyz[1] && xyz[2]) 
			cout << "ReadCP: [" << buffer << "]: xyz " << xyz[0] <<" "<< xyz[1] <<" "<< xyz[2] << endl;	
#endif
		if (xyz[0] && xyz[1] && xyz[2]) 
		{
			
	 		ogPoints_.push_back(xyz[0]); 
			ogPoints_.push_back(xyz[1]);
			ogPoints_.push_back(xyz[2]);
	
			for(int i=0;i<3;i++)
			{
				if(xyz[i] > Max[i]) Max[i] = xyz[i];
				if(xyz[i] < Min[i]) Min[i] = xyz[i];
			}
		}
		
	}
	
	for(int i=0;i<3;i++)
	{
		cen[i] = (Max[i]+Min[i])/2.0;
	}

#ifdef DEBUG
		cout << "Calculated Centers: " << cen[0] << " " 
			<< cen[1] << " " << cen[2] << endl;
#endif 
	
}

// read x y z coordinate file and get
template<class T, class TIn>
void Points2DX<T,TIn>::ReadXYZ(const char* _fname)
{
	char buffer[256];
	TIn Max[3] = {-3600,-3600,-3600};
	TIn Min[3] = { 3600, 3600, 3600}; 
		ifstream infile(_fname);
	if(!infile.is_open()){
		cout << "Cannot find " << _fname << endl;
		exit(-1);
	}

	ogPoints_.clear();
	while(infile.getline(buffer,256))
	{
		float xyz[3] = {0,0,0};
		char buffer2[8];
		sscanf (buffer,"%f %f %f", &xyz[0], &xyz[1], &xyz[2]);

#ifdef DEBUG1	
		if (xyz[0] && xyz[1] && xyz[2]) 
			cout << "ReadXYZ: [" << buffer << "]: xyz " << xyz[0] <<" "<< xyz[1] <<" "<< xyz[2] << endl;	
#endif
		if (xyz[0] && xyz[1] && xyz[2]) 
		{
			
	 		ogPoints_.push_back((TIn)xyz[0]); 
			ogPoints_.push_back((TIn)xyz[1]);
			ogPoints_.push_back((TIn)xyz[2]);
	
			for(int i=0;i<3;i++)
			{
				if(xyz[i] > Max[i]) Max[i] = xyz[i];
				if(xyz[i] < Min[i]) Min[i] = xyz[i];
			}
		}
		
	}
	
	for(int i=0;i<3;i++)
	{
		cen[i] = (Max[i]+Min[i])/2.0;
	}

#ifdef DEBUG
		cout << "Calculated Centers: " << cen[0] << " " 
			<< cen[1] << " " << cen[2] << endl;
#endif 
	
}


// save the vector
template<class T, class TIn>
void Points2DX<T,TIn>::PutPoints(vector<TIn>& points)
{
    int size = points.size();
		ogPoints_.resize(size);
		
    for (int i=0; i<size; ++i)
    {
        ogPoints_[i] = points[i];
    }
}

/*----------------------------------------------------------*\
 * transform point position into apbs dx position						*
 * by  translation-> scaling-> adjust to grid center				*
 * using gridSize intervalSize cenx ceny cenz								*
\* -------------------------------------------------------- */

// no transformation
template<class T, class TIn>
void Points2DX<T,TIn>::NoTransform(int _dim, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ)
{
	dim_ = _dim;
	del_ = _del;
	// update center just in case it's different
	cen[0] = _cenX; cen[1] = _cenY; cen[2] = _cenZ;	
	
	trPoints_ = ogPoints_;
	
}


template<class T, class TIn>
void Points2DX<T,TIn>::TransformPoints(int _dim, TIn _del)
{
	dim_ = _dim;
	del_ = _del;
	TransformPoints(dim_, del_, cen[0], cen[1], cen[2]);
}

template<class T, class TIn>
void Points2DX<T,TIn>::TransformPoints(int _dim, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ)
{
	dim_ = _dim;
	del_ = _del;
	// update center just in case it's different
	cen[0] = _cenX; cen[1] = _cenY; cen[2] = _cenZ;	
	
	vector<T> temp;
	TIn s = 1.0/_del;
	TIn c = ((_dim - 1) /2.0);

	for(int i=0; i< ogPoints_.size(); i+=3)
	{
		// x
		temp.push_back(s * (ogPoints_[i] - _cenX) + c); 
		// y
		temp.push_back(s * (ogPoints_[i+1] - _cenY) + c);
		// z
		temp.push_back(s * (ogPoints_[i+2] - _cenZ) + c);
	}
	
	for(int i=0; i<temp.size();i++){
		if ( temp[i]<0 || temp[i] > dim_ )
	 	{	
			cout << "ERROR Transformation temp["<< i << "]: " << temp[i]<< endl;
			cout << "\t from points_:  " << ogPoints_[i] << endl;
 		}else
		{
			trPoints_.push_back(temp[i]);	
		}
	}
	
}

template<class T, class TIn>
void Points2DX<T,TIn>::SavePoints2DX ()
{
	int _d = (int)pow((float)dim_,3);
	T* result  = new T [_d];
	// initialize with 0
	for(int i = 0; i < _d; i++)
	{
		result[i] = 0;
	}
	
	// fill in the trPoints_ to grid
	for(int i = 0; i < trPoints_.size(); i+=3)
	{
			/*
			int j0 = (int)trPoints_[i+2]*dim_*dim_ + (int)trPoints_[i+1]*dim_ + (int)trPoints_[i]+2;
			int j1 = (int)trPoints_[i+2]*dim_*dim_ + (int)trPoints_[i+1]*dim_ + (int)trPoints_[i]+2;
			int j2 = (int)trPoints_[i+2]*dim_*dim_ + (int)(trPoints_[i+1]+1)*dim_ + (int)trPoints_[i];
			int j3 = (int)trPoints_[i+2]*dim_*dim_ + (int)(trPoints_[i+1]+1)*dim_ + (int)trPoints_[i];
			int j4 = (int)(trPoints_[i+2]+1)*dim_*dim_ + (int)trPoints_[i+1]*dim_ + (int)trPoints_[i];
			int j5 = (int)(trPoints_[i+2]+1)*dim_*dim_ + (int)trPoints_[i+1]*dim_ + (int)trPoints_[i];

			result[j0] = 1;
			result[j1] = 1;
			result[j2] = 1;
			result[j3] = 1;
			result[j4] = 1;
			result[j5] = 1;
			*/
		
		int j = (int)floor(trPoints_[i]+0.5)*dim_*dim_ + (int)floor(trPoints_[i+1]+0.5)*dim_ + (int)floor(trPoints_[i+2]+0.5);
		if(j>0 && j<_d)	
			result[j] = 1;
		else 
			cout << j << "is out of range \n"
					<< (int)floor(trPoints_[i]+0.5)<<"*" <<dim_<<"*" << dim_ << " + "
					<< (int)floor(trPoints_[i+1]+0.5)<<"*"<<dim_ 
					<< " + " << (int)floor(trPoints_[i+2]+0.5) << endl;
	}
	
	// save to DX 
	dx_.setGrid(result);	
//	dx_.setPara(dim_,del_,cen[0], cen[1], cen[2]);
	dx_.setGs(dim_, dim_, dim_);
	dx_.setDel(del_,del_,del_);
	
	TIn _minX = cen[0] - (((TIn)dim_- 1.0)/2.0)*del_;
	TIn _minY = cen[1] - (((TIn)dim_- 1.0)/2.0)*del_;
	TIn _minZ = cen[2] - (((TIn)dim_- 1.0)/2.0)*del_;

	dx_.setMin(_minX, _minY, _minZ);

}

template<class T, class TIn>
void Points2DX<T,TIn>::SavePoints (vector<TIn>&  points)
{

    int dim = trPoints_.size();
		points.resize(dim);
		
    for (int i=0; i<dim; ++i)
    {
        points[i] = trPoints_[i];
    }

}


template<class T, class TIn>
void Points2DX<T,TIn>::SavePoints (const char* _fname)
{

		ofstream fout(_fname);
    int dim = trPoints_.size();
	
    for (int i=0; i<dim; i+=3)
    {
        fout <<  trPoints_[i] << " " 
					<< trPoints_[i+1] << " " 
					<< trPoints_[i+2] << " "
					<< endl;
    }

}

template<class T, class TIn>
void Points2DX<T,TIn>::SaveDX(const char* _fname)
{
	SavePoints2DX();
	dx_.writeDX(_fname);
}

template<class T, class TIn>
VolumeDX<T,TIn> Points2DX<T,TIn>::GetDX()
{
	SavePoints2DX();
	return(dx_);
}


