/*============================================
 *
 * Sael Lee 
 * Jan. 09, 2008
 *
 *===========================================*/

#ifndef MESH2DX_H
#define MESH2DX_H

#include "Common.h"


template<typename T, typename TIn>
class Mesh2DX
{
	public:
		Mesh2DX(int _ftype, char* _fname, int _surfaceType, int _dim, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ);
		Mesh2DX(int _ftype, char* _fname, int _surfaceType, int _dim, TIn _del);
		Mesh2DX(int _ftype, char* _fname, int _surfaceType, int _dim);
		
		typedef VolumeDX<T,TIn> 							VDX;
	
		//---- public functions ----------------------
		void init();
		
		// clear functions;
		void clear();
//		void clearAcc(){acc_.clear();};
//		void clearPot(){pot_.clear();};
//		void clearSurf(){surf_.clear();};
//		void clearSurfFilled(){surfFilled_.clear();};
//		void clearSeed(){seed_.clear();};

		// read files
		int readFile(int _ftype, char* _fname, int _surfaceType);
	
		// 
		void calSurf();
		void calSurf(int cdepth);
	
		
		// write dx files 
		void writeSurf(const char* _fname);
		void writeProperty(const char* _fname);

		// get dx
		VDX getSurf(){return surfaceDX_;};
		VDX getSurfPot(){return propertyDX_;};
		
		void getPara(int& gs, TIn& del, TIn& cenx, TIn& ceny, TIn& cenz)
		{
			gs = dim_; del = del_;
			cenx = cenx_;	ceny = ceny_; cenz = cenz_;
		};
		
		void getCen(TIn& cenx, TIn& ceny, TIn& cenz)
		{
			cenx = cenx_;	ceny = ceny_; cenz = cenz_;
		};
		
		void getMin(TIn& minx, TIn& miny, TIn& minz)
		{
			minx = minx_;	miny = miny_; minz = minz_;
		};
	
		void getMax(TIn& maxx, TIn& maxy, TIn& maxz)
		{
			maxx = maxx_;	maxy = maxy_; maxz = maxz_;
		};

	
	private:
		//----- private variables -------------------
		int												dim_;	
		int 											d_;
		TIn 											del_;

		TIn 											threshold_;				
		TIn												para_;
		TIn	 											maxx_, maxy_, maxz_;
		TIn 											minx_, miny_, minz_;
		TIn 											cenx_, ceny_, cenz_;
		
		//------ input -------------------------------
		vector<TIn> 							vertex_;
		vector<int> 							face_;
		vector<TIn> 							property_;
	  vector<int>								edge_;
		
		int 											numV_;
		int 											numF_;
		int 											numP_;

		//------ output ------------------------------
		T*												surfaceGrid_;
		T*												propertyGrid_;
		
		VDX												surfaceDX_;
		VDX												propertyDX_;

		//------ private functions -------------------
		
		TIn distance(
				TIn ax, TIn ay, TIn az, 
				TIn bx, TIn by, TIn bz, 
				TIn cx, TIn cy, TIn cz, 
				TIn* x, TIn* y, TIn* z )
		{
			TIn a = ( by - ay ) * ( cz - az ) - ( bz - az ) * ( cy - ay );
			TIn b = ( bz - az ) * ( cx - ax ) - ( bx - ax ) * ( cz - az );
			TIn c = ( bx - ax ) * ( cy - ay ) - ( by - ay ) * ( cx - ax );
			TIn d = - bx * a - by * b - bz * c;
			TIn flen = sqrt ( a * a + b * b + c * c );
			TIn dist = fabs ( a * (*x) + b * (*y) + c * (*z) + d ) / flen;
			TIn fx=(*x), fy=(*y), fz=(*z);
			TIn dplus = fabs(a*(fx+dist*a/flen)+b*(fy+dist*b/flen)+c*(fz+dist*c/flen)+d);
			TIn dminus = fabs(a*(fx-dist*a/flen)+b*(fy-dist*b/flen)+c*(fz-dist*c/flen)+d);
			if (dplus < dminus) {
				(*x) += dist*a/flen; (*y) += dist*b/flen; (*z) += dist*c/flen;
			} else {
				(*x) -= dist*a/flen; (*y) -= dist*b/flen; (*z) -= dist*c/flen;
			}
			return dist;
		};
		
		bool checkboundary(
				TIn abc, TIn dist, 
				TIn ax, TIn ay, TIn az, 
				TIn bx, TIn by, TIn bz, 
				TIn cx, TIn cy, TIn cz, 
				TIn fx, TIn fy, TIn fz )
		{
			TIn nbc = AREA(fx, fy, fz, bx, by, bz, cx, cy, cz);
			TIn anc = AREA(ax, ay, az, fx, fy, fz, cx, cy, cz);
			TIn abn = AREA(ax, ay, az, bx, by, bz, fx, fy, fz);
			TIn diff = fabs(abc-nbc-anc-abn);
			diff /= abc;
		
			
			if (diff < 0.0001)
				return true;
		
			return false;
		}; 

		TIn AREA(
				TIn ax, TIn ay, TIn az, 
				TIn bx, TIn by, TIn bz, 
				TIn cx, TIn cy, TIn cz) 
		{
			TIn x1, y1, z1, x2, y2, z2;
			TIn nx, ny, nz;
			x1 = bx-ax; y1 = by-ay; z1 = bz-az;
			x2 = cx-ax; y2 = cy-ay; z2 = cz-az;
			nx = (y1 * z2) - (y2 * z1);
			ny = (z1 * x2) - (z2 * x1);
			nz = (x1 * y2) - (x2 * y1);
			TIn area = sqrt(nx*nx+ny*ny+nz*nz);
			return area;
		};
		
		int drawFace(int a, int b, int c); 
		
		void display();	
	
		void convert2DX();
};

#include "Mesh2DX.cpp"

#endif
