/*============================================
 *
 * Sael Lee 
 * Jan. 09, 2008
 *
 *===========================================*/

template<typename T, typename TIn>
Mesh2DX<T,TIn>::Mesh2DX(int _ftype, char* _fname, int _surfaceType, int _dim)
{
	readFile(_ftype, _fname, _surfaceType);

	maxx_ = minx_ = vertex_[0];
	maxy_ = miny_ = vertex_[1];
	maxz_ = minz_ = vertex_[2];
	
	
	int i, index;
	for (i=0,index=0; i<numV_; i++, index+=3) {
		TIn fx = vertex_[index], fy = vertex_[index+1], fz = vertex_[index+2];
		maxx_ = max(maxx_, fx); minx_ = min(minx_, fx);
		maxy_ = max(maxy_, fy); miny_ = min(miny_, fy);
		maxz_ = max(maxz_, fz); minz_ = min(minz_, fz);
	}	
	
	TIn diameter = 0; 
	diameter = DIST(minx_, miny_, minz_, maxx_, maxy_, maxz_);
	
	dim_ = _dim;
	para_ = dim_/diameter;
	del_ = 1.0/para_;
	d_ = dim_* dim_* dim_;
	threshold_ = THRESHOLD;
//	threshold_ = 1;
	
#ifdef DEBUG
	cout << "diameter : " << diameter
			 << "; para_ : " << para_ 
		   << "; del_ : " << del_
			 << "; dim_ : " << dim_
			 << "; d_ : " << d_<< endl;
	cout << " maxx: " << maxx_ << " minx: " << minx_
			 << " maxy: " << maxy_ << " miny: " << miny_
			 << " maxz: " << maxz_ << " minz: " << minz_ << endl;
	
#endif 

	
	convert2DX();

}

template<typename T, typename TIn>
Mesh2DX<T,TIn>::Mesh2DX(int _ftype, char* _fname, int _surfaceType, int _dim, TIn _del)
{
	readFile(_ftype, _fname, _surfaceType);

	maxx_ = minx_ = vertex_[0];
	maxy_ = miny_ = vertex_[1];
	maxz_ = minz_ = vertex_[2];
	
	int i, index;
	for (i=0,index=0; i<numV_; i++, index+=3) {
		TIn fx = vertex_[index], fy = vertex_[index+1], fz = vertex_[index+2];
		maxx_ = max(maxx_, fx); minx_ = min(minx_, fx);
		maxy_ = max(maxy_, fy); miny_ = min(miny_, fy);
		maxz_ = max(maxz_, fz); minz_ = min(minz_, fz);
	}	
	
	TIn diameter = 0; 
	diameter = DIST(minx_, miny_, minz_, maxx_, maxy_, maxz_);
	
	dim_ = _dim;
	del_ = _del;
	para_ = 1.0/del_;
	d_ = dim_* dim_* dim_;
	threshold_ = 1.733;

	//	threshold_ = 1;
	
#ifdef DEBUG
	cout << "diameter : " << diameter
			 << "; para_ : " << para_ 
		   << "; del_ : " << del_
			 << "; dim_ : " << dim_
			 << "; d_ : " << d_<< endl;
	cout << " maxx: " << maxx_ << " minx: " << minx_
			 << " maxy: " << maxy_ << " miny: " << miny_
			 << " maxz: " << maxz_ << " minz: " << minz_ << endl;
	
#endif 

	
	convert2DX();

}


template<typename T, typename TIn>
Mesh2DX<T,TIn>::Mesh2DX(int _ftype, char* _fname, int _surfaceType, int _dim, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ)
{
	threshold_ = THRESHOLD;
	dim_ = _dim;
	del_ = _del;
	d_ = dim_*dim_*dim_;
		
	para_ =  1.0/del_;
	
	minx_ = _cenX - ((dim_-1.0) * del_)/2.0;
	miny_ = _cenY - ((dim_-1.0) * del_)/2.0;
	minz_ = _cenZ - ((dim_-1.0) * del_)/2.0;
	

	maxx_ = _cenX + ((dim_-1.0) * del_)/2.0;
	maxy_ = _cenY + ((dim_-1.0) * del_)/2.0;
	maxz_ = _cenZ + ((dim_-1.0) * del_)/2.0;
	

	readFile(_ftype, _fname, _surfaceType);
	
	convert2DX();

}

template<typename T, typename TIn>
void Mesh2DX<T,TIn>::clear()
{
	surfaceDX_.clear();
	propertyDX_.clear();
}

template<typename T, typename TIn>
int Mesh2DX<T,TIn>::readFile(int _ftype, char* _fname, int _surfaceType)
{
	char buf[256];

	cout << "Reading file " << _fname << endl;
	// open file
	ifstream fin(_fname);
	if(!fin.is_open()){
		cout << "FILE " << _fname << " could not be opened\n";
		exit(-1);
	}
	
	if(_ftype == OBJ)
	{
		int f1, f2, f3, x;
		double v1, v2, v3, p;
		
		numV_ = 0; numF_ = 0; numP_ = 0;

		while(fin.getline(buf, 256))
		{
			switch(buf[0]){
				case 'f': 		// face start with f one two tree ....
					x=sscanf(buf, "f %d %d %d", &f1, &f2, &f3);
					if (x!=3) return 0;
					face_.push_back(f1); face_.push_back(f2); face_.push_back(f3);
					numF_++;
					break;
				case 'v':  		// vertex start with v x y z
					x=sscanf(buf, "v %lf %lf %lf", &v1, &v2, &v3);
					if (x!=3) return 0;
					vertex_.push_back(v1); vertex_.push_back(v2); vertex_.push_back(v3);
					numV_++;
					break;
				case 'p':			// property start with p value value ...
					if(_surfaceType == PROPERTY)
					{
						x=sscanf(buf, "p %lf", &p);
						if (x!=1) return 0;
						property_.push_back((TIn)p); 
						numP_++;
					}
					break;
				case '#':
					break;
				default:
						cout << "unknow structure in obj file" << _fname << endl;
						exit(-1);
			}
		}
		
	}

	else if(_ftype == GTS)
	{
		fin.getline(buf, 256);
		int _numE;
		vector<int> _edge;
		int x=sscanf(buf, "%d %d %d GtsSurface GtsFace GtsEdge GtsVertex", &numV_, &_numE ,&numF_);
		if (x!=3) return 0;
		numP_ = 0;
		
		cout << numV_ << _numE << numF_  << endl;
		// get Vertex
		TIn v;
		for(int i = 0; i < numV_*3; i++)
		{
			fin >> v;
			vertex_.push_back(v);
		}
		
		// get Edges
		int e; 
		for(int i = 0; i < _numE*2; i++)
		{
			fin >> e;
			_edge.push_back(e);
		}
		
		// get face
		int f;
		int el[2];
		int num;
		for(int i = 0; i < numF_*3; i+=3)
		{
			num = 2;

			fin >> f;
			int a1 = _edge[f*2-2];
			int a2 = _edge[f*2-1];
			face_.push_back(a1);
			face_.push_back(a2);
				
	
			for(int j=0; j<2; j++){
				fin >> f;
				int a3 = _edge[f*2-2];
				if(a3 != a1 && a3 != a2 )
				{
					face_.push_back(a3);
					num++;
					fin >> f;
					break;
				}
				
				int a4 = _edge[f*2-1];
				if(a4 != a1 && a4 != a2 )
				{
					face_.push_back(a4); 
					num++;
					fin >> f;
					break;
				}
				
			}
			if(num!=3){
				cout << "Something wrong with face. we got " << num << " point\n";
				exit(-1);
			}
		}

	}

	
	else if(_ftype == MSP)
	{
		fin.getline(buf, 256);
		int _numE;
		vector<int> _edge;
		int x=sscanf(buf, "%d %d %d", &numV_, &_numE ,&numF_);
		if (x!=3) return 0;
		numP_ = 0;
		
		cout << numV_ << _numE << numF_  << endl;
		// get Vertex
		TIn v;
		for(int i = 0; i < numV_*3; i++)
		{
			fin >> v;
			vertex_.push_back(v);
			
			fin >> v;
			vertex_.push_back(v);

			fin >> v;
			vertex_.push_back(v);

			fin.ignore(256,'\n');
		}
		
		// get Edges
		int e; 
		for(int i = 0; i < _numE*2; i++)
		{
			fin >> e;
			_edge.push_back(e);
		
			fin >> e;
			_edge.push_back(e);

			fin.ignore(256,'\n');
		}
		
		// get face
		int f;
		int el[2];
		int num;
		for(int i = 0; i < numF_*3; i+=3)
		{
			num = 2;

			fin >> f;
			int a1 = _edge[f*2-2];
			int a2 = _edge[f*2-1];
			face_.push_back(a1);
			face_.push_back(a2);
				
	
			for(int j=0; j<2; j++){
				fin >> f;
				int a3 = _edge[f*2-2];
				if(a3 != a1 && a3 != a2 )
				{
					face_.push_back(a3);
					num++;
					fin >> f;
					break;
				}
				
				int a4 = _edge[f*2-1];
				if(a4 != a1 && a4 != a2 )
				{
					face_.push_back(a4); 
					num++;
					fin >> f;
					break;
				}
				
			}
			if(num!=3){
				cout << "Something wrong with face. we got " << num << " point\n";
				exit(-1);
			}

			fin.ignore(256,'\n');
		}

	}

	fin.close();
	
#ifdef DEBUG
	cout << "++++++++++++++++++++++++++++++++++++++++++++++++\n";
	for(int i=0; i<numV_*3; i+=3){
		cout << "v " << vertex_[i] << " " << vertex_[i+1] << " " << vertex_[i+2] << endl;
	}	
	for(int i=0; i<numF_*3; i+=3){
		cout << "f " << face_[i] << " " << face_[i+1] << " " << face_[i+2] << endl;
	}	
	if(numP_ != 0){
		for(int i=0; i<numP_; i++){
			cout << "p " << property_[i]  << endl;
		}
	}
	cout << "+++++++++++++++++++++++++++++++++++++++++++++++\n";
#endif
	
	return 0;
}

template<typename T, typename TIn>
int Mesh2DX<T,TIn>::drawFace(int a, int b, int c) {

	int ga, gb, gc;
	TIn ax, ay, az, bx, by, bz, cx, cy, cz;
	int ea, eb, ec;
	TIn e1=0, e2=0, e3=0;
	
	ga = a*3; gb = b*3; gc = c*3;
	ea = a; eb = b; ec = c;
	
	ax = vertex_[ga]; ay = vertex_[ga+1]; az = vertex_[ga+2];
	bx = vertex_[gb]; by = vertex_[gb+1]; bz = vertex_[gb+2];
	cx = vertex_[gc]; cy = vertex_[gc+1]; cz = vertex_[gc+2];
	
	if(property_.size()){
		e1 = property_[ea]; 
		e2 = property_[eb];
		e3 = property_[ec];
	}
	
	TIn abc = AREA(ax, ay, az, bx, by, bz, cx, cy, cz);
	int _minx = (int)ax-1, _miny = (int)ay-1, _minz=(int)az-1;
	int _maxx = (int)ax+1, _maxy = (int)ay+1, _maxz=(int)az+1;
	_minx = min(_minx, (int)bx-1); _miny = min(_miny, (int)by-1); _minz = min(_minz, (int)bz-1);
	_minx = min(_minx, (int)cx-1); _miny = min(_miny, (int)cy-1); _minz = min(_minz, (int)cz-1);
	_maxx = max(_maxx, (int)bx+1); _maxy = max(_maxy, (int)by+1); _maxz = max(_maxz, (int)bz+1);
	_maxx = max(_maxx, (int)cx+1); _maxy = max(_maxy, (int)cy+1); _maxz = max(_maxz, (int)cz+1);
	_minx = max( -dim_/2, _minx); _miny = max( -dim_/2, _miny); _minz = max( -dim_/2, _minz);
	_maxx = min(dim_/2-1, _maxx); _maxy = min(dim_/2-1, _maxy); _maxz = min(dim_/2-1, _maxz);
	
	int x, y, z, total = 0;
	for (x=_minx; x<=_maxx; x++) {
		for (y=_miny; y<=_maxy; y++) {
			for (z=_minz; z<=_maxz; z++) {
				TIn fx = (TIn)x, fy = (TIn)y, fz = (TIn)z;
				TIn dist = distance(ax, ay, az, bx, by, bz, cx, cy, cz, &fx, &fy, &fz);

				if (dist > threshold_) {
					continue;
				}
			
				if (!checkboundary(abc, dist, ax, ay, az, bx, by, bz, cx, cy, cz, fx, fy, fz)){
					continue;
				}
		
				TIn nbc = AREA(fx, fy, fz, bx, by, bz, cx, cy, cz);
				TIn anc = AREA(ax, ay, az, fx, fy, fz, cx, cy, cz);
				TIn abn = AREA(ax, ay, az, bx, by, bz, fx, fy, fz);
				TIn abc = nbc+anc+abn;
				
				int mid = ROUND((dim_-1.0)/2.0);
				TIn value = (TIn)surfaceGrid_[INDEX1(x+mid, y+mid, z+mid, dim_)];
				
				// Property estimation
				TIn dG, pvalue;
				if(property_.size()){
					dG = e1*nbc/abc+e2*anc/abc+e3*abn/abc;
					pvalue = (TIn)propertyGrid_[INDEX1(x+mid, y+mid, z+mid, dim_)];
				}
					
				if (value < 0) {
					total++; 
					surfaceGrid_[INDEX1(x+mid, y+mid, z+mid, dim_)] = (T)dist;
					if( property_.size()){
						propertyGrid_[INDEX1(x+mid, y+mid, z+mid, dim_)] = (T)dG;
					}
				} else {
					value = min(dist, value);
					surfaceGrid_[INDEX1(x+mid, y+mid, z+mid, dim_)] = value;
					if( property_.size()){		
						//pvalue = min(dG, pvalue);
						propertyGrid_[INDEX1(x+mid, y+mid, z+mid, dim_)] = (T)pvalue;
					}

				}
			}
		}
	}
	
	return total;
}

template<typename T, typename TIn>
void Mesh2DX<T,TIn>::display() {

	for (int i=0, index=0; i<numF_; i++, index+=3) {
		drawFace(face_[index], face_[index+1], face_[index+2]);
	}

	for(int index=0; index < d_; index++)
	{
		T value = surfaceGrid_[index];
		if (value > -1.0) {
			if (value <= threshold_)
				surfaceGrid_[index] = 1;
		} else {
				surfaceGrid_[index] = 0;
			if(property_.size()){
				propertyGrid_[index] = 0;
			}
		}
	}
}

template<typename T, typename TIn>
void Mesh2DX<T,TIn>::calSurf()
{
#ifdef DEBUG
	cout << "calSurf\n";
#endif
	
	
	// initialize grid
	surfaceGrid_ = new T [d_];
	if(property_.size()){	propertyGrid_ = new T [d_]; }
	for(int i = 0; i < d_; i++)
	{
		surfaceGrid_[i] = -1;
		if(property_.size()){ propertyGrid_[i] = -1; }
	}
	
	cenx_ = ( maxx_ + minx_ )/2.0; 
	ceny_ = ( maxy_ + miny_ )/2.0; 
	cenz_ = ( maxz_ + minz_ )/2.0;

#ifdef DEBUG
	cout << "center: "<< cenx_ << " " << ceny_ << " " << cenz_ << " \n";
#endif
	
	
	Points2DX<T,TIn> trans;
	
#ifdef DEBUG
	cout << "====before Transform====" << vertex_.size() << endl;
	for(int i =0; i< vertex_.size(); i+=3){
		cout << vertex_[i] << " " << vertex_[i+1] << " " << vertex_[i+2] << " " << endl; 
	}
#endif
	
	/*
	trans.PutPoints(vertex_);
	
	trans.TransformPoints(dim_, del_, cenx_, ceny_, cenz_);
	
	trans.SavePoints(vertex_);
	TIn c = (dim_/2.0);
	for(int i =0; i< vertex_.size(); i+=3){
		vertex_[i] -= c;		
	}
	*/
	
	for (int i=0, index=0; i<numV_; i++, index+=3) {
		vertex_[index]   -= cenx_; 
		vertex_[index+1] -= ceny_;
		vertex_[index+2] -= cenz_;
		vertex_[index] *= para_; vertex_[index+1] *= para_; vertex_[index+2] *= para_;
	}
	
#ifdef DEBUG
	cout << "====after Transform====\n";
	for(int i =0; i< vertex_.size(); i+=3){
		cout << vertex_[i] << " " << vertex_[i+1] << " " << vertex_[i+2] << " " << endl; 
	}
#endif

	
	for (int i=0,index=0; i<numF_; i++, index+=3) {
		face_[index]--; face_[index+1]--; face_[index+2]--;
	}
	
#ifdef DEBUG
	cout << "convert2DX() moving to display()\n";
#endif
	
	display();

	TIn mx = cenx_ - (((TIn)dim_ - 1.0)/2.0)*del_;
	TIn my = ceny_ - (((TIn)dim_ - 1.0)/2.0)*del_;
	TIn mz = cenz_ - (((TIn)dim_ - 1.0)/2.0)*del_;
	
	surfaceDX_.setGrid(surfaceGrid_);
	surfaceDX_.setGs(dim_, dim_, dim_);
	surfaceDX_.setDel(del_, del_, del_);
	surfaceDX_.setMin(mx, my, mz);

	if(property_.size()){
		propertyDX_.setGrid(propertyGrid_);
		propertyDX_.setGs(dim_, dim_, dim_);
		propertyDX_.setDel(del_, del_, del_);
		propertyDX_.setMin(mx, my, mz);
	}
		
	// free vectors
	 
	vertex_.clear();
	face_.clear();
	property_.clear();
	edge_.clear();


}

template<typename T, typename TIn>
void Mesh2DX<T,TIn>::convert2DX()
{

#ifdef DEBUG
	cout << "convert2DX\n";
#endif
	
	
	// initialize grid
	surfaceGrid_ = new T [d_];
	if(property_.size()){	propertyGrid_ = new T [d_]; }
	for(int i = 0; i < d_; i++)
	{
		surfaceGrid_[i] = -1;
		if(property_.size()){ propertyGrid_[i] = -1; }
	}

	cout << "make surfaceGrid\n";
	
	cenx_ = ( maxx_ + minx_ )/2.0; 
	ceny_ = ( maxy_ + miny_ )/2.0; 
	cenz_ = ( maxz_ + minz_ )/2.0;

	for (int i=0, index=0; i<numV_; i++, index+=3) {
		vertex_[index]   -= cenx_; 
		vertex_[index+1] -= ceny_;
		vertex_[index+2] -= cenz_;
		vertex_[index] *= para_; vertex_[index+1] *= para_; vertex_[index+2] *= para_;
	}
	

	for (int i=0,index=0; i<numF_; i++, index+=3) {
		face_[index]--; face_[index+1]--; face_[index+2]--;
	}
	
#ifdef DEBUG
	cout << "convert2DX() moving to display()\n";
#endif
	
	display();

	TIn mx = cenx_ - (((TIn)dim_ - 1.0)/2.0)*del_;
	TIn my = ceny_ - (((TIn)dim_ - 1.0)/2.0)*del_;
	TIn mz = cenz_ - (((TIn)dim_ - 1.0)/2.0)*del_;
	
	surfaceDX_.setGrid(surfaceGrid_);
	surfaceDX_.setGs(dim_, dim_, dim_);
	surfaceDX_.setDel(del_, del_, del_);
	surfaceDX_.setMin(mx, my, mz);

	if(property_.size()){
		propertyDX_.setGrid(propertyGrid_);
		propertyDX_.setGs(dim_, dim_, dim_);
		propertyDX_.setDel(del_, del_, del_);
		propertyDX_.setMin(mx, my, mz);
	}
		
	// free vectors
	 
	vertex_.clear();
	face_.clear();
	property_.clear();
	edge_.clear();

}

template<typename T, typename TIn>
void Mesh2DX<T,TIn>::writeSurf(const char* _fname)
{
#ifdef DEBUG
	cout << "writing surface dx file to : " << _fname << endl;
#endif
	
	surfaceDX_.writeDX(_fname);
}

template<typename T, typename TIn>
void Mesh2DX<T,TIn>::writeProperty(const char* _fname)
{
	propertyDX_.writeDX(_fname);
}

