/*============================================
 *
 * Sael Lee 
 * March 13, 2007
 *
 *===========================================*/

#ifndef MESH__H
#define MESH__H

#include "Commom.h"

class MeshVertex
{
	public:
		int id;
		float x, y, z;	 // x y z positions
		vector<int> nf; // neighbor faces
		vector<float> inv;
		vector<float> sinv;
		
		void init(int _id, float _x, float _y, float _z)
		{
			id=_id; x=_x; y=_y; z=_z;
		};
		
		void putInv(vector<float> _inv)
		{
			inv.resize(_inv.size());
			for(int i=0; i<_inv.size(); i++){inv[i]=_inv[i];}
		};
		
		void stdInv()
		{
			float sqrsum;
			sinv.resize(inv.size());
			for(int i=0; i<inv.size(); i++){ sqrsum += inv[i]*inv[i]; }
			sqrsum=sqrt(sqrsum);
			for(int i=0; i<inv.size(); i++){ sinv[i] = inv[i]/sqrsum; }
		};

		void copy(MeshVertex _node)
		{
			x = _node.x;
			y = _node.y;
			z = _node.z;
			nf.resize((_node.nf).size());
			for(int i=0; i<nf.size(); i++)
			{
				nf[i] = (_node.nf)[i];
			}	
			if((_node.inv).size()>0){
				inv.resize((_node.inv).size());
				for(int i=0; i<inv.size(); i++)
				{
					inv[i] = (_node.inv)[i];
				}	
			}
			if((_node.sinv).size()>0){
				sinv.resize((_node.sinv).size());
				for(int i=0; i<sinv.size(); i++)
				{
					sinv[i] = (_node.sinv)[i];
				}	
			}
			
		};
		
};

template<class T, class TIn>
class Mesh
{
	public:
			
		int 																mType_; 			// mesh type  msms msp gts
		
		int 																numVertex_;		// number of vertexs in mesh
		int 																numFace_;			// number of faces in mesh
		int																	numContainer_;
		TIn																	cenx_, ceny_, cenz_;	// center position fo mesh & grid
		TIn 																maxx_, maxy_, maxz_;	// max position of mesh in Angstrom
		TIn 																minx_, miny_, minz_;	// min position of mesh in Angstrom
		TIn 																cdel_;				// delta of containers
		TIn 																maxC_;				// max position of container in Angstrom
		TIn 																minC_;				// min position of container in Angstrom
		
				
		vector<MeshVertex> 									vertex_;			// global vertex
		vector<vector<int> >								face_;				// globla face		
		vector<vector<int> > 								container_;		// container
		
		int																	order_;
		int 																ldim_;
		TIn 																ldel_;
		TIn 																radius_; 
		
		void clear();

		void ReadMSMS(const char* _vertfile, const char* _facefile);
		void ReadMSP();
		void ReadGTS();

		void MakeContainer();
		int GetCN(float x, float y, float z);		

		void SetZDPara(int _order, int _ldim, TIn _ldel, TIn _radius );

};


#include "Mesh.cpp"

#endif


