template<class T, class TIn>
void Mesh<T, TIn>::clear()
{
	vertex_.clear();
	face_.clear();
	container_.clear();
}



template<class T, class TIn>
void Mesh<T, TIn>::ReadMSMS(const char* _vertfile, const char* _facefile)
{
	// ----------------------------------
	// process Vertex file and min max
	// ----------------------------------
	
	ifstream fin1( _vertfile );
	if(!fin1.is_open()){
		cout << "file "<< _vertfile<< " could not be opend\n";
		exit(1);
	}
	//# MSMS solvent excluded surface vertices for 1d7s.A.DCS.0.5.xyzr
	fin1.ignore(256, '\n');
	//#vertex #sphere density probe_r
	fin1.ignore(256, '\n');
	//  26515    6527  1.00  1.50
	fin1 >> numVertex_;
	fin1.ignore(256, '\n');
	
	vertex_.resize(numVertex_+1);
	// vertex_[0] is dummy
	minx_ = 9999; 	miny_ = 9999; 	minz_ = 9999;
	maxx_ = -9999;	maxy_ = -9999; 	maxz_ = -9999;
	for(int i=1; i <= numVertex_; i++){
		float tmp;
		fin1 >> tmp; vertex_[i].x = tmp;
		if(minx_>(TIn)tmp) minx_ = (TIn)tmp;
		if(maxx_<(TIn)tmp) maxx_ = (TIn)tmp;
		
		fin1 >> tmp; vertex_[i].y = tmp;
		if(miny_>(TIn)tmp) miny_ = (TIn)tmp;
		if(maxy_<(TIn)tmp) maxy_ = (TIn)tmp;
		
		fin1 >> tmp; vertex_[i].z = tmp;
		if(minz_>(TIn)tmp) minz_ = (TIn)tmp;
		if(maxz_<(TIn)tmp) maxz_ = (TIn)tmp;
		fin1.ignore(100, '\n');
	}
	fin1.close();
	
	cenx_ = ( maxx_ + minx_ )/2.0; 
	ceny_ = ( maxy_ + miny_ )/2.0; 
	cenz_ = ( maxz_ + minz_ )/2.0;


	// --------------------------------
	// process Face file
	// --------------------------------
	
	ifstream fin2( _facefile );
	if(!fin2.is_open()){
		cout << "file "<< _facefile << " could not be opend\n";
		exit(1);
	}
	//	# MSMS solvent excluded surface faces for 182l.X.BZF.0.0.xyzr
	fin2.ignore(256, '\n');
	//	#faces  #sphere density probe_r
	fin2.ignore(256, '\n');
	//  23202    2603  1.00  1.50
 	fin2 >> numFace_;
	fin2.ignore(256, '\n');

	face_.resize(numFace_+1);	
	//face_[0] is dummy
	//put data
	for(int i=1; i<= numFace_; i++){
		int tmp;
		face_[i].resize(3);
		for(int j = 0; j<3; j++){
			fin2 >> tmp; face_[i][j] = tmp;
			(vertex_[tmp].nf).push_back(i);
		}
		fin2.ignore(100, '\n');
	}
	fin2.close();

}

template<class T, class TIn>
void Mesh<T, TIn>::MakeContainer()
{

#ifdef DEBUG

	for(int i=1; i<= numVertex_; i++)
	{
		cout << "VERTEX num " << i << ":" << endl;
		cout << "XYZ: " << vertex_[i].x << " "<< vertex_[i].y << " "<< vertex_[i].z << endl;
		cout << "nf: " ;
		for(int j=0; j<(vertex_[i].nf).size(); j++){
			cout << (vertex_[i].nf)[j] << " ";
		}
		cout << endl;
	}
	
#endif


	// --------------------------------
	// process container
	// --------------------------------
//	minGx_ = cenx_ - (((TIn)dim_ - 1.0)/2.0)*del_;
//	minGy_ = ceny_ - (((TIn)dim_ - 1.0)/2.0)*del_;
//	minGz_ = cenz_ - (((TIn)dim_ - 1.0)/2.0)*del_;
	
//	maxGx_ = cenx_ + (((TIn)dim_ - 1.0)/2.0)*del_;
//	maxGy_ = ceny_ + (((TIn)dim_ - 1.0)/2.0)*del_;
//	maxGz_ = cenz_ + (((TIn)dim_ - 1.0)/2.0)*del_;

	minC_ = min(minx_, min(miny_,minz_));
	maxC_ = max(maxx_, max(maxy_,minz_));
		
	int numC = (int)pow((float)(numVertex_/27), (float)(1.0/3.0)) + 1 ;
	cdel_ =  (TIn)(maxC_ - minC_)/(TIn)numC;
#ifdef DEBUG
	cout << "numC: " << numC << "Cdels: "<< cdel_ << endl;
#endif		
	numContainer_ = (int)pow((float)numC, 3);
		
	container_.resize(numContainer_ + 1); // leave extra possition for vertex outside range
		
	for(int i=1; i<=numVertex_; i++)
	{
		int j = GetCN(vertex_[i].x, vertex_[i].y, vertex_[i].z);
		if(j>=0 && j< numContainer_ ){
			container_[j].push_back(i);
		}else if(j == numContainer_) {
			container_[j].push_back(i);
		}else{
			cout << "Unsuccesful retriving container number :" << j <<  endl;
			exit(-1);
		}
	}
		

#ifdef DEBUG

	for(int i=0; i<= numContainer_; i++)
	{
		if(container_[i].size()>0){
			cout << "CONTAINER num " << i << ":" << endl;
			for(int j=0; j<(container_[i]).size(); j++){
				 cout << container_[i][j] << " ";
			}
			cout << endl;
		}
	}
	
#endif
	
}



template<typename T, typename TIn>
int Mesh<T,TIn>::GetCN(float _x, float _y, float _z)
{
	if(_x>maxC_ || _x<minC_ || _y>maxC_ || _y<minC_ || _z>maxC_ || _z<minC_){
		return numContainer_;
	}
	else{	
		int numC = (int)pow((float)numContainer_, (float)(1.0/3.0));
		
		
		TIn t1 = fabs( _x - minC_);
		TIn t2 = fabs( _y - minC_);
		TIn t3 = fabs( _z - minC_);

		int one 	= (t1 < maxC_) ? (int)(t1/cdel_) : (int)(t1/cdel_) - 1; 
		int two 	= (t2 < maxC_) ? (int)(t2/cdel_) : (int)(t2/cdel_) - 1; 
		int three = (t3 < maxC_) ? (int)(t3/cdel_) : (int)(t3/cdel_) - 1; 



		
 //		int one 	=  (int)((fabs(_x - minC_ ))/cdel_);
//		int two 	=  (int)((fabs(_y - minC_ ))/cdel_);
//		int three =  (int)((fabs(_z - minC_ ))/cdel_);


		
#ifdef DEBUG
		cout << "numC:" << numC << " cdel_:"<<cdel_ << "minC_ :" << minC_ <<
			" _x: " << _x << " _y: " << _y << " _z: " << _z 
			<< " One: " << one << " Two: " << two << " three: " << three 
			<<" return:  " << ((one*numC + two)*numC + three) << endl;
#endif
		
		return ((one*numC + two)*numC + three);
	}
}



template<typename T, typename TIn>
void Mesh<T,TIn>::SetZDPara(int _order, int _ldim, TIn _ldel, TIn _radius )
{
	order_ = _order;
	ldim_ = _ldim;
	ldel_ = _ldel;
	radius_ = _radius;
}


