
/*------------------------------------
 * April 18, 2008
 * By : Sael Lee
 *
 * maps atom or residue based properites to
 * defined surface (grid format)
 * concerns smooting.
 *
 * Energy(continuous) terms: 
 * define surface atoms => average contribution weighted by 1/distance^2
 * 
 * descrete terms:
 * 
 * ------------------------------------ */


#ifndef MAP_PDB2SURF__H
#define MAP_PDB2SURF__H

// --- std include ---
//#include <vector>
//#include <iostream>
//#include <fstream>
//#include <string>
//#include <map>
//#include <cmath>

//using namespace std;

//#include <stdio.h>

#include "ProcessPDB.h"
#include "Common.h"
#include <math.h>
//#include "SeedVec.h"
//#include "SurfVec.h"
//#include "VolumeDX.h"


template<class T, class TIn>
class MapPdb2Surf
{
	private:
		vector<ATOMStruct> 							atom_;
		VolumeDX<T,TIn>									surfDX_;
		T* 															surfGrid_;
		TIn 														radius_;	
		
		TIn															delX_, delY_, delZ_;
		int															gsX_, gsY_, gsZ_;
		TIn															cenX_, cenY_, cenZ_;
	
		T*															kdSurfG_;
		VolumeDX<T,TIn>									kdSurfDX_;

		SurfVec<T,TIn>*									surfVec_;
		SeedVec<T,TIn>*									seedVec_;

		
	public:
		MapPdb2Surf(){init();};	
		~MapPdb2Surf(){clear();};

		void init();
		void clear();
		
		void setPdb( vector<ATOMStruct> _atom );		
		void setSurfDX( VolumeDX<T,TIn> _dx );
		void setSurfGrid( T* _grid );
		void setPara(	int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ );
	 	void setPara( int _gsX, int _gsY, int _gsZ,TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ );
	
		void setRadius( TIn _rad );
	
		void setSeedVec(SeedVec<T,TIn> *_seedVec){ seedVec_ = _seedVec; };
		void setSurfVec(SurfVec<T,TIn> *_surfVec){ surfVec_ = _surfVec; };

		VolumeDX<T,TIn> mapKDhydro( vector<ATOMStruct> _atom, TIn _rad,  T* _grid, int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ );
		VolumeDX<T,TIn> mapKDhydro( vector<ATOMStruct> _atom, TIn _rad,  T* _grid, 	int _gsX, int _gsY, int _gsZ,TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ );
	
		VolumeDX<T,TIn> mapKDhydro( vector<ATOMStruct> _atom, TIn _rad,  VolumeDX<T,TIn> _dx );
		VolumeDX<T,TIn> mapKDhydro();
			
		void mapKDhydro( vector<ATOMStruct> _atom, TIn _rad, int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ, SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec);
		void mapKDhydro( vector<ATOMStruct> _atom, TIn _rad, 	int _gsX, int _gsY, int _gsZ,TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ, SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec);
		void mapHB( vector<ATOMStruct> _atom, TIn _rad, 	int _gsX, int _gsY, int _gsZ,TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ, SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec);
		void map_XlogP( vector<ATOMStruct> _atom, TIn _rad, int _gsX, int _gsY, int _gsZ,TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ, SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec);  
		void map_real_XlogP( vector<ATOMStruct> _atom, TIn _rad, int _gsX, int _gsY, int _gsZ,TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ, SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec);  
		void map_aromaticity( vector<ATOMStruct> _atom, TIn _rad, int _gsX, int _gsY, int _gsZ,TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ, SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec);
//		void mapKDhydroVec( vector<ATOMStruct> _atom, TIn _rad,  VolumeDX<T,TIn> _dx,  SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec);
		void mapKDhydroVec();
		void mapHBondVec();
		void map_XlogP_MHP();
		void map_XlogP_real_MHP();
		void map_arom_to_grid();
		

	private:
		int getAtomsInLS(float _x, float _y, float _z, vector<int>& atmlst);
		
		void trans2OrgCoor(int _i, int _j, int _k, float& _a, float& _b, float& _c)
		{
			_a = (_i - (gsX_ - 1)/2.0)*delX_ + cenX_;
			_b = (_j - (gsY_ - 1)/2.0)*delY_ + cenY_;
			_c = (_k - (gsZ_ - 1)/2.0)*delZ_ + cenZ_;
		};

		void mappingV1(float _x, float _y, float _z, const vector<int>& atmlst, vector<TIn>& weightlst);
	
		
};

#include "MapPdb2Surf.cpp"

#endif

