template<class T, class TIn>
void MapPdb2Surf<T,TIn>::init()
{
	atom_.clear(); 
	surfGrid_ = NULL;
	delX_ = 0; delY_ = 0; delZ_ = 0; 
	gsX_ = gsY_ = gsZ_ = 0;
	cenX_=0; cenY_=0; cenZ_=0;
	radius_ = 0;
};
		

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::clear()
{

}

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::setPdb(vector<ATOMStruct> _atom )		
{ 
	atom_ = _atom; 
}


template<class T, class TIn>
void MapPdb2Surf<T,TIn>::setSurfDX(VolumeDX<T,TIn> _dx)
{
	surfDX_ = _dx; 
	surfDX_.getPara(gsX_, gsY_, gsZ_, delX_, delY_, delZ_, cenX_, cenY_, cenZ_);
	surfGrid_ = surfDX_.getGrid();
}

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::setSurfGrid(T* _grid)
{ 
	surfGrid_ = _grid; 
}

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::setPara(	int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ )
{
	gsX_ 	= gsY_ = gsZ_ =	_gs; 		
	delX_ = delY_ = delZ_=	_del;
	cenX_ =  	_cenX; 	
	cenY_ =  	_cenY; 	
	cenZ_ =  	_cenZ;

#ifdef DEBUG
	cout << "Parameter Set to :" 
	<< " gs " << gsX_ << " " << gsY_ << " "  << gsZ_ 
	<< " del " << delX_  << " " << delY_  << " " << delZ_
	<< " cen " << cenX_  << " " << cenY_  << " " << cenZ_ << endl;
#endif

}

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::setPara(	int _gsX, int _gsY, int _gsZ,TIn _delX, TIn _delY, TIn _delZ,  TIn _cenX, TIn _cenY, TIn _cenZ )
{
	gsX_ 	= _gsX; gsY_ 	= _gsY; gsZ_ =	_gsZ; 		
	delX_ = _delX; delY_ = _delY; delZ_=	_delZ;
	cenX_ =  	_cenX; 	
	cenY_ =  	_cenY; 	
	cenZ_ =  	_cenZ;
#ifdef DEBUG
	cout << "Parameter Set to :" 
	<< " gs " << gsX_ << " " << gsY_ << " "  << gsZ_ 
	<< " del " << delX_  << " " << delY_  << " " << delZ_
	<< " cen " << cenX_  << " " << cenY_  << " " << cenZ_ << endl;
#endif


}


template<class T, class TIn>
void MapPdb2Surf<T,TIn>::setRadius( TIn _rad)
{ 
	radius_ = _rad; 
}

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::mapKDhydro(vector<ATOMStruct> _atom, TIn _rad, int _gsX, int _gsY, int _gsZ, TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ,  SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec)
{
	setPdb(_atom);
	setRadius(_rad);
	setPara(_gsX, _gsY, _gsZ,_delX,_delY,_delZ, _cenX, _cenY, _cenZ);
	setSeedVec(_seedVec);	
	setSurfVec(_surfVec);
	mapKDhydroVec();
}

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::mapHB(vector<ATOMStruct> _atom, TIn _rad, int _gsX, int _gsY, int _gsZ, TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ,  SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec)
{
	setPdb(_atom);
	setRadius(_rad);
	setPara(_gsX, _gsY, _gsZ,_delX,_delY,_delZ, _cenX, _cenY, _cenZ);
	setSeedVec(_seedVec);	
	setSurfVec(_surfVec);
	mapHBondVec();
}

// function for mapping XlogP value to surface
template<class T, class TIn>
void MapPdb2Surf<T,TIn>::map_XlogP(vector<ATOMStruct> _atom, TIn _rad, int _gsX, int _gsY, int _gsZ, TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ,  SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec)
{
	setPdb(_atom);
	setRadius(_rad);
	setPara(_gsX, _gsY, _gsZ,_delX,_delY,_delZ, _cenX, _cenY, _cenZ);
	setSeedVec(_seedVec);	
	setSurfVec(_surfVec);
	map_XlogP_MHP();
}

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::map_real_XlogP(vector<ATOMStruct> _atom, TIn _rad, int _gsX, int _gsY, int _gsZ, TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ,  SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec)
{
	setPdb(_atom);
	setRadius(_rad);
	setPara(_gsX, _gsY, _gsZ,_delX,_delY,_delZ, _cenX, _cenY, _cenZ);
	setSeedVec(_seedVec);	
	setSurfVec(_surfVec);
	map_XlogP_real_MHP();
}

// function for mapping aromaticity to surface
template<class T, class TIn>
void MapPdb2Surf<T,TIn>::map_aromaticity(vector<ATOMStruct> _atom, TIn _rad, int _gsX, int _gsY, int _gsZ, TIn _delX, TIn _delY, TIn _delZ, TIn _cenX, TIn _cenY, TIn _cenZ,  SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec)
{
  setPdb(_atom);
  setRadius(_rad);
  setPara(_gsX, _gsY, _gsZ,_delX,_delY,_delZ, _cenX, _cenY, _cenZ);
  setSeedVec(_seedVec);	
  setSurfVec(_surfVec);
  map_arom_to_grid();
}

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::mapKDhydro(vector<ATOMStruct> _atom, TIn _rad, int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ,  SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec)
{
	setPdb(_atom);
	setRadius(_rad);
	setPara(_gs, _del, _cenX, _cenY, _cenZ);
	setSeedVec(_seedVec);	
	setSurfVec(_surfVec);
	mapKDhydroVec();
}

/*
template<class T, class TIn>
void MapPdb2Surf<T,TIn>::mapKDhydro(vector<ATOMStruct> _atom, TIn _rad, VolumeDX<T,TIn> _dx, SurfVec<T,TIn> *_surfVec, SeedVec<T,TIn> *_seedVec )
{
	setPdb(_atom);
	setRadius(_rad);
	setSurfDX(_dx);
	mapKDhydroVec();
}
*/

template<class T, class TIn>
void MapPdb2Surf<T,TIn>::mapKDhydroVec()
{
	int _d = gsX_*gsY_*gsZ_;

	for(int l=0; l< surfVec_->size(); l++){		
		Surf<T,TIn>* tmpsurf = surfVec_->getSurf(l);
		int i,j,k;
		tmpsurf->getABC(i,j,k);			
		TIn a, b, c;
//		tmpsurf->getXYZ(a, b, c);
		trans2OrgCoor(i,j,k, a,b,c);
		tmpsurf->setXYZ((T)a,(T)b,(T)c);	


		vector<int> atmlst;
		int minA = getAtomsInLS((float)a,(float)b,(float)c, atmlst);	
				
		int numA = atmlst.size();
				
#ifdef DEBUG_MAP					
		int _index = INDEX2(i,j,k,gsX_,gsY_,gsZ_); 
		
		cout << "Index : " << _index << "(" << i <<
							" " << j << " " << k << ") " << 
							" " << gsX_<< " " << gsY_ << " " << gsZ_ << endl;
#endif
					
		if(numA >= 1)
		{	
			vector<TIn> weightlst;
			mappingV1((float)a,(float)b,(float)c, atmlst, weightlst);
			T value = 0;
			for(int m=0; m<atmlst.size(); m++)
			{
				value += atom_[atmlst[m]].KDhydro*weightlst[m];
			}
			tmpsurf->setPro(value, KD);
			int si_ = tmpsurf->getSeedIndex();
			if(si_!=-1) {
				vector<int> tcatom;
				vector<int> tcres;
				if(atmlst.size()>0){
					for(int n=0; n<atmlst.size(); n++){
							tcatom.push_back(atom_[atmlst[n]].aSN);
							int found = 0;
							for(int o=0; o<tcres.size(); o++){
								if(tcres[o] == atom_[atmlst[n]].rSN){
									found=1; break;
								}
							}
							if(!found){
								tcres.push_back(atom_[atmlst[n]].rSN);
							}
					}
				}else{
					tcatom.push_back(-1);
					tcres.push_back(-1);
				}
				(seedVec_->getSeed(si_))->setcAcR(tcatom, tcres);
				
			}

#ifdef DEBUG_MAP
			cout << "Index : " << _index << "kdsurface value: " << tmpsurf->getPro(KD) << endl;
#endif
						
		}	
	}
	
}

//mapping hydrogen bond to the grid points (by Bingjie Hu)
template<class T, class TIn>
void MapPdb2Surf<T,TIn>::mapHBondVec()
{
	int _d = gsX_*gsY_*gsZ_;

	for(int l=0; l< surfVec_->size(); l++){		
		Surf<T,TIn>* tmpsurf = surfVec_->getSurf(l);
		int i,j,k;
		tmpsurf->getABC(i,j,k);			
		TIn a, b, c;
//		tmpsurf->getXYZ(a, b, c);
		trans2OrgCoor(i,j,k, a,b,c);
		tmpsurf->setXYZ((T)a,(T)b,(T)c);	

	
		vector<int> atmlst;
		int minA = getAtomsInLS((float)a,(float)b,(float)c, atmlst);	
				
		int numA = atmlst.size();
			
#ifdef DEBUG_HB					
		int _index = INDEX2(i,j,k,gsX_,gsY_,gsZ_); 
		
		cout << "Index : " << _index << "(" << i <<
							" " << j << " " << k << ") " << 
							" " << gsX_<< " " << gsY_ << " " << gsZ_ << endl;
#endif
					
		if(numA >= 1)
		{	
			vector<TIn> weightlst;
			//mappingV1((float)a,(float)b,(float)c, atmlst, weightlst);//radius (from Hydrophobic) is tooooo large for HB?
			T value = 0;
			value = atom_[minA].hbond;//uses the closest atom to the grid point to assign the value
			tmpsurf->setPro(value, HB);
			int si_ = tmpsurf->getSeedIndex();
			if(si_!=-1) {
				vector<int> tcatom;
				vector<int> tcres;
				if(atmlst.size()>0){
					for(int n=0; n<atmlst.size(); n++){
							tcatom.push_back(atom_[atmlst[n]].aSN);
							int found = 0;
							for(int o=0; o<tcres.size(); o++){
								if(tcres[o] == atom_[atmlst[n]].rSN){
									found=1; break;
								}
							}
							if(!found){
								tcres.push_back(atom_[atmlst[n]].rSN);
							}
					}
				}else{
					tcatom.push_back(-1);
					tcres.push_back(-1);
				}
				(seedVec_->getSeed(si_))->setcAcR(tcatom, tcres);//record closest atom and residues?
				
			}

#ifdef DEBUG_HB
			cout << "Index : " << _index << "HBsurface value: " << tmpsurf->getPro(HB) << endl;
#endif
						
		}	
	}
	
}

//mapping aromaticity to the grid points (by Woong-Hee Shin)
template<class T, class TIn>
void MapPdb2Surf<T,TIn>::map_arom_to_grid()
{
  int _d = gsX_*gsY_*gsZ_;
  
  for(int l=0; l< surfVec_->size(); l++){		
    Surf<T,TIn>* tmpsurf = surfVec_->getSurf(l);
    int i,j,k;
    tmpsurf->getABC(i,j,k);			
    TIn a, b, c;
    //		tmpsurf->getXYZ(a, b, c);
    trans2OrgCoor(i,j,k, a,b,c);
    tmpsurf->setXYZ((T)a,(T)b,(T)c);	
    
    
    vector<int> atmlst;
    int minA = getAtomsInLS((float)a,(float)b,(float)c, atmlst);	
    
    int numA = atmlst.size();
    
#ifdef DEBUG_AROM					
    int _index = INDEX2(i,j,k,gsX_,gsY_,gsZ_); 
    
    cout << "Index : " << _index << "(" << i << " " << j << " " << k << ") " << " " << gsX_<< " " << gsY_ << " " << gsZ_ << endl;
#endif
    
    if(numA >= 1)
      {	
	vector<TIn> weightlst;
	//mappingV1((float)a,(float)b,(float)c, atmlst, weightlst);//radius (from Hydrophobic) is tooooo large for HB?
	T value = 0;
	value = atom_[minA].arom;//uses the closest atom to the grid point to assign the value
	tmpsurf->setPro(value, AROM);
	int si_ = tmpsurf->getSeedIndex();
	if(si_!=-1) {
	  vector<int> tcatom;
	  vector<int> tcres;
	  if(atmlst.size()>0){
	    for(int n=0; n<atmlst.size(); n++){
	      tcatom.push_back(atom_[atmlst[n]].aSN);
	      int found = 0;
	      for(int o=0; o<tcres.size(); o++){
		if(tcres[o] == atom_[atmlst[n]].rSN){
		  found=1; break;
		}
	      }
	      if(!found){
		tcres.push_back(atom_[atmlst[n]].rSN);
	      }
	    }
	  }else{
	    tcatom.push_back(-1);
	    tcres.push_back(-1);
	  }
	  (seedVec_->getSeed(si_))->setcAcR(tcatom, tcres);//record closest atom and residues?
	  
	}
	
#ifdef DEBUG_AROM
	cout << "Index : " << _index << "Aromaticity surface value: " << tmpsurf->getPro(AROM) << endl;
#endif
	
      }	
  }
}

// mapping XlogP value to the grid points (by W. -H. Shin)
// mapping function: Gaillard et al., Molecular lipophilicity potential, a tool in 3D-QSAR. Method and Applicaions, J. Comput. -Aided Mol. Des. 8, 83-96, 1994.
template<class T, class TIn>
void MapPdb2Surf<T,TIn>::map_XlogP_MHP()
{
	int _d = gsX_*gsY_*gsZ_;

	for(int l=0; l< surfVec_->size(); l++)
	  {		
	    Surf<T,TIn>* tmpsurf = surfVec_->getSurf(l);
	    int i,j,k;
	    tmpsurf->getABC(i,j,k);			
	    TIn a, b, c;
	    //		tmpsurf->getXYZ(a, b, c);
	    trans2OrgCoor(i,j,k, a,b,c);
	    tmpsurf->setXYZ((T)a,(T)b,(T)c);	
	    
#ifdef DEBUG_XlogP					
	    int _index = INDEX2(i,j,k,gsX_,gsY_,gsZ_); 
	    
	    cout << "Index : " << _index << "(" << i <<
	      " " << j << " " << k << ") " << 
	      " " << gsX_<< " " << gsY_ << " " << gsZ_ << endl;
#endif
		
	    T value = 0.0;
	    float gr;
	    float norm_fac = 0.0;
	    float fi_gr = 0.0;
	    TIn rij;
	    for(int i_atm = 0; i_atm < atom_.size(); i_atm++)
	      {
		if(atom_[i_atm].XlogP == 0.000) 
		  {
		    continue;
		  }
		rij = DIST((TIn)atom_[i_atm].x, (TIn)atom_[i_atm].y, (TIn)atom_[i_atm].z, (TIn)a, (TIn)b, (TIn)c);
		//if(rij > 6.0) continue;
		//		value += atom_[i_atm].XlogP * exp(-rij/2.0);
		gr = 1.0 / (1.0 + exp(rij - 4));
		//		norm_fac += gr;
		fi_gr += atom_[i_atm].XlogP * gr;
	      }
	    //	    value = fi_gr / norm_fac;
	    if(fi_gr > 0.0)
	      {
		value = 1.0;
	      }
	    else if(fi_gr < 0.0)
	      {
		value = -1.0;
	      }
	    else if(fi_gr == 0.0)
	      {
		value = 0.0;
	      }
	    tmpsurf->setPro(value, XLP);
	    //	    int si_ = tmpsurf->getSeedIndex();
	    //	    if(si_!=-1) 
	    //	      {
	    //	vector<int> tcatom;
	    //	vector<int> tcres;
	    //	if(atom_.size()>0)
	    //	  {
	    //	    for(int n=0; n<atom_.size(); n++)
	    //	      {
	    //		tcatom.push_back(atom_[n].aSN);
	    //		int found = 0;
	    //		for(int o=0; o<tcres.size(); o++)
	    //		  {
	    //		    if(tcres[o] == atom_[n].rSN)
	    //		      {
	    //			found=1; break;
	    //		      }
	    //		  }
	    //		if(!found)
	    //		  {
	    //		    tcres.push_back(atom_[n].rSN);
	    //		  }
	    //	      }
	    //	  }
	    //	else
	    //	  {
	    //	    tcatom.push_back(-1);
	    //	    tcres.push_back(-1);
	    //	  }
	    //	(seedVec_->getSeed(si_))->setcAcR(tcatom, tcres);//record closest atom and residues?
		
		
#ifdef DEBUG_XlogP
		cout << "Index : " << _index << "XlogP surface value: " << tmpsurf->getPro(XLP) << endl;
#endif
		
		//	  }	
	  }
	
}
	
template<class T, class TIn>
void MapPdb2Surf<T,TIn>::map_XlogP_real_MHP()
{
	int _d = gsX_*gsY_*gsZ_;

	for(int l=0; l< surfVec_->size(); l++)
	  {		
	    Surf<T,TIn>* tmpsurf = surfVec_->getSurf(l);
	    int i,j,k;
	    tmpsurf->getABC(i,j,k);			
	    TIn a, b, c;
	    //		tmpsurf->getXYZ(a, b, c);
	    trans2OrgCoor(i,j,k, a,b,c);
	    tmpsurf->setXYZ((T)a,(T)b,(T)c);	
	    
#ifdef DEBUG_XlogP					
	    int _index = INDEX2(i,j,k,gsX_,gsY_,gsZ_); 
	    
	    cout << "Index : " << _index << "(" << i <<
	      " " << j << " " << k << ") " << 
	      " " << gsX_<< " " << gsY_ << " " << gsZ_ << endl;
#endif
		
	    T value = 0.0;
	    T tmp_value = 0.0;
	    float gr;
	    float norm_fac = 0.0;
	    float fi_gr = 0.0;
	    TIn rij;
	    for(int i_atm = 0; i_atm < atom_.size(); i_atm++)
	      {
		if(atom_[i_atm].XlogP == 0.000) 
		  {
		    continue;
		  }
		rij = DIST((TIn)atom_[i_atm].x, (TIn)atom_[i_atm].y, (TIn)atom_[i_atm].z, (TIn)a, (TIn)b, (TIn)c);
		gr = 1.0 / (1.0 + exp(rij - 4));
		norm_fac += gr;
		fi_gr += atom_[i_atm].XlogP * gr;
	      }
	    tmp_value = fi_gr / norm_fac;
	    if(tmp_value > 0.10)
	      {
		value = 1.0;
	      }
	    else if(tmp_value < -0.10)
	      {
		value = -1.0;
	      }
	    else if(tmp_value >= -0.10 && tmp_value <= 0.10)
	      {
		value = 0.0;
	      }
	    tmpsurf->setPro(value, XLP);
#ifdef DEBUG_XlogP
		cout << "Index : " << _index << "XlogP surface value: " << tmpsurf->getPro(XLP) << endl;
#endif
		
	  }
	
}
	
template<class T, class TIn>
VolumeDX<T,TIn> MapPdb2Surf<T,TIn>::mapKDhydro(vector<ATOMStruct> _atom, TIn _rad, T* _grid, int _gs, TIn _del, TIn _cenX, TIn _cenY, TIn _cenZ )
{
	setPdb(_atom);
	setRadius(_rad);
	setSurfGrid(_grid);
	setPara(_gs, _del, _cenX, _cenY, _cenZ);
	return mapKDhydro();
}

template<class T, class TIn>
VolumeDX<T,TIn> MapPdb2Surf<T,TIn>::mapKDhydro(vector<ATOMStruct> _atom, TIn _rad, T* _grid, 	int _gsX, int _gsY, int _gsZ,TIn _delX, TIn _delY, TIn _delZ,  TIn _cenX, TIn _cenY, TIn _cenZ )
{
	setPdb(_atom);
	setRadius(_rad);
	setSurfGrid(_grid);
	setPara(_gsX, _gsY,_gsZ, _delX,_delY,_delZ, _cenX, _cenY, _cenZ);
	return mapKDhydro();
}


template<class T, class TIn>
VolumeDX<T,TIn> MapPdb2Surf<T,TIn>::mapKDhydro(vector<ATOMStruct> _atom, TIn _rad, VolumeDX<T,TIn> _dx)
{
	setPdb(_atom);
	setRadius(_rad);
	setSurfDX(_dx);
	return mapKDhydro();
}

template<class T, class TIn>
VolumeDX<T,TIn> MapPdb2Surf<T,TIn>::mapKDhydro()
{
	int _d = gsX_*gsY_*gsZ_;
	kdSurfG_  = new T [_d];
	
	for(int i=0; i<gsX_; i++)
	{
		for(int j=0; j<gsY_; j++)
		{
			for(int k=0; k<gsZ_; k++)
			{
				int _index = INDEX2(i,j,k, gsX_,gsY_,gsZ_);
				if(surfGrid_[_index] != 0)
				{
					float a, b, c;
					trans2OrgCoor(i,j,k, a,b,c);
				
					vector<int> atmlst;
					int minA = getAtomsInLS(a,b,c, atmlst);	
				
					int numA = atmlst.size();
#ifdef DEBUG_MAP					
					cout << "Index : " << _index << "(" << i <<
							" " << j << " " << k << ") " << 
							" " << gsX_<< " " << gsY_ << " " << gsZ_
							<< " number of Atoms: " << numA << endl;
#endif
					
					if(numA >= 1){	
						vector<TIn> weightlst;
						mappingV1(a,b,c, atmlst, weightlst);
						T value = 0;
						for(int l=0; l<atmlst.size(); l++)
						{
							value += atom_[atmlst[l]].KDhydro*weightlst[l];
						}
						kdSurfG_[_index] = value;
#ifdef DEBUG_MAP
					cout << "Index : " << _index << "(" << i <<
							" " << j << " " << k << ") " << 
							" " << gsX_<< " " << gsY_ << " " << gsZ_ << endl;
					cout << "kdsurface value: " << kdSurfG_[_index] << endl;
#endif
						
					}else {
						kdSurfG_[_index] = 0;
					}
				}else{
					kdSurfG_[_index] = 0;
				}
				
			}
		}
	}

	kdSurfDX_.setPara(gsX_,gsY_,gsZ_, delX_,delY_,delZ_, cenX_, cenY_, cenZ_ );
	kdSurfDX_.setGrid(kdSurfG_);
	
	return kdSurfDX_;
}


template<class T, class TIn>
int MapPdb2Surf<T,TIn>::getAtomsInLS(float _x, float _y, float _z, vector<int>& atmlst)
{
	TIn mindist = MAXINT;
	int minAtm = 0;
	atmlst.clear();

	for(int i=0; i<atom_.size(); i++)
	{
		TIn dist = DIST((TIn)_x, (TIn)_y, (TIn)_z, (TIn)atom_[i].x, (TIn)atom_[i].y, (TIn)atom_[i].z);
		
		
		if( dist <= radius_ )
		{
			atmlst.push_back(i);	
			if( dist < mindist ){
				mindist = dist;
				minAtm = i;
			}
		}
	}
	return minAtm;
}

// L2 squared distance weighted average value
template<class T, class TIn>
void MapPdb2Surf<T,TIn>::mappingV1(float _x, float _y, float _z, const vector<int>& atmlst, vector<TIn>& weightlst)
{
	TIn sum = 0;
	weightlst.resize(atmlst.size(), 0);
	for(int i=0; i<atmlst.size(); i++)
	{
		TIn rdist = 1.0/DIST((TIn)_x, (TIn)_y, (TIn)_z, (TIn)atom_[atmlst[i]].x, (TIn)atom_[atmlst[i]].y, (TIn)atom_[atmlst[i]].z ) ;
		sum += rdist;
		weightlst[i] = rdist;
	}
	for(int i=0; i<atmlst.size(); i++)
	{
		weightlst[i] = weightlst[i]/sum;
	}
}




