/* 
 *	coded by : Sael Lee
 *	Last Modified : May 05, 2011
 *	Description: Given protein structure file in pdb format,
 *		1. removes covalently bound substructures that are to part of protein;
 *		2. removes hetero atom that are not bound to the proteins;
 *		3. clusters the hetero atom ( ligands ) by distance in space; and
 *		4. outputs pairs of proteins structure file and bounded ligand structure cluster file.
 *		
 *	Arguments: 1. pdb file name 	2. the pdbID used to name output file
 */


#include<fstream>
#include<iostream>
#include<stdio.h>
#include<string>

using namespace std;
#include"ProcessPDB.h"


int main(int argc, char** argv)
{
	if(argc<3 || argc>5){
		cout << "argc " << argc << endl;
		cout << "usage: " << argv[0] << " pdbfile  pdbID (cluster_distance) \n";
		exit(-1);
	}
	char* pdbFN = argv[1];
	char* pdbID = argv[2];
	float clustDist = 4.0;  // 4.5
	int hetNum = 7;
	if(argc==4) 
		clustDist=atof(argv[3]);
	if(argc==5){
		clustDist=atof(argv[3]);
		hetNum = atoi(argv[4]);
	}


	ProcessPDB<float,double> ppdb; 
	ppdb.ReadPDB(pdbFN);
	int num = ppdb.LigCluster(pdbID, clustDist, hetNum); 
	
	return 1;

}


