/*============================================
 *
 * Sael Lee 
 * May 08, 2008
 *
 *===========================================*/

#ifndef COMMON__H
#define COMMON__H

// ---- std includes ---
#include <vector>
#include <algorithm>
#include <iostream>
#include <fstream>
#include <sstream>
#include <cmath>
#include <cstring>
#include <map>
#include <list>
#include <algorithm>
#include <utility>
using namespace std;

#include <stdio.h>

#ifndef OBJ
#define OBJ		 				0
#define GTS 					1
#define MSMS 					2
#define MSP 					3
#define DX						4
#endif


#ifndef SURFACE
#define SURFACE 			0
#define PROPERTY 			1
#endif

#ifndef FALSE
#define FALSE					0
#define TRUE					1
#endif
																						
#ifndef PROSIZE
#define PROSIZE				8
#define SF						0
#define KD 						1					// Kyte-Doolittle hydrophobisity
#define HW 						2					// Hoop-Woods Hydrophilicity
#define EP	 					3					// electrostatic potential
#define VIS						4					// Visibility	
#define HB						5					// Hydrogen Bond (by Bingjie Hu)
#define XLP                                             6                                       // hydrophobicity calculated by XlogP
#define AROM                                            7                                       // aromatic ring
#endif
																						
#ifndef TYPE
#define ALL						0					// INV of both Positive and Negative value	
#define	PN						1					// INV of Positive/Negative seperately
#endif

#ifndef THRESHOLD
//#define THRESHOLD 1.733
#define THRESHOLD 1
#endif

#ifndef max
#define max(a,b)			(((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)			(((a) < (b)) ? (a) : (b))
#endif

#ifndef CUBIC
#define CUBIC(a)			((a)*(a)*(a))
#endif

#ifndef SQR
#define SQR(a)				((a)*(a))
#endif	

#ifndef ROUND
#define ROUND(a)			(int)floor((a)+0.5)
#endif																						

#ifndef INDEX
#define INDEX1(a,b,c,dim)  (((a)*(dim)+(b))*(dim) + (c))
#define INDEX2(a,b,c,dimX, dimY, dimZ)  (((a)*(dimY)+(b))*(dimZ) + (c))
#endif


//#ifndef DIST
//#define DIST(ax,ay,az,bx,by,bz)	sqrt(((ax)-(bx))*((ax)-(bx))+((ay)-(by))*((ay)-(by))+((az)-(bz))*((az)-(bz)))
//#endif																						

#ifndef DIST
#define DIST(ax,ay,az,bx,by,bz)	sqrt(SQR((ax)-(bx))+SQR((ay)-(by))+SQR((az)-(bz)))
#endif																						


#ifndef MIN
#define MIN(a,b) (a)<(b)?(a):(b)
#endif

#ifndef MAX
#define MAX(a,b) (a)>(b)?(a):(b)
#endif

#ifndef MAXINT
#define MAXINT 999999
#define MININT -999999
#endif

#ifndef PI
#define PI 3.141592653589793
#endif

//---------ligand mol2 parameters (by Bingjie Hu)------//
// Elements
#define eH          1
#define eB                  5
#define eC          6
#define eN          7
#define eO          8
#define eF          9
#define eP          15
#define eS          16
#define eCL         17
#define eBR         35
#define eI          53
#define eDefault    0
#define eMe1            100
#define eMe2            101
#define eMe3            102

// Mass
#define mH      1.00797
#define mB              10.811
#define mC      12.01115
#define mN      14.0067
#define mO      15.9994
#define mF      18.9984
#define mNA             22.9898
#define mP      30.9738
#define mS      32.064
#define mCL     35.453
#define mCA             40.08
#define mFE             55.847
#define mCO             58.933
#define mCU             63.54
#define mZN             65.37
#define mBR     79.909
#define mI      126.904
#define mDefault  1.
#define mMe1            50.
#define mMe2            50.
#define mMe3            50.

// Definitions of Hybridization
#define sp                      1
#define sp2                     2
#define sp3                     3
#define NoHyb           0
// Bond Types
#define AcyclicOne      1       // only one bond partner
#define Acyclic         2       // more than one bond partner
#define Cyclic          3       // cyclic bonds
// Bond Strength
#define sSingle                 1               // single bond
#define sDouble                 2               // double bond
#define sTriple                 3               // triple bond
#define sq2d2   0.707106781185
#define sq3d2   0.866025403785
#define c5475   0.577145190037
#define s5475   0.816641555162
#define c5722   0.541414764190
#define s5722   0.840755644119
#define a135    2.3561945
#define a1095   1.9111355
#define c20             0.939692620786
#define s20             0.342020143326
#define c75             0.258819045103
#define s75             0.965925826289
#define sq2x2d3 0.9428162
#define sq2d3   0.8164966
#define sq2xd3  0.4714081

//end of ligand mol2 parameters (by Bingjie Hu)
// ---- local program includes ----
#include "VolumeDX.h"
#include "SurfVec.h"
#include "SeedVec.h"

#endif // COMMON


