/*============================================
 *
 * Sael Lee 
 * last modifed: May 09, 2008
 *
 *===========================================*/

#ifndef APBS2DX__H
#define APBS2DX__H

// ---- std includes ---
//#include <vector>
//#include <iostream>
//#include <fstream>

//using namespace std;

//#include <stdio.h>
//#include <cstring>
//#include <cmath>

#include "Common.h"
#include "VolumeDX.h"
#include "SeedVec.h"
#include "SurfVec.h"


template<typename T, typename TIn>
class Apbs2DX
{
	public:
		typedef VolumeDX<T,TIn> 							VDX;
		
		Apbs2DX();
		Apbs2DX(const char* _fname1);
//		Apbs2DX(const char* _fname1, SeedVec<T,TIn> &seedVec_,  SurfVec<T,TIn> &surfVec_);

		Apbs2DX(const char* _fname1, const char* _fname2);
			
		
		void init(const char* _fname1);
		void init(const char* _fname1, const char* _fname2);


		// free memory allocation
		void clear();
		
		void clearAcc(){acc_.clear();};
		void clearPot(){pot_.clear();};
		void clearSurf(){surf_.clear();};
		void clearSurfFilled(){surfFilled_.clear();};
		void clearSeed(){seed_.clear();};

		// read from file and store to acc_ also return grid
		void readacc(const char* _fname);
		void readaccLig(const char* _fname);
		
		// read from file and store to pot_ also return grid
		void readpot(const char* _fname);
		void readpotProt(const char* _fname);
		void readpotLig(const char* _fname);
		void readpotLig_inv(const char* _fname);
		
		// calculate surface area
		void calSurf(int cdepth);					
	
//		void calSurf( SeedVec<T,TIn> &seedVec_, SurfVec<T,TIn> &surfVec_);					
//		void calSurf(int cdepth, SeedVec<T,TIn> &seedVec_,  SurfVec<T,TIn> &surfVec_);					
		
		// calculate surface area and put 1 and fill inside as -1
		void calSurfFilled();					

		// extract potential on surface area
		void calSurfPot();	
	
		// extract seed points (primitive)
		void calSeed();

		// write dx files 
		void writeSurf(const char* _fname);
		void writeSurfFilled(const char* _fname);
		void writeSurfPot(const char* _fname);
		void writeAcc(const char* _fname);
		void writePot(const char* _fname);
		void writeSeed(const char* _fname);

		// get dx
		VDX	 	getAcc(){				return acc_;				};
		VDX 	getPot(){				return pot_;				};
		VDX		getSurf(){			return surf_;				};
		VDX		getSurfFilled(){return surfFilled_;	};
		VDX 	getSurfPot(){		return surfPot_;		};
		VDX		getSeed(){			return seed_;				};

//		SeedVec<T,TIn> getSeedVec(){ return seedVec_; 		};
//		SurfVec<T,TIn> getSurfVec(){ return surfVec_; 		};
		
		void setSeedVec(SeedVec<T,TIn> *_seedVec){ seedVec_ = _seedVec; };
		void setSurfVec(SurfVec<T,TIn> *_surfVec){ surfVec_ = _surfVec; };
		void reduceDXSize();

	private:
		
		VDX 							acc_;						// solvent excluded area denoted as 1
		VDX								pot_;						// potential values
		VDX								surf_;					// surface area (solvent accessible area)
		VDX								surfFilled_;		// surface area filled with -l inside surface with 1
		VDX 							surfPot_;				// potential values on solvent accessible area
		VDX 							seed_;					// seed points to use in local Zernike
	
		SeedVec<T,TIn>		*seedVec_;			// Seed vector
		SurfVec<T,TIn>		*surfVec_;	 		// Surface Vector

};

#include "Apbs2DX.cpp"

#endif
