
/*==============================================
 *	Class Apbs2DX
 *	
 *	last modified : May 09, 2008
 *	
 * ============================================*/
template<typename T, typename TIn>
Apbs2DX<T,TIn>::Apbs2DX()
{
}


template<typename T, typename TIn>
Apbs2DX<T,TIn>::Apbs2DX(const char* _fname1, const char* _fname2)
{
	init(_fname1, _fname2);
}


template<typename T, typename TIn>
Apbs2DX<T,TIn>::Apbs2DX(const char* _fname1)
{
	init(_fname1);
}


template<typename T, typename TIn>
void Apbs2DX<T,TIn>::init(const char* _fname1, const char* _fname2)
{
	readacc(_fname1);	
	readpot(_fname2);
	calSurf();
	calSurfPot();
	calSeed();
}


template<typename T, typename TIn>
void Apbs2DX<T,TIn>::init(const char* _fname1)
{
	readacc(_fname1);	
	calSurf();
	calSeed();
}


template<typename T, typename TIn>
void Apbs2DX<T,TIn>::clear()
{
	acc_.clear();
	pot_.clear();
 	surf_.clear();
 	surfFilled_.clear();
	seed_.clear();
}


template<typename T, typename TIn>
void Apbs2DX<T,TIn>::readacc(const char* _fname)
{
	acc_.readDX(_fname);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::readaccLig(const char* _fname)
{
	readacc(_fname);
	int _gsX, _gsY, _gsZ;
	acc_.getGs(_gsX, _gsY, _gsZ);
	T* _grid = new T [_gsX*_gsY*_gsZ];
	T* _ngrid;
	_ngrid = acc_.getGrid();
	for ( int i = 0; i < _gsX; i++ )
	{
		for ( int j = 0; j < _gsY; j++ )
		{
			for ( int k = 0; k < _gsZ; k++ )
			{
				int l = (i*_gsY+j)*_gsZ + k;
				if(_ngrid[l] == 1.0)
					_grid[l] = 0.0;
				else
					_grid[l] = 1.0;
			}
		}
	}
	acc_.setGrid(_grid);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::readpot(const char* _fname)
{
	pot_.readDX(_fname);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::readpotProt(const char* _fname)
{
	readpot(_fname);
	int _gsX, _gsY, _gsZ;
	pot_.getGs(_gsX, _gsY,_gsZ);
	T* _grid = new T [_gsX*_gsY*_gsZ];
	T* _ngrid;
	_ngrid = pot_.getGrid();
	for ( int i = 0; i < _gsX; i++ )
	{
		for ( int j = 0; j < _gsY; j++ )
		{
			for ( int k = 0; k < _gsZ; k++ )
			{
				int l = (i*_gsY+j)*_gsZ + k;
				float	tmpelec = _ngrid[l];
				if (tmpelec > 0.10)		_grid[l] = 1.0;
				else if(tmpelec < -0.10)	_grid[l] = -1.0;
				else				_grid[l] = 0.0;
			}
		}
	}
	pot_.setGrid(_grid);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::readpotLig_inv(const char* _fname)
{
	readpot(_fname);
	int _gsX, _gsY, _gsZ;
	pot_.getGs(_gsX, _gsY,_gsZ);
	T* _grid = new T [_gsX*_gsY*_gsZ];
	T* _ngrid;
	_ngrid = pot_.getGrid();
	for ( int i = 0; i < _gsX; i++ )
	{
		for ( int j = 0; j < _gsY; j++ )
		{
			for ( int k = 0; k < _gsZ; k++ )
			{
				int l = (i*_gsY+j)*_gsZ + k;
				float	tmpelec = _ngrid[l] * (-1.0);
				if (tmpelec > 0.0001)		_grid[l] = 1.0;
				else if(tmpelec < -0.0001)	_grid[l] = -1.0;
				else				_grid[l] = 0.0;
			}
		}
	}
	pot_.setGrid(_grid);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::readpotLig(const char* _fname)
{
	readpot(_fname);
	int _gsX, _gsY, _gsZ;
	pot_.getGs(_gsX, _gsY,_gsZ);
	T* _grid = new T [_gsX*_gsY*_gsZ];
	T* _ngrid;
	_ngrid = pot_.getGrid();
	for ( int i = 0; i < _gsX; i++ )
	{
		for ( int j = 0; j < _gsY; j++ )
		{
			for ( int k = 0; k < _gsZ; k++ )
			{
				int l = (i*_gsY+j)*_gsZ + k;
				float	tmpelec = _ngrid[l] * (-1.0);
				if (tmpelec > 0.0001)		_grid[l] = 1.0;
				else if(tmpelec < -0.0001)	_grid[l] = -1.0;
				else				_grid[l] = 0.0;
			}
		}
	}
	pot_.setGrid(_grid);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::calSurf(int cdepth=1)
{
	T* _acc;
	
	int _gsX, _gsY, _gsZ;
	acc_.getGs(_gsX, _gsY, _gsZ);	
	_acc = acc_.getGrid();
	int d = _gsX*_gsY*_gsZ;

	seedVec_->init();
	surfVec_->init();
	
	T* _surf = new T [d];
	for(int i = 0; i < d; i++)
	{
		_surf[i] = 0;
	}

	T* _seed = new T [d];
	for(int i = 0; i < d; i++)
	{
		_seed[i] = 0;
	}

	int numseed=0;	
	int numsurf=0;
	for(int x = cdepth; x < _gsX-cdepth; x++){
		for(int y = cdepth; y < _gsY-cdepth; y++){
			for(int z = cdepth; z < _gsZ-cdepth; z++){
				int l  = (x*_gsY + y)*_gsZ + z;
				if(_acc[l]==0){
					// thick (depth) grids
					int la =((x)*_gsY+(y))*_gsZ + (z+1);
					if(_acc[la]){ _surf[la] = 1; numsurf++; }
					la =((x)*_gsY+(y))*_gsZ + (z-1);
					if(_acc[la]){ _surf[la] = 1; numsurf++; }
					la =((x)*_gsY+(y+1))*_gsZ + (z);
					if(_acc[la]){ _surf[la] = 1; numsurf++; }
					la =((x)*_gsY+(y-1))*_gsZ + (z);
					if(_acc[la]){ _surf[la] = 1; numsurf++; }
					la =((x+1)*_gsY+(y))*_gsZ + (z);
					if(_acc[la]){ _surf[la] = 1; numsurf++; }
					la =((x-1)*_gsY+(y))*_gsZ + (z);
					if(_acc[la]){ _surf[la] = 1; numsurf++; }


					/*
					for(int i = -1*cdepth; i <= cdepth; i++){
						for(int j = -1*cdepth; j <= cdepth; j++){
							for(int k = -1*cdepth; k <= cdepth; k++){	
								if( sqrt(i*i + j*j + k*k) <= cdepth ){
									int la =((x+i)*_gsY+(y+j))*_gsZ + (z+k);
									if(_acc[la]){ 
										_surf[la] = 1;
										numsurf++;
									}
								}
							}
						}
					}
					*/

					// seed & surface
					if(_acc[l+_gsZ*_gsY] 
								|| _acc[l-_gsZ*_gsY] || _acc[l+_gsZ] 
								|| _acc[l-_gsZ] || _acc[l+1] 
								|| _acc[l-1] ){
						numseed++;
						numsurf++;
						_surf[l] = 1;
						_seed[l] = 1;

					}
				}
				
			}
		}
	}
	
	
	// surface	
	TIn _delX, _delY, _delZ;
	acc_.getDel(_delX, _delY, _delZ);
	TIn _minX, _minY, _minZ;
	acc_.getMin(_minX, _minY, _minZ);
	
	surf_.setGrid(_surf);
	surf_.setGs(_gsX, _gsY, _gsZ);
	surf_.setDel(_delX, _delY, _delZ);
	surf_.setMin(_minX, _minY, _minZ);
	
	// seed
	seed_.setGrid(_seed);
	seed_.setGs(_gsX, _gsY, _gsZ);
	seed_.setDel(_delX, _delY, _delZ);
	seed_.setMin(_minX, _minY, _minZ);


	// Set vectors
	int dimX, dimY, dimZ;
	TIn delX,delY,delZ;
	TIn cenX, cenY, cenZ;
	seed_.getPara(dimX,dimY,dimZ, delX,delY,delZ, cenX,cenY,cenZ);

	surfVec_->reserveSurfs(numsurf);		
	surfVec_->setPara(dimX,dimY,dimZ, delX,delY,delZ, cenX, cenY, cenZ);
	seedVec_->reserveSeeds(numseed);
	seedVec_->setPara(dimX,dimY,dimZ, delX,delY,delZ, cenX, cenY, cenZ);
	
  int l=0;
	for(int i=0; i<_gsX; i++){
		for(int j=0; j<_gsY; j++){
			for(int k=0; k<_gsZ; k++){
				if(_surf[l]==1)
				{
					Surf<T,TIn> tmpsurf; 	
					TIn ti, tj, tk;
					surfVec_->TRANSFORMTO( i, j, k, ti, tj ,tk);
					tmpsurf.init(ti,tj,tk, i, j, k, l);
				//	tmpsurf.init(0,0,0,i,j,k,l);
					tmpsurf.setPro(1,0);
					int m = surfVec_->pushSurf(tmpsurf);
					
					if(_seed[l]==1)
					{
						Seed<T,TIn> tmpseed;
						tmpseed.init(ti, tj, tk);
				//		tmpseed.init(i,j,k);
						tmpseed.setSurf(surfVec_->getSurf(m));
						int n = seedVec_->pushSeed(tmpseed);
						(surfVec_->getSurf(m))->setSeedIndex(n);
					}
				}
				l++;
			}
		}
	}

//seedVec_->mapSeedABC();
//seedVec_->mapSeedABC();
//surfVec_->mapSurfXYZ();
//surfVec_->mapSurfXYZ();

#ifdef DEBUG
	cout << "Seed vector size: " << seedVec_->size() << endl
			 << "Surf vecotr size: " << surfVec_->size() << endl;
#endif

}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::calSurfFilled()
{
//	calSurf();
	
	int _gsX, _gsY, _gsZ;
	seed_.getGs(_gsX, _gsY, _gsZ);	
	T* _seed = seed_.getGrid();
	T* _acc = acc_.getGrid();
	int d = _gsX*_gsY*_gsZ;
	
	T* result = new T [d];	
	
	for(int i =0; i< d; i++)
	{
//		if(_acc[i] == 0 || _seed[i] == 1){
		if(_acc[i] == 0){	
			result[i] = 1;
		}else{
			result[i] = 0;
		}
	}			
	
	TIn _delX, _delY, _delZ;
	seed_.getDel(_delX, _delY, _delZ);
	TIn _minX, _minY, _minZ;
	seed_.getMin(_minX, _minY, _minZ);
	
	surfFilled_.setGs(_gsX, _gsY, _gsZ);
	surfFilled_.setDel(_delX, _delY, _delZ);
	surfFilled_.setMin(_minX, _minY, _minZ);

	surfFilled_.setGrid(result);
	
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::calSurfPot()
{
//	calSurf();
	
	// take properties from pot
	T* _pot = pot_.getGrid();
	T* _surf = surf_.getGrid();
	
	int _gsX, _gsY, _gsZ;
	surf_.getGs(_gsX, _gsY, _gsZ);	
	TIn _delX, _delY, _delZ;
	surf_.getDel(_delX, _delY, _delZ);
	TIn _minX, _minY, _minZ;
	surf_.getMin(_minX, _minY, _minZ);
	// save to surf pot dx
	surfPot_.setGs(_gsX, _gsY, _gsZ);
	surfPot_.setDel(_delX, _delY, _delZ);
	surfPot_.setMin(_minX, _minY, _minZ);

	int d = _gsX*_gsY*_gsZ;
	T* result = new T [d];	
	for(int i=0; i<d; i++){
		if(_surf[i] == 1){
			result[i] = _pot[i];
		}else{
			result[i] = 0;
		}
	}

	for(int i=0;i<surfVec_->size(); i++)
	{
		int a,b,c;
		(surfVec_->getSurf(i))->getABC(a,b,c);
		(surfVec_->getSurf(i))->setPro(_pot[(a*_gsZ+b)*_gsY+c], EP);
	}
	
	surfPot_.setGrid(result);
}	

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::calSeed()
{
		int numseed=0;
		T* accGrid = acc_.getGrid();
		int _gsX, _gsY, _gsZ;
		acc_.getGs(_gsX, _gsY, _gsZ);	
		int d = _gsX*_gsY*_gsZ;
		
		T* result = new T [d];
		for(int i = 0; i < d; i++)
		{
			result[i] = 0;
		}

		// get seed points
		for(int x=1; x < _gsX -1 ; x++){
			for(int y=1; y < _gsY -1; y++){
				for(int z=1; z < _gsZ -1; z++){	
					int i0 = INDEX2(x,y,z, _gsX, _gsY, _gsZ);
					int i1 = INDEX2(x+1,y,z, _gsX, _gsY, _gsZ);
					int i2 = INDEX2(x,y+1,z, _gsX, _gsY, _gsZ);
					int i3 = INDEX2(x,y,z+1, _gsX, _gsY, _gsZ);
					int i4 = INDEX2(x-1,y,z, _gsX, _gsY, _gsZ);
					int i5 = INDEX2(x,y-1,z, _gsX, _gsY, _gsZ);
					int i6 = INDEX2(x,y,z-1, _gsX, _gsY, _gsZ);

					if(accGrid[i0]==0 && ( accGrid[i1] || accGrid[i2] 
						|| accGrid[i3] || accGrid[i4] || accGrid[i5] || accGrid[i6] )  )
					{
						numseed++;
						result[i0] = 1;
					}

//					int i = x*_gsZ*_gsY + y*_gsZ + z;
//					if(accGrid[i] == 0 && (accGrid[i+_gsZ*_gsY] 
//								|| accGrid[i-_gsZ*_gsY] || accGrid[i+_gsZ] 
//								|| accGrid[i-_gsZ] || accGrid[i+1] 
//								|| accGrid[i-1] )){
//						numseed++;
//						result[i] = 1;
//					}

					
				}
			}
		}

	TIn _delX, _delY, _delZ;
	acc_.getDel(_delX, _delY, _delZ);
	TIn _minX, _minY, _minZ;
	acc_.getMin(_minX, _minY, _minZ);
	
	seed_.setGrid(result);
	seed_.setGs(_gsX, _gsY, _gsZ);
	seed_.setDel(_delX, _delY, _delZ);
	seed_.setMin(_minX, _minY, _minZ);
	
}


// very unstable for internal use only
template<typename T, typename TIn>
void Apbs2DX<T,TIn>::reduceDXSize()
{
	if(acc_.getGrid() != NULL) acc_.reduceSize();
	if(pot_.getGrid() != NULL) pot_.reduceSize();




}


template<typename T, typename TIn>
void Apbs2DX<T,TIn>::writeSurf(const char* _fname)
{
	surf_.writeDX(_fname);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::writeSurfFilled(const char* _fname)
{
	surfFilled_.writeDX(_fname);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::writeSurfPot(const char* _fname)
{
	surfPot_.writeDX(_fname);
}


template<typename T, typename TIn>
void Apbs2DX<T,TIn>::writeAcc(const char* _fname)
{
	acc_.writeDX(_fname);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::writePot(const char* _fname)
{
	pot_.writeDX(_fname);
}

template<typename T, typename TIn>
void Apbs2DX<T,TIn>::writeSeed(const char* _fname)
{
	seed_.writeDX(_fname);
}
